@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of quota
 */
public enum class Type(
    public val javaValue: com.pulumi.azurenative.netapp.enums.Type,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.enums.Type> {
    /**
     * Default user quota
     */
    DefaultUserQuota(com.pulumi.azurenative.netapp.enums.Type.DefaultUserQuota),

    /**
     * Default group quota
     */
    DefaultGroupQuota(com.pulumi.azurenative.netapp.enums.Type.DefaultGroupQuota),

    /**
     * Individual user quota
     */
    IndividualUserQuota(com.pulumi.azurenative.netapp.enums.Type.IndividualUserQuota),

    /**
     * Individual group quota
     */
    IndividualGroupQuota(com.pulumi.azurenative.netapp.enums.Type.IndividualGroupQuota),
    ;

    override fun toJava(): com.pulumi.azurenative.netapp.enums.Type = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.enums.Type): Type =
            Type.values().first { it.javaValue == javaType }
    }
}
