@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.ActiveDirectoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Active Directory
 * @property activeDirectoryId Id of the Active Directory
 * @property adName Name of the active directory machine. This optional parameter is used only while creating kerberos volume
 * @property administrators Users to be added to the Built-in Administrators active directory group. A list of unique usernames without domain specifier
 * @property aesEncryption If enabled, AES encryption will be enabled for SMB communication.
 * @property allowLocalNfsUsersWithLdap  If enabled, NFS client local users can also (in addition to LDAP users) access the NFS volumes.
 * @property backupOperators Users to be added to the Built-in Backup Operator active directory group. A list of unique usernames without domain specifier
 * @property dns Comma separated list of DNS server IP addresses (IPv4 only) for the Active Directory domain
 * @property domain Name of the Active Directory domain
 * @property encryptDCConnections If enabled, Traffic between the SMB server to Domain Controller (DC) will be encrypted.
 * @property kdcIP kdc server IP addresses for the active directory machine. This optional parameter is used only while creating kerberos volume.
 * @property ldapOverTLS Specifies whether or not the LDAP traffic needs to be secured via TLS.
 * @property ldapSearchScope LDAP Search scope options
 * @property ldapSigning Specifies whether or not the LDAP traffic needs to be signed.
 * @property organizationalUnit The Organizational Unit (OU) within the Windows Active Directory
 * @property password Plain text password of Active Directory domain administrator, value is masked in the response
 * @property preferredServersForLdapClient Comma separated list of IPv4 addresses of preferred servers for LDAP client. At most two comma separated IPv4 addresses can be passed.
 * @property securityOperators Domain Users in the Active directory to be given SeSecurityPrivilege privilege (Needed for SMB Continuously available shares for SQL). A list of unique usernames without domain specifier
 * @property serverRootCACertificate When LDAP over SSL/TLS is enabled, the LDAP client is required to have base64 encoded Active Directory Certificate Service's self-signed root CA certificate, this optional parameter is used only for dual protocol with LDAP user-mapping volumes.
 * @property site The Active Directory site the service will limit Domain Controller discovery to
 * @property smbServerName NetBIOS name of the SMB server. This name will be registered as a computer account in the AD and used to mount volumes
 * @property username A domain user account with permission to create machine accounts
 */
public data class ActiveDirectoryArgs(
    public val activeDirectoryId: Output<String>? = null,
    public val adName: Output<String>? = null,
    public val administrators: Output<List<String>>? = null,
    public val aesEncryption: Output<Boolean>? = null,
    public val allowLocalNfsUsersWithLdap: Output<Boolean>? = null,
    public val backupOperators: Output<List<String>>? = null,
    public val dns: Output<String>? = null,
    public val domain: Output<String>? = null,
    public val encryptDCConnections: Output<Boolean>? = null,
    public val kdcIP: Output<String>? = null,
    public val ldapOverTLS: Output<Boolean>? = null,
    public val ldapSearchScope: Output<LdapSearchScopeOptArgs>? = null,
    public val ldapSigning: Output<Boolean>? = null,
    public val organizationalUnit: Output<String>? = null,
    public val password: Output<String>? = null,
    public val preferredServersForLdapClient: Output<String>? = null,
    public val securityOperators: Output<List<String>>? = null,
    public val serverRootCACertificate: Output<String>? = null,
    public val site: Output<String>? = null,
    public val smbServerName: Output<String>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.ActiveDirectoryArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.ActiveDirectoryArgs =
        com.pulumi.azurenative.netapp.inputs.ActiveDirectoryArgs.builder()
            .activeDirectoryId(activeDirectoryId?.applyValue({ args0 -> args0 }))
            .adName(adName?.applyValue({ args0 -> args0 }))
            .administrators(administrators?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .aesEncryption(aesEncryption?.applyValue({ args0 -> args0 }))
            .allowLocalNfsUsersWithLdap(allowLocalNfsUsersWithLdap?.applyValue({ args0 -> args0 }))
            .backupOperators(backupOperators?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .dns(dns?.applyValue({ args0 -> args0 }))
            .domain(domain?.applyValue({ args0 -> args0 }))
            .encryptDCConnections(encryptDCConnections?.applyValue({ args0 -> args0 }))
            .kdcIP(kdcIP?.applyValue({ args0 -> args0 }))
            .ldapOverTLS(ldapOverTLS?.applyValue({ args0 -> args0 }))
            .ldapSearchScope(ldapSearchScope?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ldapSigning(ldapSigning?.applyValue({ args0 -> args0 }))
            .organizationalUnit(organizationalUnit?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .preferredServersForLdapClient(preferredServersForLdapClient?.applyValue({ args0 -> args0 }))
            .securityOperators(securityOperators?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .serverRootCACertificate(serverRootCACertificate?.applyValue({ args0 -> args0 }))
            .site(site?.applyValue({ args0 -> args0 }))
            .smbServerName(smbServerName?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ActiveDirectoryArgs].
 */
@PulumiTagMarker
public class ActiveDirectoryArgsBuilder internal constructor() {
    private var activeDirectoryId: Output<String>? = null

    private var adName: Output<String>? = null

    private var administrators: Output<List<String>>? = null

    private var aesEncryption: Output<Boolean>? = null

    private var allowLocalNfsUsersWithLdap: Output<Boolean>? = null

    private var backupOperators: Output<List<String>>? = null

    private var dns: Output<String>? = null

    private var domain: Output<String>? = null

    private var encryptDCConnections: Output<Boolean>? = null

    private var kdcIP: Output<String>? = null

    private var ldapOverTLS: Output<Boolean>? = null

    private var ldapSearchScope: Output<LdapSearchScopeOptArgs>? = null

    private var ldapSigning: Output<Boolean>? = null

    private var organizationalUnit: Output<String>? = null

    private var password: Output<String>? = null

    private var preferredServersForLdapClient: Output<String>? = null

    private var securityOperators: Output<List<String>>? = null

    private var serverRootCACertificate: Output<String>? = null

    private var site: Output<String>? = null

    private var smbServerName: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value Id of the Active Directory
     */
    @JvmName("ycqlhklxlljrloac")
    public suspend fun activeDirectoryId(`value`: Output<String>) {
        this.activeDirectoryId = value
    }

    /**
     * @param value Name of the active directory machine. This optional parameter is used only while creating kerberos volume
     */
    @JvmName("bvvoubopbgabndxk")
    public suspend fun adName(`value`: Output<String>) {
        this.adName = value
    }

    /**
     * @param value Users to be added to the Built-in Administrators active directory group. A list of unique usernames without domain specifier
     */
    @JvmName("prkgfolptgpigusv")
    public suspend fun administrators(`value`: Output<List<String>>) {
        this.administrators = value
    }

    @JvmName("shasatqveursrtkf")
    public suspend fun administrators(vararg values: Output<String>) {
        this.administrators = Output.all(values.asList())
    }

    /**
     * @param values Users to be added to the Built-in Administrators active directory group. A list of unique usernames without domain specifier
     */
    @JvmName("iejecxdfqwkwxwwf")
    public suspend fun administrators(values: List<Output<String>>) {
        this.administrators = Output.all(values)
    }

    /**
     * @param value If enabled, AES encryption will be enabled for SMB communication.
     */
    @JvmName("wfhxyhnulrrkmhsx")
    public suspend fun aesEncryption(`value`: Output<Boolean>) {
        this.aesEncryption = value
    }

    /**
     * @param value  If enabled, NFS client local users can also (in addition to LDAP users) access the NFS volumes.
     */
    @JvmName("yrcdropwrngahctt")
    public suspend fun allowLocalNfsUsersWithLdap(`value`: Output<Boolean>) {
        this.allowLocalNfsUsersWithLdap = value
    }

    /**
     * @param value Users to be added to the Built-in Backup Operator active directory group. A list of unique usernames without domain specifier
     */
    @JvmName("xusqggqwdgppspdl")
    public suspend fun backupOperators(`value`: Output<List<String>>) {
        this.backupOperators = value
    }

    @JvmName("graipwijxxxkdrxi")
    public suspend fun backupOperators(vararg values: Output<String>) {
        this.backupOperators = Output.all(values.asList())
    }

    /**
     * @param values Users to be added to the Built-in Backup Operator active directory group. A list of unique usernames without domain specifier
     */
    @JvmName("bqpvokumwgsjracv")
    public suspend fun backupOperators(values: List<Output<String>>) {
        this.backupOperators = Output.all(values)
    }

    /**
     * @param value Comma separated list of DNS server IP addresses (IPv4 only) for the Active Directory domain
     */
    @JvmName("tqvoohljqggxkuul")
    public suspend fun dns(`value`: Output<String>) {
        this.dns = value
    }

    /**
     * @param value Name of the Active Directory domain
     */
    @JvmName("dqrdyftmochlgnkn")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value If enabled, Traffic between the SMB server to Domain Controller (DC) will be encrypted.
     */
    @JvmName("jontfgmryhpmrvsn")
    public suspend fun encryptDCConnections(`value`: Output<Boolean>) {
        this.encryptDCConnections = value
    }

    /**
     * @param value kdc server IP addresses for the active directory machine. This optional parameter is used only while creating kerberos volume.
     */
    @JvmName("cwvsmutdhwwkcdcg")
    public suspend fun kdcIP(`value`: Output<String>) {
        this.kdcIP = value
    }

    /**
     * @param value Specifies whether or not the LDAP traffic needs to be secured via TLS.
     */
    @JvmName("xuridfcyqakldysl")
    public suspend fun ldapOverTLS(`value`: Output<Boolean>) {
        this.ldapOverTLS = value
    }

    /**
     * @param value LDAP Search scope options
     */
    @JvmName("qxsdmhboalsqknse")
    public suspend fun ldapSearchScope(`value`: Output<LdapSearchScopeOptArgs>) {
        this.ldapSearchScope = value
    }

    /**
     * @param value Specifies whether or not the LDAP traffic needs to be signed.
     */
    @JvmName("sepuqfwqxyvhykql")
    public suspend fun ldapSigning(`value`: Output<Boolean>) {
        this.ldapSigning = value
    }

    /**
     * @param value The Organizational Unit (OU) within the Windows Active Directory
     */
    @JvmName("liinavumsxcpftkj")
    public suspend fun organizationalUnit(`value`: Output<String>) {
        this.organizationalUnit = value
    }

    /**
     * @param value Plain text password of Active Directory domain administrator, value is masked in the response
     */
    @JvmName("mlaprrruyujteoxf")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Comma separated list of IPv4 addresses of preferred servers for LDAP client. At most two comma separated IPv4 addresses can be passed.
     */
    @JvmName("hqlksisaqttmeikw")
    public suspend fun preferredServersForLdapClient(`value`: Output<String>) {
        this.preferredServersForLdapClient = value
    }

    /**
     * @param value Domain Users in the Active directory to be given SeSecurityPrivilege privilege (Needed for SMB Continuously available shares for SQL). A list of unique usernames without domain specifier
     */
    @JvmName("ddthioxvhgtoyoyp")
    public suspend fun securityOperators(`value`: Output<List<String>>) {
        this.securityOperators = value
    }

    @JvmName("yaddcinbdlxqmbuf")
    public suspend fun securityOperators(vararg values: Output<String>) {
        this.securityOperators = Output.all(values.asList())
    }

    /**
     * @param values Domain Users in the Active directory to be given SeSecurityPrivilege privilege (Needed for SMB Continuously available shares for SQL). A list of unique usernames without domain specifier
     */
    @JvmName("ddsfwbjuekxeghtp")
    public suspend fun securityOperators(values: List<Output<String>>) {
        this.securityOperators = Output.all(values)
    }

    /**
     * @param value When LDAP over SSL/TLS is enabled, the LDAP client is required to have base64 encoded Active Directory Certificate Service's self-signed root CA certificate, this optional parameter is used only for dual protocol with LDAP user-mapping volumes.
     */
    @JvmName("fschnhencnsbixhu")
    public suspend fun serverRootCACertificate(`value`: Output<String>) {
        this.serverRootCACertificate = value
    }

    /**
     * @param value The Active Directory site the service will limit Domain Controller discovery to
     */
    @JvmName("dgltmcgutpflepul")
    public suspend fun site(`value`: Output<String>) {
        this.site = value
    }

    /**
     * @param value NetBIOS name of the SMB server. This name will be registered as a computer account in the AD and used to mount volumes
     */
    @JvmName("smrmoipwqrqrrxbf")
    public suspend fun smbServerName(`value`: Output<String>) {
        this.smbServerName = value
    }

    /**
     * @param value A domain user account with permission to create machine accounts
     */
    @JvmName("fshdysruudogvchg")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Id of the Active Directory
     */
    @JvmName("jiduecrrfxpukyjh")
    public suspend fun activeDirectoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeDirectoryId = mapped
    }

    /**
     * @param value Name of the active directory machine. This optional parameter is used only while creating kerberos volume
     */
    @JvmName("ivaimxdxgyojdjbe")
    public suspend fun adName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adName = mapped
    }

    /**
     * @param value Users to be added to the Built-in Administrators active directory group. A list of unique usernames without domain specifier
     */
    @JvmName("sccmibnedsmgssvt")
    public suspend fun administrators(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administrators = mapped
    }

    /**
     * @param values Users to be added to the Built-in Administrators active directory group. A list of unique usernames without domain specifier
     */
    @JvmName("skrjuvqjktfmlklp")
    public suspend fun administrators(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.administrators = mapped
    }

    /**
     * @param value If enabled, AES encryption will be enabled for SMB communication.
     */
    @JvmName("ujbfsfdacglhuwoy")
    public suspend fun aesEncryption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aesEncryption = mapped
    }

    /**
     * @param value  If enabled, NFS client local users can also (in addition to LDAP users) access the NFS volumes.
     */
    @JvmName("ylxdkjexyryscgxk")
    public suspend fun allowLocalNfsUsersWithLdap(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowLocalNfsUsersWithLdap = mapped
    }

    /**
     * @param value Users to be added to the Built-in Backup Operator active directory group. A list of unique usernames without domain specifier
     */
    @JvmName("nujtpfqdpxlnpxbm")
    public suspend fun backupOperators(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupOperators = mapped
    }

    /**
     * @param values Users to be added to the Built-in Backup Operator active directory group. A list of unique usernames without domain specifier
     */
    @JvmName("gcqryotqilwdvwmg")
    public suspend fun backupOperators(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupOperators = mapped
    }

    /**
     * @param value Comma separated list of DNS server IP addresses (IPv4 only) for the Active Directory domain
     */
    @JvmName("boarhtgfachraaew")
    public suspend fun dns(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dns = mapped
    }

    /**
     * @param value Name of the Active Directory domain
     */
    @JvmName("tuhwfhlyjsjycsyn")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value If enabled, Traffic between the SMB server to Domain Controller (DC) will be encrypted.
     */
    @JvmName("gedsyeqorifurmsp")
    public suspend fun encryptDCConnections(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptDCConnections = mapped
    }

    /**
     * @param value kdc server IP addresses for the active directory machine. This optional parameter is used only while creating kerberos volume.
     */
    @JvmName("aqlgitbsgiarkpdi")
    public suspend fun kdcIP(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kdcIP = mapped
    }

    /**
     * @param value Specifies whether or not the LDAP traffic needs to be secured via TLS.
     */
    @JvmName("qffraadmxfccvvkt")
    public suspend fun ldapOverTLS(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ldapOverTLS = mapped
    }

    /**
     * @param value LDAP Search scope options
     */
    @JvmName("hahktejclefebluv")
    public suspend fun ldapSearchScope(`value`: LdapSearchScopeOptArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ldapSearchScope = mapped
    }

    /**
     * @param argument LDAP Search scope options
     */
    @JvmName("cwjpdufrkekwclji")
    public suspend fun ldapSearchScope(argument: suspend LdapSearchScopeOptArgsBuilder.() -> Unit) {
        val toBeMapped = LdapSearchScopeOptArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ldapSearchScope = mapped
    }

    /**
     * @param value Specifies whether or not the LDAP traffic needs to be signed.
     */
    @JvmName("hhnejmvimemewwde")
    public suspend fun ldapSigning(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ldapSigning = mapped
    }

    /**
     * @param value The Organizational Unit (OU) within the Windows Active Directory
     */
    @JvmName("gomcayhcdilvlsjg")
    public suspend fun organizationalUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationalUnit = mapped
    }

    /**
     * @param value Plain text password of Active Directory domain administrator, value is masked in the response
     */
    @JvmName("ffwpbksjgtwqmbwd")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Comma separated list of IPv4 addresses of preferred servers for LDAP client. At most two comma separated IPv4 addresses can be passed.
     */
    @JvmName("jddmawoccwqobrqs")
    public suspend fun preferredServersForLdapClient(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredServersForLdapClient = mapped
    }

    /**
     * @param value Domain Users in the Active directory to be given SeSecurityPrivilege privilege (Needed for SMB Continuously available shares for SQL). A list of unique usernames without domain specifier
     */
    @JvmName("ojrenumcwvccckux")
    public suspend fun securityOperators(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityOperators = mapped
    }

    /**
     * @param values Domain Users in the Active directory to be given SeSecurityPrivilege privilege (Needed for SMB Continuously available shares for SQL). A list of unique usernames without domain specifier
     */
    @JvmName("uswndxeggwljxoqc")
    public suspend fun securityOperators(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityOperators = mapped
    }

    /**
     * @param value When LDAP over SSL/TLS is enabled, the LDAP client is required to have base64 encoded Active Directory Certificate Service's self-signed root CA certificate, this optional parameter is used only for dual protocol with LDAP user-mapping volumes.
     */
    @JvmName("sbjejancbdghtghw")
    public suspend fun serverRootCACertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverRootCACertificate = mapped
    }

    /**
     * @param value The Active Directory site the service will limit Domain Controller discovery to
     */
    @JvmName("diwqenogylsemyea")
    public suspend fun site(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.site = mapped
    }

    /**
     * @param value NetBIOS name of the SMB server. This name will be registered as a computer account in the AD and used to mount volumes
     */
    @JvmName("ptygrrsxpdxhxccj")
    public suspend fun smbServerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smbServerName = mapped
    }

    /**
     * @param value A domain user account with permission to create machine accounts
     */
    @JvmName("mkvgmueloucyeaiy")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): ActiveDirectoryArgs = ActiveDirectoryArgs(
        activeDirectoryId = activeDirectoryId,
        adName = adName,
        administrators = administrators,
        aesEncryption = aesEncryption,
        allowLocalNfsUsersWithLdap = allowLocalNfsUsersWithLdap,
        backupOperators = backupOperators,
        dns = dns,
        domain = domain,
        encryptDCConnections = encryptDCConnections,
        kdcIP = kdcIP,
        ldapOverTLS = ldapOverTLS,
        ldapSearchScope = ldapSearchScope,
        ldapSigning = ldapSigning,
        organizationalUnit = organizationalUnit,
        password = password,
        preferredServersForLdapClient = preferredServersForLdapClient,
        securityOperators = securityOperators,
        serverRootCACertificate = serverRootCACertificate,
        site = site,
        smbServerName = smbServerName,
        username = username,
    )
}
