@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.GetSnapshotPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the NetApp account
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property snapshotPolicyName The name of the snapshot policy
 */
public data class GetSnapshotPolicyPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
    public val snapshotPolicyName: String,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.GetSnapshotPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.GetSnapshotPolicyPlainArgs =
        com.pulumi.azurenative.netapp.inputs.GetSnapshotPolicyPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .snapshotPolicyName(snapshotPolicyName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSnapshotPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetSnapshotPolicyPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    private var snapshotPolicyName: String? = null

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("lxhwvlrormsdcaxt")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ygbjqqqhvwxcecwb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the snapshot policy
     */
    @JvmName("hvkcbnfjywyahitw")
    public suspend fun snapshotPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.snapshotPolicyName = mapped
    }

    internal fun build(): GetSnapshotPolicyPlainArgs = GetSnapshotPolicyPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        snapshotPolicyName = snapshotPolicyName ?: throw PulumiNullFieldException("snapshotPolicyName"),
    )
}
