@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.GetSubvolumePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the NetApp account
 * @property poolName The name of the capacity pool
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property subvolumeName The name of the subvolume.
 * @property volumeName The name of the volume
 */
public data class GetSubvolumePlainArgs(
    public val accountName: String,
    public val poolName: String,
    public val resourceGroupName: String,
    public val subvolumeName: String,
    public val volumeName: String,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.GetSubvolumePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.GetSubvolumePlainArgs =
        com.pulumi.azurenative.netapp.inputs.GetSubvolumePlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .poolName(poolName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .subvolumeName(subvolumeName.let({ args0 -> args0 }))
            .volumeName(volumeName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSubvolumePlainArgs].
 */
@PulumiTagMarker
public class GetSubvolumePlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var poolName: String? = null

    private var resourceGroupName: String? = null

    private var subvolumeName: String? = null

    private var volumeName: String? = null

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("ysagbbokgyseuuap")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the capacity pool
     */
    @JvmName("gvlrpiqgyddxhaxb")
    public suspend fun poolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.poolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eutntlmplksvbwcc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the subvolume.
     */
    @JvmName("ikcchqsakvpugwbx")
    public suspend fun subvolumeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.subvolumeName = mapped
    }

    /**
     * @param value The name of the volume
     */
    @JvmName("gwnkrecyanurnips")
    public suspend fun volumeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.volumeName = mapped
    }

    internal fun build(): GetSubvolumePlainArgs = GetSubvolumePlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        poolName = poolName ?: throw PulumiNullFieldException("poolName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        subvolumeName = subvolumeName ?: throw PulumiNullFieldException("subvolumeName"),
        volumeName = volumeName ?: throw PulumiNullFieldException("volumeName"),
    )
}
