@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.MonthlyScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Monthly Schedule properties
 * @property daysOfMonth Indicates which days of the month snapshot should be taken. A comma delimited string.
 * @property hour Indicates which hour in UTC timezone a snapshot should be taken
 * @property minute Indicates which minute snapshot should be taken
 * @property snapshotsToKeep Monthly snapshot count to keep
 * @property usedBytes Resource size in bytes, current storage usage for the volume in bytes
 */
public data class MonthlyScheduleArgs(
    public val daysOfMonth: Output<String>? = null,
    public val hour: Output<Int>? = null,
    public val minute: Output<Int>? = null,
    public val snapshotsToKeep: Output<Int>? = null,
    public val usedBytes: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.MonthlyScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.MonthlyScheduleArgs =
        com.pulumi.azurenative.netapp.inputs.MonthlyScheduleArgs.builder()
            .daysOfMonth(daysOfMonth?.applyValue({ args0 -> args0 }))
            .hour(hour?.applyValue({ args0 -> args0 }))
            .minute(minute?.applyValue({ args0 -> args0 }))
            .snapshotsToKeep(snapshotsToKeep?.applyValue({ args0 -> args0 }))
            .usedBytes(usedBytes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MonthlyScheduleArgs].
 */
@PulumiTagMarker
public class MonthlyScheduleArgsBuilder internal constructor() {
    private var daysOfMonth: Output<String>? = null

    private var hour: Output<Int>? = null

    private var minute: Output<Int>? = null

    private var snapshotsToKeep: Output<Int>? = null

    private var usedBytes: Output<Double>? = null

    /**
     * @param value Indicates which days of the month snapshot should be taken. A comma delimited string.
     */
    @JvmName("ayguufxahmwfnlpp")
    public suspend fun daysOfMonth(`value`: Output<String>) {
        this.daysOfMonth = value
    }

    /**
     * @param value Indicates which hour in UTC timezone a snapshot should be taken
     */
    @JvmName("mvjwbqaakfgnofhd")
    public suspend fun hour(`value`: Output<Int>) {
        this.hour = value
    }

    /**
     * @param value Indicates which minute snapshot should be taken
     */
    @JvmName("dlohtbytsscgfgax")
    public suspend fun minute(`value`: Output<Int>) {
        this.minute = value
    }

    /**
     * @param value Monthly snapshot count to keep
     */
    @JvmName("pgbbhbniqewcisri")
    public suspend fun snapshotsToKeep(`value`: Output<Int>) {
        this.snapshotsToKeep = value
    }

    /**
     * @param value Resource size in bytes, current storage usage for the volume in bytes
     */
    @JvmName("rqgwahytlcvqqgmf")
    public suspend fun usedBytes(`value`: Output<Double>) {
        this.usedBytes = value
    }

    /**
     * @param value Indicates which days of the month snapshot should be taken. A comma delimited string.
     */
    @JvmName("lmycywxmshtlwmdo")
    public suspend fun daysOfMonth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daysOfMonth = mapped
    }

    /**
     * @param value Indicates which hour in UTC timezone a snapshot should be taken
     */
    @JvmName("olhpbjxedyvxvqgg")
    public suspend fun hour(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hour = mapped
    }

    /**
     * @param value Indicates which minute snapshot should be taken
     */
    @JvmName("rscjlrmlnjltdeoc")
    public suspend fun minute(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minute = mapped
    }

    /**
     * @param value Monthly snapshot count to keep
     */
    @JvmName("dlhcnbeylbppmsoq")
    public suspend fun snapshotsToKeep(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotsToKeep = mapped
    }

    /**
     * @param value Resource size in bytes, current storage usage for the volume in bytes
     */
    @JvmName("wpregfqcmadgddrs")
    public suspend fun usedBytes(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usedBytes = mapped
    }

    internal fun build(): MonthlyScheduleArgs = MonthlyScheduleArgs(
        daysOfMonth = daysOfMonth,
        hour = hour,
        minute = minute,
        snapshotsToKeep = snapshotsToKeep,
        usedBytes = usedBytes,
    )
}
