@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.VolumeRelocationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Volume relocation properties
 * @property relocationRequested Has relocation been requested for this volume
 */
public data class VolumeRelocationPropertiesArgs(
    public val relocationRequested: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.VolumeRelocationPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.VolumeRelocationPropertiesArgs =
        com.pulumi.azurenative.netapp.inputs.VolumeRelocationPropertiesArgs.builder()
            .relocationRequested(relocationRequested?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeRelocationPropertiesArgs].
 */
@PulumiTagMarker
public class VolumeRelocationPropertiesArgsBuilder internal constructor() {
    private var relocationRequested: Output<Boolean>? = null

    /**
     * @param value Has relocation been requested for this volume
     */
    @JvmName("xxkacpqbnkvrrpwc")
    public suspend fun relocationRequested(`value`: Output<Boolean>) {
        this.relocationRequested = value
    }

    /**
     * @param value Has relocation been requested for this volume
     */
    @JvmName("xfccrhhkmvjlediv")
    public suspend fun relocationRequested(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relocationRequested = mapped
    }

    internal fun build(): VolumeRelocationPropertiesArgs = VolumeRelocationPropertiesArgs(
        relocationRequested = relocationRequested,
    )
}
