@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Snapshot of a Volume
 * @property created The creation date of the snapshot
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location Resource location
 * @property name The name of the resource
 * @property provisioningState Azure lifecycle management
 * @property snapshotId UUID v4 used to identify the Snapshot
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetSnapshotResult(
    public val created: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val snapshotId: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.GetSnapshotResult):
            GetSnapshotResult = GetSnapshotResult(
            created = javaType.created(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            snapshotId = javaType.snapshotId(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
