@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Volume group resource for create
 * @property groupMetaData Volume group details
 * @property id Resource Id
 * @property location Resource location
 * @property name Resource name
 * @property provisioningState Azure lifecycle management
 * @property type Resource type
 * @property volumes List of volumes from group
 */
public data class GetVolumeGroupResult(
    public val groupMetaData: VolumeGroupMetaDataResponse? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val type: String,
    public val volumes: List<VolumeGroupVolumePropertiesResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.GetVolumeGroupResult):
            GetVolumeGroupResult = GetVolumeGroupResult(
            groupMetaData = javaType.groupMetaData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.netapp.kotlin.outputs.VolumeGroupMetaDataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
            volumes = javaType.volumes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.netapp.kotlin.outputs.VolumeGroupVolumePropertiesResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
