@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Quota Rule of a Volume
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState Gets the status of the VolumeQuotaRule at the time the operation was called.
 * @property quotaSizeInKiBs Size of quota
 * @property quotaTarget UserID/GroupID/SID based on the quota target type. UserID and groupID can be found by running ‘id’ or ‘getent’ command for the user or group and SID can be found by running <wmic useraccount where name='user-name' get sid>
 * @property quotaType Type of quota
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetVolumeQuotaRuleResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val quotaSizeInKiBs: Double? = null,
    public val quotaTarget: String? = null,
    public val quotaType: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.GetVolumeQuotaRuleResult):
            GetVolumeQuotaRuleResult = GetVolumeQuotaRuleResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            quotaSizeInKiBs = javaType.quotaSizeInKiBs().map({ args0 -> args0 }).orElse(null),
            quotaTarget = javaType.quotaTarget().map({ args0 -> args0 }).orElse(null),
            quotaType = javaType.quotaType().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
