@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of key vault.
 * @property keyName The name of KeyVault key.
 * @property keyVaultId UUID v4 used to identify the Azure Key Vault configuration
 * @property keyVaultResourceId The resource ID of KeyVault.
 * @property keyVaultUri The Uri of KeyVault.
 * @property status Status of the KeyVault connection.
 */
public data class KeyVaultPropertiesResponse(
    public val keyName: String,
    public val keyVaultId: String,
    public val keyVaultResourceId: String,
    public val keyVaultUri: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.KeyVaultPropertiesResponse):
            KeyVaultPropertiesResponse = KeyVaultPropertiesResponse(
            keyName = javaType.keyName(),
            keyVaultId = javaType.keyVaultId(),
            keyVaultResourceId = javaType.keyVaultResourceId(),
            keyVaultUri = javaType.keyVaultUri(),
            status = javaType.status(),
        )
    }
}
