@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.NetworkManagerSecurityGroupItemResponse
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.network.kotlin.outputs.NetworkManagerSecurityGroupItemResponse.Companion.toKotlin as networkManagerSecurityGroupItemResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AdminRuleCollection].
 */
@PulumiTagMarker
public class AdminRuleCollectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AdminRuleCollectionArgs = AdminRuleCollectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AdminRuleCollectionArgsBuilder.() -> Unit) {
        val builder = AdminRuleCollectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AdminRuleCollection {
        val builtJavaResource =
            com.pulumi.azurenative.network.AdminRuleCollection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AdminRuleCollection(builtJavaResource)
    }
}

/**
 * Defines the admin rule collection.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2021-02-01-preview, 2021-05-01-preview, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create or Update an admin rule collection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var adminRuleCollection = new AzureNative.Network.AdminRuleCollection("adminRuleCollection", new()
 *     {
 *         AppliesToGroups = new[]
 *         {
 *             new AzureNative.Network.Inputs.NetworkManagerSecurityGroupItemArgs
 *             {
 *                 NetworkGroupId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Network/networkManagers/testNetworkManager/networkGroups/testGroup",
 *             },
 *         },
 *         ConfigurationName = "myTestSecurityConfig",
 *         Description = "A sample policy",
 *         NetworkManagerName = "testNetworkManager",
 *         ResourceGroupName = "rg1",
 *         RuleCollectionName = "testRuleCollection",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewAdminRuleCollection(ctx, "adminRuleCollection", &network.AdminRuleCollectionArgs{
 * 			AppliesToGroups: []network.NetworkManagerSecurityGroupItemArgs{
 * 				{
 * 					NetworkGroupId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Network/networkManagers/testNetworkManager/networkGroups/testGroup"),
 * 				},
 * 			},
 * 			ConfigurationName:  pulumi.String("myTestSecurityConfig"),
 * 			Description:        pulumi.String("A sample policy"),
 * 			NetworkManagerName: pulumi.String("testNetworkManager"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			RuleCollectionName: pulumi.String("testRuleCollection"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.AdminRuleCollection;
 * import com.pulumi.azurenative.network.AdminRuleCollectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var adminRuleCollection = new AdminRuleCollection("adminRuleCollection", AdminRuleCollectionArgs.builder()
 *             .appliesToGroups(Map.of("networkGroupId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Network/networkManagers/testNetworkManager/networkGroups/testGroup"))
 *             .configurationName("myTestSecurityConfig")
 *             .description("A sample policy")
 *             .networkManagerName("testNetworkManager")
 *             .resourceGroupName("rg1")
 *             .ruleCollectionName("testRuleCollection")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:AdminRuleCollection myTestSecurityConfig /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/securityAdminConfigurations/{configurationName}/ruleCollections/{ruleCollectionName}
 * ```
 */
public class AdminRuleCollection internal constructor(
    override val javaResource: com.pulumi.azurenative.network.AdminRuleCollection,
) : KotlinCustomResource(javaResource, AdminRuleCollectionMapper) {
    /**
     * Groups for configuration
     */
    public val appliesToGroups: Output<List<NetworkManagerSecurityGroupItemResponse>>
        get() = javaResource.appliesToGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkManagerSecurityGroupItemResponseToKotlin(args0) })
            })
        })

    /**
     * A description of the admin rule collection.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Unique identifier for this resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * The system metadata related to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AdminRuleCollectionMapper : ResourceMapper<AdminRuleCollection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.AdminRuleCollection::class == javaResource::class

    override fun map(javaResource: Resource): AdminRuleCollection = AdminRuleCollection(
        javaResource
            as com.pulumi.azurenative.network.AdminRuleCollection,
    )
}

/**
 * @see [AdminRuleCollection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AdminRuleCollection].
 */
public suspend fun adminRuleCollection(
    name: String,
    block: suspend AdminRuleCollectionResourceBuilder.() -> Unit,
): AdminRuleCollection {
    val builder = AdminRuleCollectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AdminRuleCollection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun adminRuleCollection(name: String): AdminRuleCollection {
    val builder = AdminRuleCollectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
