@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorDestinationResponse
import com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorEndpointResponse
import com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorOutputResponse
import com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorSourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorTestConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorTestGroupResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorDestinationResponse.Companion.toKotlin as connectionMonitorDestinationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorEndpointResponse.Companion.toKotlin as connectionMonitorEndpointResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorOutputResponse.Companion.toKotlin as connectionMonitorOutputResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorSourceResponse.Companion.toKotlin as connectionMonitorSourceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorTestConfigurationResponse.Companion.toKotlin as connectionMonitorTestConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorTestGroupResponse.Companion.toKotlin as connectionMonitorTestGroupResponseToKotlin

/**
 * Builder for [ConnectionMonitor].
 */
@PulumiTagMarker
public class ConnectionMonitorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectionMonitorArgs = ConnectionMonitorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectionMonitorArgsBuilder.() -> Unit) {
        val builder = ConnectionMonitorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConnectionMonitor {
        val builtJavaResource =
            com.pulumi.azurenative.network.ConnectionMonitor(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConnectionMonitor(builtJavaResource)
    }
}

/**
 * Information about the connection monitor.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-09-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create connection monitor V1
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectionMonitor = new AzureNative.Network.ConnectionMonitor("connectionMonitor", new()
 *     {
 *         ConnectionMonitorName = "cm1",
 *         Endpoints = new[]
 *         {
 *             new AzureNative.Network.Inputs.ConnectionMonitorEndpointArgs
 *             {
 *                 Name = "source",
 *                 ResourceId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Compute/virtualMachines/ct1",
 *             },
 *             new AzureNative.Network.Inputs.ConnectionMonitorEndpointArgs
 *             {
 *                 Address = "bing.com",
 *                 Name = "destination",
 *             },
 *         },
 *         Location = "eastus",
 *         NetworkWatcherName = "nw1",
 *         ResourceGroupName = "rg1",
 *         TestConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.ConnectionMonitorTestConfigurationArgs
 *             {
 *                 Name = "tcp",
 *                 Protocol = "Tcp",
 *                 TcpConfiguration = new AzureNative.Network.Inputs.ConnectionMonitorTcpConfigurationArgs
 *                 {
 *                     Port = 80,
 *                 },
 *                 TestFrequencySec = 60,
 *             },
 *         },
 *         TestGroups = new[]
 *         {
 *             new AzureNative.Network.Inputs.ConnectionMonitorTestGroupArgs
 *             {
 *                 Destinations = new[]
 *                 {
 *                     "destination",
 *                 },
 *                 Name = "tg",
 *                 Sources = new[]
 *                 {
 *                     "source",
 *                 },
 *                 TestConfigurations = new[]
 *                 {
 *                     "tcp",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewConnectionMonitor(ctx, "connectionMonitor", &network.ConnectionMonitorArgs{
 * 			ConnectionMonitorName: pulumi.String("cm1"),
 * 			Endpoints: []network.ConnectionMonitorEndpointArgs{
 * 				{
 * 					Name:       pulumi.String("source"),
 * 					ResourceId: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Compute/virtualMachines/ct1"),
 * 				},
 * 				{
 * 					Address: pulumi.String("bing.com"),
 * 					Name:    pulumi.String("destination"),
 * 				},
 * 			},
 * 			Location:           pulumi.String("eastus"),
 * 			NetworkWatcherName: pulumi.String("nw1"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			TestConfigurations: []network.ConnectionMonitorTestConfigurationArgs{
 * 				{
 * 					Name:     pulumi.String("tcp"),
 * 					Protocol: pulumi.String("Tcp"),
 * 					TcpConfiguration: {
 * 						Port: pulumi.Int(80),
 * 					},
 * 					TestFrequencySec: pulumi.Int(60),
 * 				},
 * 			},
 * 			TestGroups: []network.ConnectionMonitorTestGroupArgs{
 * 				{
 * 					Destinations: pulumi.StringArray{
 * 						pulumi.String("destination"),
 * 					},
 * 					Name: pulumi.String("tg"),
 * 					Sources: pulumi.StringArray{
 * 						pulumi.String("source"),
 * 					},
 * 					TestConfigurations: pulumi.StringArray{
 * 						pulumi.String("tcp"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ConnectionMonitor;
 * import com.pulumi.azurenative.network.ConnectionMonitorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectionMonitor = new ConnectionMonitor("connectionMonitor", ConnectionMonitorArgs.builder()
 *             .connectionMonitorName("cm1")
 *             .endpoints(
 *                 Map.ofEntries(
 *                     Map.entry("name", "source"),
 *                     Map.entry("resourceId", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Compute/virtualMachines/ct1")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("address", "bing.com"),
 *                     Map.entry("name", "destination")
 *                 ))
 *             .location("eastus")
 *             .networkWatcherName("nw1")
 *             .resourceGroupName("rg1")
 *             .testConfigurations(Map.ofEntries(
 *                 Map.entry("name", "tcp"),
 *                 Map.entry("protocol", "Tcp"),
 *                 Map.entry("tcpConfiguration", Map.of("port", 80)),
 *                 Map.entry("testFrequencySec", 60)
 *             ))
 *             .testGroups(Map.ofEntries(
 *                 Map.entry("destinations", "destination"),
 *                 Map.entry("name", "tg"),
 *                 Map.entry("sources", "source"),
 *                 Map.entry("testConfigurations", "tcp")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create connection monitor V2
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectionMonitor = new AzureNative.Network.ConnectionMonitor("connectionMonitor", new()
 *     {
 *         ConnectionMonitorName = "cm1",
 *         Endpoints = new[]
 *         {
 *             new AzureNative.Network.Inputs.ConnectionMonitorEndpointArgs
 *             {
 *                 Name = "vm1",
 *                 ResourceId = "/subscriptions/96e68903-0a56-4819-9987-8d08ad6a1f99/resourceGroups/NwRgIrinaCentralUSEUAP/providers/Microsoft.Compute/virtualMachines/vm1",
 *             },
 *             new AzureNative.Network.Inputs.ConnectionMonitorEndpointArgs
 *             {
 *                 Filter = new AzureNative.Network.Inputs.ConnectionMonitorEndpointFilterArgs
 *                 {
 *                     Items = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.ConnectionMonitorEndpointFilterItemArgs
 *                         {
 *                             Address = "npmuser",
 *                             Type = "AgentAddress",
 *                         },
 *                     },
 *                     Type = "Include",
 *                 },
 *                 Name = "CanaryWorkspaceVamshi",
 *                 ResourceId = "/subscriptions/96e68903-0a56-4819-9987-8d08ad6a1f99/resourceGroups/vasamudrRG/providers/Microsoft.OperationalInsights/workspaces/vasamudrWorkspace",
 *             },
 *             new AzureNative.Network.Inputs.ConnectionMonitorEndpointArgs
 *             {
 *                 Address = "bing.com",
 *                 Name = "bing",
 *             },
 *             new AzureNative.Network.Inputs.ConnectionMonitorEndpointArgs
 *             {
 *                 Address = "google.com",
 *                 Name = "google",
 *             },
 *         },
 *         NetworkWatcherName = "nw1",
 *         Outputs = new[] {},
 *         ResourceGroupName = "rg1",
 *         TestConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.ConnectionMonitorTestConfigurationArgs
 *             {
 *                 Name = "testConfig1",
 *                 Protocol = "Tcp",
 *                 TcpConfiguration = new AzureNative.Network.Inputs.ConnectionMonitorTcpConfigurationArgs
 *                 {
 *                     DisableTraceRoute = false,
 *                     Port = 80,
 *                 },
 *                 TestFrequencySec = 60,
 *             },
 *         },
 *         TestGroups = new[]
 *         {
 *             new AzureNative.Network.Inputs.ConnectionMonitorTestGroupArgs
 *             {
 *                 Destinations = new[]
 *                 {
 *                     "bing",
 *                     "google",
 *                 },
 *                 Disable = false,
 *                 Name = "test1",
 *                 Sources = new[]
 *                 {
 *                     "vm1",
 *                     "CanaryWorkspaceVamshi",
 *                 },
 *                 TestConfigurations = new[]
 *                 {
 *                     "testConfig1",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewConnectionMonitor(ctx, "connectionMonitor", &network.ConnectionMonitorArgs{
 * 			ConnectionMonitorName: pulumi.String("cm1"),
 * 			Endpoints: []network.ConnectionMonitorEndpointArgs{
 * 				{
 * 					Name:       pulumi.String("vm1"),
 * 					ResourceId: pulumi.String("/subscriptions/96e68903-0a56-4819-9987-8d08ad6a1f99/resourceGroups/NwRgIrinaCentralUSEUAP/providers/Microsoft.Compute/virtualMachines/vm1"),
 * 				},
 * 				{
 * 					Filter: {
 * 						Items: network.ConnectionMonitorEndpointFilterItemArray{
 * 							{
 * 								Address: pulumi.String("npmuser"),
 * 								Type:    pulumi.String("AgentAddress"),
 * 							},
 * 						},
 * 						Type: pulumi.String("Include"),
 * 					},
 * 					Name:       pulumi.String("CanaryWorkspaceVamshi"),
 * 					ResourceId: pulumi.String("/subscriptions/96e68903-0a56-4819-9987-8d08ad6a1f99/resourceGroups/vasamudrRG/providers/Microsoft.OperationalInsights/workspaces/vasamudrWorkspace"),
 * 				},
 * 				{
 * 					Address: pulumi.String("bing.com"),
 * 					Name:    pulumi.String("bing"),
 * 				},
 * 				{
 * 					Address: pulumi.String("google.com"),
 * 					Name:    pulumi.String("google"),
 * 				},
 * 			},
 * 			NetworkWatcherName: pulumi.String("nw1"),
 * 			Outputs:            network.ConnectionMonitorOutputTypeArray{},
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			TestConfigurations: []network.ConnectionMonitorTestConfigurationArgs{
 * 				{
 * 					Name:     pulumi.String("testConfig1"),
 * 					Protocol: pulumi.String("Tcp"),
 * 					TcpConfiguration: {
 * 						DisableTraceRoute: pulumi.Bool(false),
 * 						Port:              pulumi.Int(80),
 * 					},
 * 					TestFrequencySec: pulumi.Int(60),
 * 				},
 * 			},
 * 			TestGroups: []network.ConnectionMonitorTestGroupArgs{
 * 				{
 * 					Destinations: pulumi.StringArray{
 * 						pulumi.String("bing"),
 * 						pulumi.String("google"),
 * 					},
 * 					Disable: pulumi.Bool(false),
 * 					Name:    pulumi.String("test1"),
 * 					Sources: pulumi.StringArray{
 * 						pulumi.String("vm1"),
 * 						pulumi.String("CanaryWorkspaceVamshi"),
 * 					},
 * 					TestConfigurations: pulumi.StringArray{
 * 						pulumi.String("testConfig1"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ConnectionMonitor;
 * import com.pulumi.azurenative.network.ConnectionMonitorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectionMonitor = new ConnectionMonitor("connectionMonitor", ConnectionMonitorArgs.builder()
 *             .connectionMonitorName("cm1")
 *             .endpoints(
 *                 Map.ofEntries(
 *                     Map.entry("name", "vm1"),
 *                     Map.entry("resourceId", "/subscriptions/96e68903-0a56-4819-9987-8d08ad6a1f99/resourceGroups/NwRgIrinaCentralUSEUAP/providers/Microsoft.Compute/virtualMachines/vm1")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("filter", Map.ofEntries(
 *                         Map.entry("items", Map.ofEntries(
 *                             Map.entry("address", "npmuser"),
 *                             Map.entry("type", "AgentAddress")
 *                         )),
 *                         Map.entry("type", "Include")
 *                     )),
 *                     Map.entry("name", "CanaryWorkspaceVamshi"),
 *                     Map.entry("resourceId", "/subscriptions/96e68903-0a56-4819-9987-8d08ad6a1f99/resourceGroups/vasamudrRG/providers/Microsoft.OperationalInsights/workspaces/vasamudrWorkspace")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("address", "bing.com"),
 *                     Map.entry("name", "bing")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("address", "google.com"),
 *                     Map.entry("name", "google")
 *                 ))
 *             .networkWatcherName("nw1")
 *             .outputs()
 *             .resourceGroupName("rg1")
 *             .testConfigurations(Map.ofEntries(
 *                 Map.entry("name", "testConfig1"),
 *                 Map.entry("protocol", "Tcp"),
 *                 Map.entry("tcpConfiguration", Map.ofEntries(
 *                     Map.entry("disableTraceRoute", false),
 *                     Map.entry("port", 80)
 *                 )),
 *                 Map.entry("testFrequencySec", 60)
 *             ))
 *             .testGroups(Map.ofEntries(
 *                 Map.entry("destinations",
 *                     "bing",
 *                     "google"),
 *                 Map.entry("disable", false),
 *                 Map.entry("name", "test1"),
 *                 Map.entry("sources",
 *                     "vm1",
 *                     "CanaryWorkspaceVamshi"),
 *                 Map.entry("testConfigurations", "testConfig1")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ConnectionMonitor cm1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}
 * ```
 */
public class ConnectionMonitor internal constructor(
    override val javaResource: com.pulumi.azurenative.network.ConnectionMonitor,
) : KotlinCustomResource(javaResource, ConnectionMonitorMapper) {
    /**
     * Determines if the connection monitor will start automatically once created.
     */
    public val autoStart: Output<Boolean>?
        get() = javaResource.autoStart().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Type of connection monitor.
     */
    public val connectionMonitorType: Output<String>
        get() = javaResource.connectionMonitorType().applyValue({ args0 -> args0 })

    /**
     * Describes the destination of connection monitor.
     */
    public val destination: Output<ConnectionMonitorDestinationResponse>?
        get() = javaResource.destination().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    connectionMonitorDestinationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of connection monitor endpoints.
     */
    public val endpoints: Output<List<ConnectionMonitorEndpointResponse>>?
        get() = javaResource.endpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> connectionMonitorEndpointResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Connection monitor location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Monitoring interval in seconds.
     */
    public val monitoringIntervalInSeconds: Output<Int>?
        get() = javaResource.monitoringIntervalInSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The monitoring status of the connection monitor.
     */
    public val monitoringStatus: Output<String>
        get() = javaResource.monitoringStatus().applyValue({ args0 -> args0 })

    /**
     * Name of the connection monitor.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Optional notes to be associated with the connection monitor.
     */
    public val notes: Output<String>?
        get() = javaResource.notes().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * List of connection monitor outputs.
     */
    public val outputs: Output<List<ConnectionMonitorOutputResponse>>?
        get() = javaResource.outputs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> connectionMonitorOutputResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The provisioning state of the connection monitor.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Describes the source of connection monitor.
     */
    public val source: Output<ConnectionMonitorSourceResponse>?
        get() = javaResource.source().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    connectionMonitorSourceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The date and time when the connection monitor was started.
     */
    public val startTime: Output<String>
        get() = javaResource.startTime().applyValue({ args0 -> args0 })

    /**
     * Connection monitor tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * List of connection monitor test configurations.
     */
    public val testConfigurations: Output<List<ConnectionMonitorTestConfigurationResponse>>?
        get() = javaResource.testConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        connectionMonitorTestConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * List of connection monitor test groups.
     */
    public val testGroups: Output<List<ConnectionMonitorTestGroupResponse>>?
        get() = javaResource.testGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> connectionMonitorTestGroupResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Connection monitor type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConnectionMonitorMapper : ResourceMapper<ConnectionMonitor> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.ConnectionMonitor::class == javaResource::class

    override fun map(javaResource: Resource): ConnectionMonitor = ConnectionMonitor(
        javaResource as
            com.pulumi.azurenative.network.ConnectionMonitor,
    )
}

/**
 * @see [ConnectionMonitor].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectionMonitor].
 */
public suspend fun connectionMonitor(
    name: String,
    block: suspend ConnectionMonitorResourceBuilder.() -> Unit,
): ConnectionMonitor {
    val builder = ConnectionMonitorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectionMonitor].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectionMonitor(name: String): ConnectionMonitor {
    val builder = ConnectionMonitorResourceBuilder()
    builder.name(name)
    return builder.build()
}
