@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin

/**
 * Builder for [CustomIPPrefix].
 */
@PulumiTagMarker
public class CustomIPPrefixResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomIPPrefixArgs = CustomIPPrefixArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomIPPrefixArgsBuilder.() -> Unit) {
        val builder = CustomIPPrefixArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CustomIPPrefix {
        val builtJavaResource = com.pulumi.azurenative.network.CustomIPPrefix(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CustomIPPrefix(builtJavaResource)
    }
}

/**
 * Custom IP prefix resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2021-03-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create custom IP prefix allocation method
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customIPPrefix = new AzureNative.Network.CustomIPPrefix("customIPPrefix", new()
 *     {
 *         Cidr = "0.0.0.0/24",
 *         CustomIpPrefixName = "test-customipprefix",
 *         Location = "westus",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewCustomIPPrefix(ctx, "customIPPrefix", &network.CustomIPPrefixArgs{
 * 			Cidr:               pulumi.String("0.0.0.0/24"),
 * 			CustomIpPrefixName: pulumi.String("test-customipprefix"),
 * 			Location:           pulumi.String("westus"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.CustomIPPrefix;
 * import com.pulumi.azurenative.network.CustomIPPrefixArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customIPPrefix = new CustomIPPrefix("customIPPrefix", CustomIPPrefixArgs.builder()
 *             .cidr("0.0.0.0/24")
 *             .customIpPrefixName("test-customipprefix")
 *             .location("westus")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:CustomIPPrefix test-customipprefix /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/customIpPrefixes/{customIpPrefixName}
 * ```
 */
public class CustomIPPrefix internal constructor(
    override val javaResource: com.pulumi.azurenative.network.CustomIPPrefix,
) : KotlinCustomResource(javaResource, CustomIPPrefixMapper) {
    /**
     * The ASN for CIDR advertising. Should be an integer as string.
     */
    public val asn: Output<String>?
        get() = javaResource.asn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Authorization message for WAN validation.
     */
    public val authorizationMessage: Output<String>?
        get() = javaResource.authorizationMessage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of all Children for IPv6 /48 CustomIpPrefix.
     */
    public val childCustomIpPrefixes: Output<List<SubResourceResponse>>
        get() = javaResource.childCustomIpPrefixes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            })
        })

    /**
     * The prefix range in CIDR notation. Should include the start address and the prefix length.
     */
    public val cidr: Output<String>?
        get() = javaResource.cidr().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The commissioned state of the Custom IP Prefix.
     */
    public val commissionedState: Output<String>?
        get() = javaResource.commissionedState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Parent CustomIpPrefix for IPv6 /64 CustomIpPrefix.
     */
    public val customIpPrefixParent: Output<SubResourceResponse>?
        get() = javaResource.customIpPrefixParent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Whether to do express route advertise.
     */
    public val expressRouteAdvertise: Output<Boolean>?
        get() = javaResource.expressRouteAdvertise().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The extended location of the custom IP prefix.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The reason why resource is in failed state.
     */
    public val failedReason: Output<String>
        get() = javaResource.failedReason().applyValue({ args0 -> args0 })

    /**
     * The Geo for CIDR advertising. Should be an Geo code.
     */
    public val geo: Output<String>?
        get() = javaResource.geo().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Whether to Advertise the range to Internet.
     */
    public val noInternetAdvertise: Output<Boolean>?
        get() = javaResource.noInternetAdvertise().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of custom IP prefix. Should be Singular, Parent, or Child.
     */
    public val prefixType: Output<String>?
        get() = javaResource.prefixType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The provisioning state of the custom IP prefix resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The list of all referenced PublicIpPrefixes.
     */
    public val publicIpPrefixes: Output<List<SubResourceResponse>>
        get() = javaResource.publicIpPrefixes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            })
        })

    /**
     * The resource GUID property of the custom IP prefix resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * Signed message for WAN validation.
     */
    public val signedMessage: Output<String>?
        get() = javaResource.signedMessage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object CustomIPPrefixMapper : ResourceMapper<CustomIPPrefix> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.CustomIPPrefix::class == javaResource::class

    override fun map(javaResource: Resource): CustomIPPrefix = CustomIPPrefix(
        javaResource as
            com.pulumi.azurenative.network.CustomIPPrefix,
    )
}

/**
 * @see [CustomIPPrefix].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomIPPrefix].
 */
public suspend fun customIPPrefix(
    name: String,
    block: suspend CustomIPPrefixResourceBuilder.() -> Unit,
): CustomIPPrefix {
    val builder = CustomIPPrefixResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomIPPrefix].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customIPPrefix(name: String): CustomIPPrefix {
    val builder = CustomIPPrefixResourceBuilder()
    builder.name(name)
    return builder.build()
}
