@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.CustomIPPrefixArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.CommissionedState
import com.pulumi.azurenative.network.kotlin.enums.CustomIpPrefixType
import com.pulumi.azurenative.network.kotlin.enums.Geo
import com.pulumi.azurenative.network.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Custom IP prefix resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2021-03-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create custom IP prefix allocation method
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customIPPrefix = new AzureNative.Network.CustomIPPrefix("customIPPrefix", new()
 *     {
 *         Cidr = "0.0.0.0/24",
 *         CustomIpPrefixName = "test-customipprefix",
 *         Location = "westus",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewCustomIPPrefix(ctx, "customIPPrefix", &network.CustomIPPrefixArgs{
 * 			Cidr:               pulumi.String("0.0.0.0/24"),
 * 			CustomIpPrefixName: pulumi.String("test-customipprefix"),
 * 			Location:           pulumi.String("westus"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.CustomIPPrefix;
 * import com.pulumi.azurenative.network.CustomIPPrefixArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customIPPrefix = new CustomIPPrefix("customIPPrefix", CustomIPPrefixArgs.builder()
 *             .cidr("0.0.0.0/24")
 *             .customIpPrefixName("test-customipprefix")
 *             .location("westus")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:CustomIPPrefix test-customipprefix /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/customIpPrefixes/{customIpPrefixName}
 * ```
 * @property asn The ASN for CIDR advertising. Should be an integer as string.
 * @property authorizationMessage Authorization message for WAN validation.
 * @property cidr The prefix range in CIDR notation. Should include the start address and the prefix length.
 * @property commissionedState The commissioned state of the Custom IP Prefix.
 * @property customIpPrefixName The name of the custom IP prefix.
 * @property customIpPrefixParent The Parent CustomIpPrefix for IPv6 /64 CustomIpPrefix.
 * @property expressRouteAdvertise Whether to do express route advertise.
 * @property extendedLocation The extended location of the custom IP prefix.
 * @property geo The Geo for CIDR advertising. Should be an Geo code.
 * @property id Resource ID.
 * @property location Resource location.
 * @property noInternetAdvertise Whether to Advertise the range to Internet.
 * @property prefixType Type of custom IP prefix. Should be Singular, Parent, or Child.
 * @property resourceGroupName The name of the resource group.
 * @property signedMessage Signed message for WAN validation.
 * @property tags Resource tags.
 * @property zones A list of availability zones denoting the IP allocated for the resource needs to come from.
 */
public data class CustomIPPrefixArgs(
    public val asn: Output<String>? = null,
    public val authorizationMessage: Output<String>? = null,
    public val cidr: Output<String>? = null,
    public val commissionedState: Output<Either<String, CommissionedState>>? = null,
    public val customIpPrefixName: Output<String>? = null,
    public val customIpPrefixParent: Output<SubResourceArgs>? = null,
    public val expressRouteAdvertise: Output<Boolean>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val geo: Output<Either<String, Geo>>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val noInternetAdvertise: Output<Boolean>? = null,
    public val prefixType: Output<Either<String, CustomIpPrefixType>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val signedMessage: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.CustomIPPrefixArgs> {
    override fun toJava(): com.pulumi.azurenative.network.CustomIPPrefixArgs =
        com.pulumi.azurenative.network.CustomIPPrefixArgs.builder()
            .asn(asn?.applyValue({ args0 -> args0 }))
            .authorizationMessage(authorizationMessage?.applyValue({ args0 -> args0 }))
            .cidr(cidr?.applyValue({ args0 -> args0 }))
            .commissionedState(
                commissionedState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .customIpPrefixName(customIpPrefixName?.applyValue({ args0 -> args0 }))
            .customIpPrefixParent(
                customIpPrefixParent?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .expressRouteAdvertise(expressRouteAdvertise?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .geo(
                geo?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .noInternetAdvertise(noInternetAdvertise?.applyValue({ args0 -> args0 }))
            .prefixType(
                prefixType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .signedMessage(signedMessage?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [CustomIPPrefixArgs].
 */
@PulumiTagMarker
public class CustomIPPrefixArgsBuilder internal constructor() {
    private var asn: Output<String>? = null

    private var authorizationMessage: Output<String>? = null

    private var cidr: Output<String>? = null

    private var commissionedState: Output<Either<String, CommissionedState>>? = null

    private var customIpPrefixName: Output<String>? = null

    private var customIpPrefixParent: Output<SubResourceArgs>? = null

    private var expressRouteAdvertise: Output<Boolean>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var geo: Output<Either<String, Geo>>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var noInternetAdvertise: Output<Boolean>? = null

    private var prefixType: Output<Either<String, CustomIpPrefixType>>? = null

    private var resourceGroupName: Output<String>? = null

    private var signedMessage: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value The ASN for CIDR advertising. Should be an integer as string.
     */
    @JvmName("fajuwwvbpruaqsvi")
    public suspend fun asn(`value`: Output<String>) {
        this.asn = value
    }

    /**
     * @param value Authorization message for WAN validation.
     */
    @JvmName("xtocobtjhwgsgtrs")
    public suspend fun authorizationMessage(`value`: Output<String>) {
        this.authorizationMessage = value
    }

    /**
     * @param value The prefix range in CIDR notation. Should include the start address and the prefix length.
     */
    @JvmName("daigwqalgryexiup")
    public suspend fun cidr(`value`: Output<String>) {
        this.cidr = value
    }

    /**
     * @param value The commissioned state of the Custom IP Prefix.
     */
    @JvmName("karrmfvcygbjxacc")
    public suspend fun commissionedState(`value`: Output<Either<String, CommissionedState>>) {
        this.commissionedState = value
    }

    /**
     * @param value The name of the custom IP prefix.
     */
    @JvmName("gruixkidgtbhfvrk")
    public suspend fun customIpPrefixName(`value`: Output<String>) {
        this.customIpPrefixName = value
    }

    /**
     * @param value The Parent CustomIpPrefix for IPv6 /64 CustomIpPrefix.
     */
    @JvmName("ssopoaqrkeyvqtll")
    public suspend fun customIpPrefixParent(`value`: Output<SubResourceArgs>) {
        this.customIpPrefixParent = value
    }

    /**
     * @param value Whether to do express route advertise.
     */
    @JvmName("bmxugcbcbangfgmo")
    public suspend fun expressRouteAdvertise(`value`: Output<Boolean>) {
        this.expressRouteAdvertise = value
    }

    /**
     * @param value The extended location of the custom IP prefix.
     */
    @JvmName("byccldnbjeqivblg")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The Geo for CIDR advertising. Should be an Geo code.
     */
    @JvmName("xibqqgnnrieebhcq")
    public suspend fun geo(`value`: Output<Either<String, Geo>>) {
        this.geo = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("lodbkkvfbiooswnj")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("tvhfcdlayomvgtkq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Whether to Advertise the range to Internet.
     */
    @JvmName("hxbhqsehyajrdfpx")
    public suspend fun noInternetAdvertise(`value`: Output<Boolean>) {
        this.noInternetAdvertise = value
    }

    /**
     * @param value Type of custom IP prefix. Should be Singular, Parent, or Child.
     */
    @JvmName("fcaeygdkxcjfcqwx")
    public suspend fun prefixType(`value`: Output<Either<String, CustomIpPrefixType>>) {
        this.prefixType = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("yystymrdsayhfldr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Signed message for WAN validation.
     */
    @JvmName("lbbppnpqlkcpipab")
    public suspend fun signedMessage(`value`: Output<String>) {
        this.signedMessage = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("muiasrbjcphocdlo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    @JvmName("rwxnrxrgmaoegwbj")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("pkdoplsmnkgkpihh")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    @JvmName("xkjpxjxtwxbyoxuk")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value The ASN for CIDR advertising. Should be an integer as string.
     */
    @JvmName("llmrvykmcdnwfhfk")
    public suspend fun asn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.asn = mapped
    }

    /**
     * @param value Authorization message for WAN validation.
     */
    @JvmName("hjqgqgcdarkirdba")
    public suspend fun authorizationMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationMessage = mapped
    }

    /**
     * @param value The prefix range in CIDR notation. Should include the start address and the prefix length.
     */
    @JvmName("ahbyxgckmttfsvhq")
    public suspend fun cidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidr = mapped
    }

    /**
     * @param value The commissioned state of the Custom IP Prefix.
     */
    @JvmName("fxujqfdsqomcoega")
    public suspend fun commissionedState(`value`: Either<String, CommissionedState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commissionedState = mapped
    }

    /**
     * @param value The commissioned state of the Custom IP Prefix.
     */
    @JvmName("mfbhsstggqkhkrvn")
    public fun commissionedState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CommissionedState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commissionedState = mapped
    }

    /**
     * @param value The commissioned state of the Custom IP Prefix.
     */
    @JvmName("apbyqvslkojpmwvh")
    public fun commissionedState(`value`: CommissionedState) {
        val toBeMapped = Either.ofRight<String, CommissionedState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commissionedState = mapped
    }

    /**
     * @param value The name of the custom IP prefix.
     */
    @JvmName("wndbpetpwgfrpsqk")
    public suspend fun customIpPrefixName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customIpPrefixName = mapped
    }

    /**
     * @param value The Parent CustomIpPrefix for IPv6 /64 CustomIpPrefix.
     */
    @JvmName("sfafvjcusbjmrvmo")
    public suspend fun customIpPrefixParent(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customIpPrefixParent = mapped
    }

    /**
     * @param argument The Parent CustomIpPrefix for IPv6 /64 CustomIpPrefix.
     */
    @JvmName("ydbjeerkoqrkrtki")
    public suspend fun customIpPrefixParent(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customIpPrefixParent = mapped
    }

    /**
     * @param value Whether to do express route advertise.
     */
    @JvmName("rcermhmkpdhjkjti")
    public suspend fun expressRouteAdvertise(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressRouteAdvertise = mapped
    }

    /**
     * @param value The extended location of the custom IP prefix.
     */
    @JvmName("eadebylwgxtrgpyw")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the custom IP prefix.
     */
    @JvmName("iakdovajvnjwfloa")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The Geo for CIDR advertising. Should be an Geo code.
     */
    @JvmName("fntsjprpfqhocbta")
    public suspend fun geo(`value`: Either<String, Geo>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geo = mapped
    }

    /**
     * @param value The Geo for CIDR advertising. Should be an Geo code.
     */
    @JvmName("mlqixquexurversl")
    public fun geo(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Geo>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.geo = mapped
    }

    /**
     * @param value The Geo for CIDR advertising. Should be an Geo code.
     */
    @JvmName("tbfhknojxrnnleqj")
    public fun geo(`value`: Geo) {
        val toBeMapped = Either.ofRight<String, Geo>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.geo = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("edkfkmynekibceft")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("cyphadtqcosmtvdg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Whether to Advertise the range to Internet.
     */
    @JvmName("bbbpnagyppgsvhtv")
    public suspend fun noInternetAdvertise(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noInternetAdvertise = mapped
    }

    /**
     * @param value Type of custom IP prefix. Should be Singular, Parent, or Child.
     */
    @JvmName("vfrlocsbtxmkaxxb")
    public suspend fun prefixType(`value`: Either<String, CustomIpPrefixType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixType = mapped
    }

    /**
     * @param value Type of custom IP prefix. Should be Singular, Parent, or Child.
     */
    @JvmName("ueagnjxpmuquonma")
    public fun prefixType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CustomIpPrefixType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixType = mapped
    }

    /**
     * @param value Type of custom IP prefix. Should be Singular, Parent, or Child.
     */
    @JvmName("qmdvekvhhkmybcjf")
    public fun prefixType(`value`: CustomIpPrefixType) {
        val toBeMapped = Either.ofRight<String, CustomIpPrefixType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixType = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("dxmxofgidaeeacji")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Signed message for WAN validation.
     */
    @JvmName("qoxvegynmmacwyjl")
    public suspend fun signedMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signedMessage = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lnwofxbihtsljtwx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("hmdswajjjvpbybiv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    @JvmName("xecspqgqxkjkprjh")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    @JvmName("oojxpsbxnpqyiaqj")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): CustomIPPrefixArgs = CustomIPPrefixArgs(
        asn = asn,
        authorizationMessage = authorizationMessage,
        cidr = cidr,
        commissionedState = commissionedState,
        customIpPrefixName = customIpPrefixName,
        customIpPrefixParent = customIpPrefixParent,
        expressRouteAdvertise = expressRouteAdvertise,
        extendedLocation = extendedLocation,
        geo = geo,
        id = id,
        location = location,
        noInternetAdvertise = noInternetAdvertise,
        prefixType = prefixType,
        resourceGroupName = resourceGroupName,
        signedMessage = signedMessage,
        tags = tags,
        zones = zones,
    )
}
