@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.EndpointArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.AlwaysServe
import com.pulumi.azurenative.network.kotlin.enums.EndpointMonitorStatus
import com.pulumi.azurenative.network.kotlin.enums.EndpointStatus
import com.pulumi.azurenative.network.kotlin.inputs.EndpointPropertiesCustomHeadersArgs
import com.pulumi.azurenative.network.kotlin.inputs.EndpointPropertiesCustomHeadersArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.EndpointPropertiesSubnetsArgs
import com.pulumi.azurenative.network.kotlin.inputs.EndpointPropertiesSubnetsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Class representing a Traffic Manager endpoint.
 * Azure REST API version: 2022-04-01. Prior API version in Azure Native 1.x: 2018-08-01.
 * Other available API versions: 2017-03-01, 2018-02-01, 2022-04-01-preview.
 * ## Example Usage
 * ### Endpoint-PUT-External-WithAlwaysServe
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var endpoint = new AzureNative.Network.Endpoint("endpoint", new()
 *     {
 *         AlwaysServe = "Enabled",
 *         EndpointLocation = "North Europe",
 *         EndpointName = "azsmnet7187",
 *         EndpointStatus = "Enabled",
 *         EndpointType = "ExternalEndpoints",
 *         Name = "azsmnet7187",
 *         ProfileName = "azsmnet6386",
 *         ResourceGroupName = "azuresdkfornetautoresttrafficmanager1421",
 *         Target = "foobar.contoso.com",
 *         Type = "Microsoft.network/TrafficManagerProfiles/ExternalEndpoints",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewEndpoint(ctx, "endpoint", &network.EndpointArgs{
 * 			AlwaysServe:       pulumi.String("Enabled"),
 * 			EndpointLocation:  pulumi.String("North Europe"),
 * 			EndpointName:      pulumi.String("azsmnet7187"),
 * 			EndpointStatus:    pulumi.String("Enabled"),
 * 			EndpointType:      pulumi.String("ExternalEndpoints"),
 * 			Name:              pulumi.String("azsmnet7187"),
 * 			ProfileName:       pulumi.String("azsmnet6386"),
 * 			ResourceGroupName: pulumi.String("azuresdkfornetautoresttrafficmanager1421"),
 * 			Target:            pulumi.String("foobar.contoso.com"),
 * 			Type:              pulumi.String("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Endpoint;
 * import com.pulumi.azurenative.network.EndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var endpoint = new Endpoint("endpoint", EndpointArgs.builder()
 *             .alwaysServe("Enabled")
 *             .endpointLocation("North Europe")
 *             .endpointName("azsmnet7187")
 *             .endpointStatus("Enabled")
 *             .endpointType("ExternalEndpoints")
 *             .name("azsmnet7187")
 *             .profileName("azsmnet6386")
 *             .resourceGroupName("azuresdkfornetautoresttrafficmanager1421")
 *             .target("foobar.contoso.com")
 *             .type("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints")
 *             .build());
 *     }
 * }
 * ```
 * ### Endpoint-PUT-External-WithCustomHeaders
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var endpoint = new AzureNative.Network.Endpoint("endpoint", new()
 *     {
 *         CustomHeaders = new[]
 *         {
 *             new AzureNative.Network.Inputs.EndpointPropertiesCustomHeadersArgs
 *             {
 *                 Name = "header-1",
 *                 Value = "value-1",
 *             },
 *             new AzureNative.Network.Inputs.EndpointPropertiesCustomHeadersArgs
 *             {
 *                 Name = "header-2",
 *                 Value = "value-2",
 *             },
 *         },
 *         EndpointLocation = "North Europe",
 *         EndpointName = "azsmnet7187",
 *         EndpointStatus = "Enabled",
 *         EndpointType = "ExternalEndpoints",
 *         Name = "azsmnet7187",
 *         ProfileName = "azsmnet6386",
 *         ResourceGroupName = "azuresdkfornetautoresttrafficmanager1421",
 *         Target = "foobar.contoso.com",
 *         Type = "Microsoft.network/TrafficManagerProfiles/ExternalEndpoints",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewEndpoint(ctx, "endpoint", &network.EndpointArgs{
 * 			CustomHeaders: []network.EndpointPropertiesCustomHeadersArgs{
 * 				{
 * 					Name:  pulumi.String("header-1"),
 * 					Value: pulumi.String("value-1"),
 * 				},
 * 				{
 * 					Name:  pulumi.String("header-2"),
 * 					Value: pulumi.String("value-2"),
 * 				},
 * 			},
 * 			EndpointLocation:  pulumi.String("North Europe"),
 * 			EndpointName:      pulumi.String("azsmnet7187"),
 * 			EndpointStatus:    pulumi.String("Enabled"),
 * 			EndpointType:      pulumi.String("ExternalEndpoints"),
 * 			Name:              pulumi.String("azsmnet7187"),
 * 			ProfileName:       pulumi.String("azsmnet6386"),
 * 			ResourceGroupName: pulumi.String("azuresdkfornetautoresttrafficmanager1421"),
 * 			Target:            pulumi.String("foobar.contoso.com"),
 * 			Type:              pulumi.String("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Endpoint;
 * import com.pulumi.azurenative.network.EndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var endpoint = new Endpoint("endpoint", EndpointArgs.builder()
 *             .customHeaders(
 *                 Map.ofEntries(
 *                     Map.entry("name", "header-1"),
 *                     Map.entry("value", "value-1")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "header-2"),
 *                     Map.entry("value", "value-2")
 *                 ))
 *             .endpointLocation("North Europe")
 *             .endpointName("azsmnet7187")
 *             .endpointStatus("Enabled")
 *             .endpointType("ExternalEndpoints")
 *             .name("azsmnet7187")
 *             .profileName("azsmnet6386")
 *             .resourceGroupName("azuresdkfornetautoresttrafficmanager1421")
 *             .target("foobar.contoso.com")
 *             .type("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints")
 *             .build());
 *     }
 * }
 * ```
 * ### Endpoint-PUT-External-WithGeoMapping
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var endpoint = new AzureNative.Network.Endpoint("endpoint", new()
 *     {
 *         EndpointName = "My%20external%20endpoint",
 *         EndpointStatus = "Enabled",
 *         EndpointType = "ExternalEndpoints",
 *         GeoMapping = new[]
 *         {
 *             "GEO-AS",
 *             "GEO-AF",
 *         },
 *         Name = "My external endpoint",
 *         ProfileName = "azuresdkfornetautoresttrafficmanager8224",
 *         ResourceGroupName = "azuresdkfornetautoresttrafficmanager2191",
 *         Target = "foobar.contoso.com",
 *         Type = "Microsoft.network/TrafficManagerProfiles/ExternalEndpoints",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewEndpoint(ctx, "endpoint", &network.EndpointArgs{
 * 			EndpointName:   pulumi.String("My%20external%20endpoint"),
 * 			EndpointStatus: pulumi.String("Enabled"),
 * 			EndpointType:   pulumi.String("ExternalEndpoints"),
 * 			GeoMapping: pulumi.StringArray{
 * 				pulumi.String("GEO-AS"),
 * 				pulumi.String("GEO-AF"),
 * 			},
 * 			Name:              pulumi.String("My external endpoint"),
 * 			ProfileName:       pulumi.String("azuresdkfornetautoresttrafficmanager8224"),
 * 			ResourceGroupName: pulumi.String("azuresdkfornetautoresttrafficmanager2191"),
 * 			Target:            pulumi.String("foobar.contoso.com"),
 * 			Type:              pulumi.String("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Endpoint;
 * import com.pulumi.azurenative.network.EndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var endpoint = new Endpoint("endpoint", EndpointArgs.builder()
 *             .endpointName("My%20external%20endpoint")
 *             .endpointStatus("Enabled")
 *             .endpointType("ExternalEndpoints")
 *             .geoMapping(
 *                 "GEO-AS",
 *                 "GEO-AF")
 *             .name("My external endpoint")
 *             .profileName("azuresdkfornetautoresttrafficmanager8224")
 *             .resourceGroupName("azuresdkfornetautoresttrafficmanager2191")
 *             .target("foobar.contoso.com")
 *             .type("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints")
 *             .build());
 *     }
 * }
 * ```
 * ### Endpoint-PUT-External-WithLocation
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var endpoint = new AzureNative.Network.Endpoint("endpoint", new()
 *     {
 *         EndpointLocation = "North Europe",
 *         EndpointName = "azsmnet7187",
 *         EndpointStatus = "Enabled",
 *         EndpointType = "ExternalEndpoints",
 *         Name = "azsmnet7187",
 *         ProfileName = "azsmnet6386",
 *         ResourceGroupName = "azuresdkfornetautoresttrafficmanager1421",
 *         Target = "foobar.contoso.com",
 *         Type = "Microsoft.network/TrafficManagerProfiles/ExternalEndpoints",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewEndpoint(ctx, "endpoint", &network.EndpointArgs{
 * 			EndpointLocation:  pulumi.String("North Europe"),
 * 			EndpointName:      pulumi.String("azsmnet7187"),
 * 			EndpointStatus:    pulumi.String("Enabled"),
 * 			EndpointType:      pulumi.String("ExternalEndpoints"),
 * 			Name:              pulumi.String("azsmnet7187"),
 * 			ProfileName:       pulumi.String("azsmnet6386"),
 * 			ResourceGroupName: pulumi.String("azuresdkfornetautoresttrafficmanager1421"),
 * 			Target:            pulumi.String("foobar.contoso.com"),
 * 			Type:              pulumi.String("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Endpoint;
 * import com.pulumi.azurenative.network.EndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var endpoint = new Endpoint("endpoint", EndpointArgs.builder()
 *             .endpointLocation("North Europe")
 *             .endpointName("azsmnet7187")
 *             .endpointStatus("Enabled")
 *             .endpointType("ExternalEndpoints")
 *             .name("azsmnet7187")
 *             .profileName("azsmnet6386")
 *             .resourceGroupName("azuresdkfornetautoresttrafficmanager1421")
 *             .target("foobar.contoso.com")
 *             .type("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints")
 *             .build());
 *     }
 * }
 * ```
 * ### Endpoint-PUT-External-WithSubnetMapping
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var endpoint = new AzureNative.Network.Endpoint("endpoint", new()
 *     {
 *         EndpointName = "My%20external%20endpoint",
 *         EndpointStatus = "Enabled",
 *         EndpointType = "ExternalEndpoints",
 *         Name = "My external endpoint",
 *         ProfileName = "azuresdkfornetautoresttrafficmanager8224",
 *         ResourceGroupName = "azuresdkfornetautoresttrafficmanager2191",
 *         Subnets = new[]
 *         {
 *             new AzureNative.Network.Inputs.EndpointPropertiesSubnetsArgs
 *             {
 *                 First = "1.2.3.0",
 *                 Scope = 24,
 *             },
 *             new AzureNative.Network.Inputs.EndpointPropertiesSubnetsArgs
 *             {
 *                 First = "25.26.27.28",
 *                 Last = "29.30.31.32",
 *             },
 *         },
 *         Target = "foobar.contoso.com",
 *         Type = "Microsoft.network/TrafficManagerProfiles/ExternalEndpoints",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewEndpoint(ctx, "endpoint", &network.EndpointArgs{
 * 			EndpointName:      pulumi.String("My%20external%20endpoint"),
 * 			EndpointStatus:    pulumi.String("Enabled"),
 * 			EndpointType:      pulumi.String("ExternalEndpoints"),
 * 			Name:              pulumi.String("My external endpoint"),
 * 			ProfileName:       pulumi.String("azuresdkfornetautoresttrafficmanager8224"),
 * 			ResourceGroupName: pulumi.String("azuresdkfornetautoresttrafficmanager2191"),
 * 			Subnets: []network.EndpointPropertiesSubnetsArgs{
 * 				{
 * 					First: pulumi.String("1.2.3.0"),
 * 					Scope: pulumi.Int(24),
 * 				},
 * 				{
 * 					First: pulumi.String("25.26.27.28"),
 * 					Last:  pulumi.String("29.30.31.32"),
 * 				},
 * 			},
 * 			Target: pulumi.String("foobar.contoso.com"),
 * 			Type:   pulumi.String("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Endpoint;
 * import com.pulumi.azurenative.network.EndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var endpoint = new Endpoint("endpoint", EndpointArgs.builder()
 *             .endpointName("My%20external%20endpoint")
 *             .endpointStatus("Enabled")
 *             .endpointType("ExternalEndpoints")
 *             .name("My external endpoint")
 *             .profileName("azuresdkfornetautoresttrafficmanager8224")
 *             .resourceGroupName("azuresdkfornetautoresttrafficmanager2191")
 *             .subnets(
 *                 Map.ofEntries(
 *                     Map.entry("first", "1.2.3.0"),
 *                     Map.entry("scope", 24)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("first", "25.26.27.28"),
 *                     Map.entry("last", "29.30.31.32")
 *                 ))
 *             .target("foobar.contoso.com")
 *             .type("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:Endpoint My external endpoint /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}/{endpointType}/{endpointName}
 * ```
 * @property alwaysServe If Always Serve is enabled, probing for endpoint health will be disabled and endpoints will be included in the traffic routing method.
 * @property customHeaders List of custom headers.
 * @property endpointLocation Specifies the location of the external or nested endpoints when using the 'Performance' traffic routing method.
 * @property endpointMonitorStatus The monitoring status of the endpoint.
 * @property endpointName The name of the Traffic Manager endpoint to be created or updated.
 * @property endpointStatus The status of the endpoint. If the endpoint is Enabled, it is probed for endpoint health and is included in the traffic routing method.
 * @property endpointType The type of the Traffic Manager endpoint to be created or updated.
 * @property geoMapping The list of countries/regions mapped to this endpoint when using the 'Geographic' traffic routing method. Please consult Traffic Manager Geographic documentation for a full list of accepted values.
 * @property id Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
 * @property minChildEndpoints The minimum number of endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
 * @property minChildEndpointsIPv4 The minimum number of IPv4 (DNS record type A) endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
 * @property minChildEndpointsIPv6 The minimum number of IPv6 (DNS record type AAAA) endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
 * @property name The name of the resource
 * @property priority The priority of this endpoint when using the 'Priority' traffic routing method. Possible values are from 1 to 1000, lower values represent higher priority. This is an optional parameter.  If specified, it must be specified on all endpoints, and no two endpoints can share the same priority value.
 * @property profileName The name of the Traffic Manager profile.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property subnets The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
 * @property target The fully-qualified DNS name or IP address of the endpoint. Traffic Manager returns this value in DNS responses to direct traffic to this endpoint.
 * @property targetResourceId The Azure Resource URI of the of the endpoint. Not applicable to endpoints of type 'ExternalEndpoints'.
 * @property type The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
 * @property weight The weight of this endpoint when using the 'Weighted' traffic routing method. Possible values are from 1 to 1000.
 */
public data class EndpointArgs(
    public val alwaysServe: Output<Either<String, AlwaysServe>>? = null,
    public val customHeaders: Output<List<EndpointPropertiesCustomHeadersArgs>>? = null,
    public val endpointLocation: Output<String>? = null,
    public val endpointMonitorStatus: Output<Either<String, EndpointMonitorStatus>>? = null,
    public val endpointName: Output<String>? = null,
    public val endpointStatus: Output<Either<String, EndpointStatus>>? = null,
    public val endpointType: Output<String>? = null,
    public val geoMapping: Output<List<String>>? = null,
    public val id: Output<String>? = null,
    public val minChildEndpoints: Output<Double>? = null,
    public val minChildEndpointsIPv4: Output<Double>? = null,
    public val minChildEndpointsIPv6: Output<Double>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Double>? = null,
    public val profileName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subnets: Output<List<EndpointPropertiesSubnetsArgs>>? = null,
    public val target: Output<String>? = null,
    public val targetResourceId: Output<String>? = null,
    public val type: Output<String>? = null,
    public val weight: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.EndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.network.EndpointArgs =
        com.pulumi.azurenative.network.EndpointArgs.builder()
            .alwaysServe(
                alwaysServe?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .customHeaders(
                customHeaders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .endpointLocation(endpointLocation?.applyValue({ args0 -> args0 }))
            .endpointMonitorStatus(
                endpointMonitorStatus?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .endpointName(endpointName?.applyValue({ args0 -> args0 }))
            .endpointStatus(
                endpointStatus?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .endpointType(endpointType?.applyValue({ args0 -> args0 }))
            .geoMapping(geoMapping?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .minChildEndpoints(minChildEndpoints?.applyValue({ args0 -> args0 }))
            .minChildEndpointsIPv4(minChildEndpointsIPv4?.applyValue({ args0 -> args0 }))
            .minChildEndpointsIPv6(minChildEndpointsIPv6?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subnets(
                subnets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .target(target?.applyValue({ args0 -> args0 }))
            .targetResourceId(targetResourceId?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointArgs].
 */
@PulumiTagMarker
public class EndpointArgsBuilder internal constructor() {
    private var alwaysServe: Output<Either<String, AlwaysServe>>? = null

    private var customHeaders: Output<List<EndpointPropertiesCustomHeadersArgs>>? = null

    private var endpointLocation: Output<String>? = null

    private var endpointMonitorStatus: Output<Either<String, EndpointMonitorStatus>>? = null

    private var endpointName: Output<String>? = null

    private var endpointStatus: Output<Either<String, EndpointStatus>>? = null

    private var endpointType: Output<String>? = null

    private var geoMapping: Output<List<String>>? = null

    private var id: Output<String>? = null

    private var minChildEndpoints: Output<Double>? = null

    private var minChildEndpointsIPv4: Output<Double>? = null

    private var minChildEndpointsIPv6: Output<Double>? = null

    private var name: Output<String>? = null

    private var priority: Output<Double>? = null

    private var profileName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var subnets: Output<List<EndpointPropertiesSubnetsArgs>>? = null

    private var target: Output<String>? = null

    private var targetResourceId: Output<String>? = null

    private var type: Output<String>? = null

    private var weight: Output<Double>? = null

    /**
     * @param value If Always Serve is enabled, probing for endpoint health will be disabled and endpoints will be included in the traffic routing method.
     */
    @JvmName("liebrbbubyqhyehp")
    public suspend fun alwaysServe(`value`: Output<Either<String, AlwaysServe>>) {
        this.alwaysServe = value
    }

    /**
     * @param value List of custom headers.
     */
    @JvmName("ghvuybjxohoyvoko")
    public suspend fun customHeaders(`value`: Output<List<EndpointPropertiesCustomHeadersArgs>>) {
        this.customHeaders = value
    }

    @JvmName("qvlpvupkiljsucfw")
    public suspend fun customHeaders(vararg values: Output<EndpointPropertiesCustomHeadersArgs>) {
        this.customHeaders = Output.all(values.asList())
    }

    /**
     * @param values List of custom headers.
     */
    @JvmName("erutcsyqppopblnm")
    public suspend fun customHeaders(values: List<Output<EndpointPropertiesCustomHeadersArgs>>) {
        this.customHeaders = Output.all(values)
    }

    /**
     * @param value Specifies the location of the external or nested endpoints when using the 'Performance' traffic routing method.
     */
    @JvmName("rbcnllanaibpdfmc")
    public suspend fun endpointLocation(`value`: Output<String>) {
        this.endpointLocation = value
    }

    /**
     * @param value The monitoring status of the endpoint.
     */
    @JvmName("niowsucxatfghrxu")
    public suspend fun endpointMonitorStatus(`value`: Output<Either<String, EndpointMonitorStatus>>) {
        this.endpointMonitorStatus = value
    }

    /**
     * @param value The name of the Traffic Manager endpoint to be created or updated.
     */
    @JvmName("igpslsoymoswmljl")
    public suspend fun endpointName(`value`: Output<String>) {
        this.endpointName = value
    }

    /**
     * @param value The status of the endpoint. If the endpoint is Enabled, it is probed for endpoint health and is included in the traffic routing method.
     */
    @JvmName("oiraccxyhdlvtmsx")
    public suspend fun endpointStatus(`value`: Output<Either<String, EndpointStatus>>) {
        this.endpointStatus = value
    }

    /**
     * @param value The type of the Traffic Manager endpoint to be created or updated.
     */
    @JvmName("hpgimmemfaxwabfw")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value The list of countries/regions mapped to this endpoint when using the 'Geographic' traffic routing method. Please consult Traffic Manager Geographic documentation for a full list of accepted values.
     */
    @JvmName("jbulueejkuqdmhgr")
    public suspend fun geoMapping(`value`: Output<List<String>>) {
        this.geoMapping = value
    }

    @JvmName("lbkiknhxbxojmkgn")
    public suspend fun geoMapping(vararg values: Output<String>) {
        this.geoMapping = Output.all(values.asList())
    }

    /**
     * @param values The list of countries/regions mapped to this endpoint when using the 'Geographic' traffic routing method. Please consult Traffic Manager Geographic documentation for a full list of accepted values.
     */
    @JvmName("dngbnrrymeuduhgr")
    public suspend fun geoMapping(values: List<Output<String>>) {
        this.geoMapping = Output.all(values)
    }

    /**
     * @param value Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
     */
    @JvmName("yypuapvnexycbusn")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The minimum number of endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
     */
    @JvmName("bpxuxfusiviscwcw")
    public suspend fun minChildEndpoints(`value`: Output<Double>) {
        this.minChildEndpoints = value
    }

    /**
     * @param value The minimum number of IPv4 (DNS record type A) endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
     */
    @JvmName("udaefyaupifarxsm")
    public suspend fun minChildEndpointsIPv4(`value`: Output<Double>) {
        this.minChildEndpointsIPv4 = value
    }

    /**
     * @param value The minimum number of IPv6 (DNS record type AAAA) endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
     */
    @JvmName("picmfjjaecwpxsrd")
    public suspend fun minChildEndpointsIPv6(`value`: Output<Double>) {
        this.minChildEndpointsIPv6 = value
    }

    /**
     * @param value The name of the resource
     */
    @JvmName("nrlrseipcjmtcdwp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The priority of this endpoint when using the 'Priority' traffic routing method. Possible values are from 1 to 1000, lower values represent higher priority. This is an optional parameter.  If specified, it must be specified on all endpoints, and no two endpoints can share the same priority value.
     */
    @JvmName("tbwdjovcanwtnqdk")
    public suspend fun priority(`value`: Output<Double>) {
        this.priority = value
    }

    /**
     * @param value The name of the Traffic Manager profile.
     */
    @JvmName("cijtaiqcyaqkkbop")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("awctrifrbcbbviwc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
     */
    @JvmName("ydbmbhpngrhethcv")
    public suspend fun subnets(`value`: Output<List<EndpointPropertiesSubnetsArgs>>) {
        this.subnets = value
    }

    @JvmName("jycqdtpjtsphequb")
    public suspend fun subnets(vararg values: Output<EndpointPropertiesSubnetsArgs>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
     */
    @JvmName("djegenrukjaorxgd")
    public suspend fun subnets(values: List<Output<EndpointPropertiesSubnetsArgs>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value The fully-qualified DNS name or IP address of the endpoint. Traffic Manager returns this value in DNS responses to direct traffic to this endpoint.
     */
    @JvmName("tbctmqasjajdtoej")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value The Azure Resource URI of the of the endpoint. Not applicable to endpoints of type 'ExternalEndpoints'.
     */
    @JvmName("rtvtoklgealduqqm")
    public suspend fun targetResourceId(`value`: Output<String>) {
        this.targetResourceId = value
    }

    /**
     * @param value The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
     */
    @JvmName("daxftebbjuwqejmv")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The weight of this endpoint when using the 'Weighted' traffic routing method. Possible values are from 1 to 1000.
     */
    @JvmName("btttplvwlenaejty")
    public suspend fun weight(`value`: Output<Double>) {
        this.weight = value
    }

    /**
     * @param value If Always Serve is enabled, probing for endpoint health will be disabled and endpoints will be included in the traffic routing method.
     */
    @JvmName("kukwlnrsiproufxd")
    public suspend fun alwaysServe(`value`: Either<String, AlwaysServe>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alwaysServe = mapped
    }

    /**
     * @param value If Always Serve is enabled, probing for endpoint health will be disabled and endpoints will be included in the traffic routing method.
     */
    @JvmName("hffkuoibwuduraja")
    public fun alwaysServe(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AlwaysServe>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alwaysServe = mapped
    }

    /**
     * @param value If Always Serve is enabled, probing for endpoint health will be disabled and endpoints will be included in the traffic routing method.
     */
    @JvmName("enuhgwftyktgnskh")
    public fun alwaysServe(`value`: AlwaysServe) {
        val toBeMapped = Either.ofRight<String, AlwaysServe>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alwaysServe = mapped
    }

    /**
     * @param value List of custom headers.
     */
    @JvmName("vebdwacwilkkcbfr")
    public suspend fun customHeaders(`value`: List<EndpointPropertiesCustomHeadersArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customHeaders = mapped
    }

    /**
     * @param argument List of custom headers.
     */
    @JvmName("piyamlabdhaulbtn")
    public suspend
    fun customHeaders(argument: List<suspend EndpointPropertiesCustomHeadersArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EndpointPropertiesCustomHeadersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customHeaders = mapped
    }

    /**
     * @param argument List of custom headers.
     */
    @JvmName("ywancjvearwxcjvi")
    public suspend fun customHeaders(
        vararg
        argument: suspend EndpointPropertiesCustomHeadersArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EndpointPropertiesCustomHeadersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customHeaders = mapped
    }

    /**
     * @param argument List of custom headers.
     */
    @JvmName("vevrrjxpllnbsdph")
    public suspend
    fun customHeaders(argument: suspend EndpointPropertiesCustomHeadersArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EndpointPropertiesCustomHeadersArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customHeaders = mapped
    }

    /**
     * @param values List of custom headers.
     */
    @JvmName("nwlboivqvxwifxwf")
    public suspend fun customHeaders(vararg values: EndpointPropertiesCustomHeadersArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customHeaders = mapped
    }

    /**
     * @param value Specifies the location of the external or nested endpoints when using the 'Performance' traffic routing method.
     */
    @JvmName("raeabxqwchvkiwff")
    public suspend fun endpointLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointLocation = mapped
    }

    /**
     * @param value The monitoring status of the endpoint.
     */
    @JvmName("penlnemwdquykugq")
    public suspend fun endpointMonitorStatus(`value`: Either<String, EndpointMonitorStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointMonitorStatus = mapped
    }

    /**
     * @param value The monitoring status of the endpoint.
     */
    @JvmName("penkeyoldycdshed")
    public fun endpointMonitorStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EndpointMonitorStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointMonitorStatus = mapped
    }

    /**
     * @param value The monitoring status of the endpoint.
     */
    @JvmName("yyhoswwlmmqmknhf")
    public fun endpointMonitorStatus(`value`: EndpointMonitorStatus) {
        val toBeMapped = Either.ofRight<String, EndpointMonitorStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointMonitorStatus = mapped
    }

    /**
     * @param value The name of the Traffic Manager endpoint to be created or updated.
     */
    @JvmName("qyuqvfvelneaglxo")
    public suspend fun endpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointName = mapped
    }

    /**
     * @param value The status of the endpoint. If the endpoint is Enabled, it is probed for endpoint health and is included in the traffic routing method.
     */
    @JvmName("bvligyjlckvhnsjr")
    public suspend fun endpointStatus(`value`: Either<String, EndpointStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointStatus = mapped
    }

    /**
     * @param value The status of the endpoint. If the endpoint is Enabled, it is probed for endpoint health and is included in the traffic routing method.
     */
    @JvmName("uhemfsxljlqdptsk")
    public fun endpointStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EndpointStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointStatus = mapped
    }

    /**
     * @param value The status of the endpoint. If the endpoint is Enabled, it is probed for endpoint health and is included in the traffic routing method.
     */
    @JvmName("xfrmckrkrqhofqxn")
    public fun endpointStatus(`value`: EndpointStatus) {
        val toBeMapped = Either.ofRight<String, EndpointStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointStatus = mapped
    }

    /**
     * @param value The type of the Traffic Manager endpoint to be created or updated.
     */
    @JvmName("avibarwqjuypirbe")
    public suspend fun endpointType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value The list of countries/regions mapped to this endpoint when using the 'Geographic' traffic routing method. Please consult Traffic Manager Geographic documentation for a full list of accepted values.
     */
    @JvmName("bklocqjjjvmovyhq")
    public suspend fun geoMapping(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geoMapping = mapped
    }

    /**
     * @param values The list of countries/regions mapped to this endpoint when using the 'Geographic' traffic routing method. Please consult Traffic Manager Geographic documentation for a full list of accepted values.
     */
    @JvmName("rvstbblbbneptbql")
    public suspend fun geoMapping(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.geoMapping = mapped
    }

    /**
     * @param value Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
     */
    @JvmName("yrbxnccqohpowsjm")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The minimum number of endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
     */
    @JvmName("cjwnogrleyolynff")
    public suspend fun minChildEndpoints(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minChildEndpoints = mapped
    }

    /**
     * @param value The minimum number of IPv4 (DNS record type A) endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
     */
    @JvmName("mjxcxatporfktqxk")
    public suspend fun minChildEndpointsIPv4(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minChildEndpointsIPv4 = mapped
    }

    /**
     * @param value The minimum number of IPv6 (DNS record type AAAA) endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
     */
    @JvmName("osjbuswcutpxepbl")
    public suspend fun minChildEndpointsIPv6(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minChildEndpointsIPv6 = mapped
    }

    /**
     * @param value The name of the resource
     */
    @JvmName("gmlglgtcsxkfiaqv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The priority of this endpoint when using the 'Priority' traffic routing method. Possible values are from 1 to 1000, lower values represent higher priority. This is an optional parameter.  If specified, it must be specified on all endpoints, and no two endpoints can share the same priority value.
     */
    @JvmName("tjeapmmigskyvwbk")
    public suspend fun priority(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The name of the Traffic Manager profile.
     */
    @JvmName("lokqhfbqqfadstud")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xpaphlptorbjyapu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
     */
    @JvmName("tprnlqpvllhkvpdp")
    public suspend fun subnets(`value`: List<EndpointPropertiesSubnetsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param argument The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
     */
    @JvmName("fdpggbrauelwpvcq")
    public suspend
    fun subnets(argument: List<suspend EndpointPropertiesSubnetsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EndpointPropertiesSubnetsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param argument The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
     */
    @JvmName("xsgtlutlfojqwtfi")
    public suspend fun subnets(
        vararg
        argument: suspend EndpointPropertiesSubnetsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EndpointPropertiesSubnetsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param argument The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
     */
    @JvmName("jngpxwaipoobmgni")
    public suspend fun subnets(argument: suspend EndpointPropertiesSubnetsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EndpointPropertiesSubnetsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param values The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
     */
    @JvmName("wamxkfjduvldfhtd")
    public suspend fun subnets(vararg values: EndpointPropertiesSubnetsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param value The fully-qualified DNS name or IP address of the endpoint. Traffic Manager returns this value in DNS responses to direct traffic to this endpoint.
     */
    @JvmName("avshdujhedirduxu")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value The Azure Resource URI of the of the endpoint. Not applicable to endpoints of type 'ExternalEndpoints'.
     */
    @JvmName("svjokaogqhdpmbmu")
    public suspend fun targetResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceId = mapped
    }

    /**
     * @param value The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
     */
    @JvmName("qxhblehlvqcsihax")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The weight of this endpoint when using the 'Weighted' traffic routing method. Possible values are from 1 to 1000.
     */
    @JvmName("yldlietjslvjsmft")
    public suspend fun weight(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): EndpointArgs = EndpointArgs(
        alwaysServe = alwaysServe,
        customHeaders = customHeaders,
        endpointLocation = endpointLocation,
        endpointMonitorStatus = endpointMonitorStatus,
        endpointName = endpointName,
        endpointStatus = endpointStatus,
        endpointType = endpointType,
        geoMapping = geoMapping,
        id = id,
        minChildEndpoints = minChildEndpoints,
        minChildEndpointsIPv4 = minChildEndpointsIPv4,
        minChildEndpointsIPv6 = minChildEndpointsIPv6,
        name = name,
        priority = priority,
        profileName = profileName,
        resourceGroupName = resourceGroupName,
        subnets = subnets,
        target = target,
        targetResourceId = targetResourceId,
        type = type,
        weight = weight,
    )
}
