@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitAuthorizationResponse
import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitPeeringResponse
import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitServiceProviderPropertiesResponse
import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitSkuResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitAuthorizationResponse.Companion.toKotlin as expressRouteCircuitAuthorizationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitPeeringResponse.Companion.toKotlin as expressRouteCircuitPeeringResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitServiceProviderPropertiesResponse.Companion.toKotlin as expressRouteCircuitServiceProviderPropertiesResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitSkuResponse.Companion.toKotlin as expressRouteCircuitSkuResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin

/**
 * Builder for [ExpressRouteCircuit].
 */
@PulumiTagMarker
public class ExpressRouteCircuitResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExpressRouteCircuitArgs = ExpressRouteCircuitArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExpressRouteCircuitArgsBuilder.() -> Unit) {
        val builder = ExpressRouteCircuitArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ExpressRouteCircuit {
        val builtJavaResource =
            com.pulumi.azurenative.network.ExpressRouteCircuit(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ExpressRouteCircuit(builtJavaResource)
    }
}

/**
 * ExpressRouteCircuit resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2015-05-01-preview, 2018-12-01, 2019-06-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create ExpressRouteCircuit
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var expressRouteCircuit = new AzureNative.Network.ExpressRouteCircuit("expressRouteCircuit", new()
 *     {
 *         AllowClassicOperations = false,
 *         Authorizations = new[] {},
 *         CircuitName = "circuitName",
 *         Location = "Brazil South",
 *         Peerings = new[] {},
 *         ResourceGroupName = "rg1",
 *         ServiceProviderProperties = new AzureNative.Network.Inputs.ExpressRouteCircuitServiceProviderPropertiesArgs
 *         {
 *             BandwidthInMbps = 200,
 *             PeeringLocation = "Silicon Valley",
 *             ServiceProviderName = "Equinix",
 *         },
 *         Sku = new AzureNative.Network.Inputs.ExpressRouteCircuitSkuArgs
 *         {
 *             Family = "MeteredData",
 *             Name = "Standard_MeteredData",
 *             Tier = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewExpressRouteCircuit(ctx, "expressRouteCircuit", &network.ExpressRouteCircuitArgs{
 * 			AllowClassicOperations: pulumi.Bool(false),
 * 			Authorizations:         network.ExpressRouteCircuitAuthorizationTypeArray{},
 * 			CircuitName:            pulumi.String("circuitName"),
 * 			Location:               pulumi.String("Brazil South"),
 * 			Peerings:               network.ExpressRouteCircuitPeeringTypeArray{},
 * 			ResourceGroupName:      pulumi.String("rg1"),
 * 			ServiceProviderProperties: &network.ExpressRouteCircuitServiceProviderPropertiesArgs{
 * 				BandwidthInMbps:     pulumi.Int(200),
 * 				PeeringLocation:     pulumi.String("Silicon Valley"),
 * 				ServiceProviderName: pulumi.String("Equinix"),
 * 			},
 * 			Sku: &network.ExpressRouteCircuitSkuArgs{
 * 				Family: pulumi.String("MeteredData"),
 * 				Name:   pulumi.String("Standard_MeteredData"),
 * 				Tier:   pulumi.String("Standard"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ExpressRouteCircuit;
 * import com.pulumi.azurenative.network.ExpressRouteCircuitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var expressRouteCircuit = new ExpressRouteCircuit("expressRouteCircuit", ExpressRouteCircuitArgs.builder()
 *             .allowClassicOperations(false)
 *             .authorizations()
 *             .circuitName("circuitName")
 *             .location("Brazil South")
 *             .peerings()
 *             .resourceGroupName("rg1")
 *             .serviceProviderProperties(Map.ofEntries(
 *                 Map.entry("bandwidthInMbps", 200),
 *                 Map.entry("peeringLocation", "Silicon Valley"),
 *                 Map.entry("serviceProviderName", "Equinix")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("family", "MeteredData"),
 *                 Map.entry("name", "Standard_MeteredData"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create ExpressRouteCircuit on ExpressRoutePort
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var expressRouteCircuit = new AzureNative.Network.ExpressRouteCircuit("expressRouteCircuit", new()
 *     {
 *         AuthorizationKey = "b0be57f5-1fba-463b-adec-ffe767354cdd",
 *         BandwidthInGbps = 10,
 *         CircuitName = "expressRouteCircuit1",
 *         ExpressRoutePort = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRoutePorts/portName",
 *         },
 *         Location = "westus",
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.ExpressRouteCircuitSkuArgs
 *         {
 *             Family = "MeteredData",
 *             Name = "Premium_MeteredData",
 *             Tier = "Premium",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewExpressRouteCircuit(ctx, "expressRouteCircuit", &network.ExpressRouteCircuitArgs{
 * 			AuthorizationKey: pulumi.String("b0be57f5-1fba-463b-adec-ffe767354cdd"),
 * 			BandwidthInGbps:  pulumi.Float64(10),
 * 			CircuitName:      pulumi.String("expressRouteCircuit1"),
 * 			ExpressRoutePort: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRoutePorts/portName"),
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.ExpressRouteCircuitSkuArgs{
 * 				Family: pulumi.String("MeteredData"),
 * 				Name:   pulumi.String("Premium_MeteredData"),
 * 				Tier:   pulumi.String("Premium"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ExpressRouteCircuit;
 * import com.pulumi.azurenative.network.ExpressRouteCircuitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var expressRouteCircuit = new ExpressRouteCircuit("expressRouteCircuit", ExpressRouteCircuitArgs.builder()
 *             .authorizationKey("b0be57f5-1fba-463b-adec-ffe767354cdd")
 *             .bandwidthInGbps(10)
 *             .circuitName("expressRouteCircuit1")
 *             .expressRoutePort(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRoutePorts/portName"))
 *             .location("westus")
 *             .resourceGroupName("rg1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("family", "MeteredData"),
 *                 Map.entry("name", "Premium_MeteredData"),
 *                 Map.entry("tier", "Premium")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ExpressRouteCircuit expressRouteCircuit1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}
 * ```
 */
public class ExpressRouteCircuit internal constructor(
    override val javaResource: com.pulumi.azurenative.network.ExpressRouteCircuit,
) : KotlinCustomResource(javaResource, ExpressRouteCircuitMapper) {
    /**
     * Allow classic operations.
     */
    public val allowClassicOperations: Output<Boolean>?
        get() = javaResource.allowClassicOperations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The authorizationKey.
     */
    public val authorizationKey: Output<String>?
        get() = javaResource.authorizationKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The authorization status of the Circuit.
     */
    public val authorizationStatus: Output<String>
        get() = javaResource.authorizationStatus().applyValue({ args0 -> args0 })

    /**
     * The list of authorizations.
     */
    public val authorizations: Output<List<ExpressRouteCircuitAuthorizationResponse>>?
        get() = javaResource.authorizations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        expressRouteCircuitAuthorizationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The bandwidth of the circuit when the circuit is provisioned on an ExpressRoutePort resource.
     */
    public val bandwidthInGbps: Output<Double>?
        get() = javaResource.bandwidthInGbps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The CircuitProvisioningState state of the resource.
     */
    public val circuitProvisioningState: Output<String>?
        get() = javaResource.circuitProvisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The reference to the ExpressRoutePort resource when the circuit is provisioned on an ExpressRoutePort resource.
     */
    public val expressRoutePort: Output<SubResourceResponse>?
        get() = javaResource.expressRoutePort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The GatewayManager Etag.
     */
    public val gatewayManagerEtag: Output<String>?
        get() = javaResource.gatewayManagerEtag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Flag denoting global reach status.
     */
    public val globalReachEnabled: Output<Boolean>?
        get() = javaResource.globalReachEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The list of peerings.
     */
    public val peerings: Output<List<ExpressRouteCircuitPeeringResponse>>?
        get() = javaResource.peerings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> expressRouteCircuitPeeringResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The provisioning state of the express route circuit resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The ServiceKey.
     */
    public val serviceKey: Output<String>?
        get() = javaResource.serviceKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ServiceProviderNotes.
     */
    public val serviceProviderNotes: Output<String>?
        get() = javaResource.serviceProviderNotes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ServiceProviderProperties.
     */
    public val serviceProviderProperties:
        Output<ExpressRouteCircuitServiceProviderPropertiesResponse>?
        get() = javaResource.serviceProviderProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    expressRouteCircuitServiceProviderPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The ServiceProviderProvisioningState state of the resource.
     */
    public val serviceProviderProvisioningState: Output<String>?
        get() = javaResource.serviceProviderProvisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The SKU.
     */
    public val sku: Output<ExpressRouteCircuitSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    expressRouteCircuitSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The identifier of the circuit traffic. Outer tag for QinQ encapsulation.
     */
    public val stag: Output<Int>
        get() = javaResource.stag().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ExpressRouteCircuitMapper : ResourceMapper<ExpressRouteCircuit> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.ExpressRouteCircuit::class == javaResource::class

    override fun map(javaResource: Resource): ExpressRouteCircuit = ExpressRouteCircuit(
        javaResource
            as com.pulumi.azurenative.network.ExpressRouteCircuit,
    )
}

/**
 * @see [ExpressRouteCircuit].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ExpressRouteCircuit].
 */
public suspend fun expressRouteCircuit(
    name: String,
    block: suspend ExpressRouteCircuitResourceBuilder.() -> Unit,
): ExpressRouteCircuit {
    val builder = ExpressRouteCircuitResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ExpressRouteCircuit].
 * @param name The _unique_ name of the resulting resource.
 */
public fun expressRouteCircuit(name: String): ExpressRouteCircuit {
    val builder = ExpressRouteCircuitResourceBuilder()
    builder.name(name)
    return builder.build()
}
