@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.ExpressRouteCircuitArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ServiceProviderProvisioningState
import com.pulumi.azurenative.network.kotlin.inputs.ExpressRouteCircuitAuthorizationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExpressRouteCircuitAuthorizationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ExpressRouteCircuitPeeringArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExpressRouteCircuitPeeringArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ExpressRouteCircuitServiceProviderPropertiesArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExpressRouteCircuitServiceProviderPropertiesArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ExpressRouteCircuitSkuArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExpressRouteCircuitSkuArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ExpressRouteCircuit resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2015-05-01-preview, 2018-12-01, 2019-06-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create ExpressRouteCircuit
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var expressRouteCircuit = new AzureNative.Network.ExpressRouteCircuit("expressRouteCircuit", new()
 *     {
 *         AllowClassicOperations = false,
 *         Authorizations = new[] {},
 *         CircuitName = "circuitName",
 *         Location = "Brazil South",
 *         Peerings = new[] {},
 *         ResourceGroupName = "rg1",
 *         ServiceProviderProperties = new AzureNative.Network.Inputs.ExpressRouteCircuitServiceProviderPropertiesArgs
 *         {
 *             BandwidthInMbps = 200,
 *             PeeringLocation = "Silicon Valley",
 *             ServiceProviderName = "Equinix",
 *         },
 *         Sku = new AzureNative.Network.Inputs.ExpressRouteCircuitSkuArgs
 *         {
 *             Family = "MeteredData",
 *             Name = "Standard_MeteredData",
 *             Tier = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewExpressRouteCircuit(ctx, "expressRouteCircuit", &network.ExpressRouteCircuitArgs{
 * 			AllowClassicOperations: pulumi.Bool(false),
 * 			Authorizations:         network.ExpressRouteCircuitAuthorizationTypeArray{},
 * 			CircuitName:            pulumi.String("circuitName"),
 * 			Location:               pulumi.String("Brazil South"),
 * 			Peerings:               network.ExpressRouteCircuitPeeringTypeArray{},
 * 			ResourceGroupName:      pulumi.String("rg1"),
 * 			ServiceProviderProperties: &network.ExpressRouteCircuitServiceProviderPropertiesArgs{
 * 				BandwidthInMbps:     pulumi.Int(200),
 * 				PeeringLocation:     pulumi.String("Silicon Valley"),
 * 				ServiceProviderName: pulumi.String("Equinix"),
 * 			},
 * 			Sku: &network.ExpressRouteCircuitSkuArgs{
 * 				Family: pulumi.String("MeteredData"),
 * 				Name:   pulumi.String("Standard_MeteredData"),
 * 				Tier:   pulumi.String("Standard"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ExpressRouteCircuit;
 * import com.pulumi.azurenative.network.ExpressRouteCircuitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var expressRouteCircuit = new ExpressRouteCircuit("expressRouteCircuit", ExpressRouteCircuitArgs.builder()
 *             .allowClassicOperations(false)
 *             .authorizations()
 *             .circuitName("circuitName")
 *             .location("Brazil South")
 *             .peerings()
 *             .resourceGroupName("rg1")
 *             .serviceProviderProperties(Map.ofEntries(
 *                 Map.entry("bandwidthInMbps", 200),
 *                 Map.entry("peeringLocation", "Silicon Valley"),
 *                 Map.entry("serviceProviderName", "Equinix")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("family", "MeteredData"),
 *                 Map.entry("name", "Standard_MeteredData"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create ExpressRouteCircuit on ExpressRoutePort
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var expressRouteCircuit = new AzureNative.Network.ExpressRouteCircuit("expressRouteCircuit", new()
 *     {
 *         AuthorizationKey = "b0be57f5-1fba-463b-adec-ffe767354cdd",
 *         BandwidthInGbps = 10,
 *         CircuitName = "expressRouteCircuit1",
 *         ExpressRoutePort = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRoutePorts/portName",
 *         },
 *         Location = "westus",
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.ExpressRouteCircuitSkuArgs
 *         {
 *             Family = "MeteredData",
 *             Name = "Premium_MeteredData",
 *             Tier = "Premium",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewExpressRouteCircuit(ctx, "expressRouteCircuit", &network.ExpressRouteCircuitArgs{
 * 			AuthorizationKey: pulumi.String("b0be57f5-1fba-463b-adec-ffe767354cdd"),
 * 			BandwidthInGbps:  pulumi.Float64(10),
 * 			CircuitName:      pulumi.String("expressRouteCircuit1"),
 * 			ExpressRoutePort: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRoutePorts/portName"),
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.ExpressRouteCircuitSkuArgs{
 * 				Family: pulumi.String("MeteredData"),
 * 				Name:   pulumi.String("Premium_MeteredData"),
 * 				Tier:   pulumi.String("Premium"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ExpressRouteCircuit;
 * import com.pulumi.azurenative.network.ExpressRouteCircuitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var expressRouteCircuit = new ExpressRouteCircuit("expressRouteCircuit", ExpressRouteCircuitArgs.builder()
 *             .authorizationKey("b0be57f5-1fba-463b-adec-ffe767354cdd")
 *             .bandwidthInGbps(10)
 *             .circuitName("expressRouteCircuit1")
 *             .expressRoutePort(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRoutePorts/portName"))
 *             .location("westus")
 *             .resourceGroupName("rg1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("family", "MeteredData"),
 *                 Map.entry("name", "Premium_MeteredData"),
 *                 Map.entry("tier", "Premium")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ExpressRouteCircuit expressRouteCircuit1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}
 * ```
 * @property allowClassicOperations Allow classic operations.
 * @property authorizationKey The authorizationKey.
 * @property authorizations The list of authorizations.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property bandwidthInGbps The bandwidth of the circuit when the circuit is provisioned on an ExpressRoutePort resource.
 * @property circuitName The name of the circuit.
 * @property circuitProvisioningState The CircuitProvisioningState state of the resource.
 * @property expressRoutePort The reference to the ExpressRoutePort resource when the circuit is provisioned on an ExpressRoutePort resource.
 * @property gatewayManagerEtag The GatewayManager Etag.
 * @property globalReachEnabled Flag denoting global reach status.
 * @property id Resource ID.
 * @property location Resource location.
 * @property peerings The list of peerings.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property resourceGroupName The name of the resource group.
 * @property serviceKey The ServiceKey.
 * @property serviceProviderNotes The ServiceProviderNotes.
 * @property serviceProviderProperties The ServiceProviderProperties.
 * @property serviceProviderProvisioningState The ServiceProviderProvisioningState state of the resource.
 * @property sku The SKU.
 * @property tags Resource tags.
 */
public data class ExpressRouteCircuitArgs(
    public val allowClassicOperations: Output<Boolean>? = null,
    public val authorizationKey: Output<String>? = null,
    public val authorizations: Output<List<ExpressRouteCircuitAuthorizationArgs>>? = null,
    public val bandwidthInGbps: Output<Double>? = null,
    public val circuitName: Output<String>? = null,
    public val circuitProvisioningState: Output<String>? = null,
    public val expressRoutePort: Output<SubResourceArgs>? = null,
    public val gatewayManagerEtag: Output<String>? = null,
    public val globalReachEnabled: Output<Boolean>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val peerings: Output<List<ExpressRouteCircuitPeeringArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceKey: Output<String>? = null,
    public val serviceProviderNotes: Output<String>? = null,
    public val serviceProviderProperties: Output<ExpressRouteCircuitServiceProviderPropertiesArgs>? =
        null,
    public val serviceProviderProvisioningState:
    Output<Either<String, ServiceProviderProvisioningState>>? = null,
    public val sku: Output<ExpressRouteCircuitSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.ExpressRouteCircuitArgs> {
    override fun toJava(): com.pulumi.azurenative.network.ExpressRouteCircuitArgs =
        com.pulumi.azurenative.network.ExpressRouteCircuitArgs.builder()
            .allowClassicOperations(allowClassicOperations?.applyValue({ args0 -> args0 }))
            .authorizationKey(authorizationKey?.applyValue({ args0 -> args0 }))
            .authorizations(
                authorizations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .bandwidthInGbps(bandwidthInGbps?.applyValue({ args0 -> args0 }))
            .circuitName(circuitName?.applyValue({ args0 -> args0 }))
            .circuitProvisioningState(circuitProvisioningState?.applyValue({ args0 -> args0 }))
            .expressRoutePort(expressRoutePort?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .gatewayManagerEtag(gatewayManagerEtag?.applyValue({ args0 -> args0 }))
            .globalReachEnabled(globalReachEnabled?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .peerings(
                peerings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceKey(serviceKey?.applyValue({ args0 -> args0 }))
            .serviceProviderNotes(serviceProviderNotes?.applyValue({ args0 -> args0 }))
            .serviceProviderProperties(
                serviceProviderProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .serviceProviderProvisioningState(
                serviceProviderProvisioningState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ExpressRouteCircuitArgs].
 */
@PulumiTagMarker
public class ExpressRouteCircuitArgsBuilder internal constructor() {
    private var allowClassicOperations: Output<Boolean>? = null

    private var authorizationKey: Output<String>? = null

    private var authorizations: Output<List<ExpressRouteCircuitAuthorizationArgs>>? = null

    private var bandwidthInGbps: Output<Double>? = null

    private var circuitName: Output<String>? = null

    private var circuitProvisioningState: Output<String>? = null

    private var expressRoutePort: Output<SubResourceArgs>? = null

    private var gatewayManagerEtag: Output<String>? = null

    private var globalReachEnabled: Output<Boolean>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var peerings: Output<List<ExpressRouteCircuitPeeringArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceKey: Output<String>? = null

    private var serviceProviderNotes: Output<String>? = null

    private var serviceProviderProperties: Output<ExpressRouteCircuitServiceProviderPropertiesArgs>? =
        null

    private var serviceProviderProvisioningState:
        Output<Either<String, ServiceProviderProvisioningState>>? = null

    private var sku: Output<ExpressRouteCircuitSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Allow classic operations.
     */
    @JvmName("rmvmlhdcajpuslog")
    public suspend fun allowClassicOperations(`value`: Output<Boolean>) {
        this.allowClassicOperations = value
    }

    /**
     * @param value The authorizationKey.
     */
    @JvmName("xxwykwdufakphair")
    public suspend fun authorizationKey(`value`: Output<String>) {
        this.authorizationKey = value
    }

    /**
     * @param value The list of authorizations.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("pfjtnwhswqctgqdj")
    public suspend fun authorizations(`value`: Output<List<ExpressRouteCircuitAuthorizationArgs>>) {
        this.authorizations = value
    }

    @JvmName("vqwabiklusxqntyh")
    public suspend fun authorizations(vararg values: Output<ExpressRouteCircuitAuthorizationArgs>) {
        this.authorizations = Output.all(values.asList())
    }

    /**
     * @param values The list of authorizations.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("bblkduxeagmpalvr")
    public suspend fun authorizations(values: List<Output<ExpressRouteCircuitAuthorizationArgs>>) {
        this.authorizations = Output.all(values)
    }

    /**
     * @param value The bandwidth of the circuit when the circuit is provisioned on an ExpressRoutePort resource.
     */
    @JvmName("krbekenthskoyblk")
    public suspend fun bandwidthInGbps(`value`: Output<Double>) {
        this.bandwidthInGbps = value
    }

    /**
     * @param value The name of the circuit.
     */
    @JvmName("miqoclvxyeuewfsy")
    public suspend fun circuitName(`value`: Output<String>) {
        this.circuitName = value
    }

    /**
     * @param value The CircuitProvisioningState state of the resource.
     */
    @JvmName("ckdleenlcumpxowy")
    public suspend fun circuitProvisioningState(`value`: Output<String>) {
        this.circuitProvisioningState = value
    }

    /**
     * @param value The reference to the ExpressRoutePort resource when the circuit is provisioned on an ExpressRoutePort resource.
     */
    @JvmName("jatcwmhoefgggaqr")
    public suspend fun expressRoutePort(`value`: Output<SubResourceArgs>) {
        this.expressRoutePort = value
    }

    /**
     * @param value The GatewayManager Etag.
     */
    @JvmName("ykfgyutstjmqhhqq")
    public suspend fun gatewayManagerEtag(`value`: Output<String>) {
        this.gatewayManagerEtag = value
    }

    /**
     * @param value Flag denoting global reach status.
     */
    @JvmName("deoeefufxfulnfyw")
    public suspend fun globalReachEnabled(`value`: Output<Boolean>) {
        this.globalReachEnabled = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("iotktpcsmbuaqmij")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("yexysfhiknucoxac")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The list of peerings.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("ysguksdwwaktuine")
    public suspend fun peerings(`value`: Output<List<ExpressRouteCircuitPeeringArgs>>) {
        this.peerings = value
    }

    @JvmName("quxpabhlicwmmxfq")
    public suspend fun peerings(vararg values: Output<ExpressRouteCircuitPeeringArgs>) {
        this.peerings = Output.all(values.asList())
    }

    /**
     * @param values The list of peerings.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("eumrydrqflmltwed")
    public suspend fun peerings(values: List<Output<ExpressRouteCircuitPeeringArgs>>) {
        this.peerings = Output.all(values)
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("lqadylegynommchn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The ServiceKey.
     */
    @JvmName("nlptjsqsdlvlgxcy")
    public suspend fun serviceKey(`value`: Output<String>) {
        this.serviceKey = value
    }

    /**
     * @param value The ServiceProviderNotes.
     */
    @JvmName("beiqhvbwxjtxsihh")
    public suspend fun serviceProviderNotes(`value`: Output<String>) {
        this.serviceProviderNotes = value
    }

    /**
     * @param value The ServiceProviderProperties.
     */
    @JvmName("qitfdndigxaglsyy")
    public suspend
    fun serviceProviderProperties(`value`: Output<ExpressRouteCircuitServiceProviderPropertiesArgs>) {
        this.serviceProviderProperties = value
    }

    /**
     * @param value The ServiceProviderProvisioningState state of the resource.
     */
    @JvmName("actvsrmxaehodfax")
    public suspend
    fun serviceProviderProvisioningState(`value`: Output<Either<String, ServiceProviderProvisioningState>>) {
        this.serviceProviderProvisioningState = value
    }

    /**
     * @param value The SKU.
     */
    @JvmName("pktcgmdlxvmfkfap")
    public suspend fun sku(`value`: Output<ExpressRouteCircuitSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bygvqnhuaftjtthi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Allow classic operations.
     */
    @JvmName("xibhcbldxyopvqjc")
    public suspend fun allowClassicOperations(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowClassicOperations = mapped
    }

    /**
     * @param value The authorizationKey.
     */
    @JvmName("tikprfuluyrrvfsx")
    public suspend fun authorizationKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationKey = mapped
    }

    /**
     * @param value The list of authorizations.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("caffjdvtogbxophp")
    public suspend fun authorizations(`value`: List<ExpressRouteCircuitAuthorizationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizations = mapped
    }

    /**
     * @param argument The list of authorizations.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("jpqxvgjtwxehuchd")
    public suspend
    fun authorizations(argument: List<suspend ExpressRouteCircuitAuthorizationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExpressRouteCircuitAuthorizationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.authorizations = mapped
    }

    /**
     * @param argument The list of authorizations.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("lgfgbfmruiigqtth")
    public suspend fun authorizations(
        vararg
        argument: suspend ExpressRouteCircuitAuthorizationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ExpressRouteCircuitAuthorizationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.authorizations = mapped
    }

    /**
     * @param argument The list of authorizations.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("oedponmwmkoqcqyb")
    public suspend
    fun authorizations(argument: suspend ExpressRouteCircuitAuthorizationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ExpressRouteCircuitAuthorizationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.authorizations = mapped
    }

    /**
     * @param values The list of authorizations.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("mwhecxahlnlyuijg")
    public suspend fun authorizations(vararg values: ExpressRouteCircuitAuthorizationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizations = mapped
    }

    /**
     * @param value The bandwidth of the circuit when the circuit is provisioned on an ExpressRoutePort resource.
     */
    @JvmName("wjgdtsdmdkjtomsr")
    public suspend fun bandwidthInGbps(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidthInGbps = mapped
    }

    /**
     * @param value The name of the circuit.
     */
    @JvmName("yyvqrjpbobbxguuy")
    public suspend fun circuitName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.circuitName = mapped
    }

    /**
     * @param value The CircuitProvisioningState state of the resource.
     */
    @JvmName("ecapyucabfimqpya")
    public suspend fun circuitProvisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.circuitProvisioningState = mapped
    }

    /**
     * @param value The reference to the ExpressRoutePort resource when the circuit is provisioned on an ExpressRoutePort resource.
     */
    @JvmName("tiapucfhtoldpukj")
    public suspend fun expressRoutePort(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressRoutePort = mapped
    }

    /**
     * @param argument The reference to the ExpressRoutePort resource when the circuit is provisioned on an ExpressRoutePort resource.
     */
    @JvmName("oefcgsbnjicjylin")
    public suspend fun expressRoutePort(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.expressRoutePort = mapped
    }

    /**
     * @param value The GatewayManager Etag.
     */
    @JvmName("kuuhaquxxlnumgbv")
    public suspend fun gatewayManagerEtag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayManagerEtag = mapped
    }

    /**
     * @param value Flag denoting global reach status.
     */
    @JvmName("afylqypnnqnukwme")
    public suspend fun globalReachEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalReachEnabled = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("igapnmtsxcmisdkf")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ldekyipnisnspuxk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The list of peerings.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("dlxnojjvgolgoxlc")
    public suspend fun peerings(`value`: List<ExpressRouteCircuitPeeringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerings = mapped
    }

    /**
     * @param argument The list of peerings.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("eswfimhyhdbatbjg")
    public suspend
    fun peerings(argument: List<suspend ExpressRouteCircuitPeeringArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExpressRouteCircuitPeeringArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.peerings = mapped
    }

    /**
     * @param argument The list of peerings.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("wymdqkbaojntbtsk")
    public suspend fun peerings(
        vararg
        argument: suspend ExpressRouteCircuitPeeringArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ExpressRouteCircuitPeeringArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.peerings = mapped
    }

    /**
     * @param argument The list of peerings.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("cavlsbrhhvcnxmiv")
    public suspend fun peerings(argument: suspend ExpressRouteCircuitPeeringArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ExpressRouteCircuitPeeringArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.peerings = mapped
    }

    /**
     * @param values The list of peerings.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("fwsjwreeawjnmgvd")
    public suspend fun peerings(vararg values: ExpressRouteCircuitPeeringArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peerings = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("eyatmfwmpedhjaua")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The ServiceKey.
     */
    @JvmName("mcmjavkuooamphlq")
    public suspend fun serviceKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceKey = mapped
    }

    /**
     * @param value The ServiceProviderNotes.
     */
    @JvmName("cjvnkeqfoaehspgc")
    public suspend fun serviceProviderNotes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceProviderNotes = mapped
    }

    /**
     * @param value The ServiceProviderProperties.
     */
    @JvmName("hrxapuxqireypnxh")
    public suspend
    fun serviceProviderProperties(`value`: ExpressRouteCircuitServiceProviderPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceProviderProperties = mapped
    }

    /**
     * @param argument The ServiceProviderProperties.
     */
    @JvmName("nbducdjpfckcmjgb")
    public suspend
    fun serviceProviderProperties(argument: suspend ExpressRouteCircuitServiceProviderPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ExpressRouteCircuitServiceProviderPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.serviceProviderProperties = mapped
    }

    /**
     * @param value The ServiceProviderProvisioningState state of the resource.
     */
    @JvmName("mijtfyxacjhykfnj")
    public suspend
    fun serviceProviderProvisioningState(`value`: Either<String, ServiceProviderProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceProviderProvisioningState = mapped
    }

    /**
     * @param value The ServiceProviderProvisioningState state of the resource.
     */
    @JvmName("jrmyawyrkggcikqf")
    public fun serviceProviderProvisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServiceProviderProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceProviderProvisioningState = mapped
    }

    /**
     * @param value The ServiceProviderProvisioningState state of the resource.
     */
    @JvmName("lrdbgpsvqbueplel")
    public fun serviceProviderProvisioningState(`value`: ServiceProviderProvisioningState) {
        val toBeMapped = Either.ofRight<String, ServiceProviderProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceProviderProvisioningState = mapped
    }

    /**
     * @param value The SKU.
     */
    @JvmName("mhtssbpwnisrxoun")
    public suspend fun sku(`value`: ExpressRouteCircuitSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU.
     */
    @JvmName("kmnudpfwrrtvfact")
    public suspend fun sku(argument: suspend ExpressRouteCircuitSkuArgsBuilder.() -> Unit) {
        val toBeMapped = ExpressRouteCircuitSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pxnpvutsoyrfwvfa")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("driwrkgqtkqklxmb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ExpressRouteCircuitArgs = ExpressRouteCircuitArgs(
        allowClassicOperations = allowClassicOperations,
        authorizationKey = authorizationKey,
        authorizations = authorizations,
        bandwidthInGbps = bandwidthInGbps,
        circuitName = circuitName,
        circuitProvisioningState = circuitProvisioningState,
        expressRoutePort = expressRoutePort,
        gatewayManagerEtag = gatewayManagerEtag,
        globalReachEnabled = globalReachEnabled,
        id = id,
        location = location,
        peerings = peerings,
        resourceGroupName = resourceGroupName,
        serviceKey = serviceKey,
        serviceProviderNotes = serviceProviderNotes,
        serviceProviderProperties = serviceProviderProperties,
        serviceProviderProvisioningState = serviceProviderProvisioningState,
        sku = sku,
        tags = tags,
    )
}
