@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.ExpressRouteCircuitPeeringArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ExpressRoutePeeringState
import com.pulumi.azurenative.network.kotlin.enums.ExpressRoutePeeringType
import com.pulumi.azurenative.network.kotlin.inputs.ExpressRouteCircuitConnectionArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExpressRouteCircuitConnectionArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ExpressRouteCircuitPeeringConfigArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExpressRouteCircuitPeeringConfigArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ExpressRouteCircuitStatsArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExpressRouteCircuitStatsArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.Ipv6ExpressRouteCircuitPeeringConfigArgs
import com.pulumi.azurenative.network.kotlin.inputs.Ipv6ExpressRouteCircuitPeeringConfigArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Peering in an ExpressRouteCircuit resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2017-09-01, 2019-02-01, 2019-06-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create ExpressRouteCircuit Peerings
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var expressRouteCircuitPeering = new AzureNative.Network.ExpressRouteCircuitPeering("expressRouteCircuitPeering", new()
 *     {
 *         CircuitName = "circuitName",
 *         PeerASN = 200,
 *         PeeringName = "AzurePrivatePeering",
 *         PrimaryPeerAddressPrefix = "192.168.16.252/30",
 *         ResourceGroupName = "rg1",
 *         SecondaryPeerAddressPrefix = "192.168.18.252/30",
 *         VlanId = 200,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewExpressRouteCircuitPeering(ctx, "expressRouteCircuitPeering", &network.ExpressRouteCircuitPeeringArgs{
 * 			CircuitName:                pulumi.String("circuitName"),
 * 			PeerASN:                    pulumi.Float64(200),
 * 			PeeringName:                pulumi.String("AzurePrivatePeering"),
 * 			PrimaryPeerAddressPrefix:   pulumi.String("192.168.16.252/30"),
 * 			ResourceGroupName:          pulumi.String("rg1"),
 * 			SecondaryPeerAddressPrefix: pulumi.String("192.168.18.252/30"),
 * 			VlanId:                     pulumi.Int(200),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ExpressRouteCircuitPeering;
 * import com.pulumi.azurenative.network.ExpressRouteCircuitPeeringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var expressRouteCircuitPeering = new ExpressRouteCircuitPeering("expressRouteCircuitPeering", ExpressRouteCircuitPeeringArgs.builder()
 *             .circuitName("circuitName")
 *             .peerASN(200)
 *             .peeringName("AzurePrivatePeering")
 *             .primaryPeerAddressPrefix("192.168.16.252/30")
 *             .resourceGroupName("rg1")
 *             .secondaryPeerAddressPrefix("192.168.18.252/30")
 *             .vlanId(200)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ExpressRouteCircuitPeering AzurePrivatePeering /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/peerings/{peeringName}
 * ```
 * @property azureASN The Azure ASN.
 * @property circuitName The name of the express route circuit.
 * @property connections The list of circuit connections associated with Azure Private Peering for this circuit.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property gatewayManagerEtag The GatewayManager Etag.
 * @property id Resource ID.
 * @property ipv6PeeringConfig The IPv6 peering configuration.
 * @property microsoftPeeringConfig The Microsoft peering configuration.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property peerASN The peer ASN.
 * @property peeringName The name of the peering.
 * @property peeringType The peering type.
 * @property primaryAzurePort The primary port.
 * @property primaryPeerAddressPrefix The primary address prefix.
 * @property resourceGroupName The name of the resource group.
 * @property routeFilter The reference to the RouteFilter resource.
 * @property secondaryAzurePort The secondary port.
 * @property secondaryPeerAddressPrefix The secondary address prefix.
 * @property sharedKey The shared key.
 * @property state The peering state.
 * @property stats The peering stats of express route circuit.
 * @property vlanId The VLAN ID.
 */
public data class ExpressRouteCircuitPeeringArgs(
    public val azureASN: Output<Int>? = null,
    public val circuitName: Output<String>? = null,
    public val connections: Output<List<ExpressRouteCircuitConnectionArgs>>? = null,
    public val gatewayManagerEtag: Output<String>? = null,
    public val id: Output<String>? = null,
    public val ipv6PeeringConfig: Output<Ipv6ExpressRouteCircuitPeeringConfigArgs>? = null,
    public val microsoftPeeringConfig: Output<ExpressRouteCircuitPeeringConfigArgs>? = null,
    public val name: Output<String>? = null,
    public val peerASN: Output<Double>? = null,
    public val peeringName: Output<String>? = null,
    public val peeringType: Output<Either<String, ExpressRoutePeeringType>>? = null,
    public val primaryAzurePort: Output<String>? = null,
    public val primaryPeerAddressPrefix: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routeFilter: Output<SubResourceArgs>? = null,
    public val secondaryAzurePort: Output<String>? = null,
    public val secondaryPeerAddressPrefix: Output<String>? = null,
    public val sharedKey: Output<String>? = null,
    public val state: Output<Either<String, ExpressRoutePeeringState>>? = null,
    public val stats: Output<ExpressRouteCircuitStatsArgs>? = null,
    public val vlanId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.ExpressRouteCircuitPeeringArgs> {
    override fun toJava(): com.pulumi.azurenative.network.ExpressRouteCircuitPeeringArgs =
        com.pulumi.azurenative.network.ExpressRouteCircuitPeeringArgs.builder()
            .azureASN(azureASN?.applyValue({ args0 -> args0 }))
            .circuitName(circuitName?.applyValue({ args0 -> args0 }))
            .connections(
                connections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .gatewayManagerEtag(gatewayManagerEtag?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .ipv6PeeringConfig(ipv6PeeringConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .microsoftPeeringConfig(
                microsoftPeeringConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .peerASN(peerASN?.applyValue({ args0 -> args0 }))
            .peeringName(peeringName?.applyValue({ args0 -> args0 }))
            .peeringType(
                peeringType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .primaryAzurePort(primaryAzurePort?.applyValue({ args0 -> args0 }))
            .primaryPeerAddressPrefix(primaryPeerAddressPrefix?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routeFilter(routeFilter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .secondaryAzurePort(secondaryAzurePort?.applyValue({ args0 -> args0 }))
            .secondaryPeerAddressPrefix(secondaryPeerAddressPrefix?.applyValue({ args0 -> args0 }))
            .sharedKey(sharedKey?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .stats(stats?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vlanId(vlanId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExpressRouteCircuitPeeringArgs].
 */
@PulumiTagMarker
public class ExpressRouteCircuitPeeringArgsBuilder internal constructor() {
    private var azureASN: Output<Int>? = null

    private var circuitName: Output<String>? = null

    private var connections: Output<List<ExpressRouteCircuitConnectionArgs>>? = null

    private var gatewayManagerEtag: Output<String>? = null

    private var id: Output<String>? = null

    private var ipv6PeeringConfig: Output<Ipv6ExpressRouteCircuitPeeringConfigArgs>? = null

    private var microsoftPeeringConfig: Output<ExpressRouteCircuitPeeringConfigArgs>? = null

    private var name: Output<String>? = null

    private var peerASN: Output<Double>? = null

    private var peeringName: Output<String>? = null

    private var peeringType: Output<Either<String, ExpressRoutePeeringType>>? = null

    private var primaryAzurePort: Output<String>? = null

    private var primaryPeerAddressPrefix: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var routeFilter: Output<SubResourceArgs>? = null

    private var secondaryAzurePort: Output<String>? = null

    private var secondaryPeerAddressPrefix: Output<String>? = null

    private var sharedKey: Output<String>? = null

    private var state: Output<Either<String, ExpressRoutePeeringState>>? = null

    private var stats: Output<ExpressRouteCircuitStatsArgs>? = null

    private var vlanId: Output<Int>? = null

    /**
     * @param value The Azure ASN.
     */
    @JvmName("iglnlhonblcebglo")
    public suspend fun azureASN(`value`: Output<Int>) {
        this.azureASN = value
    }

    /**
     * @param value The name of the express route circuit.
     */
    @JvmName("grlenpgspqqjhjfl")
    public suspend fun circuitName(`value`: Output<String>) {
        this.circuitName = value
    }

    /**
     * @param value The list of circuit connections associated with Azure Private Peering for this circuit.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("xilnkvgqpawpwokm")
    public suspend fun connections(`value`: Output<List<ExpressRouteCircuitConnectionArgs>>) {
        this.connections = value
    }

    @JvmName("htntygmgksjlxihe")
    public suspend fun connections(vararg values: Output<ExpressRouteCircuitConnectionArgs>) {
        this.connections = Output.all(values.asList())
    }

    /**
     * @param values The list of circuit connections associated with Azure Private Peering for this circuit.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("owmmqnqejtcwwnth")
    public suspend fun connections(values: List<Output<ExpressRouteCircuitConnectionArgs>>) {
        this.connections = Output.all(values)
    }

    /**
     * @param value The GatewayManager Etag.
     */
    @JvmName("bwyuosdswoaenmxs")
    public suspend fun gatewayManagerEtag(`value`: Output<String>) {
        this.gatewayManagerEtag = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("nlmbgworigsbouxn")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The IPv6 peering configuration.
     */
    @JvmName("uhekyvkebuwamdsb")
    public suspend fun ipv6PeeringConfig(`value`: Output<Ipv6ExpressRouteCircuitPeeringConfigArgs>) {
        this.ipv6PeeringConfig = value
    }

    /**
     * @param value The Microsoft peering configuration.
     */
    @JvmName("cemirdbtwhpaepfn")
    public suspend fun microsoftPeeringConfig(`value`: Output<ExpressRouteCircuitPeeringConfigArgs>) {
        this.microsoftPeeringConfig = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("udbbospaduqgfiiq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The peer ASN.
     */
    @JvmName("xpitomxvnyvhyoeq")
    public suspend fun peerASN(`value`: Output<Double>) {
        this.peerASN = value
    }

    /**
     * @param value The name of the peering.
     */
    @JvmName("xrdiohekrmxrthem")
    public suspend fun peeringName(`value`: Output<String>) {
        this.peeringName = value
    }

    /**
     * @param value The peering type.
     */
    @JvmName("qexlwrpxwnqoklqn")
    public suspend fun peeringType(`value`: Output<Either<String, ExpressRoutePeeringType>>) {
        this.peeringType = value
    }

    /**
     * @param value The primary port.
     */
    @JvmName("winnwbpbvoaqofng")
    public suspend fun primaryAzurePort(`value`: Output<String>) {
        this.primaryAzurePort = value
    }

    /**
     * @param value The primary address prefix.
     */
    @JvmName("elnhcyjpemcwwmjy")
    public suspend fun primaryPeerAddressPrefix(`value`: Output<String>) {
        this.primaryPeerAddressPrefix = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vffiqvotlxvtktum")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The reference to the RouteFilter resource.
     */
    @JvmName("igbaafnqobiwvffh")
    public suspend fun routeFilter(`value`: Output<SubResourceArgs>) {
        this.routeFilter = value
    }

    /**
     * @param value The secondary port.
     */
    @JvmName("eeeqkupakguudmcu")
    public suspend fun secondaryAzurePort(`value`: Output<String>) {
        this.secondaryAzurePort = value
    }

    /**
     * @param value The secondary address prefix.
     */
    @JvmName("laahdsiuysnaypmq")
    public suspend fun secondaryPeerAddressPrefix(`value`: Output<String>) {
        this.secondaryPeerAddressPrefix = value
    }

    /**
     * @param value The shared key.
     */
    @JvmName("hjsbxigkbmuesoyo")
    public suspend fun sharedKey(`value`: Output<String>) {
        this.sharedKey = value
    }

    /**
     * @param value The peering state.
     */
    @JvmName("ywjpviukxksmuewr")
    public suspend fun state(`value`: Output<Either<String, ExpressRoutePeeringState>>) {
        this.state = value
    }

    /**
     * @param value The peering stats of express route circuit.
     */
    @JvmName("mwosnmukywfldwgq")
    public suspend fun stats(`value`: Output<ExpressRouteCircuitStatsArgs>) {
        this.stats = value
    }

    /**
     * @param value The VLAN ID.
     */
    @JvmName("shotywofhejrkyie")
    public suspend fun vlanId(`value`: Output<Int>) {
        this.vlanId = value
    }

    /**
     * @param value The Azure ASN.
     */
    @JvmName("gebgbvcaftfuusnl")
    public suspend fun azureASN(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureASN = mapped
    }

    /**
     * @param value The name of the express route circuit.
     */
    @JvmName("iosshqufnuyeomtw")
    public suspend fun circuitName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.circuitName = mapped
    }

    /**
     * @param value The list of circuit connections associated with Azure Private Peering for this circuit.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("gqsiegolrodngpso")
    public suspend fun connections(`value`: List<ExpressRouteCircuitConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connections = mapped
    }

    /**
     * @param argument The list of circuit connections associated with Azure Private Peering for this circuit.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("crqwfcogtxwgjmba")
    public suspend
    fun connections(argument: List<suspend ExpressRouteCircuitConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExpressRouteCircuitConnectionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.connections = mapped
    }

    /**
     * @param argument The list of circuit connections associated with Azure Private Peering for this circuit.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("gwuwlqaojrgtmgxf")
    public suspend fun connections(
        vararg
        argument: suspend ExpressRouteCircuitConnectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ExpressRouteCircuitConnectionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.connections = mapped
    }

    /**
     * @param argument The list of circuit connections associated with Azure Private Peering for this circuit.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("pmghqwwxijfcjmfw")
    public suspend
    fun connections(argument: suspend ExpressRouteCircuitConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ExpressRouteCircuitConnectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.connections = mapped
    }

    /**
     * @param values The list of circuit connections associated with Azure Private Peering for this circuit.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("dydxruofljrdkxct")
    public suspend fun connections(vararg values: ExpressRouteCircuitConnectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connections = mapped
    }

    /**
     * @param value The GatewayManager Etag.
     */
    @JvmName("axtlykpctncbliei")
    public suspend fun gatewayManagerEtag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayManagerEtag = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("kaqkmfjwsttvxhxj")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The IPv6 peering configuration.
     */
    @JvmName("cvvknjawhgdatprk")
    public suspend fun ipv6PeeringConfig(`value`: Ipv6ExpressRouteCircuitPeeringConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6PeeringConfig = mapped
    }

    /**
     * @param argument The IPv6 peering configuration.
     */
    @JvmName("dfxielnpexaqrsia")
    public suspend
    fun ipv6PeeringConfig(argument: suspend Ipv6ExpressRouteCircuitPeeringConfigArgsBuilder.() -> Unit) {
        val toBeMapped = Ipv6ExpressRouteCircuitPeeringConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.ipv6PeeringConfig = mapped
    }

    /**
     * @param value The Microsoft peering configuration.
     */
    @JvmName("lvkglobbcjgaifwh")
    public suspend fun microsoftPeeringConfig(`value`: ExpressRouteCircuitPeeringConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.microsoftPeeringConfig = mapped
    }

    /**
     * @param argument The Microsoft peering configuration.
     */
    @JvmName("byliseqtacyxdehl")
    public suspend
    fun microsoftPeeringConfig(argument: suspend ExpressRouteCircuitPeeringConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ExpressRouteCircuitPeeringConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.microsoftPeeringConfig = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("sssqomjauxmnksfw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The peer ASN.
     */
    @JvmName("asxtfrqunnhnwffk")
    public suspend fun peerASN(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerASN = mapped
    }

    /**
     * @param value The name of the peering.
     */
    @JvmName("iovhyqaqnrixcfxh")
    public suspend fun peeringName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringName = mapped
    }

    /**
     * @param value The peering type.
     */
    @JvmName("ipojetidrmknshvv")
    public suspend fun peeringType(`value`: Either<String, ExpressRoutePeeringType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringType = mapped
    }

    /**
     * @param value The peering type.
     */
    @JvmName("buwghlcrstnmksmi")
    public fun peeringType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExpressRoutePeeringType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peeringType = mapped
    }

    /**
     * @param value The peering type.
     */
    @JvmName("ewpggwttdlacdxsa")
    public fun peeringType(`value`: ExpressRoutePeeringType) {
        val toBeMapped = Either.ofRight<String, ExpressRoutePeeringType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peeringType = mapped
    }

    /**
     * @param value The primary port.
     */
    @JvmName("fvvmdaloyaklvbyj")
    public suspend fun primaryAzurePort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryAzurePort = mapped
    }

    /**
     * @param value The primary address prefix.
     */
    @JvmName("xulqdwsgaisuvnpp")
    public suspend fun primaryPeerAddressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryPeerAddressPrefix = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pufruqxvwlmbttgv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The reference to the RouteFilter resource.
     */
    @JvmName("pauoxdfrrchpteoi")
    public suspend fun routeFilter(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeFilter = mapped
    }

    /**
     * @param argument The reference to the RouteFilter resource.
     */
    @JvmName("witbqmuwdoyxtucq")
    public suspend fun routeFilter(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routeFilter = mapped
    }

    /**
     * @param value The secondary port.
     */
    @JvmName("tfirusupmgafahws")
    public suspend fun secondaryAzurePort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryAzurePort = mapped
    }

    /**
     * @param value The secondary address prefix.
     */
    @JvmName("ojmnscfqryciesqw")
    public suspend fun secondaryPeerAddressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryPeerAddressPrefix = mapped
    }

    /**
     * @param value The shared key.
     */
    @JvmName("mopvvflxgygleeby")
    public suspend fun sharedKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedKey = mapped
    }

    /**
     * @param value The peering state.
     */
    @JvmName("tmbytufhdlxkmabc")
    public suspend fun state(`value`: Either<String, ExpressRoutePeeringState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The peering state.
     */
    @JvmName("nimvvqsroirrikel")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExpressRoutePeeringState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The peering state.
     */
    @JvmName("vbyqjiasoyjeaxam")
    public fun state(`value`: ExpressRoutePeeringState) {
        val toBeMapped = Either.ofRight<String, ExpressRoutePeeringState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The peering stats of express route circuit.
     */
    @JvmName("gqnaxqcvoppusuqe")
    public suspend fun stats(`value`: ExpressRouteCircuitStatsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stats = mapped
    }

    /**
     * @param argument The peering stats of express route circuit.
     */
    @JvmName("sjpuhbvfhiagmdcj")
    public suspend fun stats(argument: suspend ExpressRouteCircuitStatsArgsBuilder.() -> Unit) {
        val toBeMapped = ExpressRouteCircuitStatsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.stats = mapped
    }

    /**
     * @param value The VLAN ID.
     */
    @JvmName("celvbkocmkbqshfb")
    public suspend fun vlanId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlanId = mapped
    }

    internal fun build(): ExpressRouteCircuitPeeringArgs = ExpressRouteCircuitPeeringArgs(
        azureASN = azureASN,
        circuitName = circuitName,
        connections = connections,
        gatewayManagerEtag = gatewayManagerEtag,
        id = id,
        ipv6PeeringConfig = ipv6PeeringConfig,
        microsoftPeeringConfig = microsoftPeeringConfig,
        name = name,
        peerASN = peerASN,
        peeringName = peeringName,
        peeringType = peeringType,
        primaryAzurePort = primaryAzurePort,
        primaryPeerAddressPrefix = primaryPeerAddressPrefix,
        resourceGroupName = resourceGroupName,
        routeFilter = routeFilter,
        secondaryAzurePort = secondaryAzurePort,
        secondaryPeerAddressPrefix = secondaryPeerAddressPrefix,
        sharedKey = sharedKey,
        state = state,
        stats = stats,
        vlanId = vlanId,
    )
}
