@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteConnectionResponse
import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteGatewayPropertiesResponseAutoScaleConfiguration
import com.pulumi.azurenative.network.kotlin.outputs.VirtualHubIdResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteConnectionResponse.Companion.toKotlin as expressRouteConnectionResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteGatewayPropertiesResponseAutoScaleConfiguration.Companion.toKotlin as expressRouteGatewayPropertiesResponseAutoScaleConfigurationToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VirtualHubIdResponse.Companion.toKotlin as virtualHubIdResponseToKotlin

/**
 * Builder for [ExpressRouteGateway].
 */
@PulumiTagMarker
public class ExpressRouteGatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExpressRouteGatewayArgs = ExpressRouteGatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExpressRouteGatewayArgsBuilder.() -> Unit) {
        val builder = ExpressRouteGatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ExpressRouteGateway {
        val builtJavaResource =
            com.pulumi.azurenative.network.ExpressRouteGateway(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ExpressRouteGateway(builtJavaResource)
    }
}

/**
 * ExpressRoute gateway resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2021-03-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### ExpressRouteGatewayCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var expressRouteGateway = new AzureNative.Network.ExpressRouteGateway("expressRouteGateway", new()
 *     {
 *         AllowNonVirtualWanTraffic = false,
 *         AutoScaleConfiguration = new AzureNative.Network.Inputs.ExpressRouteGatewayPropertiesAutoScaleConfigurationArgs
 *         {
 *             Bounds = new AzureNative.Network.Inputs.ExpressRouteGatewayPropertiesBoundsArgs
 *             {
 *                 Min = 3,
 *             },
 *         },
 *         ExpressRouteGatewayName = "gateway-2",
 *         Location = "westus",
 *         ResourceGroupName = "resourceGroupName",
 *         VirtualHub = new AzureNative.Network.Inputs.VirtualHubIdArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/resourceGroupId/providers/Microsoft.Network/virtualHubs/virtualHubName",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewExpressRouteGateway(ctx, "expressRouteGateway", &network.ExpressRouteGatewayArgs{
 * 			AllowNonVirtualWanTraffic: pulumi.Bool(false),
 * 			AutoScaleConfiguration: network.ExpressRouteGatewayPropertiesResponseAutoScaleConfiguration{
 * 				Bounds: &network.ExpressRouteGatewayPropertiesBoundsArgs{
 * 					Min: pulumi.Int(3),
 * 				},
 * 			},
 * 			ExpressRouteGatewayName: pulumi.String("gateway-2"),
 * 			Location:                pulumi.String("westus"),
 * 			ResourceGroupName:       pulumi.String("resourceGroupName"),
 * 			VirtualHub: &network.VirtualHubIdArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/resourceGroupId/providers/Microsoft.Network/virtualHubs/virtualHubName"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ExpressRouteGateway;
 * import com.pulumi.azurenative.network.ExpressRouteGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var expressRouteGateway = new ExpressRouteGateway("expressRouteGateway", ExpressRouteGatewayArgs.builder()
 *             .allowNonVirtualWanTraffic(false)
 *             .autoScaleConfiguration(Map.of("bounds", Map.of("min", 3)))
 *             .expressRouteGatewayName("gateway-2")
 *             .location("westus")
 *             .resourceGroupName("resourceGroupName")
 *             .virtualHub(Map.of("id", "/subscriptions/subid/resourceGroups/resourceGroupId/providers/Microsoft.Network/virtualHubs/virtualHubName"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ExpressRouteGateway gateway-2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}
 * ```
 */
public class ExpressRouteGateway internal constructor(
    override val javaResource: com.pulumi.azurenative.network.ExpressRouteGateway,
) : KotlinCustomResource(javaResource, ExpressRouteGatewayMapper) {
    /**
     * Configures this gateway to accept traffic from non Virtual WAN networks.
     */
    public val allowNonVirtualWanTraffic: Output<Boolean>?
        get() = javaResource.allowNonVirtualWanTraffic().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration for auto scaling.
     */
    public val autoScaleConfiguration:
        Output<ExpressRouteGatewayPropertiesResponseAutoScaleConfiguration>?
        get() = javaResource.autoScaleConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    expressRouteGatewayPropertiesResponseAutoScaleConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * List of ExpressRoute connections to the ExpressRoute gateway.
     */
    public val expressRouteConnections: Output<List<ExpressRouteConnectionResponse>>?
        get() = javaResource.expressRouteConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        expressRouteConnectionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the express route gateway resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The Virtual Hub where the ExpressRoute gateway is or will be deployed.
     */
    public val virtualHub: Output<VirtualHubIdResponse>
        get() = javaResource.virtualHub().applyValue({ args0 ->
            args0.let({ args0 ->
                virtualHubIdResponseToKotlin(args0)
            })
        })
}

public object ExpressRouteGatewayMapper : ResourceMapper<ExpressRouteGateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.ExpressRouteGateway::class == javaResource::class

    override fun map(javaResource: Resource): ExpressRouteGateway = ExpressRouteGateway(
        javaResource
            as com.pulumi.azurenative.network.ExpressRouteGateway,
    )
}

/**
 * @see [ExpressRouteGateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ExpressRouteGateway].
 */
public suspend fun expressRouteGateway(
    name: String,
    block: suspend ExpressRouteGatewayResourceBuilder.() -> Unit,
): ExpressRouteGateway {
    val builder = ExpressRouteGatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ExpressRouteGateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun expressRouteGateway(name: String): ExpressRouteGateway {
    val builder = ExpressRouteGatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
