@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.ExpressRoutePortAuthorizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ExpressRoutePort Authorization resource definition.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2022-01-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create ExpressRoutePort Authorization
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var expressRoutePortAuthorization = new AzureNative.Network.ExpressRoutePortAuthorization("expressRoutePortAuthorization", new()
 *     {
 *         AuthorizationName = "authorizatinName",
 *         ExpressRoutePortName = "expressRoutePortName",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewExpressRoutePortAuthorization(ctx, "expressRoutePortAuthorization", &network.ExpressRoutePortAuthorizationArgs{
 * 			AuthorizationName:    pulumi.String("authorizatinName"),
 * 			ExpressRoutePortName: pulumi.String("expressRoutePortName"),
 * 			ResourceGroupName:    pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ExpressRoutePortAuthorization;
 * import com.pulumi.azurenative.network.ExpressRoutePortAuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var expressRoutePortAuthorization = new ExpressRoutePortAuthorization("expressRoutePortAuthorization", ExpressRoutePortAuthorizationArgs.builder()
 *             .authorizationName("authorizatinName")
 *             .expressRoutePortName("expressRoutePortName")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ExpressRoutePortAuthorization authorizationName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRoutePorts/{expressRoutePortName}/authorizations/{authorizationName}
 * ```
 * @property authorizationName The name of the authorization.
 * @property expressRoutePortName The name of the express route port.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property resourceGroupName The name of the resource group.
 */
public data class ExpressRoutePortAuthorizationArgs(
    public val authorizationName: Output<String>? = null,
    public val expressRoutePortName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.ExpressRoutePortAuthorizationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.ExpressRoutePortAuthorizationArgs =
        com.pulumi.azurenative.network.ExpressRoutePortAuthorizationArgs.builder()
            .authorizationName(authorizationName?.applyValue({ args0 -> args0 }))
            .expressRoutePortName(expressRoutePortName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExpressRoutePortAuthorizationArgs].
 */
@PulumiTagMarker
public class ExpressRoutePortAuthorizationArgsBuilder internal constructor() {
    private var authorizationName: Output<String>? = null

    private var expressRoutePortName: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the authorization.
     */
    @JvmName("tyicbybgryxeclyt")
    public suspend fun authorizationName(`value`: Output<String>) {
        this.authorizationName = value
    }

    /**
     * @param value The name of the express route port.
     */
    @JvmName("xnnmardjpcrtfcdv")
    public suspend fun expressRoutePortName(`value`: Output<String>) {
        this.expressRoutePortName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("uqpwjkfujpbinhno")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("lbholhwmwanjnieo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wpmevmmijikssdis")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the authorization.
     */
    @JvmName("lepskmhhvedevymg")
    public suspend fun authorizationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationName = mapped
    }

    /**
     * @param value The name of the express route port.
     */
    @JvmName("ftpuylhkhinngtlf")
    public suspend fun expressRoutePortName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressRoutePortName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("kfypxtgwqjaibpuq")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("rrdifgppppswlkqe")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("dqjjyklsxncobdhy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ExpressRoutePortAuthorizationArgs = ExpressRoutePortAuthorizationArgs(
        authorizationName = authorizationName,
        expressRoutePortName = expressRoutePortName,
        id = id,
        name = name,
        resourceGroupName = resourceGroupName,
    )
}
