@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.DnsSettingsResponse
import com.pulumi.azurenative.network.kotlin.outputs.ExplicitProxyResponse
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyInsightsResponse
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyIntrusionDetectionResponse
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicySNATResponse
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicySQLResponse
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicySkuResponse
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyThreatIntelWhitelistResponse
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyTransportSecurityResponse
import com.pulumi.azurenative.network.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.DnsSettingsResponse.Companion.toKotlin as dnsSettingsResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ExplicitProxyResponse.Companion.toKotlin as explicitProxyResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyInsightsResponse.Companion.toKotlin as firewallPolicyInsightsResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyIntrusionDetectionResponse.Companion.toKotlin as firewallPolicyIntrusionDetectionResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicySNATResponse.Companion.toKotlin as firewallPolicySNATResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicySQLResponse.Companion.toKotlin as firewallPolicySQLResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicySkuResponse.Companion.toKotlin as firewallPolicySkuResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyThreatIntelWhitelistResponse.Companion.toKotlin as firewallPolicyThreatIntelWhitelistResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyTransportSecurityResponse.Companion.toKotlin as firewallPolicyTransportSecurityResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin

/**
 * Builder for [FirewallPolicy].
 */
@PulumiTagMarker
public class FirewallPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FirewallPolicyArgs = FirewallPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FirewallPolicyArgsBuilder.() -> Unit) {
        val builder = FirewallPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FirewallPolicy {
        val builtJavaResource = com.pulumi.azurenative.network.FirewallPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FirewallPolicy(builtJavaResource)
    }
}

/**
 * FirewallPolicy Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2020-04-01, 2021-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create FirewallPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallPolicy = new AzureNative.Network.FirewallPolicy("firewallPolicy", new()
 *     {
 *         DnsSettings = new AzureNative.Network.Inputs.DnsSettingsArgs
 *         {
 *             EnableProxy = true,
 *             RequireProxyForNetworkRules = false,
 *             Servers = new[]
 *             {
 *                 "30.3.4.5",
 *             },
 *         },
 *         ExplicitProxy = new AzureNative.Network.Inputs.ExplicitProxyArgs
 *         {
 *             EnableExplicitProxy = true,
 *             EnablePacFile = true,
 *             HttpPort = 8087,
 *             HttpsPort = 8087,
 *             PacFile = "https://tinawstorage.file.core.windows.net/?sv=2020-02-10&ss=bfqt&srt=sco&sp=rwdlacuptfx&se=2021-06-04T07:01:12Z&st=2021-06-03T23:01:12Z&sip=68.65.171.11&spr=https&sig=Plsa0RRVpGbY0IETZZOT6znOHcSro71LLTTbzquYPgs%3D",
 *             PacFilePort = 8087,
 *         },
 *         FirewallPolicyName = "firewallPolicy",
 *         Insights = new AzureNative.Network.Inputs.FirewallPolicyInsightsArgs
 *         {
 *             IsEnabled = true,
 *             LogAnalyticsResources = new AzureNative.Network.Inputs.FirewallPolicyLogAnalyticsResourcesArgs
 *             {
 *                 DefaultWorkspaceId = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/defaultWorkspace",
 *                 },
 *                 Workspaces = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.FirewallPolicyLogAnalyticsWorkspaceArgs
 *                     {
 *                         Region = "westus",
 *                         WorkspaceId = new AzureNative.Network.Inputs.SubResourceArgs
 *                         {
 *                             Id = "/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace1",
 *                         },
 *                     },
 *                     new AzureNative.Network.Inputs.FirewallPolicyLogAnalyticsWorkspaceArgs
 *                     {
 *                         Region = "eastus",
 *                         WorkspaceId = new AzureNative.Network.Inputs.SubResourceArgs
 *                         {
 *                             Id = "/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace2",
 *                         },
 *                     },
 *                 },
 *             },
 *             RetentionDays = 100,
 *         },
 *         IntrusionDetection = new AzureNative.Network.Inputs.FirewallPolicyIntrusionDetectionArgs
 *         {
 *             Configuration = new AzureNative.Network.Inputs.FirewallPolicyIntrusionDetectionConfigurationArgs
 *             {
 *                 BypassTrafficSettings = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs
 *                     {
 *                         Description = "Rule 1",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "5.6.7.8",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "*",
 *                         },
 *                         Name = "bypassRule1",
 *                         Protocol = "TCP",
 *                         SourceAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                     },
 *                 },
 *                 SignatureOverrides = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.FirewallPolicyIntrusionDetectionSignatureSpecificationArgs
 *                     {
 *                         Id = "2525004",
 *                         Mode = "Deny",
 *                     },
 *                 },
 *             },
 *             Mode = "Alert",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.FirewallPolicySkuArgs
 *         {
 *             Tier = "Premium",
 *         },
 *         Snat = new AzureNative.Network.Inputs.FirewallPolicySNATArgs
 *         {
 *             PrivateRanges = new[]
 *             {
 *                 "IANAPrivateRanges",
 *             },
 *         },
 *         Sql = new AzureNative.Network.Inputs.FirewallPolicySQLArgs
 *         {
 *             AllowSqlRedirect = true,
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         ThreatIntelMode = "Alert",
 *         ThreatIntelWhitelist = new AzureNative.Network.Inputs.FirewallPolicyThreatIntelWhitelistArgs
 *         {
 *             Fqdns = new[]
 *             {
 *                 "*.microsoft.com",
 *             },
 *             IpAddresses = new[]
 *             {
 *                 "20.3.4.5",
 *             },
 *         },
 *         TransportSecurity = new AzureNative.Network.Inputs.FirewallPolicyTransportSecurityArgs
 *         {
 *             CertificateAuthority = new AzureNative.Network.Inputs.FirewallPolicyCertificateAuthorityArgs
 *             {
 *                 KeyVaultSecretId = "https://kv/secret",
 *                 Name = "clientcert",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := network.NewFirewallPolicy(ctx, "firewallPolicy", &network.FirewallPolicyArgs{
 * DnsSettings: &network.DnsSettingsArgs{
 * EnableProxy: pulumi.Bool(true),
 * RequireProxyForNetworkRules: pulumi.Bool(false),
 * Servers: pulumi.StringArray{
 * pulumi.String("30.3.4.5"),
 * },
 * },
 * ExplicitProxy: &network.ExplicitProxyArgs{
 * EnableExplicitProxy: pulumi.Bool(true),
 * EnablePacFile: pulumi.Bool(true),
 * HttpPort: pulumi.Int(8087),
 * HttpsPort: pulumi.Int(8087),
 * PacFile: pulumi.String("https://tinawstorage.file.core.windows.net/?sv=2020-02-10&ss=bfqt&srt=sco&sp=rwdlacuptfx&se=2021-06-04T07:01:12Z&st=2021-06-03T23:01:12Z&sip=68.65.171.11&spr=https&sig=Plsa0RRVpGbY0IETZZOT6znOHcSro71LLTTbzquYPgs%3D"),
 * PacFilePort: pulumi.Int(8087),
 * },
 * FirewallPolicyName: pulumi.String("firewallPolicy"),
 * Insights: network.FirewallPolicyInsightsResponse{
 * IsEnabled: pulumi.Bool(true),
 * LogAnalyticsResources: interface{}{
 * DefaultWorkspaceId: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/defaultWorkspace"),
 * },
 * Workspaces: network.FirewallPolicyLogAnalyticsWorkspaceArray{
 * interface{}{
 * Region: pulumi.String("westus"),
 * WorkspaceId: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace1"),
 * },
 * },
 * interface{}{
 * Region: pulumi.String("eastus"),
 * WorkspaceId: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace2"),
 * },
 * },
 * },
 * },
 * RetentionDays: pulumi.Int(100),
 * },
 * IntrusionDetection: network.FirewallPolicyIntrusionDetectionResponse{
 * Configuration: interface{}{
 * BypassTrafficSettings: network.FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArray{
 * &network.FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs{
 * Description: pulumi.String("Rule 1"),
 * DestinationAddresses: pulumi.StringArray{
 * pulumi.String("5.6.7.8"),
 * },
 * DestinationPorts: pulumi.StringArray{
 * pulumi.String("*"),
 * },
 * Name: pulumi.String("bypassRule1"),
 * Protocol: pulumi.String("TCP"),
 * SourceAddresses: pulumi.StringArray{
 * pulumi.String("1.2.3.4"),
 * },
 * },
 * },
 * SignatureOverrides: network.FirewallPolicyIntrusionDetectionSignatureSpecificationArray{
 * &network.FirewallPolicyIntrusionDetectionSignatureSpecificationArgs{
 * Id: pulumi.String("2525004"),
 * Mode: pulumi.String("Deny"),
 * },
 * },
 * },
 * Mode: pulumi.String("Alert"),
 * },
 * Location: pulumi.String("West US"),
 * ResourceGroupName: pulumi.String("rg1"),
 * Sku: &network.FirewallPolicySkuArgs{
 * Tier: pulumi.String("Premium"),
 * },
 * Snat: &network.FirewallPolicySNATArgs{
 * PrivateRanges: pulumi.StringArray{
 * pulumi.String("IANAPrivateRanges"),
 * },
 * },
 * Sql: &network.FirewallPolicySQLArgs{
 * AllowSqlRedirect: pulumi.Bool(true),
 * },
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("value1"),
 * },
 * ThreatIntelMode: pulumi.String("Alert"),
 * ThreatIntelWhitelist: &network.FirewallPolicyThreatIntelWhitelistArgs{
 * Fqdns: pulumi.StringArray{
 * pulumi.String("*.microsoft.com"),
 * },
 * IpAddresses: pulumi.StringArray{
 * pulumi.String("20.3.4.5"),
 * },
 * },
 * TransportSecurity: network.FirewallPolicyTransportSecurityResponse{
 * CertificateAuthority: &network.FirewallPolicyCertificateAuthorityArgs{
 * KeyVaultSecretId: pulumi.String("https://kv/secret"),
 * Name: pulumi.String("clientcert"),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FirewallPolicy;
 * import com.pulumi.azurenative.network.FirewallPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallPolicy = new FirewallPolicy("firewallPolicy", FirewallPolicyArgs.builder()
 *             .dnsSettings(Map.ofEntries(
 *                 Map.entry("enableProxy", true),
 *                 Map.entry("requireProxyForNetworkRules", false),
 *                 Map.entry("servers", "30.3.4.5")
 *             ))
 *             .explicitProxy(Map.ofEntries(
 *                 Map.entry("enableExplicitProxy", true),
 *                 Map.entry("enablePacFile", true),
 *                 Map.entry("httpPort", 8087),
 *                 Map.entry("httpsPort", 8087),
 *                 Map.entry("pacFile", "https://tinawstorage.file.core.windows.net/?sv=2020-02-10&ss=bfqt&srt=sco&sp=rwdlacuptfx&se=2021-06-04T07:01:12Z&st=2021-06-03T23:01:12Z&sip=68.65.171.11&spr=https&sig=Plsa0RRVpGbY0IETZZOT6znOHcSro71LLTTbzquYPgs%3D"),
 *                 Map.entry("pacFilePort", 8087)
 *             ))
 *             .firewallPolicyName("firewallPolicy")
 *             .insights(Map.ofEntries(
 *                 Map.entry("isEnabled", true),
 *                 Map.entry("logAnalyticsResources", Map.ofEntries(
 *                     Map.entry("defaultWorkspaceId", Map.of("id", "/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/defaultWorkspace")),
 *                     Map.entry("workspaces",
 *                         Map.ofEntries(
 *                             Map.entry("region", "westus"),
 *                             Map.entry("workspaceId", Map.of("id", "/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace1"))
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("region", "eastus"),
 *                             Map.entry("workspaceId", Map.of("id", "/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace2"))
 *                         ))
 *                 )),
 *                 Map.entry("retentionDays", 100)
 *             ))
 *             .intrusionDetection(Map.ofEntries(
 *                 Map.entry("configuration", Map.ofEntries(
 *                     Map.entry("bypassTrafficSettings", Map.ofEntries(
 *                         Map.entry("description", "Rule 1"),
 *                         Map.entry("destinationAddresses", "5.6.7.8"),
 *                         Map.entry("destinationPorts", "*"),
 *                         Map.entry("name", "bypassRule1"),
 *                         Map.entry("protocol", "TCP"),
 *                         Map.entry("sourceAddresses", "1.2.3.4")
 *                     )),
 *                     Map.entry("signatureOverrides", Map.ofEntries(
 *                         Map.entry("id", "2525004"),
 *                         Map.entry("mode", "Deny")
 *                     ))
 *                 )),
 *                 Map.entry("mode", "Alert")
 *             ))
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .sku(Map.of("tier", "Premium"))
 *             .snat(Map.of("privateRanges", "IANAPrivateRanges"))
 *             .sql(Map.of("allowSqlRedirect", true))
 *             .tags(Map.of("key1", "value1"))
 *             .threatIntelMode("Alert")
 *             .threatIntelWhitelist(Map.ofEntries(
 *                 Map.entry("fqdns", "*.microsoft.com"),
 *                 Map.entry("ipAddresses", "20.3.4.5")
 *             ))
 *             .transportSecurity(Map.of("certificateAuthority", Map.ofEntries(
 *                 Map.entry("keyVaultSecretId", "https://kv/secret"),
 *                 Map.entry("name", "clientcert")
 *             )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:FirewallPolicy firewallPolicy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}
 * ```
 */
public class FirewallPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.network.FirewallPolicy,
) : KotlinCustomResource(javaResource, FirewallPolicyMapper) {
    /**
     * The parent firewall policy from which rules are inherited.
     */
    public val basePolicy: Output<SubResourceResponse>?
        get() = javaResource.basePolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subResourceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of references to Child Firewall Policies.
     */
    public val childPolicies: Output<List<SubResourceResponse>>
        get() = javaResource.childPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            })
        })

    /**
     * DNS Proxy Settings definition.
     */
    public val dnsSettings: Output<DnsSettingsResponse>?
        get() = javaResource.dnsSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dnsSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Explicit Proxy Settings definition.
     */
    public val explicitProxy: Output<ExplicitProxyResponse>?
        get() = javaResource.explicitProxy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> explicitProxyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * List of references to Azure Firewalls that this Firewall Policy is associated with.
     */
    public val firewalls: Output<List<SubResourceResponse>>
        get() = javaResource.firewalls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subResourceResponseToKotlin(args0)
                })
            })
        })

    /**
     * The identity of the firewall policy.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Insights on Firewall Policy.
     */
    public val insights: Output<FirewallPolicyInsightsResponse>?
        get() = javaResource.insights().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firewallPolicyInsightsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The configuration for Intrusion detection.
     */
    public val intrusionDetection: Output<FirewallPolicyIntrusionDetectionResponse>?
        get() = javaResource.intrusionDetection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firewallPolicyIntrusionDetectionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the firewall policy resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * List of references to FirewallPolicyRuleCollectionGroups.
     */
    public val ruleCollectionGroups: Output<List<SubResourceResponse>>
        get() = javaResource.ruleCollectionGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            })
        })

    /**
     * The Firewall Policy SKU.
     */
    public val sku: Output<FirewallPolicySkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firewallPolicySkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The private IP addresses/IP ranges to which traffic will not be SNAT.
     */
    public val snat: Output<FirewallPolicySNATResponse>?
        get() = javaResource.snat().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firewallPolicySNATResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * SQL Settings definition.
     */
    public val sql: Output<FirewallPolicySQLResponse>?
        get() = javaResource.sql().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firewallPolicySQLResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The operation mode for Threat Intelligence.
     */
    public val threatIntelMode: Output<String>?
        get() = javaResource.threatIntelMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ThreatIntel Whitelist for Firewall Policy.
     */
    public val threatIntelWhitelist: Output<FirewallPolicyThreatIntelWhitelistResponse>?
        get() = javaResource.threatIntelWhitelist().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firewallPolicyThreatIntelWhitelistResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * TLS Configuration definition.
     */
    public val transportSecurity: Output<FirewallPolicyTransportSecurityResponse>?
        get() = javaResource.transportSecurity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firewallPolicyTransportSecurityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FirewallPolicyMapper : ResourceMapper<FirewallPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.FirewallPolicy::class == javaResource::class

    override fun map(javaResource: Resource): FirewallPolicy = FirewallPolicy(
        javaResource as
            com.pulumi.azurenative.network.FirewallPolicy,
    )
}

/**
 * @see [FirewallPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FirewallPolicy].
 */
public suspend fun firewallPolicy(
    name: String,
    block: suspend FirewallPolicyResourceBuilder.() -> Unit,
): FirewallPolicy {
    val builder = FirewallPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FirewallPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun firewallPolicy(name: String): FirewallPolicy {
    val builder = FirewallPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
