@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicyFilterRuleCollectionArgs
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicyNatRuleCollectionArgs
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Rule Collection Group resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create FirewallPolicyNatRuleCollectionGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallPolicyRuleCollectionGroup = new AzureNative.Network.FirewallPolicyRuleCollectionGroup("firewallPolicyRuleCollectionGroup", new()
 *     {
 *         FirewallPolicyName = "firewallPolicy",
 *         Priority = 100,
 *         ResourceGroupName = "rg1",
 *         RuleCollectionGroupName = "ruleCollectionGroup1",
 *         RuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.FirewallPolicyNatRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.FirewallPolicyNatRuleCollectionActionArgs
 *                 {
 *                     Type = "DNAT",
 *                 },
 *                 Name = "Example-Nat-Rule-Collection",
 *                 Priority = 100,
 *                 RuleCollectionType = "FirewallPolicyNatRuleCollection",
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.NatRuleArgs
 *                     {
 *                         DestinationAddresses = new[]
 *                         {
 *                             "152.23.32.23",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "8080",
 *                         },
 *                         IpProtocols = new[]
 *                         {
 *                             "TCP",
 *                             "UDP",
 *                         },
 *                         Name = "nat-rule1",
 *                         RuleType = "NatRule",
 *                         SourceAddresses = new[]
 *                         {
 *                             "2.2.2.2",
 *                         },
 *                         SourceIpGroups = new() { },
 *                         TranslatedFqdn = "internalhttp.server.net",
 *                         TranslatedPort = "8080",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFirewallPolicyRuleCollectionGroup(ctx, "firewallPolicyRuleCollectionGroup", &network.FirewallPolicyRuleCollectionGroupArgs{
 * 			FirewallPolicyName:      pulumi.String("firewallPolicy"),
 * 			Priority:                pulumi.Int(100),
 * 			ResourceGroupName:       pulumi.String("rg1"),
 * 			RuleCollectionGroupName: pulumi.String("ruleCollectionGroup1"),
 * 			RuleCollections: pulumi.Array{
 * 				network.FirewallPolicyNatRuleCollection{
 * 					Action: network.FirewallPolicyNatRuleCollectionAction{
 * 						Type: "DNAT",
 * 					},
 * 					Name:               "Example-Nat-Rule-Collection",
 * 					Priority:           100,
 * 					RuleCollectionType: "FirewallPolicyNatRuleCollection",
 * 					Rules: []interface{}{
 * 						network.NatRuleType{
 * 							DestinationAddresses: []string{
 * 								"152.23.32.23",
 * 							},
 * 							DestinationPorts: []string{
 * 								"8080",
 * 							},
 * 							IpProtocols: []network.FirewallPolicyRuleNetworkProtocol{
 * 								"TCP",
 * 								"UDP",
 * 							},
 * 							Name:     "nat-rule1",
 * 							RuleType: "NatRule",
 * 							SourceAddresses: []string{
 * 								"2.2.2.2",
 * 							},
 * 							SourceIpGroups: []interface{}{},
 * 							TranslatedFqdn: "internalhttp.server.net",
 * 							TranslatedPort: "8080",
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroup;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallPolicyRuleCollectionGroup = new FirewallPolicyRuleCollectionGroup("firewallPolicyRuleCollectionGroup", FirewallPolicyRuleCollectionGroupArgs.builder()
 *             .firewallPolicyName("firewallPolicy")
 *             .priority(100)
 *             .resourceGroupName("rg1")
 *             .ruleCollectionGroupName("ruleCollectionGroup1")
 *             .ruleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "DNAT")),
 *                 Map.entry("name", "Example-Nat-Rule-Collection"),
 *                 Map.entry("priority", 100),
 *                 Map.entry("ruleCollectionType", "FirewallPolicyNatRuleCollection"),
 *                 Map.entry("rules", Map.ofEntries(
 *                     Map.entry("destinationAddresses", "152.23.32.23"),
 *                     Map.entry("destinationPorts", "8080"),
 *                     Map.entry("ipProtocols",
 *                         "TCP",
 *                         "UDP"),
 *                     Map.entry("name", "nat-rule1"),
 *                     Map.entry("ruleType", "NatRule"),
 *                     Map.entry("sourceAddresses", "2.2.2.2"),
 *                     Map.entry("sourceIpGroups", ),
 *                     Map.entry("translatedFqdn", "internalhttp.server.net"),
 *                     Map.entry("translatedPort", "8080")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create FirewallPolicyRuleCollectionGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallPolicyRuleCollectionGroup = new AzureNative.Network.FirewallPolicyRuleCollectionGroup("firewallPolicyRuleCollectionGroup", new()
 *     {
 *         FirewallPolicyName = "firewallPolicy",
 *         Priority = 100,
 *         ResourceGroupName = "rg1",
 *         RuleCollectionGroupName = "ruleCollectionGroup1",
 *         RuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.FirewallPolicyFilterRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.FirewallPolicyFilterRuleCollectionActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "Example-Filter-Rule-Collection",
 *                 Priority = 100,
 *                 RuleCollectionType = "FirewallPolicyFilterRuleCollection",
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.NetworkRuleArgs
 *                     {
 *                         DestinationAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "*",
 *                         },
 *                         IpProtocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         Name = "network-rule1",
 *                         RuleType = "NetworkRule",
 *                         SourceAddresses = new[]
 *                         {
 *                             "10.1.25.0/24",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFirewallPolicyRuleCollectionGroup(ctx, "firewallPolicyRuleCollectionGroup", &network.FirewallPolicyRuleCollectionGroupArgs{
 * 			FirewallPolicyName:      pulumi.String("firewallPolicy"),
 * 			Priority:                pulumi.Int(100),
 * 			ResourceGroupName:       pulumi.String("rg1"),
 * 			RuleCollectionGroupName: pulumi.String("ruleCollectionGroup1"),
 * 			RuleCollections: pulumi.Array{
 * 				network.FirewallPolicyFilterRuleCollection{
 * 					Action: network.FirewallPolicyFilterRuleCollectionAction{
 * 						Type: "Deny",
 * 					},
 * 					Name:               "Example-Filter-Rule-Collection",
 * 					Priority:           100,
 * 					RuleCollectionType: "FirewallPolicyFilterRuleCollection",
 * 					Rules: []interface{}{
 * 						network.NetworkRule{
 * 							DestinationAddresses: []string{
 * 								"*",
 * 							},
 * 							DestinationPorts: []string{
 * 								"*",
 * 							},
 * 							IpProtocols: []network.FirewallPolicyRuleNetworkProtocol{
 * 								"TCP",
 * 							},
 * 							Name:     "network-rule1",
 * 							RuleType: "NetworkRule",
 * 							SourceAddresses: []string{
 * 								"10.1.25.0/24",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroup;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallPolicyRuleCollectionGroup = new FirewallPolicyRuleCollectionGroup("firewallPolicyRuleCollectionGroup", FirewallPolicyRuleCollectionGroupArgs.builder()
 *             .firewallPolicyName("firewallPolicy")
 *             .priority(100)
 *             .resourceGroupName("rg1")
 *             .ruleCollectionGroupName("ruleCollectionGroup1")
 *             .ruleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "Example-Filter-Rule-Collection"),
 *                 Map.entry("priority", 100),
 *                 Map.entry("ruleCollectionType", "FirewallPolicyFilterRuleCollection"),
 *                 Map.entry("rules", Map.ofEntries(
 *                     Map.entry("destinationAddresses", "*"),
 *                     Map.entry("destinationPorts", "*"),
 *                     Map.entry("ipProtocols", "TCP"),
 *                     Map.entry("name", "network-rule1"),
 *                     Map.entry("ruleType", "NetworkRule"),
 *                     Map.entry("sourceAddresses", "10.1.25.0/24")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create FirewallPolicyRuleCollectionGroup With IpGroups
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallPolicyRuleCollectionGroup = new AzureNative.Network.FirewallPolicyRuleCollectionGroup("firewallPolicyRuleCollectionGroup", new()
 *     {
 *         FirewallPolicyName = "firewallPolicy",
 *         Priority = 110,
 *         ResourceGroupName = "rg1",
 *         RuleCollectionGroupName = "ruleCollectionGroup1",
 *         RuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.FirewallPolicyFilterRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.FirewallPolicyFilterRuleCollectionActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "Example-Filter-Rule-Collection",
 *                 RuleCollectionType = "FirewallPolicyFilterRuleCollection",
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.NetworkRuleArgs
 *                     {
 *                         DestinationIpGroups = new[]
 *                         {
 *                             "/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups2",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "*",
 *                         },
 *                         IpProtocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         Name = "network-1",
 *                         RuleType = "NetworkRule",
 *                         SourceIpGroups = new[]
 *                         {
 *                             "/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups1",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFirewallPolicyRuleCollectionGroup(ctx, "firewallPolicyRuleCollectionGroup", &network.FirewallPolicyRuleCollectionGroupArgs{
 * 			FirewallPolicyName:      pulumi.String("firewallPolicy"),
 * 			Priority:                pulumi.Int(110),
 * 			ResourceGroupName:       pulumi.String("rg1"),
 * 			RuleCollectionGroupName: pulumi.String("ruleCollectionGroup1"),
 * 			RuleCollections: pulumi.Array{
 * 				network.FirewallPolicyFilterRuleCollection{
 * 					Action: network.FirewallPolicyFilterRuleCollectionAction{
 * 						Type: "Deny",
 * 					},
 * 					Name:               "Example-Filter-Rule-Collection",
 * 					RuleCollectionType: "FirewallPolicyFilterRuleCollection",
 * 					Rules: []interface{}{
 * 						network.NetworkRule{
 * 							DestinationIpGroups: []string{
 * 								"/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups2",
 * 							},
 * 							DestinationPorts: []string{
 * 								"*",
 * 							},
 * 							IpProtocols: []network.FirewallPolicyRuleNetworkProtocol{
 * 								"TCP",
 * 							},
 * 							Name:     "network-1",
 * 							RuleType: "NetworkRule",
 * 							SourceIpGroups: []string{
 * 								"/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups1",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroup;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallPolicyRuleCollectionGroup = new FirewallPolicyRuleCollectionGroup("firewallPolicyRuleCollectionGroup", FirewallPolicyRuleCollectionGroupArgs.builder()
 *             .firewallPolicyName("firewallPolicy")
 *             .priority(110)
 *             .resourceGroupName("rg1")
 *             .ruleCollectionGroupName("ruleCollectionGroup1")
 *             .ruleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "Example-Filter-Rule-Collection"),
 *                 Map.entry("ruleCollectionType", "FirewallPolicyFilterRuleCollection"),
 *                 Map.entry("rules", Map.ofEntries(
 *                     Map.entry("destinationIpGroups", "/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups2"),
 *                     Map.entry("destinationPorts", "*"),
 *                     Map.entry("ipProtocols", "TCP"),
 *                     Map.entry("name", "network-1"),
 *                     Map.entry("ruleType", "NetworkRule"),
 *                     Map.entry("sourceIpGroups", "/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups1")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create FirewallPolicyRuleCollectionGroup With Web Categories
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallPolicyRuleCollectionGroup = new AzureNative.Network.FirewallPolicyRuleCollectionGroup("firewallPolicyRuleCollectionGroup", new()
 *     {
 *         FirewallPolicyName = "firewallPolicy",
 *         Priority = 110,
 *         ResourceGroupName = "rg1",
 *         RuleCollectionGroupName = "ruleCollectionGroup1",
 *         RuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.FirewallPolicyFilterRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.FirewallPolicyFilterRuleCollectionActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "Example-Filter-Rule-Collection",
 *                 RuleCollectionType = "FirewallPolicyFilterRuleCollection",
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.ApplicationRuleArgs
 *                     {
 *                         Description = "Deny inbound rule",
 *                         Name = "rule1",
 *                         Protocols = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.FirewallPolicyRuleApplicationProtocolArgs
 *                             {
 *                                 Port = 443,
 *                                 ProtocolType = "Https",
 *                             },
 *                         },
 *                         RuleType = "ApplicationRule",
 *                         SourceAddresses = new[]
 *                         {
 *                             "216.58.216.164",
 *                             "10.0.0.0/24",
 *                         },
 *                         WebCategories = new[]
 *                         {
 *                             "Hacking",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFirewallPolicyRuleCollectionGroup(ctx, "firewallPolicyRuleCollectionGroup", &network.FirewallPolicyRuleCollectionGroupArgs{
 * 			FirewallPolicyName:      pulumi.String("firewallPolicy"),
 * 			Priority:                pulumi.Int(110),
 * 			ResourceGroupName:       pulumi.String("rg1"),
 * 			RuleCollectionGroupName: pulumi.String("ruleCollectionGroup1"),
 * 			RuleCollections: pulumi.Array{
 * 				network.FirewallPolicyFilterRuleCollection{
 * 					Action: network.FirewallPolicyFilterRuleCollectionAction{
 * 						Type: "Deny",
 * 					},
 * 					Name:               "Example-Filter-Rule-Collection",
 * 					RuleCollectionType: "FirewallPolicyFilterRuleCollection",
 * 					Rules: []interface{}{
 * 						network.ApplicationRule{
 * 							Description: "Deny inbound rule",
 * 							Name:        "rule1",
 * 							Protocols: []network.FirewallPolicyRuleApplicationProtocol{
 * 								{
 * 									Port:         443,
 * 									ProtocolType: "Https",
 * 								},
 * 							},
 * 							RuleType: "ApplicationRule",
 * 							SourceAddresses: []string{
 * 								"216.58.216.164",
 * 								"10.0.0.0/24",
 * 							},
 * 							WebCategories: []string{
 * 								"Hacking",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroup;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallPolicyRuleCollectionGroup = new FirewallPolicyRuleCollectionGroup("firewallPolicyRuleCollectionGroup", FirewallPolicyRuleCollectionGroupArgs.builder()
 *             .firewallPolicyName("firewallPolicy")
 *             .priority(110)
 *             .resourceGroupName("rg1")
 *             .ruleCollectionGroupName("ruleCollectionGroup1")
 *             .ruleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "Example-Filter-Rule-Collection"),
 *                 Map.entry("ruleCollectionType", "FirewallPolicyFilterRuleCollection"),
 *                 Map.entry("rules", Map.ofEntries(
 *                     Map.entry("description", "Deny inbound rule"),
 *                     Map.entry("name", "rule1"),
 *                     Map.entry("protocols", Map.ofEntries(
 *                         Map.entry("port", 443),
 *                         Map.entry("protocolType", "Https")
 *                     )),
 *                     Map.entry("ruleType", "ApplicationRule"),
 *                     Map.entry("sourceAddresses",
 *                         "216.58.216.164",
 *                         "10.0.0.0/24"),
 *                     Map.entry("webCategories", "Hacking")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create FirewallPolicyRuleCollectionGroup With http header to insert
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallPolicyRuleCollectionGroup = new AzureNative.Network.FirewallPolicyRuleCollectionGroup("firewallPolicyRuleCollectionGroup", new()
 *     {
 *         FirewallPolicyName = "firewallPolicy",
 *         Priority = 110,
 *         ResourceGroupName = "rg1",
 *         RuleCollectionGroupName = "ruleCollectionGroup1",
 *         RuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.FirewallPolicyFilterRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.FirewallPolicyFilterRuleCollectionActionArgs
 *                 {
 *                     Type = "Allow",
 *                 },
 *                 Name = "Example-Filter-Rule-Collection",
 *                 RuleCollectionType = "FirewallPolicyFilterRuleCollection",
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.ApplicationRuleArgs
 *                     {
 *                         Description = "Insert HTTP header rule",
 *                         FqdnTags = new[]
 *                         {
 *                             "WindowsVirtualDesktop",
 *                         },
 *                         HttpHeadersToInsert = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.FirewallPolicyHttpHeaderToInsertArgs
 *                             {
 *                                 HeaderName = "Restrict-Access-To-Tenants",
 *                                 HeaderValue = "contoso.com,fabrikam.onmicrosoft.com",
 *                             },
 *                         },
 *                         Name = "rule1",
 *                         Protocols = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.FirewallPolicyRuleApplicationProtocolArgs
 *                             {
 *                                 Port = 80,
 *                                 ProtocolType = "Http",
 *                             },
 *                         },
 *                         RuleType = "ApplicationRule",
 *                         SourceAddresses = new[]
 *                         {
 *                             "216.58.216.164",
 *                             "10.0.0.0/24",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFirewallPolicyRuleCollectionGroup(ctx, "firewallPolicyRuleCollectionGroup", &network.FirewallPolicyRuleCollectionGroupArgs{
 * 			FirewallPolicyName:      pulumi.String("firewallPolicy"),
 * 			Priority:                pulumi.Int(110),
 * 			ResourceGroupName:       pulumi.String("rg1"),
 * 			RuleCollectionGroupName: pulumi.String("ruleCollectionGroup1"),
 * 			RuleCollections: pulumi.Array{
 * 				network.FirewallPolicyFilterRuleCollection{
 * 					Action: network.FirewallPolicyFilterRuleCollectionAction{
 * 						Type: "Allow",
 * 					},
 * 					Name:               "Example-Filter-Rule-Collection",
 * 					RuleCollectionType: "FirewallPolicyFilterRuleCollection",
 * 					Rules: []interface{}{
 * 						network.ApplicationRule{
 * 							Description: "Insert HTTP header rule",
 * 							FqdnTags: []string{
 * 								"WindowsVirtualDesktop",
 * 							},
 * 							HttpHeadersToInsert: []network.FirewallPolicyHttpHeaderToInsert{
 * 								{
 * 									HeaderName:  "Restrict-Access-To-Tenants",
 * 									HeaderValue: "contoso.com,fabrikam.onmicrosoft.com",
 * 								},
 * 							},
 * 							Name: "rule1",
 * 							Protocols: []network.FirewallPolicyRuleApplicationProtocol{
 * 								{
 * 									Port:         80,
 * 									ProtocolType: "Http",
 * 								},
 * 							},
 * 							RuleType: "ApplicationRule",
 * 							SourceAddresses: []string{
 * 								"216.58.216.164",
 * 								"10.0.0.0/24",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroup;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallPolicyRuleCollectionGroup = new FirewallPolicyRuleCollectionGroup("firewallPolicyRuleCollectionGroup", FirewallPolicyRuleCollectionGroupArgs.builder()
 *             .firewallPolicyName("firewallPolicy")
 *             .priority(110)
 *             .resourceGroupName("rg1")
 *             .ruleCollectionGroupName("ruleCollectionGroup1")
 *             .ruleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Allow")),
 *                 Map.entry("name", "Example-Filter-Rule-Collection"),
 *                 Map.entry("ruleCollectionType", "FirewallPolicyFilterRuleCollection"),
 *                 Map.entry("rules", Map.ofEntries(
 *                     Map.entry("description", "Insert HTTP header rule"),
 *                     Map.entry("fqdnTags", "WindowsVirtualDesktop"),
 *                     Map.entry("httpHeadersToInsert", Map.ofEntries(
 *                         Map.entry("headerName", "Restrict-Access-To-Tenants"),
 *                         Map.entry("headerValue", "contoso.com,fabrikam.onmicrosoft.com")
 *                     )),
 *                     Map.entry("name", "rule1"),
 *                     Map.entry("protocols", Map.ofEntries(
 *                         Map.entry("port", 80),
 *                         Map.entry("protocolType", "Http")
 *                     )),
 *                     Map.entry("ruleType", "ApplicationRule"),
 *                     Map.entry("sourceAddresses",
 *                         "216.58.216.164",
 *                         "10.0.0.0/24")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:FirewallPolicyRuleCollectionGroup ruleCollectionGroup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleCollectionGroups/{ruleCollectionGroupName}
 * ```
 * @property firewallPolicyName The name of the Firewall Policy.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property priority Priority of the Firewall Policy Rule Collection Group resource.
 * @property resourceGroupName The name of the resource group.
 * @property ruleCollectionGroupName The name of the FirewallPolicyRuleCollectionGroup.
 * @property ruleCollections Group of Firewall Policy rule collections.
 */
public data class FirewallPolicyRuleCollectionGroupArgs(
    public val firewallPolicyName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleCollectionGroupName: Output<String>? = null,
    public val ruleCollections:
    Output<List<Either<FirewallPolicyFilterRuleCollectionArgs, FirewallPolicyNatRuleCollectionArgs>>>? =
        null,
) : ConvertibleToJava<com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupArgs =
        com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupArgs.builder()
            .firewallPolicyName(firewallPolicyName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleCollectionGroupName(ruleCollectionGroupName?.applyValue({ args0 -> args0 }))
            .ruleCollections(
                ruleCollections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0.let({ args0 -> args0.toJava() }) }, { args0 ->
                            args0.let({ args0 ->
                                args0.toJava()
                            })
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirewallPolicyRuleCollectionGroupArgs].
 */
@PulumiTagMarker
public class FirewallPolicyRuleCollectionGroupArgsBuilder internal constructor() {
    private var firewallPolicyName: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleCollectionGroupName: Output<String>? = null

    private var ruleCollections:
        Output<List<Either<FirewallPolicyFilterRuleCollectionArgs, FirewallPolicyNatRuleCollectionArgs>>>? =
        null

    /**
     * @param value The name of the Firewall Policy.
     */
    @JvmName("ghuqofkuylbkgmah")
    public suspend fun firewallPolicyName(`value`: Output<String>) {
        this.firewallPolicyName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("mbqnaudvibxwxydw")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("cgdmrocyusgoxjxu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Priority of the Firewall Policy Rule Collection Group resource.
     */
    @JvmName("hecaealuxfrhimmc")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("xrrjwyuovudthaeq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the FirewallPolicyRuleCollectionGroup.
     */
    @JvmName("iywgluiyixvebkpo")
    public suspend fun ruleCollectionGroupName(`value`: Output<String>) {
        this.ruleCollectionGroupName = value
    }

    /**
     * @param value Group of Firewall Policy rule collections.
     */
    @JvmName("caqfreoqwnokfwbt")
    public suspend
    fun ruleCollections(`value`: Output<List<Either<FirewallPolicyFilterRuleCollectionArgs, FirewallPolicyNatRuleCollectionArgs>>>) {
        this.ruleCollections = value
    }

    @JvmName("byehtxstixcpcryj")
    public suspend fun ruleCollections(
        vararg
        values: Output<Either<FirewallPolicyFilterRuleCollectionArgs, FirewallPolicyNatRuleCollectionArgs>>,
    ) {
        this.ruleCollections = Output.all(values.asList())
    }

    /**
     * @param values Group of Firewall Policy rule collections.
     */
    @JvmName("ftiydcqdkxjpusqb")
    public suspend
    fun ruleCollections(values: List<Output<Either<FirewallPolicyFilterRuleCollectionArgs, FirewallPolicyNatRuleCollectionArgs>>>) {
        this.ruleCollections = Output.all(values)
    }

    /**
     * @param value The name of the Firewall Policy.
     */
    @JvmName("qykmqdtjshdtsahu")
    public suspend fun firewallPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallPolicyName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ikxgswqxpiiwknqa")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("lldqoxslhajhsnfw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Priority of the Firewall Policy Rule Collection Group resource.
     */
    @JvmName("ciggokqyosqvwben")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("dtwacvqxehfdvdae")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the FirewallPolicyRuleCollectionGroup.
     */
    @JvmName("ijbbhsrsrrvntvfq")
    public suspend fun ruleCollectionGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleCollectionGroupName = mapped
    }

    /**
     * @param value Group of Firewall Policy rule collections.
     */
    @JvmName("vgyqfpnnafyybggp")
    public suspend
    fun ruleCollections(`value`: List<Either<FirewallPolicyFilterRuleCollectionArgs, FirewallPolicyNatRuleCollectionArgs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleCollections = mapped
    }

    /**
     * @param values Group of Firewall Policy rule collections.
     */
    @JvmName("nmobydldhflkvtjv")
    public suspend fun ruleCollections(
        vararg
        values: Either<FirewallPolicyFilterRuleCollectionArgs, FirewallPolicyNatRuleCollectionArgs>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleCollections = mapped
    }

    internal fun build(): FirewallPolicyRuleCollectionGroupArgs =
        FirewallPolicyRuleCollectionGroupArgs(
            firewallPolicyName = firewallPolicyName,
            id = id,
            name = name,
            priority = priority,
            resourceGroupName = resourceGroupName,
            ruleCollectionGroupName = ruleCollectionGroupName,
            ruleCollections = ruleCollections,
        )
}
