@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.InboundEndpointIPConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.InboundEndpointIPConfigurationResponse.Companion.toKotlin as inboundEndpointIPConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [InboundEndpoint].
 */
@PulumiTagMarker
public class InboundEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InboundEndpointArgs = InboundEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InboundEndpointArgsBuilder.() -> Unit) {
        val builder = InboundEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): InboundEndpoint {
        val builtJavaResource = com.pulumi.azurenative.network.InboundEndpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InboundEndpoint(builtJavaResource)
    }
}

/**
 * Describes an inbound endpoint for a DNS resolver.
 * Azure REST API version: 2022-07-01. Prior API version in Azure Native 1.x: 2020-04-01-preview.
 * Other available API versions: 2020-04-01-preview.
 * ## Example Usage
 * ### Upsert inbound endpoint for DNS resolver
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var inboundEndpoint = new AzureNative.Network.InboundEndpoint("inboundEndpoint", new()
 *     {
 *         DnsResolverName = "sampleDnsResolver",
 *         InboundEndpointName = "sampleInboundEndpoint",
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.InboundEndpointIPConfigurationArgs
 *             {
 *                 PrivateIpAllocationMethod = "Dynamic",
 *                 Subnet = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/0403cfa9-9659-4f33-9f30-1f191c51d111/resourceGroups/sampleVnetResourceGroupName/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork/subnets/sampleSubnet",
 *                 },
 *             },
 *         },
 *         Location = "westus2",
 *         ResourceGroupName = "sampleResourceGroup",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewInboundEndpoint(ctx, "inboundEndpoint", &network.InboundEndpointArgs{
 * 			DnsResolverName:     pulumi.String("sampleDnsResolver"),
 * 			InboundEndpointName: pulumi.String("sampleInboundEndpoint"),
 * 			IpConfigurations: []network.InboundEndpointIPConfigurationArgs{
 * 				{
 * 					PrivateIpAllocationMethod: pulumi.String("Dynamic"),
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/0403cfa9-9659-4f33-9f30-1f191c51d111/resourceGroups/sampleVnetResourceGroupName/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork/subnets/sampleSubnet"),
 * 					},
 * 				},
 * 			},
 * 			Location:          pulumi.String("westus2"),
 * 			ResourceGroupName: pulumi.String("sampleResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.InboundEndpoint;
 * import com.pulumi.azurenative.network.InboundEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var inboundEndpoint = new InboundEndpoint("inboundEndpoint", InboundEndpointArgs.builder()
 *             .dnsResolverName("sampleDnsResolver")
 *             .inboundEndpointName("sampleInboundEndpoint")
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("privateIpAllocationMethod", "Dynamic"),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/0403cfa9-9659-4f33-9f30-1f191c51d111/resourceGroups/sampleVnetResourceGroupName/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork/subnets/sampleSubnet"))
 *             ))
 *             .location("westus2")
 *             .resourceGroupName("sampleResourceGroup")
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:InboundEndpoint sampleInboundEndpoint /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}/inboundEndpoints/{inboundEndpointName}
 * ```
 */
public class InboundEndpoint internal constructor(
    override val javaResource: com.pulumi.azurenative.network.InboundEndpoint,
) : KotlinCustomResource(javaResource, InboundEndpointMapper) {
    /**
     * ETag of the inbound endpoint.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * IP configurations for the inbound endpoint.
     */
    public val ipConfigurations: Output<List<InboundEndpointIPConfigurationResponse>>
        get() = javaResource.ipConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> inboundEndpointIPConfigurationResponseToKotlin(args0) })
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The current provisioning state of the inbound endpoint. This is a read-only property and any attempt to set this value will be ignored.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resourceGuid property of the inbound endpoint resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object InboundEndpointMapper : ResourceMapper<InboundEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.InboundEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): InboundEndpoint = InboundEndpoint(
        javaResource as
            com.pulumi.azurenative.network.InboundEndpoint,
    )
}

/**
 * @see [InboundEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InboundEndpoint].
 */
public suspend fun inboundEndpoint(
    name: String,
    block: suspend InboundEndpointResourceBuilder.() -> Unit,
): InboundEndpoint {
    val builder = InboundEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InboundEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun inboundEndpoint(name: String): InboundEndpoint {
    val builder = InboundEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
