@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.InboundEndpointArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.InboundEndpointIPConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.InboundEndpointIPConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes an inbound endpoint for a DNS resolver.
 * Azure REST API version: 2022-07-01. Prior API version in Azure Native 1.x: 2020-04-01-preview.
 * Other available API versions: 2020-04-01-preview.
 * ## Example Usage
 * ### Upsert inbound endpoint for DNS resolver
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var inboundEndpoint = new AzureNative.Network.InboundEndpoint("inboundEndpoint", new()
 *     {
 *         DnsResolverName = "sampleDnsResolver",
 *         InboundEndpointName = "sampleInboundEndpoint",
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.InboundEndpointIPConfigurationArgs
 *             {
 *                 PrivateIpAllocationMethod = "Dynamic",
 *                 Subnet = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/0403cfa9-9659-4f33-9f30-1f191c51d111/resourceGroups/sampleVnetResourceGroupName/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork/subnets/sampleSubnet",
 *                 },
 *             },
 *         },
 *         Location = "westus2",
 *         ResourceGroupName = "sampleResourceGroup",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewInboundEndpoint(ctx, "inboundEndpoint", &network.InboundEndpointArgs{
 * 			DnsResolverName:     pulumi.String("sampleDnsResolver"),
 * 			InboundEndpointName: pulumi.String("sampleInboundEndpoint"),
 * 			IpConfigurations: []network.InboundEndpointIPConfigurationArgs{
 * 				{
 * 					PrivateIpAllocationMethod: pulumi.String("Dynamic"),
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/0403cfa9-9659-4f33-9f30-1f191c51d111/resourceGroups/sampleVnetResourceGroupName/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork/subnets/sampleSubnet"),
 * 					},
 * 				},
 * 			},
 * 			Location:          pulumi.String("westus2"),
 * 			ResourceGroupName: pulumi.String("sampleResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.InboundEndpoint;
 * import com.pulumi.azurenative.network.InboundEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var inboundEndpoint = new InboundEndpoint("inboundEndpoint", InboundEndpointArgs.builder()
 *             .dnsResolverName("sampleDnsResolver")
 *             .inboundEndpointName("sampleInboundEndpoint")
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("privateIpAllocationMethod", "Dynamic"),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/0403cfa9-9659-4f33-9f30-1f191c51d111/resourceGroups/sampleVnetResourceGroupName/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork/subnets/sampleSubnet"))
 *             ))
 *             .location("westus2")
 *             .resourceGroupName("sampleResourceGroup")
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:InboundEndpoint sampleInboundEndpoint /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}/inboundEndpoints/{inboundEndpointName}
 * ```
 * @property dnsResolverName The name of the DNS resolver.
 * @property inboundEndpointName The name of the inbound endpoint for the DNS resolver.
 * @property ipConfigurations IP configurations for the inbound endpoint.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class InboundEndpointArgs(
    public val dnsResolverName: Output<String>? = null,
    public val inboundEndpointName: Output<String>? = null,
    public val ipConfigurations: Output<List<InboundEndpointIPConfigurationArgs>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.InboundEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.network.InboundEndpointArgs =
        com.pulumi.azurenative.network.InboundEndpointArgs.builder()
            .dnsResolverName(dnsResolverName?.applyValue({ args0 -> args0 }))
            .inboundEndpointName(inboundEndpointName?.applyValue({ args0 -> args0 }))
            .ipConfigurations(
                ipConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [InboundEndpointArgs].
 */
@PulumiTagMarker
public class InboundEndpointArgsBuilder internal constructor() {
    private var dnsResolverName: Output<String>? = null

    private var inboundEndpointName: Output<String>? = null

    private var ipConfigurations: Output<List<InboundEndpointIPConfigurationArgs>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the DNS resolver.
     */
    @JvmName("duyvygrvdnjpfnpx")
    public suspend fun dnsResolverName(`value`: Output<String>) {
        this.dnsResolverName = value
    }

    /**
     * @param value The name of the inbound endpoint for the DNS resolver.
     */
    @JvmName("pqmoijmmtjbeyaec")
    public suspend fun inboundEndpointName(`value`: Output<String>) {
        this.inboundEndpointName = value
    }

    /**
     * @param value IP configurations for the inbound endpoint.
     */
    @JvmName("yudifvbbpmjhjbht")
    public suspend fun ipConfigurations(`value`: Output<List<InboundEndpointIPConfigurationArgs>>) {
        this.ipConfigurations = value
    }

    @JvmName("ikxavflywypwohrf")
    public suspend fun ipConfigurations(vararg values: Output<InboundEndpointIPConfigurationArgs>) {
        this.ipConfigurations = Output.all(values.asList())
    }

    /**
     * @param values IP configurations for the inbound endpoint.
     */
    @JvmName("xjjdsjstkljpvnxo")
    public suspend fun ipConfigurations(values: List<Output<InboundEndpointIPConfigurationArgs>>) {
        this.ipConfigurations = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("xedhsnhwghhhlcjn")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wdfcycgdxqoilrhh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xqgnsdhdkuwqnqgn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the DNS resolver.
     */
    @JvmName("mirgdmyyyglmaiap")
    public suspend fun dnsResolverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsResolverName = mapped
    }

    /**
     * @param value The name of the inbound endpoint for the DNS resolver.
     */
    @JvmName("vhxlkylwtohkuiua")
    public suspend fun inboundEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inboundEndpointName = mapped
    }

    /**
     * @param value IP configurations for the inbound endpoint.
     */
    @JvmName("lvvlrdhiejcxmlgd")
    public suspend fun ipConfigurations(`value`: List<InboundEndpointIPConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param argument IP configurations for the inbound endpoint.
     */
    @JvmName("julbkeppcaftgbfw")
    public suspend
    fun ipConfigurations(argument: List<suspend InboundEndpointIPConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InboundEndpointIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument IP configurations for the inbound endpoint.
     */
    @JvmName("pafhwcaypjrwdtas")
    public suspend fun ipConfigurations(
        vararg
        argument: suspend InboundEndpointIPConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            InboundEndpointIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument IP configurations for the inbound endpoint.
     */
    @JvmName("fhyqihryqbadnhmu")
    public suspend
    fun ipConfigurations(argument: suspend InboundEndpointIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InboundEndpointIPConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param values IP configurations for the inbound endpoint.
     */
    @JvmName("emmylcrtbvvujxhq")
    public suspend fun ipConfigurations(vararg values: InboundEndpointIPConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("vofpmkjmllipjyak")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("onkkjqyvdxhlfcnv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ywgffjreijhxkkcm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nklvixslmstorxmb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): InboundEndpointArgs = InboundEndpointArgs(
        dnsResolverName = dnsResolverName,
        inboundEndpointName = inboundEndpointName,
        ipConfigurations = ipConfigurations,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
