@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.InboundNatRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.TransportProtocol
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Inbound NAT rule of the load balancer.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-06-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### InboundNatRuleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var inboundNatRule = new AzureNative.Network.InboundNatRule("inboundNatRule", new()
 *     {
 *         BackendPort = 3389,
 *         EnableFloatingIP = false,
 *         EnableTcpReset = false,
 *         FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/testrg/providers/Microsoft.Network/loadBalancers/lb1/frontendIPConfigurations/ip1",
 *         },
 *         FrontendPort = 3390,
 *         IdleTimeoutInMinutes = 4,
 *         InboundNatRuleName = "natRule1.1",
 *         LoadBalancerName = "lb1",
 *         Protocol = "Tcp",
 *         ResourceGroupName = "testrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewInboundNatRule(ctx, "inboundNatRule", &network.InboundNatRuleArgs{
 * 			BackendPort:      pulumi.Int(3389),
 * 			EnableFloatingIP: pulumi.Bool(false),
 * 			EnableTcpReset:   pulumi.Bool(false),
 * 			FrontendIPConfiguration: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/testrg/providers/Microsoft.Network/loadBalancers/lb1/frontendIPConfigurations/ip1"),
 * 			},
 * 			FrontendPort:         pulumi.Int(3390),
 * 			IdleTimeoutInMinutes: pulumi.Int(4),
 * 			InboundNatRuleName:   pulumi.String("natRule1.1"),
 * 			LoadBalancerName:     pulumi.String("lb1"),
 * 			Protocol:             pulumi.String("Tcp"),
 * 			ResourceGroupName:    pulumi.String("testrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.InboundNatRule;
 * import com.pulumi.azurenative.network.InboundNatRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var inboundNatRule = new InboundNatRule("inboundNatRule", InboundNatRuleArgs.builder()
 *             .backendPort(3389)
 *             .enableFloatingIP(false)
 *             .enableTcpReset(false)
 *             .frontendIPConfiguration(Map.of("id", "/subscriptions/subid/resourceGroups/testrg/providers/Microsoft.Network/loadBalancers/lb1/frontendIPConfigurations/ip1"))
 *             .frontendPort(3390)
 *             .idleTimeoutInMinutes(4)
 *             .inboundNatRuleName("natRule1.1")
 *             .loadBalancerName("lb1")
 *             .protocol("Tcp")
 *             .resourceGroupName("testrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:InboundNatRule natRule1.1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/inboundNatRules/{inboundNatRuleName}
 * ```
 * @property backendAddressPool A reference to backendAddressPool resource.
 * @property backendPort The port used for the internal endpoint. Acceptable values range from 1 to 65535.
 * @property enableFloatingIP Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
 * @property enableTcpReset Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
 * @property frontendIPConfiguration A reference to frontend IP addresses.
 * @property frontendPort The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.
 * @property frontendPortRangeEnd The port range end for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
 * @property frontendPortRangeStart The port range start for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
 * @property id Resource ID.
 * @property idleTimeoutInMinutes The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
 * @property inboundNatRuleName The name of the inbound NAT rule.
 * @property loadBalancerName The name of the load balancer.
 * @property name The name of the resource that is unique within the set of inbound NAT rules used by the load balancer. This name can be used to access the resource.
 * @property protocol The reference to the transport protocol used by the load balancing rule.
 * @property resourceGroupName The name of the resource group.
 */
public data class InboundNatRuleArgs(
    public val backendAddressPool: Output<SubResourceArgs>? = null,
    public val backendPort: Output<Int>? = null,
    public val enableFloatingIP: Output<Boolean>? = null,
    public val enableTcpReset: Output<Boolean>? = null,
    public val frontendIPConfiguration: Output<SubResourceArgs>? = null,
    public val frontendPort: Output<Int>? = null,
    public val frontendPortRangeEnd: Output<Int>? = null,
    public val frontendPortRangeStart: Output<Int>? = null,
    public val id: Output<String>? = null,
    public val idleTimeoutInMinutes: Output<Int>? = null,
    public val inboundNatRuleName: Output<String>? = null,
    public val loadBalancerName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val protocol: Output<Either<String, TransportProtocol>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.InboundNatRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.InboundNatRuleArgs =
        com.pulumi.azurenative.network.InboundNatRuleArgs.builder()
            .backendAddressPool(
                backendAddressPool?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .backendPort(backendPort?.applyValue({ args0 -> args0 }))
            .enableFloatingIP(enableFloatingIP?.applyValue({ args0 -> args0 }))
            .enableTcpReset(enableTcpReset?.applyValue({ args0 -> args0 }))
            .frontendIPConfiguration(
                frontendIPConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .frontendPort(frontendPort?.applyValue({ args0 -> args0 }))
            .frontendPortRangeEnd(frontendPortRangeEnd?.applyValue({ args0 -> args0 }))
            .frontendPortRangeStart(frontendPortRangeStart?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .idleTimeoutInMinutes(idleTimeoutInMinutes?.applyValue({ args0 -> args0 }))
            .inboundNatRuleName(inboundNatRuleName?.applyValue({ args0 -> args0 }))
            .loadBalancerName(loadBalancerName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InboundNatRuleArgs].
 */
@PulumiTagMarker
public class InboundNatRuleArgsBuilder internal constructor() {
    private var backendAddressPool: Output<SubResourceArgs>? = null

    private var backendPort: Output<Int>? = null

    private var enableFloatingIP: Output<Boolean>? = null

    private var enableTcpReset: Output<Boolean>? = null

    private var frontendIPConfiguration: Output<SubResourceArgs>? = null

    private var frontendPort: Output<Int>? = null

    private var frontendPortRangeEnd: Output<Int>? = null

    private var frontendPortRangeStart: Output<Int>? = null

    private var id: Output<String>? = null

    private var idleTimeoutInMinutes: Output<Int>? = null

    private var inboundNatRuleName: Output<String>? = null

    private var loadBalancerName: Output<String>? = null

    private var name: Output<String>? = null

    private var protocol: Output<Either<String, TransportProtocol>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value A reference to backendAddressPool resource.
     */
    @JvmName("tlwjhkqtosfardyp")
    public suspend fun backendAddressPool(`value`: Output<SubResourceArgs>) {
        this.backendAddressPool = value
    }

    /**
     * @param value The port used for the internal endpoint. Acceptable values range from 1 to 65535.
     */
    @JvmName("osjafftqamufyavh")
    public suspend fun backendPort(`value`: Output<Int>) {
        this.backendPort = value
    }

    /**
     * @param value Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
     */
    @JvmName("ggfyvfkfpmogpunb")
    public suspend fun enableFloatingIP(`value`: Output<Boolean>) {
        this.enableFloatingIP = value
    }

    /**
     * @param value Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
     */
    @JvmName("efpjfsomcumpsqia")
    public suspend fun enableTcpReset(`value`: Output<Boolean>) {
        this.enableTcpReset = value
    }

    /**
     * @param value A reference to frontend IP addresses.
     */
    @JvmName("vvumjknrbutfpjjs")
    public suspend fun frontendIPConfiguration(`value`: Output<SubResourceArgs>) {
        this.frontendIPConfiguration = value
    }

    /**
     * @param value The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.
     */
    @JvmName("ekdfokdmwcvpiujd")
    public suspend fun frontendPort(`value`: Output<Int>) {
        this.frontendPort = value
    }

    /**
     * @param value The port range end for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
     */
    @JvmName("kxlqxfqrvfnlntro")
    public suspend fun frontendPortRangeEnd(`value`: Output<Int>) {
        this.frontendPortRangeEnd = value
    }

    /**
     * @param value The port range start for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
     */
    @JvmName("yjmbwgowbbukukvw")
    public suspend fun frontendPortRangeStart(`value`: Output<Int>) {
        this.frontendPortRangeStart = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ysrotbuvhkxledci")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
     */
    @JvmName("mjgnmpgbldravbhn")
    public suspend fun idleTimeoutInMinutes(`value`: Output<Int>) {
        this.idleTimeoutInMinutes = value
    }

    /**
     * @param value The name of the inbound NAT rule.
     */
    @JvmName("sjdoyugdnafqwsub")
    public suspend fun inboundNatRuleName(`value`: Output<String>) {
        this.inboundNatRuleName = value
    }

    /**
     * @param value The name of the load balancer.
     */
    @JvmName("lcxmlpmgykosiqhm")
    public suspend fun loadBalancerName(`value`: Output<String>) {
        this.loadBalancerName = value
    }

    /**
     * @param value The name of the resource that is unique within the set of inbound NAT rules used by the load balancer. This name can be used to access the resource.
     */
    @JvmName("wxiqssniufdklpej")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The reference to the transport protocol used by the load balancing rule.
     */
    @JvmName("itnalwxlgmmxwtlb")
    public suspend fun protocol(`value`: Output<Either<String, TransportProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("rbbholfpvyuuiykp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value A reference to backendAddressPool resource.
     */
    @JvmName("rnxhtrxflumwyesn")
    public suspend fun backendAddressPool(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendAddressPool = mapped
    }

    /**
     * @param argument A reference to backendAddressPool resource.
     */
    @JvmName("cufomslfoksddpwl")
    public suspend fun backendAddressPool(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backendAddressPool = mapped
    }

    /**
     * @param value The port used for the internal endpoint. Acceptable values range from 1 to 65535.
     */
    @JvmName("gvvapnnynxpdvcud")
    public suspend fun backendPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendPort = mapped
    }

    /**
     * @param value Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
     */
    @JvmName("quinekavyxdxwedx")
    public suspend fun enableFloatingIP(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableFloatingIP = mapped
    }

    /**
     * @param value Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
     */
    @JvmName("bkhntjfkufejwhjt")
    public suspend fun enableTcpReset(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableTcpReset = mapped
    }

    /**
     * @param value A reference to frontend IP addresses.
     */
    @JvmName("hsayifqemslmjqeh")
    public suspend fun frontendIPConfiguration(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendIPConfiguration = mapped
    }

    /**
     * @param argument A reference to frontend IP addresses.
     */
    @JvmName("corpunelapebslxy")
    public suspend fun frontendIPConfiguration(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.frontendIPConfiguration = mapped
    }

    /**
     * @param value The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.
     */
    @JvmName("dmeueienqtqqpocp")
    public suspend fun frontendPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendPort = mapped
    }

    /**
     * @param value The port range end for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
     */
    @JvmName("wpxajjdgwiddovpl")
    public suspend fun frontendPortRangeEnd(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendPortRangeEnd = mapped
    }

    /**
     * @param value The port range start for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
     */
    @JvmName("gheiovqfttuiaidw")
    public suspend fun frontendPortRangeStart(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendPortRangeStart = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("qegoblpwkrdehqpt")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
     */
    @JvmName("ngjiypickfrdeqth")
    public suspend fun idleTimeoutInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeoutInMinutes = mapped
    }

    /**
     * @param value The name of the inbound NAT rule.
     */
    @JvmName("oxvuejtwmwmxywbd")
    public suspend fun inboundNatRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inboundNatRuleName = mapped
    }

    /**
     * @param value The name of the load balancer.
     */
    @JvmName("ndiqeahjqcrndwny")
    public suspend fun loadBalancerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerName = mapped
    }

    /**
     * @param value The name of the resource that is unique within the set of inbound NAT rules used by the load balancer. This name can be used to access the resource.
     */
    @JvmName("mipjdbnhrqmbvsqp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The reference to the transport protocol used by the load balancing rule.
     */
    @JvmName("dpcyudipudqrlapn")
    public suspend fun protocol(`value`: Either<String, TransportProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The reference to the transport protocol used by the load balancing rule.
     */
    @JvmName("nilyikerwjalllqk")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TransportProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The reference to the transport protocol used by the load balancing rule.
     */
    @JvmName("nhnkkjqrxcawniqe")
    public fun protocol(`value`: TransportProtocol) {
        val toBeMapped = Either.ofRight<String, TransportProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qselsoxabngntcde")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): InboundNatRuleArgs = InboundNatRuleArgs(
        backendAddressPool = backendAddressPool,
        backendPort = backendPort,
        enableFloatingIP = enableFloatingIP,
        enableTcpReset = enableTcpReset,
        frontendIPConfiguration = frontendIPConfiguration,
        frontendPort = frontendPort,
        frontendPortRangeEnd = frontendPortRangeEnd,
        frontendPortRangeStart = frontendPortRangeStart,
        id = id,
        idleTimeoutInMinutes = idleTimeoutInMinutes,
        inboundNatRuleName = inboundNatRuleName,
        loadBalancerName = loadBalancerName,
        name = name,
        protocol = protocol,
        resourceGroupName = resourceGroupName,
    )
}
