@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.LoadBalancerBackendAddressPoolArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.GatewayLoadBalancerTunnelInterfaceArgs
import com.pulumi.azurenative.network.kotlin.inputs.GatewayLoadBalancerTunnelInterfaceArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.LoadBalancerBackendAddressArgs
import com.pulumi.azurenative.network.kotlin.inputs.LoadBalancerBackendAddressArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Pool of backend IP addresses.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Update load balancer backend pool with backend addresses containing virtual network and  IP address.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancerBackendAddressPool = new AzureNative.Network.LoadBalancerBackendAddressPool("loadBalancerBackendAddressPool", new()
 *     {
 *         BackendAddressPoolName = "backend",
 *         LoadBalancerBackendAddresses = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancerBackendAddressArgs
 *             {
 *                 IpAddress = "10.0.0.4",
 *                 Name = "address1",
 *                 VirtualNetwork = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb",
 *                 },
 *             },
 *             new AzureNative.Network.Inputs.LoadBalancerBackendAddressArgs
 *             {
 *                 IpAddress = "10.0.0.5",
 *                 Name = "address2",
 *                 VirtualNetwork = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb",
 *                 },
 *             },
 *         },
 *         LoadBalancerName = "lb",
 *         ResourceGroupName = "testrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancerBackendAddressPool(ctx, "loadBalancerBackendAddressPool", &network.LoadBalancerBackendAddressPoolArgs{
 * 			BackendAddressPoolName: pulumi.String("backend"),
 * 			LoadBalancerBackendAddresses: []network.LoadBalancerBackendAddressArgs{
 * 				{
 * 					IpAddress: pulumi.String("10.0.0.4"),
 * 					Name:      pulumi.String("address1"),
 * 					VirtualNetwork: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb"),
 * 					},
 * 				},
 * 				{
 * 					IpAddress: pulumi.String("10.0.0.5"),
 * 					Name:      pulumi.String("address2"),
 * 					VirtualNetwork: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb"),
 * 					},
 * 				},
 * 			},
 * 			LoadBalancerName:  pulumi.String("lb"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancerBackendAddressPool;
 * import com.pulumi.azurenative.network.LoadBalancerBackendAddressPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancerBackendAddressPool = new LoadBalancerBackendAddressPool("loadBalancerBackendAddressPool", LoadBalancerBackendAddressPoolArgs.builder()
 *             .backendAddressPoolName("backend")
 *             .loadBalancerBackendAddresses(
 *                 Map.ofEntries(
 *                     Map.entry("ipAddress", "10.0.0.4"),
 *                     Map.entry("name", "address1"),
 *                     Map.entry("virtualNetwork", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb"))
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("ipAddress", "10.0.0.5"),
 *                     Map.entry("name", "address2"),
 *                     Map.entry("virtualNetwork", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb"))
 *                 ))
 *             .loadBalancerName("lb")
 *             .resourceGroupName("testrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:LoadBalancerBackendAddressPool backend /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/backendAddressPools/{backendAddressPoolName}
 * ```
 * @property backendAddressPoolName The name of the backend address pool.
 * @property drainPeriodInSeconds Amount of seconds Load Balancer waits for before sending RESET to client and backend address.
 * @property id Resource ID.
 * @property loadBalancerBackendAddresses An array of backend addresses.
 * @property loadBalancerName The name of the load balancer.
 * @property location The location of the backend address pool.
 * @property name The name of the resource that is unique within the set of backend address pools used by the load balancer. This name can be used to access the resource.
 * @property resourceGroupName The name of the resource group.
 * @property tunnelInterfaces An array of gateway load balancer tunnel interfaces.
 * @property virtualNetwork A reference to a virtual network.
 */
public data class LoadBalancerBackendAddressPoolArgs(
    public val backendAddressPoolName: Output<String>? = null,
    public val drainPeriodInSeconds: Output<Int>? = null,
    public val id: Output<String>? = null,
    public val loadBalancerBackendAddresses: Output<List<LoadBalancerBackendAddressArgs>>? = null,
    public val loadBalancerName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tunnelInterfaces: Output<List<GatewayLoadBalancerTunnelInterfaceArgs>>? = null,
    public val virtualNetwork: Output<SubResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.LoadBalancerBackendAddressPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.network.LoadBalancerBackendAddressPoolArgs =
        com.pulumi.azurenative.network.LoadBalancerBackendAddressPoolArgs.builder()
            .backendAddressPoolName(backendAddressPoolName?.applyValue({ args0 -> args0 }))
            .drainPeriodInSeconds(drainPeriodInSeconds?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .loadBalancerBackendAddresses(
                loadBalancerBackendAddresses?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .loadBalancerName(loadBalancerName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tunnelInterfaces(
                tunnelInterfaces?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .virtualNetwork(
                virtualNetwork?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [LoadBalancerBackendAddressPoolArgs].
 */
@PulumiTagMarker
public class LoadBalancerBackendAddressPoolArgsBuilder internal constructor() {
    private var backendAddressPoolName: Output<String>? = null

    private var drainPeriodInSeconds: Output<Int>? = null

    private var id: Output<String>? = null

    private var loadBalancerBackendAddresses: Output<List<LoadBalancerBackendAddressArgs>>? = null

    private var loadBalancerName: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tunnelInterfaces: Output<List<GatewayLoadBalancerTunnelInterfaceArgs>>? = null

    private var virtualNetwork: Output<SubResourceArgs>? = null

    /**
     * @param value The name of the backend address pool.
     */
    @JvmName("muxrykuytbvmwafx")
    public suspend fun backendAddressPoolName(`value`: Output<String>) {
        this.backendAddressPoolName = value
    }

    /**
     * @param value Amount of seconds Load Balancer waits for before sending RESET to client and backend address.
     */
    @JvmName("lcidylbwoxbtlimt")
    public suspend fun drainPeriodInSeconds(`value`: Output<Int>) {
        this.drainPeriodInSeconds = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("gwcuxdqkblogygbi")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value An array of backend addresses.
     */
    @JvmName("luxwkybfscyhrlhc")
    public suspend
    fun loadBalancerBackendAddresses(`value`: Output<List<LoadBalancerBackendAddressArgs>>) {
        this.loadBalancerBackendAddresses = value
    }

    @JvmName("wkovmtrgefghohud")
    public suspend fun loadBalancerBackendAddresses(
        vararg
        values: Output<LoadBalancerBackendAddressArgs>,
    ) {
        this.loadBalancerBackendAddresses = Output.all(values.asList())
    }

    /**
     * @param values An array of backend addresses.
     */
    @JvmName("pxajoxfimnvcstlp")
    public suspend
    fun loadBalancerBackendAddresses(values: List<Output<LoadBalancerBackendAddressArgs>>) {
        this.loadBalancerBackendAddresses = Output.all(values)
    }

    /**
     * @param value The name of the load balancer.
     */
    @JvmName("tlnctksntdlkvbua")
    public suspend fun loadBalancerName(`value`: Output<String>) {
        this.loadBalancerName = value
    }

    /**
     * @param value The location of the backend address pool.
     */
    @JvmName("nfudvwnlifpxbuao")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource that is unique within the set of backend address pools used by the load balancer. This name can be used to access the resource.
     */
    @JvmName("kfmojkavmqjbffcn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("aewtjsefswtwljaa")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value An array of gateway load balancer tunnel interfaces.
     */
    @JvmName("ovpwqjjhrshfrjoy")
    public suspend
    fun tunnelInterfaces(`value`: Output<List<GatewayLoadBalancerTunnelInterfaceArgs>>) {
        this.tunnelInterfaces = value
    }

    @JvmName("vphrkpajwsikwibr")
    public suspend fun tunnelInterfaces(
        vararg
        values: Output<GatewayLoadBalancerTunnelInterfaceArgs>,
    ) {
        this.tunnelInterfaces = Output.all(values.asList())
    }

    /**
     * @param values An array of gateway load balancer tunnel interfaces.
     */
    @JvmName("kdlupgtkblqcxqgl")
    public suspend
    fun tunnelInterfaces(values: List<Output<GatewayLoadBalancerTunnelInterfaceArgs>>) {
        this.tunnelInterfaces = Output.all(values)
    }

    /**
     * @param value A reference to a virtual network.
     */
    @JvmName("gafftgbhowddkifo")
    public suspend fun virtualNetwork(`value`: Output<SubResourceArgs>) {
        this.virtualNetwork = value
    }

    /**
     * @param value The name of the backend address pool.
     */
    @JvmName("ncqiijtbifmxujyt")
    public suspend fun backendAddressPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendAddressPoolName = mapped
    }

    /**
     * @param value Amount of seconds Load Balancer waits for before sending RESET to client and backend address.
     */
    @JvmName("uvlvmxdgepxntvnc")
    public suspend fun drainPeriodInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.drainPeriodInSeconds = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("mbrkqwoubnuhnjtm")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value An array of backend addresses.
     */
    @JvmName("nwsecbnblthptbdl")
    public suspend fun loadBalancerBackendAddresses(`value`: List<LoadBalancerBackendAddressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerBackendAddresses = mapped
    }

    /**
     * @param argument An array of backend addresses.
     */
    @JvmName("yciiilhscklgwqlf")
    public suspend
    fun loadBalancerBackendAddresses(argument: List<suspend LoadBalancerBackendAddressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LoadBalancerBackendAddressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerBackendAddresses = mapped
    }

    /**
     * @param argument An array of backend addresses.
     */
    @JvmName("dntigxwdticymeyr")
    public suspend fun loadBalancerBackendAddresses(
        vararg
        argument: suspend LoadBalancerBackendAddressArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LoadBalancerBackendAddressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerBackendAddresses = mapped
    }

    /**
     * @param argument An array of backend addresses.
     */
    @JvmName("inxcanfrdnbldobk")
    public suspend
    fun loadBalancerBackendAddresses(argument: suspend LoadBalancerBackendAddressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LoadBalancerBackendAddressArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.loadBalancerBackendAddresses = mapped
    }

    /**
     * @param values An array of backend addresses.
     */
    @JvmName("kfgemieaagckgiek")
    public suspend fun loadBalancerBackendAddresses(vararg values: LoadBalancerBackendAddressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerBackendAddresses = mapped
    }

    /**
     * @param value The name of the load balancer.
     */
    @JvmName("fkdhpycohswbmddu")
    public suspend fun loadBalancerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerName = mapped
    }

    /**
     * @param value The location of the backend address pool.
     */
    @JvmName("smwoqtjipnftyomd")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource that is unique within the set of backend address pools used by the load balancer. This name can be used to access the resource.
     */
    @JvmName("enppveyxtxvxcfmn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("dbvxamxwunhusegu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value An array of gateway load balancer tunnel interfaces.
     */
    @JvmName("yfjvwiurgtwgufke")
    public suspend fun tunnelInterfaces(`value`: List<GatewayLoadBalancerTunnelInterfaceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tunnelInterfaces = mapped
    }

    /**
     * @param argument An array of gateway load balancer tunnel interfaces.
     */
    @JvmName("sbjjucvwrkiitatq")
    public suspend
    fun tunnelInterfaces(argument: List<suspend GatewayLoadBalancerTunnelInterfaceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GatewayLoadBalancerTunnelInterfaceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tunnelInterfaces = mapped
    }

    /**
     * @param argument An array of gateway load balancer tunnel interfaces.
     */
    @JvmName("kqghpquyqcgrsvkb")
    public suspend fun tunnelInterfaces(
        vararg
        argument: suspend GatewayLoadBalancerTunnelInterfaceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GatewayLoadBalancerTunnelInterfaceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tunnelInterfaces = mapped
    }

    /**
     * @param argument An array of gateway load balancer tunnel interfaces.
     */
    @JvmName("bprgqmqqyaivoseu")
    public suspend
    fun tunnelInterfaces(argument: suspend GatewayLoadBalancerTunnelInterfaceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GatewayLoadBalancerTunnelInterfaceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.tunnelInterfaces = mapped
    }

    /**
     * @param values An array of gateway load balancer tunnel interfaces.
     */
    @JvmName("sggkvdcobpbvxxoy")
    public suspend fun tunnelInterfaces(vararg values: GatewayLoadBalancerTunnelInterfaceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tunnelInterfaces = mapped
    }

    /**
     * @param value A reference to a virtual network.
     */
    @JvmName("ctsjjxovouasysem")
    public suspend fun virtualNetwork(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetwork = mapped
    }

    /**
     * @param argument A reference to a virtual network.
     */
    @JvmName("cyuqlhxsmyitgoeq")
    public suspend fun virtualNetwork(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualNetwork = mapped
    }

    internal fun build(): LoadBalancerBackendAddressPoolArgs = LoadBalancerBackendAddressPoolArgs(
        backendAddressPoolName = backendAddressPoolName,
        drainPeriodInSeconds = drainPeriodInSeconds,
        id = id,
        loadBalancerBackendAddresses = loadBalancerBackendAddresses,
        loadBalancerName = loadBalancerName,
        location = location,
        name = name,
        resourceGroupName = resourceGroupName,
        tunnelInterfaces = tunnelInterfaces,
        virtualNetwork = virtualNetwork,
    )
}
