@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ManagementGroupNetworkManagerConnection].
 */
@PulumiTagMarker
public class ManagementGroupNetworkManagerConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagementGroupNetworkManagerConnectionArgs =
        ManagementGroupNetworkManagerConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend ManagementGroupNetworkManagerConnectionArgsBuilder.() -> Unit) {
        val builder = ManagementGroupNetworkManagerConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ManagementGroupNetworkManagerConnection {
        val builtJavaResource =
            com.pulumi.azurenative.network.ManagementGroupNetworkManagerConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagementGroupNetworkManagerConnection(builtJavaResource)
    }
}

/**
 * The Network Manager Connection resource
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-05-01-preview.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create or Update Management Group Network Manager Connection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementGroupNetworkManagerConnection = new AzureNative.Network.ManagementGroupNetworkManagerConnection("managementGroupNetworkManagerConnection", new()
 *     {
 *         ManagementGroupId = "managementGroupA",
 *         NetworkManagerConnectionName = "TestNMConnection",
 *         NetworkManagerId = "/subscriptions/subscriptionC/resourceGroup/rg1/providers/Microsoft.Network/networkManagers/testNetworkManager",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewManagementGroupNetworkManagerConnection(ctx, "managementGroupNetworkManagerConnection", &network.ManagementGroupNetworkManagerConnectionArgs{
 * 			ManagementGroupId:            pulumi.String("managementGroupA"),
 * 			NetworkManagerConnectionName: pulumi.String("TestNMConnection"),
 * 			NetworkManagerId:             pulumi.String("/subscriptions/subscriptionC/resourceGroup/rg1/providers/Microsoft.Network/networkManagers/testNetworkManager"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ManagementGroupNetworkManagerConnection;
 * import com.pulumi.azurenative.network.ManagementGroupNetworkManagerConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementGroupNetworkManagerConnection = new ManagementGroupNetworkManagerConnection("managementGroupNetworkManagerConnection", ManagementGroupNetworkManagerConnectionArgs.builder()
 *             .managementGroupId("managementGroupA")
 *             .networkManagerConnectionName("TestNMConnection")
 *             .networkManagerId("/subscriptions/subscriptionC/resourceGroup/rg1/providers/Microsoft.Network/networkManagers/testNetworkManager")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ManagementGroupNetworkManagerConnection TestNMConnection /providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Network/networkManagerConnections/{networkManagerConnectionName}
 * ```
 */
public class ManagementGroupNetworkManagerConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.network.ManagementGroupNetworkManagerConnection,
) : KotlinCustomResource(javaResource, ManagementGroupNetworkManagerConnectionMapper) {
    /**
     * A description of the network manager connection.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network Manager Id.
     */
    public val networkManagerId: Output<String>?
        get() = javaResource.networkManagerId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system metadata related to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagementGroupNetworkManagerConnectionMapper :
    ResourceMapper<ManagementGroupNetworkManagerConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.ManagementGroupNetworkManagerConnection::class == javaResource::class

    override fun map(javaResource: Resource): ManagementGroupNetworkManagerConnection =
        ManagementGroupNetworkManagerConnection(
            javaResource as
                com.pulumi.azurenative.network.ManagementGroupNetworkManagerConnection,
        )
}

/**
 * @see [ManagementGroupNetworkManagerConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagementGroupNetworkManagerConnection].
 */
public suspend fun managementGroupNetworkManagerConnection(
    name: String,
    block: suspend ManagementGroupNetworkManagerConnectionResourceBuilder.() -> Unit,
):
    ManagementGroupNetworkManagerConnection {
    val builder = ManagementGroupNetworkManagerConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagementGroupNetworkManagerConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managementGroupNetworkManagerConnection(name: String):
    ManagementGroupNetworkManagerConnection {
    val builder = ManagementGroupNetworkManagerConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
