@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.ManagementGroupNetworkManagerConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Network Manager Connection resource
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-05-01-preview.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create or Update Management Group Network Manager Connection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementGroupNetworkManagerConnection = new AzureNative.Network.ManagementGroupNetworkManagerConnection("managementGroupNetworkManagerConnection", new()
 *     {
 *         ManagementGroupId = "managementGroupA",
 *         NetworkManagerConnectionName = "TestNMConnection",
 *         NetworkManagerId = "/subscriptions/subscriptionC/resourceGroup/rg1/providers/Microsoft.Network/networkManagers/testNetworkManager",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewManagementGroupNetworkManagerConnection(ctx, "managementGroupNetworkManagerConnection", &network.ManagementGroupNetworkManagerConnectionArgs{
 * 			ManagementGroupId:            pulumi.String("managementGroupA"),
 * 			NetworkManagerConnectionName: pulumi.String("TestNMConnection"),
 * 			NetworkManagerId:             pulumi.String("/subscriptions/subscriptionC/resourceGroup/rg1/providers/Microsoft.Network/networkManagers/testNetworkManager"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ManagementGroupNetworkManagerConnection;
 * import com.pulumi.azurenative.network.ManagementGroupNetworkManagerConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementGroupNetworkManagerConnection = new ManagementGroupNetworkManagerConnection("managementGroupNetworkManagerConnection", ManagementGroupNetworkManagerConnectionArgs.builder()
 *             .managementGroupId("managementGroupA")
 *             .networkManagerConnectionName("TestNMConnection")
 *             .networkManagerId("/subscriptions/subscriptionC/resourceGroup/rg1/providers/Microsoft.Network/networkManagers/testNetworkManager")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ManagementGroupNetworkManagerConnection TestNMConnection /providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Network/networkManagerConnections/{networkManagerConnectionName}
 * ```
 * @property description A description of the network manager connection.
 * @property managementGroupId The management group Id which uniquely identify the Microsoft Azure management group.
 * @property networkManagerConnectionName Name for the network manager connection.
 * @property networkManagerId Network Manager Id.
 */
public data class ManagementGroupNetworkManagerConnectionArgs(
    public val description: Output<String>? = null,
    public val managementGroupId: Output<String>? = null,
    public val networkManagerConnectionName: Output<String>? = null,
    public val networkManagerId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.ManagementGroupNetworkManagerConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.ManagementGroupNetworkManagerConnectionArgs =
        com.pulumi.azurenative.network.ManagementGroupNetworkManagerConnectionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .managementGroupId(managementGroupId?.applyValue({ args0 -> args0 }))
            .networkManagerConnectionName(networkManagerConnectionName?.applyValue({ args0 -> args0 }))
            .networkManagerId(networkManagerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagementGroupNetworkManagerConnectionArgs].
 */
@PulumiTagMarker
public class ManagementGroupNetworkManagerConnectionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var managementGroupId: Output<String>? = null

    private var networkManagerConnectionName: Output<String>? = null

    private var networkManagerId: Output<String>? = null

    /**
     * @param value A description of the network manager connection.
     */
    @JvmName("amcjcxjufnnxfkjn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The management group Id which uniquely identify the Microsoft Azure management group.
     */
    @JvmName("rvqmktorhlpfyipl")
    public suspend fun managementGroupId(`value`: Output<String>) {
        this.managementGroupId = value
    }

    /**
     * @param value Name for the network manager connection.
     */
    @JvmName("acambqotyuvecmfw")
    public suspend fun networkManagerConnectionName(`value`: Output<String>) {
        this.networkManagerConnectionName = value
    }

    /**
     * @param value Network Manager Id.
     */
    @JvmName("kjbraeyceyrojavh")
    public suspend fun networkManagerId(`value`: Output<String>) {
        this.networkManagerId = value
    }

    /**
     * @param value A description of the network manager connection.
     */
    @JvmName("wwfdbnayxsntvdsq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The management group Id which uniquely identify the Microsoft Azure management group.
     */
    @JvmName("ftqwslugwygjoees")
    public suspend fun managementGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementGroupId = mapped
    }

    /**
     * @param value Name for the network manager connection.
     */
    @JvmName("phmsqkckolsthsfb")
    public suspend fun networkManagerConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkManagerConnectionName = mapped
    }

    /**
     * @param value Network Manager Id.
     */
    @JvmName("pltcueaobeqfhcnd")
    public suspend fun networkManagerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkManagerId = mapped
    }

    internal fun build(): ManagementGroupNetworkManagerConnectionArgs =
        ManagementGroupNetworkManagerConnectionArgs(
            description = description,
            managementGroupId = managementGroupId,
            networkManagerConnectionName = networkManagerConnectionName,
            networkManagerId = networkManagerId,
        )
}
