@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.NetworkInterfaceArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.NetworkInterfaceAuxiliaryMode
import com.pulumi.azurenative.network.kotlin.enums.NetworkInterfaceAuxiliarySku
import com.pulumi.azurenative.network.kotlin.enums.NetworkInterfaceMigrationPhase
import com.pulumi.azurenative.network.kotlin.enums.NetworkInterfaceNicType
import com.pulumi.azurenative.network.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.NetworkInterfaceDnsSettingsArgs
import com.pulumi.azurenative.network.kotlin.inputs.NetworkInterfaceDnsSettingsArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.NetworkInterfaceIPConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.NetworkInterfaceIPConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.NetworkSecurityGroupArgs
import com.pulumi.azurenative.network.kotlin.inputs.NetworkSecurityGroupArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.PrivateLinkServiceArgs
import com.pulumi.azurenative.network.kotlin.inputs.PrivateLinkServiceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A network interface in a resource group.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2015-05-01-preview, 2018-07-01, 2019-02-01, 2019-06-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create network interface
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkInterface = new AzureNative.Network.NetworkInterface("networkInterface", new()
 *     {
 *         DisableTcpStateTracking = true,
 *         EnableAcceleratedNetworking = true,
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.NetworkInterfaceIPConfigurationArgs
 *             {
 *                 Name = "ipconfig1",
 *                 PublicIPAddress = new AzureNative.Network.Inputs.PublicIPAddressArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/test-ip",
 *                 },
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/rg1-vnet/subnets/default",
 *                 },
 *             },
 *         },
 *         Location = "eastus",
 *         NetworkInterfaceName = "test-nic",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNetworkInterface(ctx, "networkInterface", &network.NetworkInterfaceArgs{
 * 			DisableTcpStateTracking:     pulumi.Bool(true),
 * 			EnableAcceleratedNetworking: pulumi.Bool(true),
 * 			IpConfigurations: []network.NetworkInterfaceIPConfigurationArgs{
 * 				{
 * 					Name: pulumi.String("ipconfig1"),
 * 					PublicIPAddress: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/test-ip"),
 * 					},
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/rg1-vnet/subnets/default"),
 * 					},
 * 				},
 * 			},
 * 			Location:             pulumi.String("eastus"),
 * 			NetworkInterfaceName: pulumi.String("test-nic"),
 * 			ResourceGroupName:    pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NetworkInterface;
 * import com.pulumi.azurenative.network.NetworkInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkInterface = new NetworkInterface("networkInterface", NetworkInterfaceArgs.builder()
 *             .disableTcpStateTracking(true)
 *             .enableAcceleratedNetworking(true)
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("name", "ipconfig1"),
 *                 Map.entry("publicIPAddress", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/test-ip")),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/rg1-vnet/subnets/default"))
 *             ))
 *             .location("eastus")
 *             .networkInterfaceName("test-nic")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create network interface with Gateway Load Balancer Consumer configured
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkInterface = new AzureNative.Network.NetworkInterface("networkInterface", new()
 *     {
 *         EnableAcceleratedNetworking = true,
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.NetworkInterfaceIPConfigurationArgs
 *             {
 *                 GatewayLoadBalancer = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb-provider",
 *                 },
 *                 Name = "ipconfig1",
 *                 PublicIPAddress = new AzureNative.Network.Inputs.PublicIPAddressArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/test-ip",
 *                 },
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/rg1-vnet/subnets/default",
 *                 },
 *             },
 *         },
 *         Location = "eastus",
 *         NetworkInterfaceName = "test-nic",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNetworkInterface(ctx, "networkInterface", &network.NetworkInterfaceArgs{
 * 			EnableAcceleratedNetworking: pulumi.Bool(true),
 * 			IpConfigurations: []network.NetworkInterfaceIPConfigurationArgs{
 * 				{
 * 					GatewayLoadBalancer: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb-provider"),
 * 					},
 * 					Name: pulumi.String("ipconfig1"),
 * 					PublicIPAddress: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/test-ip"),
 * 					},
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/rg1-vnet/subnets/default"),
 * 					},
 * 				},
 * 			},
 * 			Location:             pulumi.String("eastus"),
 * 			NetworkInterfaceName: pulumi.String("test-nic"),
 * 			ResourceGroupName:    pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NetworkInterface;
 * import com.pulumi.azurenative.network.NetworkInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkInterface = new NetworkInterface("networkInterface", NetworkInterfaceArgs.builder()
 *             .enableAcceleratedNetworking(true)
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("gatewayLoadBalancer", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb-provider")),
 *                 Map.entry("name", "ipconfig1"),
 *                 Map.entry("publicIPAddress", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/test-ip")),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/rg1-vnet/subnets/default"))
 *             ))
 *             .location("eastus")
 *             .networkInterfaceName("test-nic")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NetworkInterface test-nic /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}
 * ```
 * @property auxiliaryMode Auxiliary mode of Network Interface resource.
 * @property auxiliarySku Auxiliary sku of Network Interface resource.
 * @property disableTcpStateTracking Indicates whether to disable tcp state tracking.
 * @property dnsSettings The DNS settings in network interface.
 * @property enableAcceleratedNetworking If the network interface is configured for accelerated networking. Not applicable to VM sizes which require accelerated networking.
 * @property enableIPForwarding Indicates whether IP forwarding is enabled on this network interface.
 * @property extendedLocation The extended location of the network interface.
 * @property id Resource ID.
 * @property ipConfigurations A list of IPConfigurations of the network interface.
 * @property location Resource location.
 * @property migrationPhase Migration phase of Network Interface resource.
 * @property networkInterfaceName The name of the network interface.
 * @property networkSecurityGroup The reference to the NetworkSecurityGroup resource.
 * @property nicType Type of Network Interface resource.
 * @property privateLinkService Privatelinkservice of the network interface resource.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 * @property workloadType WorkloadType of the NetworkInterface for BareMetal resources
 */
public data class NetworkInterfaceArgs(
    public val auxiliaryMode: Output<Either<String, NetworkInterfaceAuxiliaryMode>>? = null,
    public val auxiliarySku: Output<Either<String, NetworkInterfaceAuxiliarySku>>? = null,
    public val disableTcpStateTracking: Output<Boolean>? = null,
    public val dnsSettings: Output<NetworkInterfaceDnsSettingsArgs>? = null,
    public val enableAcceleratedNetworking: Output<Boolean>? = null,
    public val enableIPForwarding: Output<Boolean>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val id: Output<String>? = null,
    public val ipConfigurations: Output<List<NetworkInterfaceIPConfigurationArgs>>? = null,
    public val location: Output<String>? = null,
    public val migrationPhase: Output<Either<String, NetworkInterfaceMigrationPhase>>? = null,
    public val networkInterfaceName: Output<String>? = null,
    public val networkSecurityGroup: Output<NetworkSecurityGroupArgs>? = null,
    public val nicType: Output<Either<String, NetworkInterfaceNicType>>? = null,
    public val privateLinkService: Output<PrivateLinkServiceArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workloadType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.NetworkInterfaceArgs> {
    override fun toJava(): com.pulumi.azurenative.network.NetworkInterfaceArgs =
        com.pulumi.azurenative.network.NetworkInterfaceArgs.builder()
            .auxiliaryMode(
                auxiliaryMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .auxiliarySku(
                auxiliarySku?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .disableTcpStateTracking(disableTcpStateTracking?.applyValue({ args0 -> args0 }))
            .dnsSettings(dnsSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enableAcceleratedNetworking(enableAcceleratedNetworking?.applyValue({ args0 -> args0 }))
            .enableIPForwarding(enableIPForwarding?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .ipConfigurations(
                ipConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .migrationPhase(
                migrationPhase?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .networkInterfaceName(networkInterfaceName?.applyValue({ args0 -> args0 }))
            .networkSecurityGroup(
                networkSecurityGroup?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .nicType(
                nicType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .privateLinkService(
                privateLinkService?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workloadType(workloadType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkInterfaceArgs].
 */
@PulumiTagMarker
public class NetworkInterfaceArgsBuilder internal constructor() {
    private var auxiliaryMode: Output<Either<String, NetworkInterfaceAuxiliaryMode>>? = null

    private var auxiliarySku: Output<Either<String, NetworkInterfaceAuxiliarySku>>? = null

    private var disableTcpStateTracking: Output<Boolean>? = null

    private var dnsSettings: Output<NetworkInterfaceDnsSettingsArgs>? = null

    private var enableAcceleratedNetworking: Output<Boolean>? = null

    private var enableIPForwarding: Output<Boolean>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var id: Output<String>? = null

    private var ipConfigurations: Output<List<NetworkInterfaceIPConfigurationArgs>>? = null

    private var location: Output<String>? = null

    private var migrationPhase: Output<Either<String, NetworkInterfaceMigrationPhase>>? = null

    private var networkInterfaceName: Output<String>? = null

    private var networkSecurityGroup: Output<NetworkSecurityGroupArgs>? = null

    private var nicType: Output<Either<String, NetworkInterfaceNicType>>? = null

    private var privateLinkService: Output<PrivateLinkServiceArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workloadType: Output<String>? = null

    /**
     * @param value Auxiliary mode of Network Interface resource.
     */
    @JvmName("hftntcksuwgxyywu")
    public suspend fun auxiliaryMode(`value`: Output<Either<String, NetworkInterfaceAuxiliaryMode>>) {
        this.auxiliaryMode = value
    }

    /**
     * @param value Auxiliary sku of Network Interface resource.
     */
    @JvmName("nsctbapwgybjnxtk")
    public suspend fun auxiliarySku(`value`: Output<Either<String, NetworkInterfaceAuxiliarySku>>) {
        this.auxiliarySku = value
    }

    /**
     * @param value Indicates whether to disable tcp state tracking.
     */
    @JvmName("ygiwhpaefdpoulyh")
    public suspend fun disableTcpStateTracking(`value`: Output<Boolean>) {
        this.disableTcpStateTracking = value
    }

    /**
     * @param value The DNS settings in network interface.
     */
    @JvmName("dhbiqtptftbxpxsi")
    public suspend fun dnsSettings(`value`: Output<NetworkInterfaceDnsSettingsArgs>) {
        this.dnsSettings = value
    }

    /**
     * @param value If the network interface is configured for accelerated networking. Not applicable to VM sizes which require accelerated networking.
     */
    @JvmName("wfmsaoapfxdoqpnt")
    public suspend fun enableAcceleratedNetworking(`value`: Output<Boolean>) {
        this.enableAcceleratedNetworking = value
    }

    /**
     * @param value Indicates whether IP forwarding is enabled on this network interface.
     */
    @JvmName("ekqwipfjrbjaokjh")
    public suspend fun enableIPForwarding(`value`: Output<Boolean>) {
        this.enableIPForwarding = value
    }

    /**
     * @param value The extended location of the network interface.
     */
    @JvmName("fowvnotykxsnccng")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("cxlmoxbkongpruab")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value A list of IPConfigurations of the network interface.
     */
    @JvmName("khvlwknbdxaagiry")
    public suspend fun ipConfigurations(`value`: Output<List<NetworkInterfaceIPConfigurationArgs>>) {
        this.ipConfigurations = value
    }

    @JvmName("wucrovnhghttkhei")
    public suspend fun ipConfigurations(vararg values: Output<NetworkInterfaceIPConfigurationArgs>) {
        this.ipConfigurations = Output.all(values.asList())
    }

    /**
     * @param values A list of IPConfigurations of the network interface.
     */
    @JvmName("xivnkickwdqcnghi")
    public suspend fun ipConfigurations(values: List<Output<NetworkInterfaceIPConfigurationArgs>>) {
        this.ipConfigurations = Output.all(values)
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ydbrdwcljtnvegyx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Migration phase of Network Interface resource.
     */
    @JvmName("oyspbfpjawnagsrg")
    public suspend
    fun migrationPhase(`value`: Output<Either<String, NetworkInterfaceMigrationPhase>>) {
        this.migrationPhase = value
    }

    /**
     * @param value The name of the network interface.
     */
    @JvmName("ckotliwyyguwjtwl")
    public suspend fun networkInterfaceName(`value`: Output<String>) {
        this.networkInterfaceName = value
    }

    /**
     * @param value The reference to the NetworkSecurityGroup resource.
     */
    @JvmName("xocqqjwxayxhsmjs")
    public suspend fun networkSecurityGroup(`value`: Output<NetworkSecurityGroupArgs>) {
        this.networkSecurityGroup = value
    }

    /**
     * @param value Type of Network Interface resource.
     */
    @JvmName("jtyeusqvmxfveseo")
    public suspend fun nicType(`value`: Output<Either<String, NetworkInterfaceNicType>>) {
        this.nicType = value
    }

    /**
     * @param value Privatelinkservice of the network interface resource.
     */
    @JvmName("vfbcocmsixcaubmu")
    public suspend fun privateLinkService(`value`: Output<PrivateLinkServiceArgs>) {
        this.privateLinkService = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("jtbweebqjqlhwncj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fpfaliympwspqrux")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value WorkloadType of the NetworkInterface for BareMetal resources
     */
    @JvmName("mtwpfnritvdiamcf")
    public suspend fun workloadType(`value`: Output<String>) {
        this.workloadType = value
    }

    /**
     * @param value Auxiliary mode of Network Interface resource.
     */
    @JvmName("isfmllommgvgokfk")
    public suspend fun auxiliaryMode(`value`: Either<String, NetworkInterfaceAuxiliaryMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auxiliaryMode = mapped
    }

    /**
     * @param value Auxiliary mode of Network Interface resource.
     */
    @JvmName("ptogrfcegegjqtke")
    public fun auxiliaryMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkInterfaceAuxiliaryMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.auxiliaryMode = mapped
    }

    /**
     * @param value Auxiliary mode of Network Interface resource.
     */
    @JvmName("amxyllqvdetlibav")
    public fun auxiliaryMode(`value`: NetworkInterfaceAuxiliaryMode) {
        val toBeMapped = Either.ofRight<String, NetworkInterfaceAuxiliaryMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.auxiliaryMode = mapped
    }

    /**
     * @param value Auxiliary sku of Network Interface resource.
     */
    @JvmName("gtejpwdtksrmcess")
    public suspend fun auxiliarySku(`value`: Either<String, NetworkInterfaceAuxiliarySku>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auxiliarySku = mapped
    }

    /**
     * @param value Auxiliary sku of Network Interface resource.
     */
    @JvmName("xabbabokxqkdfvtw")
    public fun auxiliarySku(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkInterfaceAuxiliarySku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.auxiliarySku = mapped
    }

    /**
     * @param value Auxiliary sku of Network Interface resource.
     */
    @JvmName("wqmloceatgibucjk")
    public fun auxiliarySku(`value`: NetworkInterfaceAuxiliarySku) {
        val toBeMapped = Either.ofRight<String, NetworkInterfaceAuxiliarySku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.auxiliarySku = mapped
    }

    /**
     * @param value Indicates whether to disable tcp state tracking.
     */
    @JvmName("nhgsamuhxfhneotd")
    public suspend fun disableTcpStateTracking(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableTcpStateTracking = mapped
    }

    /**
     * @param value The DNS settings in network interface.
     */
    @JvmName("ulcpyveyaabbaydj")
    public suspend fun dnsSettings(`value`: NetworkInterfaceDnsSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsSettings = mapped
    }

    /**
     * @param argument The DNS settings in network interface.
     */
    @JvmName("iplhwoenbubkhnun")
    public suspend
    fun dnsSettings(argument: suspend NetworkInterfaceDnsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkInterfaceDnsSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dnsSettings = mapped
    }

    /**
     * @param value If the network interface is configured for accelerated networking. Not applicable to VM sizes which require accelerated networking.
     */
    @JvmName("uystmjbkybhiiols")
    public suspend fun enableAcceleratedNetworking(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAcceleratedNetworking = mapped
    }

    /**
     * @param value Indicates whether IP forwarding is enabled on this network interface.
     */
    @JvmName("auluvjgkyfadhksd")
    public suspend fun enableIPForwarding(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableIPForwarding = mapped
    }

    /**
     * @param value The extended location of the network interface.
     */
    @JvmName("gxphdbinyxucgfuj")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the network interface.
     */
    @JvmName("cbcnlgayimpmwsly")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("rdtwdjnrclcdjrfi")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value A list of IPConfigurations of the network interface.
     */
    @JvmName("sjdwylyjihikqaod")
    public suspend fun ipConfigurations(`value`: List<NetworkInterfaceIPConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param argument A list of IPConfigurations of the network interface.
     */
    @JvmName("wisleinjiuveutuf")
    public suspend
    fun ipConfigurations(argument: List<suspend NetworkInterfaceIPConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkInterfaceIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument A list of IPConfigurations of the network interface.
     */
    @JvmName("hneingmgnoigbrwb")
    public suspend fun ipConfigurations(
        vararg
        argument: suspend NetworkInterfaceIPConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NetworkInterfaceIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument A list of IPConfigurations of the network interface.
     */
    @JvmName("erjefkensatptkna")
    public suspend
    fun ipConfigurations(argument: suspend NetworkInterfaceIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            NetworkInterfaceIPConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param values A list of IPConfigurations of the network interface.
     */
    @JvmName("rryrdyvhfeivedev")
    public suspend fun ipConfigurations(vararg values: NetworkInterfaceIPConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("uqvuavwwojwmqvhx")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Migration phase of Network Interface resource.
     */
    @JvmName("qglpkoybnabmscwh")
    public suspend fun migrationPhase(`value`: Either<String, NetworkInterfaceMigrationPhase>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationPhase = mapped
    }

    /**
     * @param value Migration phase of Network Interface resource.
     */
    @JvmName("pckkvuiwlgrcqflh")
    public fun migrationPhase(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkInterfaceMigrationPhase>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.migrationPhase = mapped
    }

    /**
     * @param value Migration phase of Network Interface resource.
     */
    @JvmName("popsggoeyifyoibx")
    public fun migrationPhase(`value`: NetworkInterfaceMigrationPhase) {
        val toBeMapped = Either.ofRight<String, NetworkInterfaceMigrationPhase>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.migrationPhase = mapped
    }

    /**
     * @param value The name of the network interface.
     */
    @JvmName("qpbtbpaxlikrihpl")
    public suspend fun networkInterfaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceName = mapped
    }

    /**
     * @param value The reference to the NetworkSecurityGroup resource.
     */
    @JvmName("srciyabkkvdxpgrx")
    public suspend fun networkSecurityGroup(`value`: NetworkSecurityGroupArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSecurityGroup = mapped
    }

    /**
     * @param argument The reference to the NetworkSecurityGroup resource.
     */
    @JvmName("voiibhtsmagdiljy")
    public suspend
    fun networkSecurityGroup(argument: suspend NetworkSecurityGroupArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkSecurityGroupArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkSecurityGroup = mapped
    }

    /**
     * @param value Type of Network Interface resource.
     */
    @JvmName("oypdggwrfvvblggt")
    public suspend fun nicType(`value`: Either<String, NetworkInterfaceNicType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nicType = mapped
    }

    /**
     * @param value Type of Network Interface resource.
     */
    @JvmName("dlfgvopdltwwipgt")
    public fun nicType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkInterfaceNicType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nicType = mapped
    }

    /**
     * @param value Type of Network Interface resource.
     */
    @JvmName("pdjvylptffwuxulr")
    public fun nicType(`value`: NetworkInterfaceNicType) {
        val toBeMapped = Either.ofRight<String, NetworkInterfaceNicType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nicType = mapped
    }

    /**
     * @param value Privatelinkservice of the network interface resource.
     */
    @JvmName("ptkcbkxnkjwvftpa")
    public suspend fun privateLinkService(`value`: PrivateLinkServiceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkService = mapped
    }

    /**
     * @param argument Privatelinkservice of the network interface resource.
     */
    @JvmName("comykibcbgtlfmtj")
    public suspend
    fun privateLinkService(argument: suspend PrivateLinkServiceArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateLinkService = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qsiqocfsjimnrktk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("aetpfudbxuxjyina")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("srchagcmfaubbnhu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value WorkloadType of the NetworkInterface for BareMetal resources
     */
    @JvmName("fjdgqbjgmlsifoyf")
    public suspend fun workloadType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadType = mapped
    }

    internal fun build(): NetworkInterfaceArgs = NetworkInterfaceArgs(
        auxiliaryMode = auxiliaryMode,
        auxiliarySku = auxiliarySku,
        disableTcpStateTracking = disableTcpStateTracking,
        dnsSettings = dnsSettings,
        enableAcceleratedNetworking = enableAcceleratedNetworking,
        enableIPForwarding = enableIPForwarding,
        extendedLocation = extendedLocation,
        id = id,
        ipConfigurations = ipConfigurations,
        location = location,
        migrationPhase = migrationPhase,
        networkInterfaceName = networkInterfaceName,
        networkSecurityGroup = networkSecurityGroup,
        nicType = nicType,
        privateLinkService = privateLinkService,
        resourceGroupName = resourceGroupName,
        tags = tags,
        workloadType = workloadType,
    )
}
