@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.NetworkInterfaceTapConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.VirtualNetworkTapArgs
import com.pulumi.azurenative.network.kotlin.inputs.VirtualNetworkTapArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Tap configuration in a Network Interface.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create Network Interface Tap Configurations
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkInterfaceTapConfiguration = new AzureNative.Network.NetworkInterfaceTapConfiguration("networkInterfaceTapConfiguration", new()
 *     {
 *         NetworkInterfaceName = "mynic",
 *         ResourceGroupName = "testrg",
 *         TapConfigurationName = "tapconfiguration1",
 *         VirtualNetworkTap = new AzureNative.Network.Inputs.VirtualNetworkTapArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworkTaps/testvtap",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNetworkInterfaceTapConfiguration(ctx, "networkInterfaceTapConfiguration", &network.NetworkInterfaceTapConfigurationArgs{
 * 			NetworkInterfaceName: pulumi.String("mynic"),
 * 			ResourceGroupName:    pulumi.String("testrg"),
 * 			TapConfigurationName: pulumi.String("tapconfiguration1"),
 * 			VirtualNetworkTap: &network.VirtualNetworkTapTypeArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworkTaps/testvtap"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NetworkInterfaceTapConfiguration;
 * import com.pulumi.azurenative.network.NetworkInterfaceTapConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkInterfaceTapConfiguration = new NetworkInterfaceTapConfiguration("networkInterfaceTapConfiguration", NetworkInterfaceTapConfigurationArgs.builder()
 *             .networkInterfaceName("mynic")
 *             .resourceGroupName("testrg")
 *             .tapConfigurationName("tapconfiguration1")
 *             .virtualNetworkTap(Map.of("id", "/subscriptions/subid/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworkTaps/testvtap"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NetworkInterfaceTapConfiguration tapConfiguration1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}/tapConfigurations/{tapConfigurationName}
 * ```
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property networkInterfaceName The name of the network interface.
 * @property resourceGroupName The name of the resource group.
 * @property tapConfigurationName The name of the tap configuration.
 * @property virtualNetworkTap The reference to the Virtual Network Tap resource.
 */
public data class NetworkInterfaceTapConfigurationArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val networkInterfaceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tapConfigurationName: Output<String>? = null,
    public val virtualNetworkTap: Output<VirtualNetworkTapArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.NetworkInterfaceTapConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.NetworkInterfaceTapConfigurationArgs =
        com.pulumi.azurenative.network.NetworkInterfaceTapConfigurationArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkInterfaceName(networkInterfaceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tapConfigurationName(tapConfigurationName?.applyValue({ args0 -> args0 }))
            .virtualNetworkTap(
                virtualNetworkTap?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkInterfaceTapConfigurationArgs].
 */
@PulumiTagMarker
public class NetworkInterfaceTapConfigurationArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var networkInterfaceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tapConfigurationName: Output<String>? = null

    private var virtualNetworkTap: Output<VirtualNetworkTapArgs>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("oaskgxujhvtofwwk")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("rptmhpjkqvyccmed")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the network interface.
     */
    @JvmName("pakcmpqfpyalgijy")
    public suspend fun networkInterfaceName(`value`: Output<String>) {
        this.networkInterfaceName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("bvjvloxpjhahlchl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the tap configuration.
     */
    @JvmName("qpctrycsdhkdrqhj")
    public suspend fun tapConfigurationName(`value`: Output<String>) {
        this.tapConfigurationName = value
    }

    /**
     * @param value The reference to the Virtual Network Tap resource.
     */
    @JvmName("doygiwaejfeimgbo")
    public suspend fun virtualNetworkTap(`value`: Output<VirtualNetworkTapArgs>) {
        this.virtualNetworkTap = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("fgdxwmomyvdvxprw")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("wwbgmauggfmjepgc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the network interface.
     */
    @JvmName("cdjeuyhjgnwlunyk")
    public suspend fun networkInterfaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hscvuujlmbqfiajv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the tap configuration.
     */
    @JvmName("xuelxfqktdnumlgk")
    public suspend fun tapConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tapConfigurationName = mapped
    }

    /**
     * @param value The reference to the Virtual Network Tap resource.
     */
    @JvmName("siwjotvlhxttjuhb")
    public suspend fun virtualNetworkTap(`value`: VirtualNetworkTapArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkTap = mapped
    }

    /**
     * @param argument The reference to the Virtual Network Tap resource.
     */
    @JvmName("dwpujfhdvekjquog")
    public suspend fun virtualNetworkTap(argument: suspend VirtualNetworkTapArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworkTapArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualNetworkTap = mapped
    }

    internal fun build(): NetworkInterfaceTapConfigurationArgs = NetworkInterfaceTapConfigurationArgs(
        id = id,
        name = name,
        networkInterfaceName = networkInterfaceName,
        resourceGroupName = resourceGroupName,
        tapConfigurationName = tapConfigurationName,
        virtualNetworkTap = virtualNetworkTap,
    )
}
