@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.NetworkWatcherArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Network watcher in a resource group.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2018-01-01, 2022-05-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create network watcher
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkWatcher = new AzureNative.Network.NetworkWatcher("networkWatcher", new()
 *     {
 *         Location = "eastus",
 *         NetworkWatcherName = "nw1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNetworkWatcher(ctx, "networkWatcher", &network.NetworkWatcherArgs{
 * 			Location:           pulumi.String("eastus"),
 * 			NetworkWatcherName: pulumi.String("nw1"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NetworkWatcher;
 * import com.pulumi.azurenative.network.NetworkWatcherArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkWatcher = new NetworkWatcher("networkWatcher", NetworkWatcherArgs.builder()
 *             .location("eastus")
 *             .networkWatcherName("nw1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NetworkWatcher nw1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}
 * ```
 * @property id Resource ID.
 * @property location Resource location.
 * @property networkWatcherName The name of the network watcher.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 */
public data class NetworkWatcherArgs(
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val networkWatcherName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.NetworkWatcherArgs> {
    override fun toJava(): com.pulumi.azurenative.network.NetworkWatcherArgs =
        com.pulumi.azurenative.network.NetworkWatcherArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkWatcherName(networkWatcherName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NetworkWatcherArgs].
 */
@PulumiTagMarker
public class NetworkWatcherArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var networkWatcherName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("ltnuwbngnwggqexd")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("fubkddqmvqqomheu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the network watcher.
     */
    @JvmName("cmvygyqckjrbxdxe")
    public suspend fun networkWatcherName(`value`: Output<String>) {
        this.networkWatcherName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("xcksocydoujiupki")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pgmpfswintjicntr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("gbcxkbykdgqlyauc")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("krypwkmecjnylcap")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the network watcher.
     */
    @JvmName("xljscxopwknigsnh")
    public suspend fun networkWatcherName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkWatcherName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("mojdmubktspmkqdj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("apybigvvincjtgai")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ftmlkkrlphvfpmbc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NetworkWatcherArgs = NetworkWatcherArgs(
        id = id,
        location = location,
        networkWatcherName = networkWatcherName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
