@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.NspAccessRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.AccessRuleDirection
import com.pulumi.azurenative.network.kotlin.inputs.SubscriptionIdArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubscriptionIdArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The NSP access rule resource
 * Azure REST API version: 2021-02-01-preview. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### NspAccessRulePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nspAccessRule = new AzureNative.Network.NspAccessRule("nspAccessRule", new()
 *     {
 *         AccessRuleName = "accessRule1",
 *         AddressPrefixes = new[]
 *         {
 *             "10.11.0.0/16",
 *             "10.10.1.0/24",
 *         },
 *         Direction = "Inbound",
 *         NetworkSecurityPerimeterName = "nsp1",
 *         ProfileName = "profile1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNspAccessRule(ctx, "nspAccessRule", &network.NspAccessRuleArgs{
 * 			AccessRuleName: pulumi.String("accessRule1"),
 * 			AddressPrefixes: pulumi.StringArray{
 * 				pulumi.String("10.11.0.0/16"),
 * 				pulumi.String("10.10.1.0/24"),
 * 			},
 * 			Direction:                    pulumi.String("Inbound"),
 * 			NetworkSecurityPerimeterName: pulumi.String("nsp1"),
 * 			ProfileName:                  pulumi.String("profile1"),
 * 			ResourceGroupName:            pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NspAccessRule;
 * import com.pulumi.azurenative.network.NspAccessRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nspAccessRule = new NspAccessRule("nspAccessRule", NspAccessRuleArgs.builder()
 *             .accessRuleName("accessRule1")
 *             .addressPrefixes(
 *                 "10.11.0.0/16",
 *                 "10.10.1.0/24")
 *             .direction("Inbound")
 *             .networkSecurityPerimeterName("nsp1")
 *             .profileName("profile1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NspAccessRule accessRule1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}/profiles/{profileName}/accessRules/{accessRuleName}
 * ```
 * @property accessRuleName The name of the NSP access rule.
 * @property addressPrefixes Inbound address prefixes (IPv4/IPv6)
 * @property direction Direction that specifies whether the access rules is inbound/outbound.
 * @property emailAddresses Outbound rules email address format.
 * @property fullyQualifiedDomainNames Outbound rules fully qualified domain name format.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name The name of the access rule that is unique within a profile. This name can be used to access the resource.
 * @property networkSecurityPerimeterName The name of the network security perimeter.
 * @property phoneNumbers Outbound rules phone number format.
 * @property profileName The name of the NSP profile.
 * @property resourceGroupName The name of the resource group.
 * @property subscriptions List of subscription ids
 * @property tags Resource tags.
 */
public data class NspAccessRuleArgs(
    public val accessRuleName: Output<String>? = null,
    public val addressPrefixes: Output<List<String>>? = null,
    public val direction: Output<Either<String, AccessRuleDirection>>? = null,
    public val emailAddresses: Output<List<String>>? = null,
    public val fullyQualifiedDomainNames: Output<List<String>>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val networkSecurityPerimeterName: Output<String>? = null,
    public val phoneNumbers: Output<List<String>>? = null,
    public val profileName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subscriptions: Output<List<SubscriptionIdArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.NspAccessRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.NspAccessRuleArgs =
        com.pulumi.azurenative.network.NspAccessRuleArgs.builder()
            .accessRuleName(accessRuleName?.applyValue({ args0 -> args0 }))
            .addressPrefixes(addressPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .direction(
                direction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .emailAddresses(emailAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .fullyQualifiedDomainNames(
                fullyQualifiedDomainNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkSecurityPerimeterName(networkSecurityPerimeterName?.applyValue({ args0 -> args0 }))
            .phoneNumbers(phoneNumbers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subscriptions(
                subscriptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NspAccessRuleArgs].
 */
@PulumiTagMarker
public class NspAccessRuleArgsBuilder internal constructor() {
    private var accessRuleName: Output<String>? = null

    private var addressPrefixes: Output<List<String>>? = null

    private var direction: Output<Either<String, AccessRuleDirection>>? = null

    private var emailAddresses: Output<List<String>>? = null

    private var fullyQualifiedDomainNames: Output<List<String>>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var networkSecurityPerimeterName: Output<String>? = null

    private var phoneNumbers: Output<List<String>>? = null

    private var profileName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var subscriptions: Output<List<SubscriptionIdArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the NSP access rule.
     */
    @JvmName("kejtkcybnyaidmlu")
    public suspend fun accessRuleName(`value`: Output<String>) {
        this.accessRuleName = value
    }

    /**
     * @param value Inbound address prefixes (IPv4/IPv6)
     */
    @JvmName("xmhyxkjgovlnqqmo")
    public suspend fun addressPrefixes(`value`: Output<List<String>>) {
        this.addressPrefixes = value
    }

    @JvmName("xrayfynpnjhewvig")
    public suspend fun addressPrefixes(vararg values: Output<String>) {
        this.addressPrefixes = Output.all(values.asList())
    }

    /**
     * @param values Inbound address prefixes (IPv4/IPv6)
     */
    @JvmName("tnswtwhrsimholis")
    public suspend fun addressPrefixes(values: List<Output<String>>) {
        this.addressPrefixes = Output.all(values)
    }

    /**
     * @param value Direction that specifies whether the access rules is inbound/outbound.
     */
    @JvmName("btdfhfnugmiedpyt")
    public suspend fun direction(`value`: Output<Either<String, AccessRuleDirection>>) {
        this.direction = value
    }

    /**
     * @param value Outbound rules email address format.
     */
    @JvmName("qrkokphdleseqkhk")
    public suspend fun emailAddresses(`value`: Output<List<String>>) {
        this.emailAddresses = value
    }

    @JvmName("ynqrnksmeebxrrst")
    public suspend fun emailAddresses(vararg values: Output<String>) {
        this.emailAddresses = Output.all(values.asList())
    }

    /**
     * @param values Outbound rules email address format.
     */
    @JvmName("dfxxnsvwuruudfcb")
    public suspend fun emailAddresses(values: List<Output<String>>) {
        this.emailAddresses = Output.all(values)
    }

    /**
     * @param value Outbound rules fully qualified domain name format.
     */
    @JvmName("egtjnoiwceiaiflk")
    public suspend fun fullyQualifiedDomainNames(`value`: Output<List<String>>) {
        this.fullyQualifiedDomainNames = value
    }

    @JvmName("kjbqkgucwdccnryv")
    public suspend fun fullyQualifiedDomainNames(vararg values: Output<String>) {
        this.fullyQualifiedDomainNames = Output.all(values.asList())
    }

    /**
     * @param values Outbound rules fully qualified domain name format.
     */
    @JvmName("aamfifrenrutvdgc")
    public suspend fun fullyQualifiedDomainNames(values: List<Output<String>>) {
        this.fullyQualifiedDomainNames = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("cltcmgdhmosprqed")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("exbasiadnwrbolst")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the access rule that is unique within a profile. This name can be used to access the resource.
     */
    @JvmName("cglohjebwhaftvqx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the network security perimeter.
     */
    @JvmName("thpspajqektmhjcm")
    public suspend fun networkSecurityPerimeterName(`value`: Output<String>) {
        this.networkSecurityPerimeterName = value
    }

    /**
     * @param value Outbound rules phone number format.
     */
    @JvmName("aibbyatxexenjccu")
    public suspend fun phoneNumbers(`value`: Output<List<String>>) {
        this.phoneNumbers = value
    }

    @JvmName("ksdpmpjqggxcvdkk")
    public suspend fun phoneNumbers(vararg values: Output<String>) {
        this.phoneNumbers = Output.all(values.asList())
    }

    /**
     * @param values Outbound rules phone number format.
     */
    @JvmName("wpcumssaegnlyfuu")
    public suspend fun phoneNumbers(values: List<Output<String>>) {
        this.phoneNumbers = Output.all(values)
    }

    /**
     * @param value The name of the NSP profile.
     */
    @JvmName("pydtudyywhuuuqar")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("noelhqetuvdxptos")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value List of subscription ids
     */
    @JvmName("qqkrgwyuetnkrolj")
    public suspend fun subscriptions(`value`: Output<List<SubscriptionIdArgs>>) {
        this.subscriptions = value
    }

    @JvmName("pcovdkguggspivhi")
    public suspend fun subscriptions(vararg values: Output<SubscriptionIdArgs>) {
        this.subscriptions = Output.all(values.asList())
    }

    /**
     * @param values List of subscription ids
     */
    @JvmName("puppetesgwromorg")
    public suspend fun subscriptions(values: List<Output<SubscriptionIdArgs>>) {
        this.subscriptions = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("uggxstgxyrdgwvvd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the NSP access rule.
     */
    @JvmName("isamfxqrxrkfqyms")
    public suspend fun accessRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessRuleName = mapped
    }

    /**
     * @param value Inbound address prefixes (IPv4/IPv6)
     */
    @JvmName("yybpxybeqhxnoywb")
    public suspend fun addressPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefixes = mapped
    }

    /**
     * @param values Inbound address prefixes (IPv4/IPv6)
     */
    @JvmName("wmhjlntiylrqujyq")
    public suspend fun addressPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addressPrefixes = mapped
    }

    /**
     * @param value Direction that specifies whether the access rules is inbound/outbound.
     */
    @JvmName("ienrhsrqcexcviek")
    public suspend fun direction(`value`: Either<String, AccessRuleDirection>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Direction that specifies whether the access rules is inbound/outbound.
     */
    @JvmName("edplrsslhcjvwkbh")
    public fun direction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AccessRuleDirection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Direction that specifies whether the access rules is inbound/outbound.
     */
    @JvmName("kweyqwcxskyhkerq")
    public fun direction(`value`: AccessRuleDirection) {
        val toBeMapped = Either.ofRight<String, AccessRuleDirection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Outbound rules email address format.
     */
    @JvmName("yvfwnbnwsqbfjmih")
    public suspend fun emailAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailAddresses = mapped
    }

    /**
     * @param values Outbound rules email address format.
     */
    @JvmName("clojcohvooxptbpx")
    public suspend fun emailAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emailAddresses = mapped
    }

    /**
     * @param value Outbound rules fully qualified domain name format.
     */
    @JvmName("wnphbcofwmnnlaua")
    public suspend fun fullyQualifiedDomainNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fullyQualifiedDomainNames = mapped
    }

    /**
     * @param values Outbound rules fully qualified domain name format.
     */
    @JvmName("dlkrlxwvwfsbkney")
    public suspend fun fullyQualifiedDomainNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fullyQualifiedDomainNames = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("yjplshbminhmpkut")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("drfmbvcijafojvau")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the access rule that is unique within a profile. This name can be used to access the resource.
     */
    @JvmName("ojotpuqvukqwmahy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the network security perimeter.
     */
    @JvmName("badgtrurclxapmrl")
    public suspend fun networkSecurityPerimeterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSecurityPerimeterName = mapped
    }

    /**
     * @param value Outbound rules phone number format.
     */
    @JvmName("wsjxfbwnotjjdchm")
    public suspend fun phoneNumbers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phoneNumbers = mapped
    }

    /**
     * @param values Outbound rules phone number format.
     */
    @JvmName("ctlsraigtmqojjau")
    public suspend fun phoneNumbers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.phoneNumbers = mapped
    }

    /**
     * @param value The name of the NSP profile.
     */
    @JvmName("ktirmmpxekajivmb")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("xywrfsoewmlodmdn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value List of subscription ids
     */
    @JvmName("hghvnmlbbnrpgmdr")
    public suspend fun subscriptions(`value`: List<SubscriptionIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptions = mapped
    }

    /**
     * @param argument List of subscription ids
     */
    @JvmName("vyofetaowswictdb")
    public suspend fun subscriptions(argument: List<suspend SubscriptionIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SubscriptionIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subscriptions = mapped
    }

    /**
     * @param argument List of subscription ids
     */
    @JvmName("fpjjnlffftluqeue")
    public suspend fun subscriptions(vararg argument: suspend SubscriptionIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SubscriptionIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subscriptions = mapped
    }

    /**
     * @param argument List of subscription ids
     */
    @JvmName("clcmgfglegwowcpv")
    public suspend fun subscriptions(argument: suspend SubscriptionIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubscriptionIdArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.subscriptions = mapped
    }

    /**
     * @param values List of subscription ids
     */
    @JvmName("btrggwminriiyjsf")
    public suspend fun subscriptions(vararg values: SubscriptionIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscriptions = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ybmhonbfnndmcvsj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("rubatxplkfydfplb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NspAccessRuleArgs = NspAccessRuleArgs(
        accessRuleName = accessRuleName,
        addressPrefixes = addressPrefixes,
        direction = direction,
        emailAddresses = emailAddresses,
        fullyQualifiedDomainNames = fullyQualifiedDomainNames,
        id = id,
        location = location,
        name = name,
        networkSecurityPerimeterName = networkSecurityPerimeterName,
        phoneNumbers = phoneNumbers,
        profileName = profileName,
        resourceGroupName = resourceGroupName,
        subscriptions = subscriptions,
        tags = tags,
    )
}
