@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.NspProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The network security perimeter profile resource
 * Azure REST API version: 2021-02-01-preview. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### NspProfilesPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nspProfile = new AzureNative.Network.NspProfile("nspProfile", new()
 *     {
 *         NetworkSecurityPerimeterName = "nsp1",
 *         ProfileName = "profile1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNspProfile(ctx, "nspProfile", &network.NspProfileArgs{
 * 			NetworkSecurityPerimeterName: pulumi.String("nsp1"),
 * 			ProfileName:                  pulumi.String("profile1"),
 * 			ResourceGroupName:            pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NspProfile;
 * import com.pulumi.azurenative.network.NspProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nspProfile = new NspProfile("nspProfile", NspProfileArgs.builder()
 *             .networkSecurityPerimeterName("nsp1")
 *             .profileName("profile1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NspProfile profile1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}/profiles/{profileName}
 * ```
 * @property id Resource ID.
 * @property location Resource location.
 * @property name The name of the profile resource that is unique within a perimeter. This name can be used to access the resource.
 * @property networkSecurityPerimeterName The name of the network security perimeter.
 * @property profileName The name of the NSP profile.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 */
public data class NspProfileArgs(
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val networkSecurityPerimeterName: Output<String>? = null,
    public val profileName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.NspProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.network.NspProfileArgs =
        com.pulumi.azurenative.network.NspProfileArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkSecurityPerimeterName(networkSecurityPerimeterName?.applyValue({ args0 -> args0 }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NspProfileArgs].
 */
@PulumiTagMarker
public class NspProfileArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var networkSecurityPerimeterName: Output<String>? = null

    private var profileName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("dktdrpxrtnirkdkq")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ahswnnnpgpnyiees")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the profile resource that is unique within a perimeter. This name can be used to access the resource.
     */
    @JvmName("aeknhnmajkoggnja")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the network security perimeter.
     */
    @JvmName("kjxjwfniduqbuuqh")
    public suspend fun networkSecurityPerimeterName(`value`: Output<String>) {
        this.networkSecurityPerimeterName = value
    }

    /**
     * @param value The name of the NSP profile.
     */
    @JvmName("itekhdvdmwwxnlbt")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("prwcvgabulxpuuph")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ndfuvaklmywnhudi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("chpsbbppblqtwsav")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("xwxxpkuhsjvmponq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the profile resource that is unique within a perimeter. This name can be used to access the resource.
     */
    @JvmName("qgyekwucojnwluol")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the network security perimeter.
     */
    @JvmName("gqximllevhxqsluq")
    public suspend fun networkSecurityPerimeterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSecurityPerimeterName = mapped
    }

    /**
     * @param value The name of the NSP profile.
     */
    @JvmName("lvcghxemqxrcqrxk")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("sfisvjhtfsnkmpsh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dljmcrcwlhkflxnn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("cfptoedjbuwmbvcv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NspProfileArgs = NspProfileArgs(
        id = id,
        location = location,
        name = name,
        networkSecurityPerimeterName = networkSecurityPerimeterName,
        profileName = profileName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
