@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.P2sVpnGatewayArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.P2SConnectionConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.P2SConnectionConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * P2SVpnGateway Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-07-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### P2SVpnGatewayPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var p2sVpnGateway = new AzureNative.Network.P2sVpnGateway("p2sVpnGateway", new()
 *     {
 *         CustomDnsServers = new[]
 *         {
 *             "1.1.1.1",
 *             "2.2.2.2",
 *         },
 *         GatewayName = "p2sVpnGateway1",
 *         IsRoutingPreferenceInternet = false,
 *         Location = "West US",
 *         P2SConnectionConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.P2SConnectionConfigurationArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/p2sVpnGateways/p2sVpnGateway1/p2sConnectionConfigurations/P2SConnectionConfig1",
 *                 Name = "P2SConnectionConfig1",
 *                 RoutingConfiguration = new AzureNative.Network.Inputs.RoutingConfigurationArgs
 *                 {
 *                     AssociatedRouteTable = new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1",
 *                     },
 *                     PropagatedRouteTables = new AzureNative.Network.Inputs.PropagatedRouteTableArgs
 *                     {
 *                         Ids = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.SubResourceArgs
 *                             {
 *                                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1",
 *                             },
 *                             new AzureNative.Network.Inputs.SubResourceArgs
 *                             {
 *                                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable2",
 *                             },
 *                             new AzureNative.Network.Inputs.SubResourceArgs
 *                             {
 *                                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable3",
 *                             },
 *                         },
 *                         Labels = new[]
 *                         {
 *                             "label1",
 *                             "label2",
 *                         },
 *                     },
 *                     VnetRoutes = new AzureNative.Network.Inputs.VnetRouteArgs
 *                     {
 *                         StaticRoutes = new[] {},
 *                     },
 *                 },
 *                 VpnClientAddressPool = new AzureNative.Network.Inputs.AddressSpaceArgs
 *                 {
 *                     AddressPrefixes = new[]
 *                     {
 *                         "101.3.0.0/16",
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         VirtualHub = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1",
 *         },
 *         VpnGatewayScaleUnit = 1,
 *         VpnServerConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewP2sVpnGateway(ctx, "p2sVpnGateway", &network.P2sVpnGatewayArgs{
 * 			CustomDnsServers: pulumi.StringArray{
 * 				pulumi.String("1.1.1.1"),
 * 				pulumi.String("2.2.2.2"),
 * 			},
 * 			GatewayName:                 pulumi.String("p2sVpnGateway1"),
 * 			IsRoutingPreferenceInternet: pulumi.Bool(false),
 * 			Location:                    pulumi.String("West US"),
 * 			P2SConnectionConfigurations: []network.P2SConnectionConfigurationArgs{
 * 				{
 * 					Id:   pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/p2sVpnGateways/p2sVpnGateway1/p2sConnectionConfigurations/P2SConnectionConfig1"),
 * 					Name: pulumi.String("P2SConnectionConfig1"),
 * 					RoutingConfiguration: {
 * 						AssociatedRouteTable: {
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1"),
 * 						},
 * 						PropagatedRouteTables: {
 * 							Ids: network.SubResourceArray{
 * 								{
 * 									Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1"),
 * 								},
 * 								{
 * 									Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable2"),
 * 								},
 * 								{
 * 									Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable3"),
 * 								},
 * 							},
 * 							Labels: pulumi.StringArray{
 * 								pulumi.String("label1"),
 * 								pulumi.String("label2"),
 * 							},
 * 						},
 * 						VnetRoutes: {
 * 							StaticRoutes: network.StaticRouteArray{},
 * 						},
 * 					},
 * 					VpnClientAddressPool: {
 * 						AddressPrefixes: pulumi.StringArray{
 * 							pulumi.String("101.3.0.0/16"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			VirtualHub: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1"),
 * 			},
 * 			VpnGatewayScaleUnit: pulumi.Int(1),
 * 			VpnServerConfiguration: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.P2sVpnGateway;
 * import com.pulumi.azurenative.network.P2sVpnGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var p2sVpnGateway = new P2sVpnGateway("p2sVpnGateway", P2sVpnGatewayArgs.builder()
 *             .customDnsServers(
 *                 "1.1.1.1",
 *                 "2.2.2.2")
 *             .gatewayName("p2sVpnGateway1")
 *             .isRoutingPreferenceInternet(false)
 *             .location("West US")
 *             .p2SConnectionConfigurations(Map.ofEntries(
 *                 Map.entry("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/p2sVpnGateways/p2sVpnGateway1/p2sConnectionConfigurations/P2SConnectionConfig1"),
 *                 Map.entry("name", "P2SConnectionConfig1"),
 *                 Map.entry("routingConfiguration", Map.ofEntries(
 *                     Map.entry("associatedRouteTable", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1")),
 *                     Map.entry("propagatedRouteTables", Map.ofEntries(
 *                         Map.entry("ids",
 *                             Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1"),
 *                             Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable2"),
 *                             Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable3")),
 *                         Map.entry("labels",
 *                             "label1",
 *                             "label2")
 *                     )),
 *                     Map.entry("vnetRoutes", Map.of("staticRoutes", ))
 *                 )),
 *                 Map.entry("vpnClientAddressPool", Map.of("addressPrefixes", "101.3.0.0/16"))
 *             ))
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "value1"))
 *             .virtualHub(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1"))
 *             .vpnGatewayScaleUnit(1)
 *             .vpnServerConfiguration(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:P2sVpnGateway p2sVpnGateway1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}
 * ```
 * @property customDnsServers List of all customer specified DNS servers IP addresses.
 * @property gatewayName The name of the gateway.
 * @property id Resource ID.
 * @property isRoutingPreferenceInternet Enable Routing Preference property for the Public IP Interface of the P2SVpnGateway.
 * @property location Resource location.
 * @property p2SConnectionConfigurations List of all p2s connection configurations of the gateway.
 * @property resourceGroupName The resource group name of the P2SVpnGateway.
 * @property tags Resource tags.
 * @property virtualHub The VirtualHub to which the gateway belongs.
 * @property vpnGatewayScaleUnit The scale unit for this p2s vpn gateway.
 * @property vpnServerConfiguration The VpnServerConfiguration to which the p2sVpnGateway is attached to.
 */
public data class P2sVpnGatewayArgs(
    public val customDnsServers: Output<List<String>>? = null,
    public val gatewayName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val isRoutingPreferenceInternet: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val p2SConnectionConfigurations: Output<List<P2SConnectionConfigurationArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualHub: Output<SubResourceArgs>? = null,
    public val vpnGatewayScaleUnit: Output<Int>? = null,
    public val vpnServerConfiguration: Output<SubResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.P2sVpnGatewayArgs> {
    override fun toJava(): com.pulumi.azurenative.network.P2sVpnGatewayArgs =
        com.pulumi.azurenative.network.P2sVpnGatewayArgs.builder()
            .customDnsServers(customDnsServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .gatewayName(gatewayName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .isRoutingPreferenceInternet(isRoutingPreferenceInternet?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .p2SConnectionConfigurations(
                p2SConnectionConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualHub(virtualHub?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vpnGatewayScaleUnit(vpnGatewayScaleUnit?.applyValue({ args0 -> args0 }))
            .vpnServerConfiguration(
                vpnServerConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [P2sVpnGatewayArgs].
 */
@PulumiTagMarker
public class P2sVpnGatewayArgsBuilder internal constructor() {
    private var customDnsServers: Output<List<String>>? = null

    private var gatewayName: Output<String>? = null

    private var id: Output<String>? = null

    private var isRoutingPreferenceInternet: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var p2SConnectionConfigurations: Output<List<P2SConnectionConfigurationArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualHub: Output<SubResourceArgs>? = null

    private var vpnGatewayScaleUnit: Output<Int>? = null

    private var vpnServerConfiguration: Output<SubResourceArgs>? = null

    /**
     * @param value List of all customer specified DNS servers IP addresses.
     */
    @JvmName("cpfqmytywbmqijhg")
    public suspend fun customDnsServers(`value`: Output<List<String>>) {
        this.customDnsServers = value
    }

    @JvmName("jxawdtebbfxclnfo")
    public suspend fun customDnsServers(vararg values: Output<String>) {
        this.customDnsServers = Output.all(values.asList())
    }

    /**
     * @param values List of all customer specified DNS servers IP addresses.
     */
    @JvmName("mmnjrinrxmxxcfmm")
    public suspend fun customDnsServers(values: List<Output<String>>) {
        this.customDnsServers = Output.all(values)
    }

    /**
     * @param value The name of the gateway.
     */
    @JvmName("eltdvqxcbqgsxsoq")
    public suspend fun gatewayName(`value`: Output<String>) {
        this.gatewayName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("mixibbmummmajihr")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Enable Routing Preference property for the Public IP Interface of the P2SVpnGateway.
     */
    @JvmName("hgrdawcrxppnhfdc")
    public suspend fun isRoutingPreferenceInternet(`value`: Output<Boolean>) {
        this.isRoutingPreferenceInternet = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("mgxgiedivukofjwe")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value List of all p2s connection configurations of the gateway.
     */
    @JvmName("yuumbljyeqniirka")
    public suspend
    fun p2SConnectionConfigurations(`value`: Output<List<P2SConnectionConfigurationArgs>>) {
        this.p2SConnectionConfigurations = value
    }

    @JvmName("opporuhhmsgorcwh")
    public suspend fun p2SConnectionConfigurations(
        vararg
        values: Output<P2SConnectionConfigurationArgs>,
    ) {
        this.p2SConnectionConfigurations = Output.all(values.asList())
    }

    /**
     * @param values List of all p2s connection configurations of the gateway.
     */
    @JvmName("woyumjeuahavldaa")
    public suspend
    fun p2SConnectionConfigurations(values: List<Output<P2SConnectionConfigurationArgs>>) {
        this.p2SConnectionConfigurations = Output.all(values)
    }

    /**
     * @param value The resource group name of the P2SVpnGateway.
     */
    @JvmName("xfbqfuajcsvmbfje")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("cdroqkyrwbdtelsi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The VirtualHub to which the gateway belongs.
     */
    @JvmName("xfygmnuhdkgefhds")
    public suspend fun virtualHub(`value`: Output<SubResourceArgs>) {
        this.virtualHub = value
    }

    /**
     * @param value The scale unit for this p2s vpn gateway.
     */
    @JvmName("musaqcircivtkwaw")
    public suspend fun vpnGatewayScaleUnit(`value`: Output<Int>) {
        this.vpnGatewayScaleUnit = value
    }

    /**
     * @param value The VpnServerConfiguration to which the p2sVpnGateway is attached to.
     */
    @JvmName("mqwdvdcgsaheopny")
    public suspend fun vpnServerConfiguration(`value`: Output<SubResourceArgs>) {
        this.vpnServerConfiguration = value
    }

    /**
     * @param value List of all customer specified DNS servers IP addresses.
     */
    @JvmName("jormkwxfhadovrcl")
    public suspend fun customDnsServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDnsServers = mapped
    }

    /**
     * @param values List of all customer specified DNS servers IP addresses.
     */
    @JvmName("kubuxyasoerjophq")
    public suspend fun customDnsServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customDnsServers = mapped
    }

    /**
     * @param value The name of the gateway.
     */
    @JvmName("ohermkbocjtfprms")
    public suspend fun gatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ytlhogewmbdhhtfu")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Enable Routing Preference property for the Public IP Interface of the P2SVpnGateway.
     */
    @JvmName("cxaoyobjlmgsaovp")
    public suspend fun isRoutingPreferenceInternet(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isRoutingPreferenceInternet = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("yxeoiwsqamxcxlku")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value List of all p2s connection configurations of the gateway.
     */
    @JvmName("cifvxyuvljiykxsm")
    public suspend fun p2SConnectionConfigurations(`value`: List<P2SConnectionConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.p2SConnectionConfigurations = mapped
    }

    /**
     * @param argument List of all p2s connection configurations of the gateway.
     */
    @JvmName("ewuytmxytiqhmwxj")
    public suspend
    fun p2SConnectionConfigurations(argument: List<suspend P2SConnectionConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            P2SConnectionConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.p2SConnectionConfigurations = mapped
    }

    /**
     * @param argument List of all p2s connection configurations of the gateway.
     */
    @JvmName("yxmkohfhcgyotgbq")
    public suspend fun p2SConnectionConfigurations(
        vararg
        argument: suspend P2SConnectionConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            P2SConnectionConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.p2SConnectionConfigurations = mapped
    }

    /**
     * @param argument List of all p2s connection configurations of the gateway.
     */
    @JvmName("dxnlvrpbvhqhckxa")
    public suspend
    fun p2SConnectionConfigurations(argument: suspend P2SConnectionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            P2SConnectionConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.p2SConnectionConfigurations = mapped
    }

    /**
     * @param values List of all p2s connection configurations of the gateway.
     */
    @JvmName("uxmupkgmjoangqbl")
    public suspend fun p2SConnectionConfigurations(vararg values: P2SConnectionConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.p2SConnectionConfigurations = mapped
    }

    /**
     * @param value The resource group name of the P2SVpnGateway.
     */
    @JvmName("rycoqtmnwicprntt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("cputehmvyemvkwgp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ckngjxblqdjuicsm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The VirtualHub to which the gateway belongs.
     */
    @JvmName("yuwnqvetkbibbmip")
    public suspend fun virtualHub(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualHub = mapped
    }

    /**
     * @param argument The VirtualHub to which the gateway belongs.
     */
    @JvmName("dysymhuqwsictjyq")
    public suspend fun virtualHub(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualHub = mapped
    }

    /**
     * @param value The scale unit for this p2s vpn gateway.
     */
    @JvmName("cawxrotdwhlbfain")
    public suspend fun vpnGatewayScaleUnit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnGatewayScaleUnit = mapped
    }

    /**
     * @param value The VpnServerConfiguration to which the p2sVpnGateway is attached to.
     */
    @JvmName("hdkqtdyknfndlkke")
    public suspend fun vpnServerConfiguration(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnServerConfiguration = mapped
    }

    /**
     * @param argument The VpnServerConfiguration to which the p2sVpnGateway is attached to.
     */
    @JvmName("vcpyckwjucjbbdwm")
    public suspend fun vpnServerConfiguration(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpnServerConfiguration = mapped
    }

    internal fun build(): P2sVpnGatewayArgs = P2sVpnGatewayArgs(
        customDnsServers = customDnsServers,
        gatewayName = gatewayName,
        id = id,
        isRoutingPreferenceInternet = isRoutingPreferenceInternet,
        location = location,
        p2SConnectionConfigurations = p2SConnectionConfigurations,
        resourceGroupName = resourceGroupName,
        tags = tags,
        virtualHub = virtualHub,
        vpnGatewayScaleUnit = vpnGatewayScaleUnit,
        vpnServerConfiguration = vpnServerConfiguration,
    )
}
