@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.PrivateLinkServiceArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.FrontendIPConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.FrontendIPConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.PrivateLinkServiceIpConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.PrivateLinkServiceIpConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.PrivateLinkServicePropertiesAutoApprovalArgs
import com.pulumi.azurenative.network.kotlin.inputs.PrivateLinkServicePropertiesAutoApprovalArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.PrivateLinkServicePropertiesVisibilityArgs
import com.pulumi.azurenative.network.kotlin.inputs.PrivateLinkServicePropertiesVisibilityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Private link service resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-08-01, 2021-02-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create private link service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkService = new AzureNative.Network.PrivateLinkService("privateLinkService", new()
 *     {
 *         AutoApproval = new AzureNative.Network.Inputs.PrivateLinkServicePropertiesAutoApprovalArgs
 *         {
 *             Subscriptions = new[]
 *             {
 *                 "subscription1",
 *                 "subscription2",
 *             },
 *         },
 *         Fqdns = new[]
 *         {
 *             "fqdn1",
 *             "fqdn2",
 *             "fqdn3",
 *         },
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.PrivateLinkServiceIpConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 PrivateIPAddress = "10.0.1.4",
 *                 PrivateIPAddressVersion = "IPv4",
 *                 PrivateIPAllocationMethod = "Static",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *             },
 *         },
 *         LoadBalancerFrontendIpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *             },
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "testPls",
 *         Visibility = new AzureNative.Network.Inputs.PrivateLinkServicePropertiesVisibilityArgs
 *         {
 *             Subscriptions = new[]
 *             {
 *                 "subscription1",
 *                 "subscription2",
 *                 "subscription3",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateLinkService(ctx, "privateLinkService", &network.PrivateLinkServiceArgs{
 * 			AutoApproval: &network.PrivateLinkServicePropertiesAutoApprovalArgs{
 * 				Subscriptions: pulumi.StringArray{
 * 					pulumi.String("subscription1"),
 * 					pulumi.String("subscription2"),
 * 				},
 * 			},
 * 			Fqdns: pulumi.StringArray{
 * 				pulumi.String("fqdn1"),
 * 				pulumi.String("fqdn2"),
 * 				pulumi.String("fqdn3"),
 * 			},
 * 			IpConfigurations: []network.PrivateLinkServiceIpConfigurationArgs{
 * 				{
 * 					Name:                      pulumi.String("fe-lb"),
 * 					PrivateIPAddress:          pulumi.String("10.0.1.4"),
 * 					PrivateIPAddressVersion:   pulumi.String("IPv4"),
 * 					PrivateIPAllocationMethod: pulumi.String("Static"),
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 				},
 * 			},
 * 			LoadBalancerFrontendIpConfigurations: []network.FrontendIPConfigurationArgs{
 * 				{
 * 					Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("testPls"),
 * 			Visibility: &network.PrivateLinkServicePropertiesVisibilityArgs{
 * 				Subscriptions: pulumi.StringArray{
 * 					pulumi.String("subscription1"),
 * 					pulumi.String("subscription2"),
 * 					pulumi.String("subscription3"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateLinkService;
 * import com.pulumi.azurenative.network.PrivateLinkServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkService = new PrivateLinkService("privateLinkService", PrivateLinkServiceArgs.builder()
 *             .autoApproval(Map.of("subscriptions",
 *                 "subscription1",
 *                 "subscription2"))
 *             .fqdns(
 *                 "fqdn1",
 *                 "fqdn2",
 *                 "fqdn3")
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("name", "fe-lb"),
 *                 Map.entry("privateIPAddress", "10.0.1.4"),
 *                 Map.entry("privateIPAddressVersion", "IPv4"),
 *                 Map.entry("privateIPAllocationMethod", "Static"),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"))
 *             ))
 *             .loadBalancerFrontendIpConfigurations(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"))
 *             .location("eastus")
 *             .resourceGroupName("rg1")
 *             .serviceName("testPls")
 *             .visibility(Map.of("subscriptions",
 *                 "subscription1",
 *                 "subscription2",
 *                 "subscription3"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:PrivateLinkService testPls /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}
 * ```
 * @property autoApproval The auto-approval list of the private link service.
 * @property enableProxyProtocol Whether the private link service is enabled for proxy protocol or not.
 * @property extendedLocation The extended location of the load balancer.
 * @property fqdns The list of Fqdn.
 * @property id Resource ID.
 * @property ipConfigurations An array of private link service IP configurations.
 * @property loadBalancerFrontendIpConfigurations An array of references to the load balancer IP configurations.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group.
 * @property serviceName The name of the private link service.
 * @property tags Resource tags.
 * @property visibility The visibility list of the private link service.
 */
public data class PrivateLinkServiceArgs(
    public val autoApproval: Output<PrivateLinkServicePropertiesAutoApprovalArgs>? = null,
    public val enableProxyProtocol: Output<Boolean>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val fqdns: Output<List<String>>? = null,
    public val id: Output<String>? = null,
    public val ipConfigurations: Output<List<PrivateLinkServiceIpConfigurationArgs>>? = null,
    public val loadBalancerFrontendIpConfigurations: Output<List<FrontendIPConfigurationArgs>>? =
        null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val visibility: Output<PrivateLinkServicePropertiesVisibilityArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.PrivateLinkServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.network.PrivateLinkServiceArgs =
        com.pulumi.azurenative.network.PrivateLinkServiceArgs.builder()
            .autoApproval(autoApproval?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enableProxyProtocol(enableProxyProtocol?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fqdns(fqdns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .ipConfigurations(
                ipConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .loadBalancerFrontendIpConfigurations(
                loadBalancerFrontendIpConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .visibility(visibility?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PrivateLinkServiceArgs].
 */
@PulumiTagMarker
public class PrivateLinkServiceArgsBuilder internal constructor() {
    private var autoApproval: Output<PrivateLinkServicePropertiesAutoApprovalArgs>? = null

    private var enableProxyProtocol: Output<Boolean>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var fqdns: Output<List<String>>? = null

    private var id: Output<String>? = null

    private var ipConfigurations: Output<List<PrivateLinkServiceIpConfigurationArgs>>? = null

    private var loadBalancerFrontendIpConfigurations: Output<List<FrontendIPConfigurationArgs>>? =
        null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var visibility: Output<PrivateLinkServicePropertiesVisibilityArgs>? = null

    /**
     * @param value The auto-approval list of the private link service.
     */
    @JvmName("eibbhgbvkqruhdso")
    public suspend fun autoApproval(`value`: Output<PrivateLinkServicePropertiesAutoApprovalArgs>) {
        this.autoApproval = value
    }

    /**
     * @param value Whether the private link service is enabled for proxy protocol or not.
     */
    @JvmName("qcdwebdciqyojmmy")
    public suspend fun enableProxyProtocol(`value`: Output<Boolean>) {
        this.enableProxyProtocol = value
    }

    /**
     * @param value The extended location of the load balancer.
     */
    @JvmName("smcimmpeqqghcjqw")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The list of Fqdn.
     */
    @JvmName("wxvrnkkdurkghfcx")
    public suspend fun fqdns(`value`: Output<List<String>>) {
        this.fqdns = value
    }

    @JvmName("asgijqijgbquyjju")
    public suspend fun fqdns(vararg values: Output<String>) {
        this.fqdns = Output.all(values.asList())
    }

    /**
     * @param values The list of Fqdn.
     */
    @JvmName("ttipxbpaafosytrx")
    public suspend fun fqdns(values: List<Output<String>>) {
        this.fqdns = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("cnkmfnepbungokcl")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value An array of private link service IP configurations.
     */
    @JvmName("alldvmobvatdpvsp")
    public suspend
    fun ipConfigurations(`value`: Output<List<PrivateLinkServiceIpConfigurationArgs>>) {
        this.ipConfigurations = value
    }

    @JvmName("supogqkxtclrigbq")
    public suspend fun ipConfigurations(
        vararg
        values: Output<PrivateLinkServiceIpConfigurationArgs>,
    ) {
        this.ipConfigurations = Output.all(values.asList())
    }

    /**
     * @param values An array of private link service IP configurations.
     */
    @JvmName("swmctrjtlhxrlhfv")
    public suspend fun ipConfigurations(values: List<Output<PrivateLinkServiceIpConfigurationArgs>>) {
        this.ipConfigurations = Output.all(values)
    }

    /**
     * @param value An array of references to the load balancer IP configurations.
     */
    @JvmName("fimfhqerbnywanma")
    public suspend
    fun loadBalancerFrontendIpConfigurations(`value`: Output<List<FrontendIPConfigurationArgs>>) {
        this.loadBalancerFrontendIpConfigurations = value
    }

    @JvmName("qnkdwspwhgmdnfes")
    public suspend fun loadBalancerFrontendIpConfigurations(
        vararg
        values: Output<FrontendIPConfigurationArgs>,
    ) {
        this.loadBalancerFrontendIpConfigurations = Output.all(values.asList())
    }

    /**
     * @param values An array of references to the load balancer IP configurations.
     */
    @JvmName("ekjqajjfokqrglpa")
    public suspend
    fun loadBalancerFrontendIpConfigurations(values: List<Output<FrontendIPConfigurationArgs>>) {
        this.loadBalancerFrontendIpConfigurations = Output.all(values)
    }

    /**
     * @param value Resource location.
     */
    @JvmName("jstljqtmcejvwydk")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("edavfcmdrhsafowq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the private link service.
     */
    @JvmName("kufwnewnrhtjqjxb")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("kgngrpiluahxwluq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The visibility list of the private link service.
     */
    @JvmName("xlypbonjdbavigsi")
    public suspend fun visibility(`value`: Output<PrivateLinkServicePropertiesVisibilityArgs>) {
        this.visibility = value
    }

    /**
     * @param value The auto-approval list of the private link service.
     */
    @JvmName("vdcdaotkovsovcni")
    public suspend fun autoApproval(`value`: PrivateLinkServicePropertiesAutoApprovalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoApproval = mapped
    }

    /**
     * @param argument The auto-approval list of the private link service.
     */
    @JvmName("yyqlyeljgmcxpftb")
    public suspend
    fun autoApproval(argument: suspend PrivateLinkServicePropertiesAutoApprovalArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServicePropertiesAutoApprovalArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoApproval = mapped
    }

    /**
     * @param value Whether the private link service is enabled for proxy protocol or not.
     */
    @JvmName("qgkunjnfwhlwmwyp")
    public suspend fun enableProxyProtocol(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableProxyProtocol = mapped
    }

    /**
     * @param value The extended location of the load balancer.
     */
    @JvmName("uxwipirnvjiuaabv")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the load balancer.
     */
    @JvmName("drthtspfvfouffrb")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The list of Fqdn.
     */
    @JvmName("vnnflgnlwwifuxum")
    public suspend fun fqdns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdns = mapped
    }

    /**
     * @param values The list of Fqdn.
     */
    @JvmName("oxvtrnbekealvreq")
    public suspend fun fqdns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fqdns = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("hwiubpvrkwvkwlur")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value An array of private link service IP configurations.
     */
    @JvmName("fnnkokcwhgvobslh")
    public suspend fun ipConfigurations(`value`: List<PrivateLinkServiceIpConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param argument An array of private link service IP configurations.
     */
    @JvmName("egqbbrwcykcxikjo")
    public suspend
    fun ipConfigurations(argument: List<suspend PrivateLinkServiceIpConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateLinkServiceIpConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument An array of private link service IP configurations.
     */
    @JvmName("eucqjyctruvknjrg")
    public suspend fun ipConfigurations(
        vararg
        argument: suspend PrivateLinkServiceIpConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateLinkServiceIpConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument An array of private link service IP configurations.
     */
    @JvmName("kxmknwpbsjrefuxe")
    public suspend
    fun ipConfigurations(argument: suspend PrivateLinkServiceIpConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateLinkServiceIpConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param values An array of private link service IP configurations.
     */
    @JvmName("muprwlsbepupvnes")
    public suspend fun ipConfigurations(vararg values: PrivateLinkServiceIpConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param value An array of references to the load balancer IP configurations.
     */
    @JvmName("xbybfwyionbwfgxh")
    public suspend
    fun loadBalancerFrontendIpConfigurations(`value`: List<FrontendIPConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerFrontendIpConfigurations = mapped
    }

    /**
     * @param argument An array of references to the load balancer IP configurations.
     */
    @JvmName("imjulvuatdxrvrxb")
    public suspend
    fun loadBalancerFrontendIpConfigurations(argument: List<suspend FrontendIPConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FrontendIPConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerFrontendIpConfigurations = mapped
    }

    /**
     * @param argument An array of references to the load balancer IP configurations.
     */
    @JvmName("pnupmmkfluckhwlj")
    public suspend fun loadBalancerFrontendIpConfigurations(
        vararg
        argument: suspend FrontendIPConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FrontendIPConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerFrontendIpConfigurations = mapped
    }

    /**
     * @param argument An array of references to the load balancer IP configurations.
     */
    @JvmName("mywvpgpdatspigao")
    public suspend
    fun loadBalancerFrontendIpConfigurations(argument: suspend FrontendIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FrontendIPConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.loadBalancerFrontendIpConfigurations = mapped
    }

    /**
     * @param values An array of references to the load balancer IP configurations.
     */
    @JvmName("alnhdxgrdhfqnggk")
    public suspend fun loadBalancerFrontendIpConfigurations(
        vararg
        values: FrontendIPConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerFrontendIpConfigurations = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("cbufvfpxxoeonaxk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pygbdxeklkuupkti")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the private link service.
     */
    @JvmName("nmsuiwerjnxtmpbm")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("garhigexcbonvtnt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("dwxgygkhmugydbxx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The visibility list of the private link service.
     */
    @JvmName("hciscmugkhbqtnuq")
    public suspend fun visibility(`value`: PrivateLinkServicePropertiesVisibilityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.visibility = mapped
    }

    /**
     * @param argument The visibility list of the private link service.
     */
    @JvmName("giajebencyhxpflk")
    public suspend
    fun visibility(argument: suspend PrivateLinkServicePropertiesVisibilityArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServicePropertiesVisibilityArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.visibility = mapped
    }

    internal fun build(): PrivateLinkServiceArgs = PrivateLinkServiceArgs(
        autoApproval = autoApproval,
        enableProxyProtocol = enableProxyProtocol,
        extendedLocation = extendedLocation,
        fqdns = fqdns,
        id = id,
        ipConfigurations = ipConfigurations,
        loadBalancerFrontendIpConfigurations = loadBalancerFrontendIpConfigurations,
        location = location,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        tags = tags,
        visibility = visibility,
    )
}
