@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Route].
 */
@PulumiTagMarker
public class RouteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouteArgs = RouteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouteArgsBuilder.() -> Unit) {
        val builder = RouteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Route {
        val builtJavaResource = com.pulumi.azurenative.network.Route(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Route(builtJavaResource)
    }
}

/**
 * Route resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-06-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create route
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var route = new AzureNative.Network.Route("route", new()
 *     {
 *         AddressPrefix = "10.0.3.0/24",
 *         NextHopType = "VirtualNetworkGateway",
 *         ResourceGroupName = "rg1",
 *         RouteName = "route1",
 *         RouteTableName = "testrt",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRoute(ctx, "route", &network.RouteArgs{
 * 			AddressPrefix:     pulumi.String("10.0.3.0/24"),
 * 			NextHopType:       pulumi.String("VirtualNetworkGateway"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			RouteName:         pulumi.String("route1"),
 * 			RouteTableName:    pulumi.String("testrt"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Route;
 * import com.pulumi.azurenative.network.RouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var route = new Route("route", RouteArgs.builder()
 *             .addressPrefix("10.0.3.0/24")
 *             .nextHopType("VirtualNetworkGateway")
 *             .resourceGroupName("rg1")
 *             .routeName("route1")
 *             .routeTableName("testrt")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:Route route1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeTables/{routeTableName}/routes/{routeName}
 * ```
 */
public class Route internal constructor(
    override val javaResource: com.pulumi.azurenative.network.Route,
) : KotlinCustomResource(javaResource, RouteMapper) {
    /**
     * The destination CIDR to which the route applies.
     */
    public val addressPrefix: Output<String>?
        get() = javaResource.addressPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * A value indicating whether this route overrides overlapping BGP routes regardless of LPM.
     */
    public val hasBgpOverride: Output<Boolean>?
        get() = javaResource.hasBgpOverride().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
     */
    public val nextHopIpAddress: Output<String>?
        get() = javaResource.nextHopIpAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of Azure hop the packet should be sent to.
     */
    public val nextHopType: Output<String>
        get() = javaResource.nextHopType().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the route resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The type of the resource.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object RouteMapper : ResourceMapper<Route> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.Route::class == javaResource::class

    override fun map(javaResource: Resource): Route = Route(
        javaResource as
            com.pulumi.azurenative.network.Route,
    )
}

/**
 * @see [Route].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Route].
 */
public suspend fun route(name: String, block: suspend RouteResourceBuilder.() -> Unit): Route {
    val builder = RouteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Route].
 * @param name The _unique_ name of the resulting resource.
 */
public fun route(name: String): Route {
    val builder = RouteResourceBuilder()
    builder.name(name)
    return builder.build()
}
