@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.RoutingIntentArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.RoutingPolicyArgs
import com.pulumi.azurenative.network.kotlin.inputs.RoutingPolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The routing intent child resource of a Virtual hub.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2022-01-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### RouteTablePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var routingIntent = new AzureNative.Network.RoutingIntent("routingIntent", new()
 *     {
 *         ResourceGroupName = "rg1",
 *         RoutingIntentName = "Intent1",
 *         RoutingPolicies = new[]
 *         {
 *             new AzureNative.Network.Inputs.RoutingPolicyArgs
 *             {
 *                 Destinations = new[]
 *                 {
 *                     "Internet",
 *                 },
 *                 Name = "InternetTraffic",
 *                 NextHop = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azfw1",
 *             },
 *             new AzureNative.Network.Inputs.RoutingPolicyArgs
 *             {
 *                 Destinations = new[]
 *                 {
 *                     "PrivateTraffic",
 *                 },
 *                 Name = "PrivateTrafficPolicy",
 *                 NextHop = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azfw1",
 *             },
 *         },
 *         VirtualHubName = "virtualHub1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRoutingIntent(ctx, "routingIntent", &network.RoutingIntentArgs{
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			RoutingIntentName: pulumi.String("Intent1"),
 * 			RoutingPolicies: []network.RoutingPolicyArgs{
 * 				{
 * 					Destinations: pulumi.StringArray{
 * 						pulumi.String("Internet"),
 * 					},
 * 					Name:    pulumi.String("InternetTraffic"),
 * 					NextHop: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azfw1"),
 * 				},
 * 				{
 * 					Destinations: pulumi.StringArray{
 * 						pulumi.String("PrivateTraffic"),
 * 					},
 * 					Name:    pulumi.String("PrivateTrafficPolicy"),
 * 					NextHop: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azfw1"),
 * 				},
 * 			},
 * 			VirtualHubName: pulumi.String("virtualHub1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RoutingIntent;
 * import com.pulumi.azurenative.network.RoutingIntentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var routingIntent = new RoutingIntent("routingIntent", RoutingIntentArgs.builder()
 *             .resourceGroupName("rg1")
 *             .routingIntentName("Intent1")
 *             .routingPolicies(
 *                 Map.ofEntries(
 *                     Map.entry("destinations", "Internet"),
 *                     Map.entry("name", "InternetTraffic"),
 *                     Map.entry("nextHop", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azfw1")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("destinations", "PrivateTraffic"),
 *                     Map.entry("name", "PrivateTrafficPolicy"),
 *                     Map.entry("nextHop", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azfw1")
 *                 ))
 *             .virtualHubName("virtualHub1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:RoutingIntent Intent1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routingIntent/{routingIntentName}
 * ```
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property resourceGroupName The resource group name of the RoutingIntent.
 * @property routingIntentName The name of the per VirtualHub singleton Routing Intent resource.
 * @property routingPolicies List of routing policies.
 * @property virtualHubName The name of the VirtualHub.
 */
public data class RoutingIntentArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routingIntentName: Output<String>? = null,
    public val routingPolicies: Output<List<RoutingPolicyArgs>>? = null,
    public val virtualHubName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.RoutingIntentArgs> {
    override fun toJava(): com.pulumi.azurenative.network.RoutingIntentArgs =
        com.pulumi.azurenative.network.RoutingIntentArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routingIntentName(routingIntentName?.applyValue({ args0 -> args0 }))
            .routingPolicies(
                routingPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .virtualHubName(virtualHubName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoutingIntentArgs].
 */
@PulumiTagMarker
public class RoutingIntentArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var routingIntentName: Output<String>? = null

    private var routingPolicies: Output<List<RoutingPolicyArgs>>? = null

    private var virtualHubName: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("aogqmdleiygbefxh")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("hsjtfbsqirqccrab")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource group name of the RoutingIntent.
     */
    @JvmName("ukqijymsnsvakkpq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the per VirtualHub singleton Routing Intent resource.
     */
    @JvmName("cxxbqkkwynglxpio")
    public suspend fun routingIntentName(`value`: Output<String>) {
        this.routingIntentName = value
    }

    /**
     * @param value List of routing policies.
     */
    @JvmName("sqpmibljanimxorg")
    public suspend fun routingPolicies(`value`: Output<List<RoutingPolicyArgs>>) {
        this.routingPolicies = value
    }

    @JvmName("bruajtpmwoqbnlec")
    public suspend fun routingPolicies(vararg values: Output<RoutingPolicyArgs>) {
        this.routingPolicies = Output.all(values.asList())
    }

    /**
     * @param values List of routing policies.
     */
    @JvmName("mqcdxjbbsedwmknn")
    public suspend fun routingPolicies(values: List<Output<RoutingPolicyArgs>>) {
        this.routingPolicies = Output.all(values)
    }

    /**
     * @param value The name of the VirtualHub.
     */
    @JvmName("twpcwsvltadwkawi")
    public suspend fun virtualHubName(`value`: Output<String>) {
        this.virtualHubName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("wjrxwxnhfijlaxct")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("gjtthddplwgjrxqu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The resource group name of the RoutingIntent.
     */
    @JvmName("gqqlsmhafkjjmjkm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the per VirtualHub singleton Routing Intent resource.
     */
    @JvmName("uhotmvorxprojyph")
    public suspend fun routingIntentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingIntentName = mapped
    }

    /**
     * @param value List of routing policies.
     */
    @JvmName("dfbthlqhudqurnux")
    public suspend fun routingPolicies(`value`: List<RoutingPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingPolicies = mapped
    }

    /**
     * @param argument List of routing policies.
     */
    @JvmName("xaedoyvkbaieibks")
    public suspend fun routingPolicies(argument: List<suspend RoutingPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RoutingPolicyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.routingPolicies = mapped
    }

    /**
     * @param argument List of routing policies.
     */
    @JvmName("pxqufnrrnhownfou")
    public suspend fun routingPolicies(vararg argument: suspend RoutingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RoutingPolicyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.routingPolicies = mapped
    }

    /**
     * @param argument List of routing policies.
     */
    @JvmName("xavlleayauugjslb")
    public suspend fun routingPolicies(argument: suspend RoutingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RoutingPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.routingPolicies = mapped
    }

    /**
     * @param values List of routing policies.
     */
    @JvmName("cednierykdgietjy")
    public suspend fun routingPolicies(vararg values: RoutingPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingPolicies = mapped
    }

    /**
     * @param value The name of the VirtualHub.
     */
    @JvmName("yvhwknsdnpivpuig")
    public suspend fun virtualHubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualHubName = mapped
    }

    internal fun build(): RoutingIntentArgs = RoutingIntentArgs(
        id = id,
        name = name,
        resourceGroupName = resourceGroupName,
        routingIntentName = routingIntentName,
        routingPolicies = routingPolicies,
        virtualHubName = virtualHubName,
    )
}
