@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ScopeConnection].
 */
@PulumiTagMarker
public class ScopeConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScopeConnectionArgs = ScopeConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScopeConnectionArgsBuilder.() -> Unit) {
        val builder = ScopeConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ScopeConnection {
        val builtJavaResource = com.pulumi.azurenative.network.ScopeConnection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ScopeConnection(builtJavaResource)
    }
}

/**
 * The Scope Connections resource
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2022-02-01-preview.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create or Update Network Manager Scope Connection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scopeConnection = new AzureNative.Network.ScopeConnection("scopeConnection", new()
 *     {
 *         Description = "This is a scope connection to a cross tenant subscription.",
 *         NetworkManagerName = "testNetworkManager",
 *         ResourceGroupName = "rg1",
 *         ResourceId = "subscriptions/f0dc2b34-dfad-40e4-83e0-2309fed8d00b",
 *         ScopeConnectionName = "TestScopeConnection",
 *         TenantId = "6babcaad-604b-40ac-a9d7-9fd97c0b779f",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewScopeConnection(ctx, "scopeConnection", &network.ScopeConnectionArgs{
 * 			Description:         pulumi.String("This is a scope connection to a cross tenant subscription."),
 * 			NetworkManagerName:  pulumi.String("testNetworkManager"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			ResourceId:          pulumi.String("subscriptions/f0dc2b34-dfad-40e4-83e0-2309fed8d00b"),
 * 			ScopeConnectionName: pulumi.String("TestScopeConnection"),
 * 			TenantId:            pulumi.String("6babcaad-604b-40ac-a9d7-9fd97c0b779f"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ScopeConnection;
 * import com.pulumi.azurenative.network.ScopeConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scopeConnection = new ScopeConnection("scopeConnection", ScopeConnectionArgs.builder()
 *             .description("This is a scope connection to a cross tenant subscription.")
 *             .networkManagerName("testNetworkManager")
 *             .resourceGroupName("rg1")
 *             .resourceId("subscriptions/f0dc2b34-dfad-40e4-83e0-2309fed8d00b")
 *             .scopeConnectionName("TestScopeConnection")
 *             .tenantId("6babcaad-604b-40ac-a9d7-9fd97c0b779f")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ScopeConnection TestScopeConnection /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/scopeConnections/{scopeConnectionName}
 * ```
 */
public class ScopeConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.network.ScopeConnection,
) : KotlinCustomResource(javaResource, ScopeConnectionMapper) {
    /**
     * A description of the scope connection.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource ID.
     */
    public val resourceId: Output<String>?
        get() = javaResource.resourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system metadata related to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Tenant ID.
     */
    public val tenantId: Output<String>?
        get() = javaResource.tenantId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ScopeConnectionMapper : ResourceMapper<ScopeConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.ScopeConnection::class == javaResource::class

    override fun map(javaResource: Resource): ScopeConnection = ScopeConnection(
        javaResource as
            com.pulumi.azurenative.network.ScopeConnection,
    )
}

/**
 * @see [ScopeConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ScopeConnection].
 */
public suspend fun scopeConnection(
    name: String,
    block: suspend ScopeConnectionResourceBuilder.() -> Unit,
): ScopeConnection {
    val builder = ScopeConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ScopeConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scopeConnection(name: String): ScopeConnection {
    val builder = ScopeConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
