@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.SecurityAdminConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.NetworkIntentPolicyBasedService
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the security admin configuration
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2021-05-01-preview, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create network manager security admin configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var securityAdminConfiguration = new AzureNative.Network.SecurityAdminConfiguration("securityAdminConfiguration", new()
 *     {
 *         ApplyOnNetworkIntentPolicyBasedServices = new[]
 *         {
 *             "None",
 *         },
 *         ConfigurationName = "myTestSecurityConfig",
 *         Description = "A sample policy",
 *         NetworkManagerName = "testNetworkManager",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewSecurityAdminConfiguration(ctx, "securityAdminConfiguration", &network.SecurityAdminConfigurationArgs{
 * 			ApplyOnNetworkIntentPolicyBasedServices: pulumi.StringArray{
 * 				pulumi.String("None"),
 * 			},
 * 			ConfigurationName:  pulumi.String("myTestSecurityConfig"),
 * 			Description:        pulumi.String("A sample policy"),
 * 			NetworkManagerName: pulumi.String("testNetworkManager"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.SecurityAdminConfiguration;
 * import com.pulumi.azurenative.network.SecurityAdminConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var securityAdminConfiguration = new SecurityAdminConfiguration("securityAdminConfiguration", SecurityAdminConfigurationArgs.builder()
 *             .applyOnNetworkIntentPolicyBasedServices("None")
 *             .configurationName("myTestSecurityConfig")
 *             .description("A sample policy")
 *             .networkManagerName("testNetworkManager")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:SecurityAdminConfiguration myTestSecurityConfig /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/securityAdminConfigurations/{configurationName}
 * ```
 * @property applyOnNetworkIntentPolicyBasedServices Enum list of network intent policy based services.
 * @property configurationName The name of the network manager Security Configuration.
 * @property description A description of the security configuration.
 * @property networkManagerName The name of the network manager.
 * @property resourceGroupName The name of the resource group.
 */
public data class SecurityAdminConfigurationArgs(
    public val applyOnNetworkIntentPolicyBasedServices:
    Output<List<Either<String, NetworkIntentPolicyBasedService>>>? = null,
    public val configurationName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val networkManagerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.SecurityAdminConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.SecurityAdminConfigurationArgs =
        com.pulumi.azurenative.network.SecurityAdminConfigurationArgs.builder()
            .applyOnNetworkIntentPolicyBasedServices(
                applyOnNetworkIntentPolicyBasedServices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 ->
                                args0.toJava()
                            })
                        })
                    })
                }),
            )
            .configurationName(configurationName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .networkManagerName(networkManagerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityAdminConfigurationArgs].
 */
@PulumiTagMarker
public class SecurityAdminConfigurationArgsBuilder internal constructor() {
    private var applyOnNetworkIntentPolicyBasedServices:
        Output<List<Either<String, NetworkIntentPolicyBasedService>>>? = null

    private var configurationName: Output<String>? = null

    private var description: Output<String>? = null

    private var networkManagerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Enum list of network intent policy based services.
     */
    @JvmName("nqbcatgtxypwhtxc")
    public suspend
    fun applyOnNetworkIntentPolicyBasedServices(`value`: Output<List<Either<String, NetworkIntentPolicyBasedService>>>) {
        this.applyOnNetworkIntentPolicyBasedServices = value
    }

    @JvmName("rxfiovaimplqkqoy")
    public suspend fun applyOnNetworkIntentPolicyBasedServices(
        vararg
        values: Output<Either<String, NetworkIntentPolicyBasedService>>,
    ) {
        this.applyOnNetworkIntentPolicyBasedServices = Output.all(values.asList())
    }

    /**
     * @param values Enum list of network intent policy based services.
     */
    @JvmName("lihyluywdkfigkne")
    public suspend
    fun applyOnNetworkIntentPolicyBasedServices(values: List<Output<Either<String, NetworkIntentPolicyBasedService>>>) {
        this.applyOnNetworkIntentPolicyBasedServices = Output.all(values)
    }

    /**
     * @param value The name of the network manager Security Configuration.
     */
    @JvmName("auvphidhrshecgxu")
    public suspend fun configurationName(`value`: Output<String>) {
        this.configurationName = value
    }

    /**
     * @param value A description of the security configuration.
     */
    @JvmName("wcanrdssfnipvjku")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("wvxkocyeaihuwbma")
    public suspend fun networkManagerName(`value`: Output<String>) {
        this.networkManagerName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ncsmacirewflbryb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Enum list of network intent policy based services.
     */
    @JvmName("ndniokseyauaaoao")
    public suspend
    fun applyOnNetworkIntentPolicyBasedServices(`value`: List<Either<String, NetworkIntentPolicyBasedService>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applyOnNetworkIntentPolicyBasedServices = mapped
    }

    /**
     * @param values Enum list of network intent policy based services.
     */
    @JvmName("rexbgrmrvlopnljn")
    public suspend fun applyOnNetworkIntentPolicyBasedServices(
        vararg
        values: Either<String, NetworkIntentPolicyBasedService>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applyOnNetworkIntentPolicyBasedServices = mapped
    }

    /**
     * @param value The name of the network manager Security Configuration.
     */
    @JvmName("mvssidlonwjkdlif")
    public suspend fun configurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationName = mapped
    }

    /**
     * @param value A description of the security configuration.
     */
    @JvmName("eeynidwfeiygjaoo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("fcnwfjvblsltjjup")
    public suspend fun networkManagerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkManagerName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("tiqqeffyltghvyas")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): SecurityAdminConfigurationArgs = SecurityAdminConfigurationArgs(
        applyOnNetworkIntentPolicyBasedServices = applyOnNetworkIntentPolicyBasedServices,
        configurationName = configurationName,
        description = description,
        networkManagerName = networkManagerName,
        resourceGroupName = resourceGroupName,
    )
}
