@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ServiceEndpointPolicyDefinitionResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.ServiceEndpointPolicyDefinitionResponse.Companion.toKotlin as serviceEndpointPolicyDefinitionResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse.Companion.toKotlin as subnetResponseToKotlin

/**
 * Builder for [ServiceEndpointPolicy].
 */
@PulumiTagMarker
public class ServiceEndpointPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceEndpointPolicyArgs = ServiceEndpointPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceEndpointPolicyArgsBuilder.() -> Unit) {
        val builder = ServiceEndpointPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ServiceEndpointPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.network.ServiceEndpointPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServiceEndpointPolicy(builtJavaResource)
    }
}

/**
 * Service End point policy resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2018-07-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create service endpoint policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceEndpointPolicy = new AzureNative.Network.ServiceEndpointPolicy("serviceEndpointPolicy", new()
 *     {
 *         Location = "westus",
 *         ResourceGroupName = "rg1",
 *         ServiceEndpointPolicyName = "testPolicy",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewServiceEndpointPolicy(ctx, "serviceEndpointPolicy", &network.ServiceEndpointPolicyArgs{
 * 			Location:                  pulumi.String("westus"),
 * 			ResourceGroupName:         pulumi.String("rg1"),
 * 			ServiceEndpointPolicyName: pulumi.String("testPolicy"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ServiceEndpointPolicy;
 * import com.pulumi.azurenative.network.ServiceEndpointPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceEndpointPolicy = new ServiceEndpointPolicy("serviceEndpointPolicy", ServiceEndpointPolicyArgs.builder()
 *             .location("westus")
 *             .resourceGroupName("rg1")
 *             .serviceEndpointPolicyName("testPolicy")
 *             .build());
 *     }
 * }
 * ```
 * ### Create service endpoint policy with definition
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceEndpointPolicy = new AzureNative.Network.ServiceEndpointPolicy("serviceEndpointPolicy", new()
 *     {
 *         Location = "westus",
 *         ResourceGroupName = "rg1",
 *         ServiceEndpointPolicyDefinitions = new[]
 *         {
 *             new AzureNative.Network.Inputs.ServiceEndpointPolicyDefinitionArgs
 *             {
 *                 Description = "Storage Service EndpointPolicy Definition",
 *                 Name = "StorageServiceEndpointPolicyDefinition",
 *                 Service = "Microsoft.Storage",
 *                 ServiceResources = new[]
 *                 {
 *                     "/subscriptions/subid1",
 *                     "/subscriptions/subid1/resourceGroups/storageRg",
 *                     "/subscriptions/subid1/resourceGroups/storageRg/providers/Microsoft.Storage/storageAccounts/stAccount",
 *                 },
 *             },
 *         },
 *         ServiceEndpointPolicyName = "testPolicy",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewServiceEndpointPolicy(ctx, "serviceEndpointPolicy", &network.ServiceEndpointPolicyArgs{
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceEndpointPolicyDefinitions: []network.ServiceEndpointPolicyDefinitionTypeArgs{
 * 				{
 * 					Description: pulumi.String("Storage Service EndpointPolicy Definition"),
 * 					Name:        pulumi.String("StorageServiceEndpointPolicyDefinition"),
 * 					Service:     pulumi.String("Microsoft.Storage"),
 * 					ServiceResources: pulumi.StringArray{
 * 						pulumi.String("/subscriptions/subid1"),
 * 						pulumi.String("/subscriptions/subid1/resourceGroups/storageRg"),
 * 						pulumi.String("/subscriptions/subid1/resourceGroups/storageRg/providers/Microsoft.Storage/storageAccounts/stAccount"),
 * 					},
 * 				},
 * 			},
 * 			ServiceEndpointPolicyName: pulumi.String("testPolicy"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ServiceEndpointPolicy;
 * import com.pulumi.azurenative.network.ServiceEndpointPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceEndpointPolicy = new ServiceEndpointPolicy("serviceEndpointPolicy", ServiceEndpointPolicyArgs.builder()
 *             .location("westus")
 *             .resourceGroupName("rg1")
 *             .serviceEndpointPolicyDefinitions(Map.ofEntries(
 *                 Map.entry("description", "Storage Service EndpointPolicy Definition"),
 *                 Map.entry("name", "StorageServiceEndpointPolicyDefinition"),
 *                 Map.entry("service", "Microsoft.Storage"),
 *                 Map.entry("serviceResources",
 *                     "/subscriptions/subid1",
 *                     "/subscriptions/subid1/resourceGroups/storageRg",
 *                     "/subscriptions/subid1/resourceGroups/storageRg/providers/Microsoft.Storage/storageAccounts/stAccount")
 *             ))
 *             .serviceEndpointPolicyName("testPolicy")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ServiceEndpointPolicy testnsg /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}
 * ```
 */
public class ServiceEndpointPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.network.ServiceEndpointPolicy,
) : KotlinCustomResource(javaResource, ServiceEndpointPolicyMapper) {
    /**
     * A collection of contextual service endpoint policy.
     */
    public val contextualServiceEndpointPolicies: Output<List<String>>?
        get() = javaResource.contextualServiceEndpointPolicies().applyValue({ args0 ->
            args0.map({ args0 -> args0.map({ args0 -> args0 }) }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Kind of service endpoint policy. This is metadata used for the Azure portal experience.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the service endpoint policy resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resource GUID property of the service endpoint policy resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * The alias indicating if the policy belongs to a service
     */
    public val serviceAlias: Output<String>?
        get() = javaResource.serviceAlias().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A collection of service endpoint policy definitions of the service endpoint policy.
     */
    public val serviceEndpointPolicyDefinitions:
        Output<List<ServiceEndpointPolicyDefinitionResponse>>?
        get() = javaResource.serviceEndpointPolicyDefinitions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        serviceEndpointPolicyDefinitionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * A collection of references to subnets.
     */
    public val subnets: Output<List<SubnetResponse>>
        get() = javaResource.subnets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subnetResponseToKotlin(args0)
                })
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServiceEndpointPolicyMapper : ResourceMapper<ServiceEndpointPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.ServiceEndpointPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ServiceEndpointPolicy =
        ServiceEndpointPolicy(javaResource as com.pulumi.azurenative.network.ServiceEndpointPolicy)
}

/**
 * @see [ServiceEndpointPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceEndpointPolicy].
 */
public suspend fun serviceEndpointPolicy(
    name: String,
    block: suspend ServiceEndpointPolicyResourceBuilder.() -> Unit,
): ServiceEndpointPolicy {
    val builder = ServiceEndpointPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceEndpointPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceEndpointPolicy(name: String): ServiceEndpointPolicy {
    val builder = ServiceEndpointPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
