@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ServiceEndpointPolicyDefinition].
 */
@PulumiTagMarker
public class ServiceEndpointPolicyDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceEndpointPolicyDefinitionArgs = ServiceEndpointPolicyDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceEndpointPolicyDefinitionArgsBuilder.() -> Unit) {
        val builder = ServiceEndpointPolicyDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ServiceEndpointPolicyDefinition {
        val builtJavaResource =
            com.pulumi.azurenative.network.ServiceEndpointPolicyDefinition(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServiceEndpointPolicyDefinition(builtJavaResource)
    }
}

/**
 * Service Endpoint policy definitions.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2018-07-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create service endpoint policy definition
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceEndpointPolicyDefinition = new AzureNative.Network.ServiceEndpointPolicyDefinition("serviceEndpointPolicyDefinition", new()
 *     {
 *         Description = "Storage Service EndpointPolicy Definition",
 *         ResourceGroupName = "rg1",
 *         Service = "Microsoft.Storage",
 *         ServiceEndpointPolicyDefinitionName = "testDefinition",
 *         ServiceEndpointPolicyName = "testPolicy",
 *         ServiceResources = new[]
 *         {
 *             "/subscriptions/subid1",
 *             "/subscriptions/subid1/resourceGroups/storageRg",
 *             "/subscriptions/subid1/resourceGroups/storageRg/providers/Microsoft.Storage/storageAccounts/stAccount",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewServiceEndpointPolicyDefinition(ctx, "serviceEndpointPolicyDefinition", &network.ServiceEndpointPolicyDefinitionArgs{
 * 			Description:                         pulumi.String("Storage Service EndpointPolicy Definition"),
 * 			ResourceGroupName:                   pulumi.String("rg1"),
 * 			Service:                             pulumi.String("Microsoft.Storage"),
 * 			ServiceEndpointPolicyDefinitionName: pulumi.String("testDefinition"),
 * 			ServiceEndpointPolicyName:           pulumi.String("testPolicy"),
 * 			ServiceResources: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/subid1"),
 * 				pulumi.String("/subscriptions/subid1/resourceGroups/storageRg"),
 * 				pulumi.String("/subscriptions/subid1/resourceGroups/storageRg/providers/Microsoft.Storage/storageAccounts/stAccount"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ServiceEndpointPolicyDefinition;
 * import com.pulumi.azurenative.network.ServiceEndpointPolicyDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceEndpointPolicyDefinition = new ServiceEndpointPolicyDefinition("serviceEndpointPolicyDefinition", ServiceEndpointPolicyDefinitionArgs.builder()
 *             .description("Storage Service EndpointPolicy Definition")
 *             .resourceGroupName("rg1")
 *             .service("Microsoft.Storage")
 *             .serviceEndpointPolicyDefinitionName("testDefinition")
 *             .serviceEndpointPolicyName("testPolicy")
 *             .serviceResources(
 *                 "/subscriptions/subid1",
 *                 "/subscriptions/subid1/resourceGroups/storageRg",
 *                 "/subscriptions/subid1/resourceGroups/storageRg/providers/Microsoft.Storage/storageAccounts/stAccount")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ServiceEndpointPolicyDefinition testDefinition /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}/serviceEndpointPolicyDefinitions/{serviceEndpointPolicyDefinitionName}
 * ```
 */
public class ServiceEndpointPolicyDefinition internal constructor(
    override val javaResource: com.pulumi.azurenative.network.ServiceEndpointPolicyDefinition,
) : KotlinCustomResource(javaResource, ServiceEndpointPolicyDefinitionMapper) {
    /**
     * A description for this rule. Restricted to 140 chars.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning state of the service endpoint policy definition resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Service endpoint name.
     */
    public val service: Output<String>?
        get() = javaResource.service().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A list of service resources.
     */
    public val serviceResources: Output<List<String>>?
        get() = javaResource.serviceResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ServiceEndpointPolicyDefinitionMapper :
    ResourceMapper<ServiceEndpointPolicyDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.ServiceEndpointPolicyDefinition::class == javaResource::class

    override fun map(javaResource: Resource): ServiceEndpointPolicyDefinition =
        ServiceEndpointPolicyDefinition(
            javaResource as
                com.pulumi.azurenative.network.ServiceEndpointPolicyDefinition,
        )
}

/**
 * @see [ServiceEndpointPolicyDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceEndpointPolicyDefinition].
 */
public suspend fun serviceEndpointPolicyDefinition(
    name: String,
    block: suspend ServiceEndpointPolicyDefinitionResourceBuilder.() -> Unit,
):
    ServiceEndpointPolicyDefinition {
    val builder = ServiceEndpointPolicyDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceEndpointPolicyDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceEndpointPolicyDefinition(name: String): ServiceEndpointPolicyDefinition {
    val builder = ServiceEndpointPolicyDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
