@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.UserRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.SecurityConfigurationRuleDirection
import com.pulumi.azurenative.network.kotlin.enums.SecurityConfigurationRuleProtocol
import com.pulumi.azurenative.network.kotlin.inputs.AddressPrefixItemArgs
import com.pulumi.azurenative.network.kotlin.inputs.AddressPrefixItemArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Network security user rule.
 * Azure REST API version: 2022-04-01-preview. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2021-05-01-preview.
 * ## Example Usage
 * ### Create a default user rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var userRule = new AzureNative.Network.UserRule("userRule", new()
 *     {
 *         ConfigurationName = "myTestSecurityConfig",
 *         NetworkManagerName = "testNetworkManager",
 *         ResourceGroupName = "rg1",
 *         RuleCollectionName = "testRuleCollection",
 *         RuleName = "SampleDefaultUserRule",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewUserRule(ctx, "userRule", &network.UserRuleArgs{
 * 			ConfigurationName:  pulumi.String("myTestSecurityConfig"),
 * 			NetworkManagerName: pulumi.String("testNetworkManager"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			RuleCollectionName: pulumi.String("testRuleCollection"),
 * 			RuleName:           pulumi.String("SampleDefaultUserRule"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.UserRule;
 * import com.pulumi.azurenative.network.UserRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var userRule = new UserRule("userRule", UserRuleArgs.builder()
 *             .configurationName("myTestSecurityConfig")
 *             .networkManagerName("testNetworkManager")
 *             .resourceGroupName("rg1")
 *             .ruleCollectionName("testRuleCollection")
 *             .ruleName("SampleDefaultUserRule")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a user rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var userRule = new AzureNative.Network.UserRule("userRule", new()
 *     {
 *         ConfigurationName = "myTestSecurityConfig",
 *         Description = "Sample User Rule",
 *         DestinationPortRanges = new[]
 *         {
 *             "22",
 *         },
 *         Destinations = new[]
 *         {
 *             new AzureNative.Network.Inputs.AddressPrefixItemArgs
 *             {
 *                 AddressPrefix = "*",
 *                 AddressPrefixType = "IPPrefix",
 *             },
 *         },
 *         Direction = "Inbound",
 *         Kind = "Custom",
 *         NetworkManagerName = "testNetworkManager",
 *         Protocol = "Tcp",
 *         ResourceGroupName = "rg1",
 *         RuleCollectionName = "testRuleCollection",
 *         RuleName = "SampleUserRule",
 *         SourcePortRanges = new[]
 *         {
 *             "0-65535",
 *         },
 *         Sources = new[]
 *         {
 *             new AzureNative.Network.Inputs.AddressPrefixItemArgs
 *             {
 *                 AddressPrefix = "*",
 *                 AddressPrefixType = "IPPrefix",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewUserRule(ctx, "userRule", &network.UserRuleArgs{
 * 			ConfigurationName: pulumi.String("myTestSecurityConfig"),
 * 			Description:       pulumi.String("Sample User Rule"),
 * 			DestinationPortRanges: pulumi.StringArray{
 * 				pulumi.String("22"),
 * 			},
 * 			Destinations: []network.AddressPrefixItemArgs{
 * 				{
 * 					AddressPrefix:     pulumi.String("*"),
 * 					AddressPrefixType: pulumi.String("IPPrefix"),
 * 				},
 * 			},
 * 			Direction:          pulumi.String("Inbound"),
 * 			Kind:               pulumi.String("Custom"),
 * 			NetworkManagerName: pulumi.String("testNetworkManager"),
 * 			Protocol:           pulumi.String("Tcp"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			RuleCollectionName: pulumi.String("testRuleCollection"),
 * 			RuleName:           pulumi.String("SampleUserRule"),
 * 			SourcePortRanges: pulumi.StringArray{
 * 				pulumi.String("0-65535"),
 * 			},
 * 			Sources: []network.AddressPrefixItemArgs{
 * 				{
 * 					AddressPrefix:     pulumi.String("*"),
 * 					AddressPrefixType: pulumi.String("IPPrefix"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.UserRule;
 * import com.pulumi.azurenative.network.UserRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var userRule = new UserRule("userRule", UserRuleArgs.builder()
 *             .configurationName("myTestSecurityConfig")
 *             .description("Sample User Rule")
 *             .destinationPortRanges("22")
 *             .destinations(Map.ofEntries(
 *                 Map.entry("addressPrefix", "*"),
 *                 Map.entry("addressPrefixType", "IPPrefix")
 *             ))
 *             .direction("Inbound")
 *             .kind("Custom")
 *             .networkManagerName("testNetworkManager")
 *             .protocol("Tcp")
 *             .resourceGroupName("rg1")
 *             .ruleCollectionName("testRuleCollection")
 *             .ruleName("SampleUserRule")
 *             .sourcePortRanges("0-65535")
 *             .sources(Map.ofEntries(
 *                 Map.entry("addressPrefix", "*"),
 *                 Map.entry("addressPrefixType", "IPPrefix")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:UserRule SampleUserRule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/securityUserConfigurations/{configurationName}/ruleCollections/{ruleCollectionName}/rules/{ruleName}
 * ```
 * @property configurationName The name of the network manager Security Configuration.
 * @property description A description for this rule.
 * @property destinationPortRanges The destination port ranges.
 * @property destinations The destination address prefixes. CIDR or destination IP ranges.
 * @property direction Indicates if the traffic matched against the rule in inbound or outbound.
 * @property kind Whether the rule is custom or default.
 * Expected value is 'Custom'.
 * @property networkManagerName The name of the network manager.
 * @property protocol Network protocol this rule applies to.
 * @property resourceGroupName The name of the resource group.
 * @property ruleCollectionName The name of the network manager security Configuration rule collection.
 * @property ruleName The name of the rule.
 * @property sourcePortRanges The source port ranges.
 * @property sources The CIDR or source IP ranges.
 */
public data class UserRuleArgs(
    public val configurationName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val destinationPortRanges: Output<List<String>>? = null,
    public val destinations: Output<List<AddressPrefixItemArgs>>? = null,
    public val direction: Output<Either<String, SecurityConfigurationRuleDirection>>? = null,
    public val kind: Output<String>? = null,
    public val networkManagerName: Output<String>? = null,
    public val protocol: Output<Either<String, SecurityConfigurationRuleProtocol>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleCollectionName: Output<String>? = null,
    public val ruleName: Output<String>? = null,
    public val sourcePortRanges: Output<List<String>>? = null,
    public val sources: Output<List<AddressPrefixItemArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.UserRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.UserRuleArgs =
        com.pulumi.azurenative.network.UserRuleArgs.builder()
            .configurationName(configurationName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationPortRanges(destinationPortRanges?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .destinations(
                destinations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .direction(
                direction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .kind(kind?.applyValue({ args0 -> args0 }))
            .networkManagerName(networkManagerName?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleCollectionName(ruleCollectionName?.applyValue({ args0 -> args0 }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .sourcePortRanges(sourcePortRanges?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sources(
                sources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [UserRuleArgs].
 */
@PulumiTagMarker
public class UserRuleArgsBuilder internal constructor() {
    private var configurationName: Output<String>? = null

    private var description: Output<String>? = null

    private var destinationPortRanges: Output<List<String>>? = null

    private var destinations: Output<List<AddressPrefixItemArgs>>? = null

    private var direction: Output<Either<String, SecurityConfigurationRuleDirection>>? = null

    private var kind: Output<String>? = null

    private var networkManagerName: Output<String>? = null

    private var protocol: Output<Either<String, SecurityConfigurationRuleProtocol>>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleCollectionName: Output<String>? = null

    private var ruleName: Output<String>? = null

    private var sourcePortRanges: Output<List<String>>? = null

    private var sources: Output<List<AddressPrefixItemArgs>>? = null

    /**
     * @param value The name of the network manager Security Configuration.
     */
    @JvmName("kqlexwwluuaohnyc")
    public suspend fun configurationName(`value`: Output<String>) {
        this.configurationName = value
    }

    /**
     * @param value A description for this rule.
     */
    @JvmName("ebispksqqbsugtbi")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The destination port ranges.
     */
    @JvmName("saajlexoepuruhex")
    public suspend fun destinationPortRanges(`value`: Output<List<String>>) {
        this.destinationPortRanges = value
    }

    @JvmName("byjsmvnqmqqexkea")
    public suspend fun destinationPortRanges(vararg values: Output<String>) {
        this.destinationPortRanges = Output.all(values.asList())
    }

    /**
     * @param values The destination port ranges.
     */
    @JvmName("lquyvhfflcjhduht")
    public suspend fun destinationPortRanges(values: List<Output<String>>) {
        this.destinationPortRanges = Output.all(values)
    }

    /**
     * @param value The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("pihxlqejtfkcdmtv")
    public suspend fun destinations(`value`: Output<List<AddressPrefixItemArgs>>) {
        this.destinations = value
    }

    @JvmName("luckemgkrdfuxfrl")
    public suspend fun destinations(vararg values: Output<AddressPrefixItemArgs>) {
        this.destinations = Output.all(values.asList())
    }

    /**
     * @param values The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("ywqufcvjwpdxjulw")
    public suspend fun destinations(values: List<Output<AddressPrefixItemArgs>>) {
        this.destinations = Output.all(values)
    }

    /**
     * @param value Indicates if the traffic matched against the rule in inbound or outbound.
     */
    @JvmName("apufvrmqpqfwcdvp")
    public suspend
    fun direction(`value`: Output<Either<String, SecurityConfigurationRuleDirection>>) {
        this.direction = value
    }

    /**
     * @param value Whether the rule is custom or default.
     * Expected value is 'Custom'.
     */
    @JvmName("okwlyjyfywuqpmpi")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("eaydrnpptlkuohkh")
    public suspend fun networkManagerName(`value`: Output<String>) {
        this.networkManagerName = value
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("sbrwxoowdeubjqwj")
    public suspend fun protocol(`value`: Output<Either<String, SecurityConfigurationRuleProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wtyibhsemrbjlxjt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the network manager security Configuration rule collection.
     */
    @JvmName("pwqclmkqcnwukcmg")
    public suspend fun ruleCollectionName(`value`: Output<String>) {
        this.ruleCollectionName = value
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("txnlvnnjhadayked")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value The source port ranges.
     */
    @JvmName("vrtninsyoeesvvck")
    public suspend fun sourcePortRanges(`value`: Output<List<String>>) {
        this.sourcePortRanges = value
    }

    @JvmName("grbomivhdgaavvky")
    public suspend fun sourcePortRanges(vararg values: Output<String>) {
        this.sourcePortRanges = Output.all(values.asList())
    }

    /**
     * @param values The source port ranges.
     */
    @JvmName("hgtehiwvaejovrpv")
    public suspend fun sourcePortRanges(values: List<Output<String>>) {
        this.sourcePortRanges = Output.all(values)
    }

    /**
     * @param value The CIDR or source IP ranges.
     */
    @JvmName("bnbkiljslmdnbmpu")
    public suspend fun sources(`value`: Output<List<AddressPrefixItemArgs>>) {
        this.sources = value
    }

    @JvmName("ggkskygbtfeeftnx")
    public suspend fun sources(vararg values: Output<AddressPrefixItemArgs>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values The CIDR or source IP ranges.
     */
    @JvmName("eukixxltoalfrvea")
    public suspend fun sources(values: List<Output<AddressPrefixItemArgs>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value The name of the network manager Security Configuration.
     */
    @JvmName("urpralunyvdfferd")
    public suspend fun configurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationName = mapped
    }

    /**
     * @param value A description for this rule.
     */
    @JvmName("vfhrclylufgchjin")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The destination port ranges.
     */
    @JvmName("lmtwxrnhxbtscbww")
    public suspend fun destinationPortRanges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPortRanges = mapped
    }

    /**
     * @param values The destination port ranges.
     */
    @JvmName("cnohommonippkdgx")
    public suspend fun destinationPortRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPortRanges = mapped
    }

    /**
     * @param value The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("pfofamamcmkluuvf")
    public suspend fun destinations(`value`: List<AddressPrefixItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param argument The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("pyppyjjefamjkawd")
    public suspend fun destinations(argument: List<suspend AddressPrefixItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AddressPrefixItemArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param argument The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("ljerwunrskpaaplq")
    public suspend fun destinations(
        vararg
        argument: suspend AddressPrefixItemArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AddressPrefixItemArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param argument The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("fssxiqcyyyfkevbg")
    public suspend fun destinations(argument: suspend AddressPrefixItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AddressPrefixItemArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param values The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("cyyyyuhwhipbypst")
    public suspend fun destinations(vararg values: AddressPrefixItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param value Indicates if the traffic matched against the rule in inbound or outbound.
     */
    @JvmName("cdfocgipgjusmmde")
    public suspend fun direction(`value`: Either<String, SecurityConfigurationRuleDirection>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Indicates if the traffic matched against the rule in inbound or outbound.
     */
    @JvmName("cjthphgsgmdmgwbt")
    public fun direction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityConfigurationRuleDirection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Indicates if the traffic matched against the rule in inbound or outbound.
     */
    @JvmName("nltqmknhoennmolp")
    public fun direction(`value`: SecurityConfigurationRuleDirection) {
        val toBeMapped = Either.ofRight<String, SecurityConfigurationRuleDirection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Whether the rule is custom or default.
     * Expected value is 'Custom'.
     */
    @JvmName("ilfwmgrfabugfyak")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("vjeatxdnditlkiah")
    public suspend fun networkManagerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkManagerName = mapped
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("wrvjtscegcmonwpf")
    public suspend fun protocol(`value`: Either<String, SecurityConfigurationRuleProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("xdnplwvjucakxncq")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityConfigurationRuleProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("cnqxvofgldwwdwdi")
    public fun protocol(`value`: SecurityConfigurationRuleProtocol) {
        val toBeMapped = Either.ofRight<String, SecurityConfigurationRuleProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("oldvjitbgxlhppqn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the network manager security Configuration rule collection.
     */
    @JvmName("hjpkrwrrrhbllfsf")
    public suspend fun ruleCollectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleCollectionName = mapped
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("utdnysqdpdqfaigi")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value The source port ranges.
     */
    @JvmName("hmxiuvjsffadmhpn")
    public suspend fun sourcePortRanges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortRanges = mapped
    }

    /**
     * @param values The source port ranges.
     */
    @JvmName("kdtsfmpqicdfyeug")
    public suspend fun sourcePortRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourcePortRanges = mapped
    }

    /**
     * @param value The CIDR or source IP ranges.
     */
    @JvmName("meipdhflnbsumals")
    public suspend fun sources(`value`: List<AddressPrefixItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param argument The CIDR or source IP ranges.
     */
    @JvmName("cdyajwsrhehfpcox")
    public suspend fun sources(argument: List<suspend AddressPrefixItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AddressPrefixItemArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument The CIDR or source IP ranges.
     */
    @JvmName("duowabvpsyyhnxbo")
    public suspend fun sources(vararg argument: suspend AddressPrefixItemArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AddressPrefixItemArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument The CIDR or source IP ranges.
     */
    @JvmName("dhlfbfodysrjuyov")
    public suspend fun sources(argument: suspend AddressPrefixItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AddressPrefixItemArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param values The CIDR or source IP ranges.
     */
    @JvmName("oireehxaqhbwtiww")
    public suspend fun sources(vararg values: AddressPrefixItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    internal fun build(): UserRuleArgs = UserRuleArgs(
        configurationName = configurationName,
        description = description,
        destinationPortRanges = destinationPortRanges,
        destinations = destinations,
        direction = direction,
        kind = kind,
        networkManagerName = networkManagerName,
        protocol = protocol,
        resourceGroupName = resourceGroupName,
        ruleCollectionName = ruleCollectionName,
        ruleName = ruleName,
        sourcePortRanges = sourcePortRanges,
        sources = sources,
    )
}
