@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.Office365PolicyPropertiesResponse
import com.pulumi.azurenative.network.kotlin.outputs.Office365PolicyPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VirtualApplianceSite].
 */
@PulumiTagMarker
public class VirtualApplianceSiteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualApplianceSiteArgs = VirtualApplianceSiteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualApplianceSiteArgsBuilder.() -> Unit) {
        val builder = VirtualApplianceSiteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VirtualApplianceSite {
        val builtJavaResource =
            com.pulumi.azurenative.network.VirtualApplianceSite(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualApplianceSite(builtJavaResource)
    }
}

/**
 * Virtual Appliance Site resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create Network Virtual Appliance Site
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualApplianceSite = new AzureNative.Network.VirtualApplianceSite("virtualApplianceSite", new()
 *     {
 *         AddressPrefix = "192.168.1.0/24",
 *         NetworkVirtualApplianceName = "nva",
 *         O365Policy = new AzureNative.Network.Inputs.Office365PolicyPropertiesArgs
 *         {
 *             BreakOutCategories = new AzureNative.Network.Inputs.BreakOutCategoryPoliciesArgs
 *             {
 *                 Allow = true,
 *                 Default = true,
 *                 Optimize = true,
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         SiteName = "site1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualApplianceSite(ctx, "virtualApplianceSite", &network.VirtualApplianceSiteArgs{
 * 			AddressPrefix:               pulumi.String("192.168.1.0/24"),
 * 			NetworkVirtualApplianceName: pulumi.String("nva"),
 * 			O365Policy: network.Office365PolicyPropertiesResponse{
 * 				BreakOutCategories: &network.BreakOutCategoryPoliciesArgs{
 * 					Allow:    pulumi.Bool(true),
 * 					Default:  pulumi.Bool(true),
 * 					Optimize: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SiteName:          pulumi.String("site1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualApplianceSite;
 * import com.pulumi.azurenative.network.VirtualApplianceSiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualApplianceSite = new VirtualApplianceSite("virtualApplianceSite", VirtualApplianceSiteArgs.builder()
 *             .addressPrefix("192.168.1.0/24")
 *             .networkVirtualApplianceName("nva")
 *             .o365Policy(Map.of("breakOutCategories", Map.ofEntries(
 *                 Map.entry("allow", true),
 *                 Map.entry("default", true),
 *                 Map.entry("optimize", true)
 *             )))
 *             .resourceGroupName("rg1")
 *             .siteName("site1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualApplianceSite site1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkVirtualAppliances/{networkVirtualApplianceName}/virtualApplianceSites/{siteName}
 * ```
 */
public class VirtualApplianceSite internal constructor(
    override val javaResource: com.pulumi.azurenative.network.VirtualApplianceSite,
) : KotlinCustomResource(javaResource, VirtualApplianceSiteMapper) {
    /**
     * Address Prefix.
     */
    public val addressPrefix: Output<String>?
        get() = javaResource.addressPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Name of the virtual appliance site.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Office 365 Policy.
     */
    public val o365Policy: Output<Office365PolicyPropertiesResponse>?
        get() = javaResource.o365Policy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Site type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VirtualApplianceSiteMapper : ResourceMapper<VirtualApplianceSite> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.VirtualApplianceSite::class == javaResource::class

    override fun map(javaResource: Resource): VirtualApplianceSite = VirtualApplianceSite(
        javaResource
            as com.pulumi.azurenative.network.VirtualApplianceSite,
    )
}

/**
 * @see [VirtualApplianceSite].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualApplianceSite].
 */
public suspend fun virtualApplianceSite(
    name: String,
    block: suspend VirtualApplianceSiteResourceBuilder.() -> Unit,
): VirtualApplianceSite {
    val builder = VirtualApplianceSiteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualApplianceSite].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualApplianceSite(name: String): VirtualApplianceSite {
    val builder = VirtualApplianceSiteResourceBuilder()
    builder.name(name)
    return builder.build()
}
