@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.AddressSpaceResponse
import com.pulumi.azurenative.network.kotlin.outputs.DhcpOptionsResponse
import com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.network.kotlin.outputs.FlowLogResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse
import com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkBgpCommunitiesResponse
import com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkEncryptionResponse
import com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkPeeringResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.AddressSpaceResponse.Companion.toKotlin as addressSpaceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.DhcpOptionsResponse.Companion.toKotlin as dhcpOptionsResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.FlowLogResponse.Companion.toKotlin as flowLogResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse.Companion.toKotlin as subnetResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkBgpCommunitiesResponse.Companion.toKotlin as virtualNetworkBgpCommunitiesResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkEncryptionResponse.Companion.toKotlin as virtualNetworkEncryptionResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkPeeringResponse.Companion.toKotlin as virtualNetworkPeeringResponseToKotlin

/**
 * Builder for [VirtualNetwork].
 */
@PulumiTagMarker
public class VirtualNetworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualNetworkArgs = VirtualNetworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualNetworkArgsBuilder.() -> Unit) {
        val builder = VirtualNetworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VirtualNetwork {
        val builtJavaResource = com.pulumi.azurenative.network.VirtualNetwork(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VirtualNetwork(builtJavaResource)
    }
}

/**
 * Virtual Network resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2015-05-01-preview, 2019-06-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create virtual network
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetwork = new AzureNative.Network.VirtualNetwork("virtualNetwork", new()
 *     {
 *         AddressSpace = new AzureNative.Network.Inputs.AddressSpaceArgs
 *         {
 *             AddressPrefixes = new[]
 *             {
 *                 "10.0.0.0/16",
 *             },
 *         },
 *         FlowTimeoutInMinutes = 10,
 *         Location = "eastus",
 *         ResourceGroupName = "rg1",
 *         VirtualNetworkName = "test-vnet",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetwork(ctx, "virtualNetwork", &network.VirtualNetworkArgs{
 * 			AddressSpace: &network.AddressSpaceArgs{
 * 				AddressPrefixes: pulumi.StringArray{
 * 					pulumi.String("10.0.0.0/16"),
 * 				},
 * 			},
 * 			FlowTimeoutInMinutes: pulumi.Int(10),
 * 			Location:             pulumi.String("eastus"),
 * 			ResourceGroupName:    pulumi.String("rg1"),
 * 			VirtualNetworkName:   pulumi.String("test-vnet"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetwork;
 * import com.pulumi.azurenative.network.VirtualNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetwork = new VirtualNetwork("virtualNetwork", VirtualNetworkArgs.builder()
 *             .addressSpace(Map.of("addressPrefixes", "10.0.0.0/16"))
 *             .flowTimeoutInMinutes(10)
 *             .location("eastus")
 *             .resourceGroupName("rg1")
 *             .virtualNetworkName("test-vnet")
 *             .build());
 *     }
 * }
 * ```
 * ### Create virtual network with Bgp Communities
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetwork = new AzureNative.Network.VirtualNetwork("virtualNetwork", new()
 *     {
 *         AddressSpace = new AzureNative.Network.Inputs.AddressSpaceArgs
 *         {
 *             AddressPrefixes = new[]
 *             {
 *                 "10.0.0.0/16",
 *             },
 *         },
 *         BgpCommunities = new AzureNative.Network.Inputs.VirtualNetworkBgpCommunitiesArgs
 *         {
 *             VirtualNetworkCommunity = "12076:20000",
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "rg1",
 *         Subnets = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubnetArgs
 *             {
 *                 AddressPrefix = "10.0.0.0/24",
 *                 Name = "test-1",
 *             },
 *         },
 *         VirtualNetworkName = "test-vnet",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetwork(ctx, "virtualNetwork", &network.VirtualNetworkArgs{
 * 			AddressSpace: &network.AddressSpaceArgs{
 * 				AddressPrefixes: pulumi.StringArray{
 * 					pulumi.String("10.0.0.0/16"),
 * 				},
 * 			},
 * 			BgpCommunities: &network.VirtualNetworkBgpCommunitiesArgs{
 * 				VirtualNetworkCommunity: pulumi.String("12076:20000"),
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Subnets: []network.SubnetTypeArgs{
 * 				{
 * 					AddressPrefix: pulumi.String("10.0.0.0/24"),
 * 					Name:          pulumi.String("test-1"),
 * 				},
 * 			},
 * 			VirtualNetworkName: pulumi.String("test-vnet"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetwork;
 * import com.pulumi.azurenative.network.VirtualNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetwork = new VirtualNetwork("virtualNetwork", VirtualNetworkArgs.builder()
 *             .addressSpace(Map.of("addressPrefixes", "10.0.0.0/16"))
 *             .bgpCommunities(Map.of("virtualNetworkCommunity", "12076:20000"))
 *             .location("eastus")
 *             .resourceGroupName("rg1")
 *             .subnets(Map.ofEntries(
 *                 Map.entry("addressPrefix", "10.0.0.0/24"),
 *                 Map.entry("name", "test-1")
 *             ))
 *             .virtualNetworkName("test-vnet")
 *             .build());
 *     }
 * }
 * ```
 * ### Create virtual network with delegated subnets
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetwork = new AzureNative.Network.VirtualNetwork("virtualNetwork", new()
 *     {
 *         AddressSpace = new AzureNative.Network.Inputs.AddressSpaceArgs
 *         {
 *             AddressPrefixes = new[]
 *             {
 *                 "10.0.0.0/16",
 *             },
 *         },
 *         Location = "westcentralus",
 *         ResourceGroupName = "rg1",
 *         Subnets = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubnetArgs
 *             {
 *                 AddressPrefix = "10.0.0.0/24",
 *                 Delegations = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.DelegationArgs
 *                     {
 *                         Name = "myDelegation",
 *                         ServiceName = "Microsoft.Sql/managedInstances",
 *                     },
 *                 },
 *                 Name = "test-1",
 *             },
 *         },
 *         VirtualNetworkName = "test-vnet",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetwork(ctx, "virtualNetwork", &network.VirtualNetworkArgs{
 * 			AddressSpace: &network.AddressSpaceArgs{
 * 				AddressPrefixes: pulumi.StringArray{
 * 					pulumi.String("10.0.0.0/16"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("westcentralus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Subnets: []network.SubnetTypeArgs{
 * 				{
 * 					AddressPrefix: pulumi.String("10.0.0.0/24"),
 * 					Delegations: network.DelegationArray{
 * 						{
 * 							Name:        pulumi.String("myDelegation"),
 * 							ServiceName: pulumi.String("Microsoft.Sql/managedInstances"),
 * 						},
 * 					},
 * 					Name: pulumi.String("test-1"),
 * 				},
 * 			},
 * 			VirtualNetworkName: pulumi.String("test-vnet"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetwork;
 * import com.pulumi.azurenative.network.VirtualNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetwork = new VirtualNetwork("virtualNetwork", VirtualNetworkArgs.builder()
 *             .addressSpace(Map.of("addressPrefixes", "10.0.0.0/16"))
 *             .location("westcentralus")
 *             .resourceGroupName("rg1")
 *             .subnets(Map.ofEntries(
 *                 Map.entry("addressPrefix", "10.0.0.0/24"),
 *                 Map.entry("delegations", Map.ofEntries(
 *                     Map.entry("name", "myDelegation"),
 *                     Map.entry("serviceName", "Microsoft.Sql/managedInstances")
 *                 )),
 *                 Map.entry("name", "test-1")
 *             ))
 *             .virtualNetworkName("test-vnet")
 *             .build());
 *     }
 * }
 * ```
 * ### Create virtual network with encryption
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetwork = new AzureNative.Network.VirtualNetwork("virtualNetwork", new()
 *     {
 *         AddressSpace = new AzureNative.Network.Inputs.AddressSpaceArgs
 *         {
 *             AddressPrefixes = new[]
 *             {
 *                 "10.0.0.0/16",
 *             },
 *         },
 *         Encryption = new AzureNative.Network.Inputs.VirtualNetworkEncryptionArgs
 *         {
 *             Enabled = true,
 *             Enforcement = "AllowUnencrypted",
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "rg1",
 *         Subnets = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubnetArgs
 *             {
 *                 AddressPrefix = "10.0.0.0/24",
 *                 Name = "test-1",
 *             },
 *         },
 *         VirtualNetworkName = "test-vnet",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetwork(ctx, "virtualNetwork", &network.VirtualNetworkArgs{
 * 			AddressSpace: &network.AddressSpaceArgs{
 * 				AddressPrefixes: pulumi.StringArray{
 * 					pulumi.String("10.0.0.0/16"),
 * 				},
 * 			},
 * 			Encryption: &network.VirtualNetworkEncryptionArgs{
 * 				Enabled:     pulumi.Bool(true),
 * 				Enforcement: pulumi.String("AllowUnencrypted"),
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Subnets: []network.SubnetTypeArgs{
 * 				{
 * 					AddressPrefix: pulumi.String("10.0.0.0/24"),
 * 					Name:          pulumi.String("test-1"),
 * 				},
 * 			},
 * 			VirtualNetworkName: pulumi.String("test-vnet"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetwork;
 * import com.pulumi.azurenative.network.VirtualNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetwork = new VirtualNetwork("virtualNetwork", VirtualNetworkArgs.builder()
 *             .addressSpace(Map.of("addressPrefixes", "10.0.0.0/16"))
 *             .encryption(Map.ofEntries(
 *                 Map.entry("enabled", true),
 *                 Map.entry("enforcement", "AllowUnencrypted")
 *             ))
 *             .location("eastus")
 *             .resourceGroupName("rg1")
 *             .subnets(Map.ofEntries(
 *                 Map.entry("addressPrefix", "10.0.0.0/24"),
 *                 Map.entry("name", "test-1")
 *             ))
 *             .virtualNetworkName("test-vnet")
 *             .build());
 *     }
 * }
 * ```
 * ### Create virtual network with service endpoints
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetwork = new AzureNative.Network.VirtualNetwork("virtualNetwork", new()
 *     {
 *         AddressSpace = new AzureNative.Network.Inputs.AddressSpaceArgs
 *         {
 *             AddressPrefixes = new[]
 *             {
 *                 "10.0.0.0/16",
 *             },
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "vnetTest",
 *         Subnets = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubnetArgs
 *             {
 *                 AddressPrefix = "10.0.0.0/16",
 *                 Name = "test-1",
 *                 ServiceEndpoints = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.ServiceEndpointPropertiesFormatArgs
 *                     {
 *                         Service = "Microsoft.Storage",
 *                     },
 *                 },
 *             },
 *         },
 *         VirtualNetworkName = "vnet1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetwork(ctx, "virtualNetwork", &network.VirtualNetworkArgs{
 * 			AddressSpace: &network.AddressSpaceArgs{
 * 				AddressPrefixes: pulumi.StringArray{
 * 					pulumi.String("10.0.0.0/16"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("vnetTest"),
 * 			Subnets: []network.SubnetTypeArgs{
 * 				{
 * 					AddressPrefix: pulumi.String("10.0.0.0/16"),
 * 					Name:          pulumi.String("test-1"),
 * 					ServiceEndpoints: network.ServiceEndpointPropertiesFormatArray{
 * 						{
 * 							Service: pulumi.String("Microsoft.Storage"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VirtualNetworkName: pulumi.String("vnet1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetwork;
 * import com.pulumi.azurenative.network.VirtualNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetwork = new VirtualNetwork("virtualNetwork", VirtualNetworkArgs.builder()
 *             .addressSpace(Map.of("addressPrefixes", "10.0.0.0/16"))
 *             .location("eastus")
 *             .resourceGroupName("vnetTest")
 *             .subnets(Map.ofEntries(
 *                 Map.entry("addressPrefix", "10.0.0.0/16"),
 *                 Map.entry("name", "test-1"),
 *                 Map.entry("serviceEndpoints", Map.of("service", "Microsoft.Storage"))
 *             ))
 *             .virtualNetworkName("vnet1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create virtual network with service endpoints and service endpoint policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetwork = new AzureNative.Network.VirtualNetwork("virtualNetwork", new()
 *     {
 *         AddressSpace = new AzureNative.Network.Inputs.AddressSpaceArgs
 *         {
 *             AddressPrefixes = new[]
 *             {
 *                 "10.0.0.0/16",
 *             },
 *         },
 *         Location = "eastus2euap",
 *         ResourceGroupName = "vnetTest",
 *         Subnets = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubnetArgs
 *             {
 *                 AddressPrefix = "10.0.0.0/16",
 *                 Name = "test-1",
 *                 ServiceEndpointPolicies = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.ServiceEndpointPolicyArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/vnetTest/providers/Microsoft.Network/serviceEndpointPolicies/ServiceEndpointPolicy1",
 *                     },
 *                 },
 *                 ServiceEndpoints = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.ServiceEndpointPropertiesFormatArgs
 *                     {
 *                         Service = "Microsoft.Storage",
 *                     },
 *                 },
 *             },
 *         },
 *         VirtualNetworkName = "vnet1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetwork(ctx, "virtualNetwork", &network.VirtualNetworkArgs{
 * 			AddressSpace: &network.AddressSpaceArgs{
 * 				AddressPrefixes: pulumi.StringArray{
 * 					pulumi.String("10.0.0.0/16"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("eastus2euap"),
 * 			ResourceGroupName: pulumi.String("vnetTest"),
 * 			Subnets: []network.SubnetTypeArgs{
 * 				{
 * 					AddressPrefix: pulumi.String("10.0.0.0/16"),
 * 					Name:          pulumi.String("test-1"),
 * 					ServiceEndpointPolicies: network.ServiceEndpointPolicyTypeArray{
 * 						{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/vnetTest/providers/Microsoft.Network/serviceEndpointPolicies/ServiceEndpointPolicy1"),
 * 						},
 * 					},
 * 					ServiceEndpoints: network.ServiceEndpointPropertiesFormatArray{
 * 						{
 * 							Service: pulumi.String("Microsoft.Storage"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VirtualNetworkName: pulumi.String("vnet1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetwork;
 * import com.pulumi.azurenative.network.VirtualNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetwork = new VirtualNetwork("virtualNetwork", VirtualNetworkArgs.builder()
 *             .addressSpace(Map.of("addressPrefixes", "10.0.0.0/16"))
 *             .location("eastus2euap")
 *             .resourceGroupName("vnetTest")
 *             .subnets(Map.ofEntries(
 *                 Map.entry("addressPrefix", "10.0.0.0/16"),
 *                 Map.entry("name", "test-1"),
 *                 Map.entry("serviceEndpointPolicies", Map.of("id", "/subscriptions/subid/resourceGroups/vnetTest/providers/Microsoft.Network/serviceEndpointPolicies/ServiceEndpointPolicy1")),
 *                 Map.entry("serviceEndpoints", Map.of("service", "Microsoft.Storage"))
 *             ))
 *             .virtualNetworkName("vnet1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create virtual network with subnet
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetwork = new AzureNative.Network.VirtualNetwork("virtualNetwork", new()
 *     {
 *         AddressSpace = new AzureNative.Network.Inputs.AddressSpaceArgs
 *         {
 *             AddressPrefixes = new[]
 *             {
 *                 "10.0.0.0/16",
 *             },
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "rg1",
 *         Subnets = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubnetArgs
 *             {
 *                 AddressPrefix = "10.0.0.0/24",
 *                 Name = "test-1",
 *             },
 *         },
 *         VirtualNetworkName = "test-vnet",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetwork(ctx, "virtualNetwork", &network.VirtualNetworkArgs{
 * 			AddressSpace: &network.AddressSpaceArgs{
 * 				AddressPrefixes: pulumi.StringArray{
 * 					pulumi.String("10.0.0.0/16"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Subnets: []network.SubnetTypeArgs{
 * 				{
 * 					AddressPrefix: pulumi.String("10.0.0.0/24"),
 * 					Name:          pulumi.String("test-1"),
 * 				},
 * 			},
 * 			VirtualNetworkName: pulumi.String("test-vnet"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetwork;
 * import com.pulumi.azurenative.network.VirtualNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetwork = new VirtualNetwork("virtualNetwork", VirtualNetworkArgs.builder()
 *             .addressSpace(Map.of("addressPrefixes", "10.0.0.0/16"))
 *             .location("eastus")
 *             .resourceGroupName("rg1")
 *             .subnets(Map.ofEntries(
 *                 Map.entry("addressPrefix", "10.0.0.0/24"),
 *                 Map.entry("name", "test-1")
 *             ))
 *             .virtualNetworkName("test-vnet")
 *             .build());
 *     }
 * }
 * ```
 * ### Create virtual network with subnet containing address prefixes
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetwork = new AzureNative.Network.VirtualNetwork("virtualNetwork", new()
 *     {
 *         AddressSpace = new AzureNative.Network.Inputs.AddressSpaceArgs
 *         {
 *             AddressPrefixes = new[]
 *             {
 *                 "10.0.0.0/16",
 *             },
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "rg1",
 *         Subnets = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubnetArgs
 *             {
 *                 AddressPrefixes = new[]
 *                 {
 *                     "10.0.0.0/28",
 *                     "10.0.1.0/28",
 *                 },
 *                 Name = "test-2",
 *             },
 *         },
 *         VirtualNetworkName = "test-vnet",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetwork(ctx, "virtualNetwork", &network.VirtualNetworkArgs{
 * 			AddressSpace: &network.AddressSpaceArgs{
 * 				AddressPrefixes: pulumi.StringArray{
 * 					pulumi.String("10.0.0.0/16"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Subnets: []network.SubnetTypeArgs{
 * 				{
 * 					AddressPrefixes: pulumi.StringArray{
 * 						pulumi.String("10.0.0.0/28"),
 * 						pulumi.String("10.0.1.0/28"),
 * 					},
 * 					Name: pulumi.String("test-2"),
 * 				},
 * 			},
 * 			VirtualNetworkName: pulumi.String("test-vnet"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetwork;
 * import com.pulumi.azurenative.network.VirtualNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetwork = new VirtualNetwork("virtualNetwork", VirtualNetworkArgs.builder()
 *             .addressSpace(Map.of("addressPrefixes", "10.0.0.0/16"))
 *             .location("eastus")
 *             .resourceGroupName("rg1")
 *             .subnets(Map.ofEntries(
 *                 Map.entry("addressPrefixes",
 *                     "10.0.0.0/28",
 *                     "10.0.1.0/28"),
 *                 Map.entry("name", "test-2")
 *             ))
 *             .virtualNetworkName("test-vnet")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualNetwork test-vnet /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}
 * ```
 */
public class VirtualNetwork internal constructor(
    override val javaResource: com.pulumi.azurenative.network.VirtualNetwork,
) : KotlinCustomResource(javaResource, VirtualNetworkMapper) {
    /**
     * The AddressSpace that contains an array of IP address ranges that can be used by subnets.
     */
    public val addressSpace: Output<AddressSpaceResponse>?
        get() = javaResource.addressSpace().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    addressSpaceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Bgp Communities sent over ExpressRoute with each route corresponding to a prefix in this VNET.
     */
    public val bgpCommunities: Output<VirtualNetworkBgpCommunitiesResponse>?
        get() = javaResource.bgpCommunities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> virtualNetworkBgpCommunitiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The DDoS protection plan associated with the virtual network.
     */
    public val ddosProtectionPlan: Output<SubResourceResponse>?
        get() = javaResource.ddosProtectionPlan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The dhcpOptions that contains an array of DNS servers available to VMs deployed in the virtual network.
     */
    public val dhcpOptions: Output<DhcpOptionsResponse>?
        get() = javaResource.dhcpOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dhcpOptionsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Indicates if DDoS protection is enabled for all the protected resources in the virtual network. It requires a DDoS protection plan associated with the resource.
     */
    public val enableDdosProtection: Output<Boolean>?
        get() = javaResource.enableDdosProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates if VM protection is enabled for all the subnets in the virtual network.
     */
    public val enableVmProtection: Output<Boolean>?
        get() = javaResource.enableVmProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates if encryption is enabled on virtual network and if VM without encryption is allowed in encrypted VNet.
     */
    public val encryption: Output<VirtualNetworkEncryptionResponse>?
        get() = javaResource.encryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualNetworkEncryptionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The extended location of the virtual network.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A collection of references to flow log resources.
     */
    public val flowLogs: Output<List<FlowLogResponse>>
        get() = javaResource.flowLogs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    flowLogResponseToKotlin(args0)
                })
            })
        })

    /**
     * The FlowTimeout value (in minutes) for the Virtual Network
     */
    public val flowTimeoutInMinutes: Output<Int>?
        get() = javaResource.flowTimeoutInMinutes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Array of IpAllocation which reference this VNET.
     */
    public val ipAllocations: Output<List<SubResourceResponse>>?
        get() = javaResource.ipAllocations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        subResourceResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the virtual network resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resourceGuid property of the Virtual Network resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * A list of subnets in a Virtual Network.
     */
    public val subnets: Output<List<SubnetResponse>>?
        get() = javaResource.subnets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> subnetResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * A list of peerings in a Virtual Network.
     */
    public val virtualNetworkPeerings: Output<List<VirtualNetworkPeeringResponse>>?
        get() = javaResource.virtualNetworkPeerings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        virtualNetworkPeeringResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })
}

public object VirtualNetworkMapper : ResourceMapper<VirtualNetwork> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.VirtualNetwork::class == javaResource::class

    override fun map(javaResource: Resource): VirtualNetwork = VirtualNetwork(
        javaResource as
            com.pulumi.azurenative.network.VirtualNetwork,
    )
}

/**
 * @see [VirtualNetwork].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualNetwork].
 */
public suspend fun virtualNetwork(
    name: String,
    block: suspend VirtualNetworkResourceBuilder.() -> Unit,
): VirtualNetwork {
    val builder = VirtualNetworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualNetwork].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualNetwork(name: String): VirtualNetwork {
    val builder = VirtualNetworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
