@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VirtualRouterPeering].
 */
@PulumiTagMarker
public class VirtualRouterPeeringResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualRouterPeeringArgs = VirtualRouterPeeringArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualRouterPeeringArgsBuilder.() -> Unit) {
        val builder = VirtualRouterPeeringArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VirtualRouterPeering {
        val builtJavaResource =
            com.pulumi.azurenative.network.VirtualRouterPeering(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualRouterPeering(builtJavaResource)
    }
}

/**
 * Virtual Router Peering resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2022-01-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create Virtual Router Peering
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualRouterPeering = new AzureNative.Network.VirtualRouterPeering("virtualRouterPeering", new()
 *     {
 *         PeerAsn = 20000,
 *         PeerIp = "192.168.1.5",
 *         PeeringName = "peering1",
 *         ResourceGroupName = "rg1",
 *         VirtualRouterName = "virtualRouter",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualRouterPeering(ctx, "virtualRouterPeering", &network.VirtualRouterPeeringArgs{
 * 			PeerAsn:           pulumi.Float64(20000),
 * 			PeerIp:            pulumi.String("192.168.1.5"),
 * 			PeeringName:       pulumi.String("peering1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			VirtualRouterName: pulumi.String("virtualRouter"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualRouterPeering;
 * import com.pulumi.azurenative.network.VirtualRouterPeeringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualRouterPeering = new VirtualRouterPeering("virtualRouterPeering", VirtualRouterPeeringArgs.builder()
 *             .peerAsn(20000)
 *             .peerIp("192.168.1.5")
 *             .peeringName("peering1")
 *             .resourceGroupName("rg1")
 *             .virtualRouterName("virtualRouter")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualRouterPeering peering1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}/peerings/{peeringName}
 * ```
 */
public class VirtualRouterPeering internal constructor(
    override val javaResource: com.pulumi.azurenative.network.VirtualRouterPeering,
) : KotlinCustomResource(javaResource, VirtualRouterPeeringMapper) {
    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Name of the virtual router peering that is unique within a virtual router.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Peer ASN.
     */
    public val peerAsn: Output<Double>?
        get() = javaResource.peerAsn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Peer IP.
     */
    public val peerIp: Output<String>?
        get() = javaResource.peerIp().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Peering type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VirtualRouterPeeringMapper : ResourceMapper<VirtualRouterPeering> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.VirtualRouterPeering::class == javaResource::class

    override fun map(javaResource: Resource): VirtualRouterPeering = VirtualRouterPeering(
        javaResource
            as com.pulumi.azurenative.network.VirtualRouterPeering,
    )
}

/**
 * @see [VirtualRouterPeering].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualRouterPeering].
 */
public suspend fun virtualRouterPeering(
    name: String,
    block: suspend VirtualRouterPeeringResourceBuilder.() -> Unit,
): VirtualRouterPeering {
    val builder = VirtualRouterPeeringResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualRouterPeering].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualRouterPeering(name: String): VirtualRouterPeering {
    val builder = VirtualRouterPeeringResourceBuilder()
    builder.name(name)
    return builder.build()
}
