@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.IpsecPolicyResponse
import com.pulumi.azurenative.network.kotlin.outputs.RoutingConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.TrafficSelectorPolicyResponse
import com.pulumi.azurenative.network.kotlin.outputs.VpnSiteLinkConnectionResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.network.kotlin.outputs.IpsecPolicyResponse.Companion.toKotlin as ipsecPolicyResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.RoutingConfigurationResponse.Companion.toKotlin as routingConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.TrafficSelectorPolicyResponse.Companion.toKotlin as trafficSelectorPolicyResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VpnSiteLinkConnectionResponse.Companion.toKotlin as vpnSiteLinkConnectionResponseToKotlin

/**
 * Builder for [VpnConnection].
 */
@PulumiTagMarker
public class VpnConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpnConnectionArgs = VpnConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpnConnectionArgsBuilder.() -> Unit) {
        val builder = VpnConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpnConnection {
        val builtJavaResource = com.pulumi.azurenative.network.VpnConnection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpnConnection(builtJavaResource)
    }
}

/**
 * VpnConnection Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2018-04-01, 2018-07-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### VpnConnectionPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vpnConnection = new AzureNative.Network.VpnConnection("vpnConnection", new()
 *     {
 *         ConnectionName = "vpnConnection1",
 *         GatewayName = "gateway1",
 *         RemoteVpnSite = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1",
 *         },
 *         ResourceGroupName = "rg1",
 *         RoutingConfiguration = new AzureNative.Network.Inputs.RoutingConfigurationArgs
 *         {
 *             AssociatedRouteTable = new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1",
 *             },
 *             InboundRouteMap = new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap1",
 *             },
 *             OutboundRouteMap = new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap2",
 *             },
 *             PropagatedRouteTables = new AzureNative.Network.Inputs.PropagatedRouteTableArgs
 *             {
 *                 Ids = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1",
 *                     },
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable2",
 *                     },
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable3",
 *                     },
 *                 },
 *                 Labels = new[]
 *                 {
 *                     "label1",
 *                     "label2",
 *                 },
 *             },
 *         },
 *         TrafficSelectorPolicies = new[] {},
 *         VpnLinkConnections = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnSiteLinkConnectionArgs
 *             {
 *                 ConnectionBandwidth = 200,
 *                 Name = "Connection-Link1",
 *                 SharedKey = "key",
 *                 UsePolicyBasedTrafficSelectors = false,
 *                 VpnConnectionProtocolType = "IKEv2",
 *                 VpnLinkConnectionMode = "Default",
 *                 VpnSiteLink = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1/vpnSiteLinks/siteLink1",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := network.NewVpnConnection(ctx, "vpnConnection", &network.VpnConnectionArgs{
 * ConnectionName: pulumi.String("vpnConnection1"),
 * GatewayName: pulumi.String("gateway1"),
 * RemoteVpnSite: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * RoutingConfiguration: network.RoutingConfigurationResponse{
 * AssociatedRouteTable: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1"),
 * },
 * InboundRouteMap: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap1"),
 * },
 * OutboundRouteMap: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap2"),
 * },
 * PropagatedRouteTables: interface{}{
 * Ids: network.SubResourceArray{
 * &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1"),
 * },
 * &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable2"),
 * },
 * &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable3"),
 * },
 * },
 * Labels: pulumi.StringArray{
 * pulumi.String("label1"),
 * pulumi.String("label2"),
 * },
 * },
 * },
 * TrafficSelectorPolicies: network.TrafficSelectorPolicyArray{
 * },
 * VpnLinkConnections: []network.VpnSiteLinkConnectionArgs{
 * {
 * ConnectionBandwidth: pulumi.Int(200),
 * Name: pulumi.String("Connection-Link1"),
 * SharedKey: pulumi.String("key"),
 * UsePolicyBasedTrafficSelectors: pulumi.Bool(false),
 * VpnConnectionProtocolType: pulumi.String("IKEv2"),
 * VpnLinkConnectionMode: pulumi.String("Default"),
 * VpnSiteLink: {
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1/vpnSiteLinks/siteLink1"),
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VpnConnection;
 * import com.pulumi.azurenative.network.VpnConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpnConnection = new VpnConnection("vpnConnection", VpnConnectionArgs.builder()
 *             .connectionName("vpnConnection1")
 *             .gatewayName("gateway1")
 *             .remoteVpnSite(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1"))
 *             .resourceGroupName("rg1")
 *             .routingConfiguration(Map.ofEntries(
 *                 Map.entry("associatedRouteTable", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1")),
 *                 Map.entry("inboundRouteMap", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap1")),
 *                 Map.entry("outboundRouteMap", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap2")),
 *                 Map.entry("propagatedRouteTables", Map.ofEntries(
 *                     Map.entry("ids",
 *                         Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1"),
 *                         Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable2"),
 *                         Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable3")),
 *                     Map.entry("labels",
 *                         "label1",
 *                         "label2")
 *                 ))
 *             ))
 *             .trafficSelectorPolicies()
 *             .vpnLinkConnections(Map.ofEntries(
 *                 Map.entry("connectionBandwidth", 200),
 *                 Map.entry("name", "Connection-Link1"),
 *                 Map.entry("sharedKey", "key"),
 *                 Map.entry("usePolicyBasedTrafficSelectors", false),
 *                 Map.entry("vpnConnectionProtocolType", "IKEv2"),
 *                 Map.entry("vpnLinkConnectionMode", "Default"),
 *                 Map.entry("vpnSiteLink", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1/vpnSiteLinks/siteLink1"))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VpnConnection vpnConnection1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways/{gatewayName}/vpnConnections/{connectionName}
 * ```
 */
public class VpnConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.network.VpnConnection,
) : KotlinCustomResource(javaResource, VpnConnectionMapper) {
    /**
     * Expected bandwidth in MBPS.
     */
    public val connectionBandwidth: Output<Int>?
        get() = javaResource.connectionBandwidth().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The connection status.
     */
    public val connectionStatus: Output<String>
        get() = javaResource.connectionStatus().applyValue({ args0 -> args0 })

    /**
     * DPD timeout in seconds for vpn connection.
     */
    public val dpdTimeoutSeconds: Output<Int>?
        get() = javaResource.dpdTimeoutSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Egress bytes transferred.
     */
    public val egressBytesTransferred: Output<Double>
        get() = javaResource.egressBytesTransferred().applyValue({ args0 -> args0 })

    /**
     * EnableBgp flag.
     */
    public val enableBgp: Output<Boolean>?
        get() = javaResource.enableBgp().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Enable internet security.
     */
    public val enableInternetSecurity: Output<Boolean>?
        get() = javaResource.enableInternetSecurity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * EnableBgp flag.
     */
    public val enableRateLimiting: Output<Boolean>?
        get() = javaResource.enableRateLimiting().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Ingress bytes transferred.
     */
    public val ingressBytesTransferred: Output<Double>
        get() = javaResource.ingressBytesTransferred().applyValue({ args0 -> args0 })

    /**
     * The IPSec Policies to be considered by this connection.
     */
    public val ipsecPolicies: Output<List<IpsecPolicyResponse>>?
        get() = javaResource.ipsecPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        ipsecPolicyResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning state of the VPN connection resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Id of the connected vpn site.
     */
    public val remoteVpnSite: Output<SubResourceResponse>?
        get() = javaResource.remoteVpnSite().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    public val routingConfiguration: Output<RoutingConfigurationResponse>?
        get() = javaResource.routingConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> routingConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Routing weight for vpn connection.
     */
    public val routingWeight: Output<Int>?
        get() = javaResource.routingWeight().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * SharedKey for the vpn connection.
     */
    public val sharedKey: Output<String>?
        get() = javaResource.sharedKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Traffic Selector Policies to be considered by this connection.
     */
    public val trafficSelectorPolicies: Output<List<TrafficSelectorPolicyResponse>>?
        get() = javaResource.trafficSelectorPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        trafficSelectorPolicyResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Use local azure ip to initiate connection.
     */
    public val useLocalAzureIpAddress: Output<Boolean>?
        get() = javaResource.useLocalAzureIpAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable policy-based traffic selectors.
     */
    public val usePolicyBasedTrafficSelectors: Output<Boolean>?
        get() = javaResource.usePolicyBasedTrafficSelectors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Connection protocol used for this connection.
     */
    public val vpnConnectionProtocolType: Output<String>?
        get() = javaResource.vpnConnectionProtocolType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of all vpn site link connections to the gateway.
     */
    public val vpnLinkConnections: Output<List<VpnSiteLinkConnectionResponse>>?
        get() = javaResource.vpnLinkConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        vpnSiteLinkConnectionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })
}

public object VpnConnectionMapper : ResourceMapper<VpnConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.VpnConnection::class == javaResource::class

    override fun map(javaResource: Resource): VpnConnection = VpnConnection(
        javaResource as
            com.pulumi.azurenative.network.VpnConnection,
    )
}

/**
 * @see [VpnConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpnConnection].
 */
public suspend fun vpnConnection(
    name: String,
    block: suspend VpnConnectionResourceBuilder.() -> Unit,
): VpnConnection {
    val builder = VpnConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpnConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpnConnection(name: String): VpnConnection {
    val builder = VpnConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
