@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.VpnConnectionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkGatewayConnectionProtocol
import com.pulumi.azurenative.network.kotlin.inputs.IpsecPolicyArgs
import com.pulumi.azurenative.network.kotlin.inputs.IpsecPolicyArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.RoutingConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.RoutingConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.TrafficSelectorPolicyArgs
import com.pulumi.azurenative.network.kotlin.inputs.TrafficSelectorPolicyArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VpnSiteLinkConnectionArgs
import com.pulumi.azurenative.network.kotlin.inputs.VpnSiteLinkConnectionArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * VpnConnection Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2018-04-01, 2018-07-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### VpnConnectionPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vpnConnection = new AzureNative.Network.VpnConnection("vpnConnection", new()
 *     {
 *         ConnectionName = "vpnConnection1",
 *         GatewayName = "gateway1",
 *         RemoteVpnSite = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1",
 *         },
 *         ResourceGroupName = "rg1",
 *         RoutingConfiguration = new AzureNative.Network.Inputs.RoutingConfigurationArgs
 *         {
 *             AssociatedRouteTable = new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1",
 *             },
 *             InboundRouteMap = new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap1",
 *             },
 *             OutboundRouteMap = new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap2",
 *             },
 *             PropagatedRouteTables = new AzureNative.Network.Inputs.PropagatedRouteTableArgs
 *             {
 *                 Ids = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1",
 *                     },
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable2",
 *                     },
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable3",
 *                     },
 *                 },
 *                 Labels = new[]
 *                 {
 *                     "label1",
 *                     "label2",
 *                 },
 *             },
 *         },
 *         TrafficSelectorPolicies = new[] {},
 *         VpnLinkConnections = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnSiteLinkConnectionArgs
 *             {
 *                 ConnectionBandwidth = 200,
 *                 Name = "Connection-Link1",
 *                 SharedKey = "key",
 *                 UsePolicyBasedTrafficSelectors = false,
 *                 VpnConnectionProtocolType = "IKEv2",
 *                 VpnLinkConnectionMode = "Default",
 *                 VpnSiteLink = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1/vpnSiteLinks/siteLink1",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := network.NewVpnConnection(ctx, "vpnConnection", &network.VpnConnectionArgs{
 * ConnectionName: pulumi.String("vpnConnection1"),
 * GatewayName: pulumi.String("gateway1"),
 * RemoteVpnSite: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * RoutingConfiguration: network.RoutingConfigurationResponse{
 * AssociatedRouteTable: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1"),
 * },
 * InboundRouteMap: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap1"),
 * },
 * OutboundRouteMap: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap2"),
 * },
 * PropagatedRouteTables: interface{}{
 * Ids: network.SubResourceArray{
 * &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1"),
 * },
 * &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable2"),
 * },
 * &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable3"),
 * },
 * },
 * Labels: pulumi.StringArray{
 * pulumi.String("label1"),
 * pulumi.String("label2"),
 * },
 * },
 * },
 * TrafficSelectorPolicies: network.TrafficSelectorPolicyArray{
 * },
 * VpnLinkConnections: []network.VpnSiteLinkConnectionArgs{
 * {
 * ConnectionBandwidth: pulumi.Int(200),
 * Name: pulumi.String("Connection-Link1"),
 * SharedKey: pulumi.String("key"),
 * UsePolicyBasedTrafficSelectors: pulumi.Bool(false),
 * VpnConnectionProtocolType: pulumi.String("IKEv2"),
 * VpnLinkConnectionMode: pulumi.String("Default"),
 * VpnSiteLink: {
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1/vpnSiteLinks/siteLink1"),
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VpnConnection;
 * import com.pulumi.azurenative.network.VpnConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpnConnection = new VpnConnection("vpnConnection", VpnConnectionArgs.builder()
 *             .connectionName("vpnConnection1")
 *             .gatewayName("gateway1")
 *             .remoteVpnSite(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1"))
 *             .resourceGroupName("rg1")
 *             .routingConfiguration(Map.ofEntries(
 *                 Map.entry("associatedRouteTable", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1")),
 *                 Map.entry("inboundRouteMap", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap1")),
 *                 Map.entry("outboundRouteMap", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap2")),
 *                 Map.entry("propagatedRouteTables", Map.ofEntries(
 *                     Map.entry("ids",
 *                         Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1"),
 *                         Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable2"),
 *                         Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable3")),
 *                     Map.entry("labels",
 *                         "label1",
 *                         "label2")
 *                 ))
 *             ))
 *             .trafficSelectorPolicies()
 *             .vpnLinkConnections(Map.ofEntries(
 *                 Map.entry("connectionBandwidth", 200),
 *                 Map.entry("name", "Connection-Link1"),
 *                 Map.entry("sharedKey", "key"),
 *                 Map.entry("usePolicyBasedTrafficSelectors", false),
 *                 Map.entry("vpnConnectionProtocolType", "IKEv2"),
 *                 Map.entry("vpnLinkConnectionMode", "Default"),
 *                 Map.entry("vpnSiteLink", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1/vpnSiteLinks/siteLink1"))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VpnConnection vpnConnection1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways/{gatewayName}/vpnConnections/{connectionName}
 * ```
 * @property connectionBandwidth Expected bandwidth in MBPS.
 * @property connectionName The name of the connection.
 * @property dpdTimeoutSeconds DPD timeout in seconds for vpn connection.
 * @property enableBgp EnableBgp flag.
 * @property enableInternetSecurity Enable internet security.
 * @property enableRateLimiting EnableBgp flag.
 * @property gatewayName The name of the gateway.
 * @property id Resource ID.
 * @property ipsecPolicies The IPSec Policies to be considered by this connection.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property remoteVpnSite Id of the connected vpn site.
 * @property resourceGroupName The resource group name of the VpnGateway.
 * @property routingConfiguration The Routing Configuration indicating the associated and propagated route tables on this connection.
 * @property routingWeight Routing weight for vpn connection.
 * @property sharedKey SharedKey for the vpn connection.
 * @property trafficSelectorPolicies The Traffic Selector Policies to be considered by this connection.
 * @property useLocalAzureIpAddress Use local azure ip to initiate connection.
 * @property usePolicyBasedTrafficSelectors Enable policy-based traffic selectors.
 * @property vpnConnectionProtocolType Connection protocol used for this connection.
 * @property vpnLinkConnections List of all vpn site link connections to the gateway.
 */
public data class VpnConnectionArgs(
    public val connectionBandwidth: Output<Int>? = null,
    public val connectionName: Output<String>? = null,
    public val dpdTimeoutSeconds: Output<Int>? = null,
    public val enableBgp: Output<Boolean>? = null,
    public val enableInternetSecurity: Output<Boolean>? = null,
    public val enableRateLimiting: Output<Boolean>? = null,
    public val gatewayName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val ipsecPolicies: Output<List<IpsecPolicyArgs>>? = null,
    public val name: Output<String>? = null,
    public val remoteVpnSite: Output<SubResourceArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routingConfiguration: Output<RoutingConfigurationArgs>? = null,
    public val routingWeight: Output<Int>? = null,
    public val sharedKey: Output<String>? = null,
    public val trafficSelectorPolicies: Output<List<TrafficSelectorPolicyArgs>>? = null,
    public val useLocalAzureIpAddress: Output<Boolean>? = null,
    public val usePolicyBasedTrafficSelectors: Output<Boolean>? = null,
    public val vpnConnectionProtocolType:
    Output<Either<String, VirtualNetworkGatewayConnectionProtocol>>? = null,
    public val vpnLinkConnections: Output<List<VpnSiteLinkConnectionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.VpnConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.VpnConnectionArgs =
        com.pulumi.azurenative.network.VpnConnectionArgs.builder()
            .connectionBandwidth(connectionBandwidth?.applyValue({ args0 -> args0 }))
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .dpdTimeoutSeconds(dpdTimeoutSeconds?.applyValue({ args0 -> args0 }))
            .enableBgp(enableBgp?.applyValue({ args0 -> args0 }))
            .enableInternetSecurity(enableInternetSecurity?.applyValue({ args0 -> args0 }))
            .enableRateLimiting(enableRateLimiting?.applyValue({ args0 -> args0 }))
            .gatewayName(gatewayName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .ipsecPolicies(
                ipsecPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .remoteVpnSite(remoteVpnSite?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routingConfiguration(
                routingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .routingWeight(routingWeight?.applyValue({ args0 -> args0 }))
            .sharedKey(sharedKey?.applyValue({ args0 -> args0 }))
            .trafficSelectorPolicies(
                trafficSelectorPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .useLocalAzureIpAddress(useLocalAzureIpAddress?.applyValue({ args0 -> args0 }))
            .usePolicyBasedTrafficSelectors(usePolicyBasedTrafficSelectors?.applyValue({ args0 -> args0 }))
            .vpnConnectionProtocolType(
                vpnConnectionProtocolType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .vpnLinkConnections(
                vpnLinkConnections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [VpnConnectionArgs].
 */
@PulumiTagMarker
public class VpnConnectionArgsBuilder internal constructor() {
    private var connectionBandwidth: Output<Int>? = null

    private var connectionName: Output<String>? = null

    private var dpdTimeoutSeconds: Output<Int>? = null

    private var enableBgp: Output<Boolean>? = null

    private var enableInternetSecurity: Output<Boolean>? = null

    private var enableRateLimiting: Output<Boolean>? = null

    private var gatewayName: Output<String>? = null

    private var id: Output<String>? = null

    private var ipsecPolicies: Output<List<IpsecPolicyArgs>>? = null

    private var name: Output<String>? = null

    private var remoteVpnSite: Output<SubResourceArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var routingConfiguration: Output<RoutingConfigurationArgs>? = null

    private var routingWeight: Output<Int>? = null

    private var sharedKey: Output<String>? = null

    private var trafficSelectorPolicies: Output<List<TrafficSelectorPolicyArgs>>? = null

    private var useLocalAzureIpAddress: Output<Boolean>? = null

    private var usePolicyBasedTrafficSelectors: Output<Boolean>? = null

    private var vpnConnectionProtocolType:
        Output<Either<String, VirtualNetworkGatewayConnectionProtocol>>? = null

    private var vpnLinkConnections: Output<List<VpnSiteLinkConnectionArgs>>? = null

    /**
     * @param value Expected bandwidth in MBPS.
     */
    @JvmName("qmnigctxxsvbhkam")
    public suspend fun connectionBandwidth(`value`: Output<Int>) {
        this.connectionBandwidth = value
    }

    /**
     * @param value The name of the connection.
     */
    @JvmName("feqhtlxyngarcttv")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value DPD timeout in seconds for vpn connection.
     */
    @JvmName("jbklvexjugfktvfw")
    public suspend fun dpdTimeoutSeconds(`value`: Output<Int>) {
        this.dpdTimeoutSeconds = value
    }

    /**
     * @param value EnableBgp flag.
     */
    @JvmName("tyrwqmpcwtuqrfiw")
    public suspend fun enableBgp(`value`: Output<Boolean>) {
        this.enableBgp = value
    }

    /**
     * @param value Enable internet security.
     */
    @JvmName("usoawaynpvbayeyu")
    public suspend fun enableInternetSecurity(`value`: Output<Boolean>) {
        this.enableInternetSecurity = value
    }

    /**
     * @param value EnableBgp flag.
     */
    @JvmName("rsuvtoptinqvdvem")
    public suspend fun enableRateLimiting(`value`: Output<Boolean>) {
        this.enableRateLimiting = value
    }

    /**
     * @param value The name of the gateway.
     */
    @JvmName("tsptreppalgvgsgq")
    public suspend fun gatewayName(`value`: Output<String>) {
        this.gatewayName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("sfonsonmeuilmbve")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The IPSec Policies to be considered by this connection.
     */
    @JvmName("mrphfunwasfnfxlb")
    public suspend fun ipsecPolicies(`value`: Output<List<IpsecPolicyArgs>>) {
        this.ipsecPolicies = value
    }

    @JvmName("pqckiwljlaenyqbo")
    public suspend fun ipsecPolicies(vararg values: Output<IpsecPolicyArgs>) {
        this.ipsecPolicies = Output.all(values.asList())
    }

    /**
     * @param values The IPSec Policies to be considered by this connection.
     */
    @JvmName("ahmcthdxwrbnjcmp")
    public suspend fun ipsecPolicies(values: List<Output<IpsecPolicyArgs>>) {
        this.ipsecPolicies = Output.all(values)
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("danweiummlvpyebo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Id of the connected vpn site.
     */
    @JvmName("uywejgduagxkxdmu")
    public suspend fun remoteVpnSite(`value`: Output<SubResourceArgs>) {
        this.remoteVpnSite = value
    }

    /**
     * @param value The resource group name of the VpnGateway.
     */
    @JvmName("jtkiaooltejhshrl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    @JvmName("witcnauvlqlnqubf")
    public suspend fun routingConfiguration(`value`: Output<RoutingConfigurationArgs>) {
        this.routingConfiguration = value
    }

    /**
     * @param value Routing weight for vpn connection.
     */
    @JvmName("yfvstcigtwfcendl")
    public suspend fun routingWeight(`value`: Output<Int>) {
        this.routingWeight = value
    }

    /**
     * @param value SharedKey for the vpn connection.
     */
    @JvmName("dhxobtprdouvixoh")
    public suspend fun sharedKey(`value`: Output<String>) {
        this.sharedKey = value
    }

    /**
     * @param value The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("navphtenfkpfwusj")
    public suspend fun trafficSelectorPolicies(`value`: Output<List<TrafficSelectorPolicyArgs>>) {
        this.trafficSelectorPolicies = value
    }

    @JvmName("kcnrhyalpskpldee")
    public suspend fun trafficSelectorPolicies(vararg values: Output<TrafficSelectorPolicyArgs>) {
        this.trafficSelectorPolicies = Output.all(values.asList())
    }

    /**
     * @param values The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("dtmdfsnymluksnsd")
    public suspend fun trafficSelectorPolicies(values: List<Output<TrafficSelectorPolicyArgs>>) {
        this.trafficSelectorPolicies = Output.all(values)
    }

    /**
     * @param value Use local azure ip to initiate connection.
     */
    @JvmName("qsfujpwofeagtwfi")
    public suspend fun useLocalAzureIpAddress(`value`: Output<Boolean>) {
        this.useLocalAzureIpAddress = value
    }

    /**
     * @param value Enable policy-based traffic selectors.
     */
    @JvmName("ihiwafiogeckuwcu")
    public suspend fun usePolicyBasedTrafficSelectors(`value`: Output<Boolean>) {
        this.usePolicyBasedTrafficSelectors = value
    }

    /**
     * @param value Connection protocol used for this connection.
     */
    @JvmName("cdicpohfwcwyollp")
    public suspend
    fun vpnConnectionProtocolType(`value`: Output<Either<String, VirtualNetworkGatewayConnectionProtocol>>) {
        this.vpnConnectionProtocolType = value
    }

    /**
     * @param value List of all vpn site link connections to the gateway.
     */
    @JvmName("tyysosfsbnoxkhtn")
    public suspend fun vpnLinkConnections(`value`: Output<List<VpnSiteLinkConnectionArgs>>) {
        this.vpnLinkConnections = value
    }

    @JvmName("cwckgcitnwdkkjie")
    public suspend fun vpnLinkConnections(vararg values: Output<VpnSiteLinkConnectionArgs>) {
        this.vpnLinkConnections = Output.all(values.asList())
    }

    /**
     * @param values List of all vpn site link connections to the gateway.
     */
    @JvmName("vrjgpxweiwjydgbk")
    public suspend fun vpnLinkConnections(values: List<Output<VpnSiteLinkConnectionArgs>>) {
        this.vpnLinkConnections = Output.all(values)
    }

    /**
     * @param value Expected bandwidth in MBPS.
     */
    @JvmName("fidpfkntlwoaaayi")
    public suspend fun connectionBandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionBandwidth = mapped
    }

    /**
     * @param value The name of the connection.
     */
    @JvmName("pknttlcwxiepvbxo")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value DPD timeout in seconds for vpn connection.
     */
    @JvmName("vvbkimvrjijgvwjl")
    public suspend fun dpdTimeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dpdTimeoutSeconds = mapped
    }

    /**
     * @param value EnableBgp flag.
     */
    @JvmName("gufcwsyiwdghnuvf")
    public suspend fun enableBgp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBgp = mapped
    }

    /**
     * @param value Enable internet security.
     */
    @JvmName("yyrurukdgqrhjtjn")
    public suspend fun enableInternetSecurity(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableInternetSecurity = mapped
    }

    /**
     * @param value EnableBgp flag.
     */
    @JvmName("cyqracptpdibrffu")
    public suspend fun enableRateLimiting(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableRateLimiting = mapped
    }

    /**
     * @param value The name of the gateway.
     */
    @JvmName("mxcbojtjuswgfeji")
    public suspend fun gatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("qqwmxbfatwpwxxfp")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The IPSec Policies to be considered by this connection.
     */
    @JvmName("wrwlexwhdwpuplpp")
    public suspend fun ipsecPolicies(`value`: List<IpsecPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecPolicies = mapped
    }

    /**
     * @param argument The IPSec Policies to be considered by this connection.
     */
    @JvmName("slhqgbmxddvwiyye")
    public suspend fun ipsecPolicies(argument: List<suspend IpsecPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IpsecPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipsecPolicies = mapped
    }

    /**
     * @param argument The IPSec Policies to be considered by this connection.
     */
    @JvmName("kymjajlpurukkane")
    public suspend fun ipsecPolicies(vararg argument: suspend IpsecPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IpsecPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipsecPolicies = mapped
    }

    /**
     * @param argument The IPSec Policies to be considered by this connection.
     */
    @JvmName("npxuohylqousbghp")
    public suspend fun ipsecPolicies(argument: suspend IpsecPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpsecPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipsecPolicies = mapped
    }

    /**
     * @param values The IPSec Policies to be considered by this connection.
     */
    @JvmName("bxigytvmakrqunen")
    public suspend fun ipsecPolicies(vararg values: IpsecPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipsecPolicies = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("yvwllaygboqwliac")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Id of the connected vpn site.
     */
    @JvmName("dnsqxihhigouelpc")
    public suspend fun remoteVpnSite(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteVpnSite = mapped
    }

    /**
     * @param argument Id of the connected vpn site.
     */
    @JvmName("inymdsyfyduseonj")
    public suspend fun remoteVpnSite(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.remoteVpnSite = mapped
    }

    /**
     * @param value The resource group name of the VpnGateway.
     */
    @JvmName("urvgsrbywachgiof")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    @JvmName("yohvswgbwmrbqsrv")
    public suspend fun routingConfiguration(`value`: RoutingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingConfiguration = mapped
    }

    /**
     * @param argument The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    @JvmName("roedxmlkcycxelhb")
    public suspend
    fun routingConfiguration(argument: suspend RoutingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = RoutingConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routingConfiguration = mapped
    }

    /**
     * @param value Routing weight for vpn connection.
     */
    @JvmName("qbbveenxoaxdwgqb")
    public suspend fun routingWeight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingWeight = mapped
    }

    /**
     * @param value SharedKey for the vpn connection.
     */
    @JvmName("wsgicplwmqhpgayu")
    public suspend fun sharedKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedKey = mapped
    }

    /**
     * @param value The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("viabigrrjojciris")
    public suspend fun trafficSelectorPolicies(`value`: List<TrafficSelectorPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficSelectorPolicies = mapped
    }

    /**
     * @param argument The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("ratmuvxrserqwpou")
    public suspend
    fun trafficSelectorPolicies(argument: List<suspend TrafficSelectorPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TrafficSelectorPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.trafficSelectorPolicies = mapped
    }

    /**
     * @param argument The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("eyrivvtcynxnbcto")
    public suspend fun trafficSelectorPolicies(
        vararg
        argument: suspend TrafficSelectorPolicyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TrafficSelectorPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.trafficSelectorPolicies = mapped
    }

    /**
     * @param argument The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("kvxaelhiiplghins")
    public suspend
    fun trafficSelectorPolicies(argument: suspend TrafficSelectorPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TrafficSelectorPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.trafficSelectorPolicies = mapped
    }

    /**
     * @param values The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("reytakwdgcmchebe")
    public suspend fun trafficSelectorPolicies(vararg values: TrafficSelectorPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trafficSelectorPolicies = mapped
    }

    /**
     * @param value Use local azure ip to initiate connection.
     */
    @JvmName("twxwkrimhygryhuh")
    public suspend fun useLocalAzureIpAddress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useLocalAzureIpAddress = mapped
    }

    /**
     * @param value Enable policy-based traffic selectors.
     */
    @JvmName("dsqjlkyrlnegujcg")
    public suspend fun usePolicyBasedTrafficSelectors(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usePolicyBasedTrafficSelectors = mapped
    }

    /**
     * @param value Connection protocol used for this connection.
     */
    @JvmName("rxertvhqfdoxbeqq")
    public suspend
    fun vpnConnectionProtocolType(`value`: Either<String, VirtualNetworkGatewayConnectionProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnConnectionProtocolType = mapped
    }

    /**
     * @param value Connection protocol used for this connection.
     */
    @JvmName("npyktsojprncsxju")
    public fun vpnConnectionProtocolType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkGatewayConnectionProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnConnectionProtocolType = mapped
    }

    /**
     * @param value Connection protocol used for this connection.
     */
    @JvmName("pqfskvawhwuqacas")
    public fun vpnConnectionProtocolType(`value`: VirtualNetworkGatewayConnectionProtocol) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkGatewayConnectionProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnConnectionProtocolType = mapped
    }

    /**
     * @param value List of all vpn site link connections to the gateway.
     */
    @JvmName("xscragiwsvgjdyet")
    public suspend fun vpnLinkConnections(`value`: List<VpnSiteLinkConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnLinkConnections = mapped
    }

    /**
     * @param argument List of all vpn site link connections to the gateway.
     */
    @JvmName("dbbikbetyeuwmcix")
    public suspend
    fun vpnLinkConnections(argument: List<suspend VpnSiteLinkConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnSiteLinkConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnLinkConnections = mapped
    }

    /**
     * @param argument List of all vpn site link connections to the gateway.
     */
    @JvmName("wsyxuqcsieadwssi")
    public suspend fun vpnLinkConnections(
        vararg
        argument: suspend VpnSiteLinkConnectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VpnSiteLinkConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnLinkConnections = mapped
    }

    /**
     * @param argument List of all vpn site link connections to the gateway.
     */
    @JvmName("bmoyscqqxpnaiojb")
    public suspend
    fun vpnLinkConnections(argument: suspend VpnSiteLinkConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VpnSiteLinkConnectionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.vpnLinkConnections = mapped
    }

    /**
     * @param values List of all vpn site link connections to the gateway.
     */
    @JvmName("raqvahwbfuujuahw")
    public suspend fun vpnLinkConnections(vararg values: VpnSiteLinkConnectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnLinkConnections = mapped
    }

    internal fun build(): VpnConnectionArgs = VpnConnectionArgs(
        connectionBandwidth = connectionBandwidth,
        connectionName = connectionName,
        dpdTimeoutSeconds = dpdTimeoutSeconds,
        enableBgp = enableBgp,
        enableInternetSecurity = enableInternetSecurity,
        enableRateLimiting = enableRateLimiting,
        gatewayName = gatewayName,
        id = id,
        ipsecPolicies = ipsecPolicies,
        name = name,
        remoteVpnSite = remoteVpnSite,
        resourceGroupName = resourceGroupName,
        routingConfiguration = routingConfiguration,
        routingWeight = routingWeight,
        sharedKey = sharedKey,
        trafficSelectorPolicies = trafficSelectorPolicies,
        useLocalAzureIpAddress = useLocalAzureIpAddress,
        usePolicyBasedTrafficSelectors = usePolicyBasedTrafficSelectors,
        vpnConnectionProtocolType = vpnConnectionProtocolType,
        vpnLinkConnections = vpnLinkConnections,
    )
}
