@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.VpnSiteArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.AddressSpaceArgs
import com.pulumi.azurenative.network.kotlin.inputs.AddressSpaceArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.BgpSettingsArgs
import com.pulumi.azurenative.network.kotlin.inputs.BgpSettingsArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.DevicePropertiesArgs
import com.pulumi.azurenative.network.kotlin.inputs.DevicePropertiesArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.O365PolicyPropertiesArgs
import com.pulumi.azurenative.network.kotlin.inputs.O365PolicyPropertiesArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VpnSiteLinkArgs
import com.pulumi.azurenative.network.kotlin.inputs.VpnSiteLinkArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * VpnSite Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2018-07-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### VpnSiteCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vpnSite = new AzureNative.Network.VpnSite("vpnSite", new()
 *     {
 *         AddressSpace = new AzureNative.Network.Inputs.AddressSpaceArgs
 *         {
 *             AddressPrefixes = new[]
 *             {
 *                 "10.0.0.0/16",
 *             },
 *         },
 *         IsSecuritySite = false,
 *         Location = "West US",
 *         O365Policy = new AzureNative.Network.Inputs.O365PolicyPropertiesArgs
 *         {
 *             BreakOutCategories = new AzureNative.Network.Inputs.O365BreakOutCategoryPoliciesArgs
 *             {
 *                 Allow = true,
 *                 Default = false,
 *                 Optimize = true,
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         VirtualWan = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualWANs/wan1",
 *         },
 *         VpnSiteLinks = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnSiteLinkArgs
 *             {
 *                 BgpProperties = new AzureNative.Network.Inputs.VpnLinkBgpSettingsArgs
 *                 {
 *                     Asn = 1234,
 *                     BgpPeeringAddress = "192.168.0.0",
 *                 },
 *                 Fqdn = "link1.vpnsite1.contoso.com",
 *                 IpAddress = "50.50.50.56",
 *                 LinkProperties = new AzureNative.Network.Inputs.VpnLinkProviderPropertiesArgs
 *                 {
 *                     LinkProviderName = "vendor1",
 *                     LinkSpeedInMbps = 0,
 *                 },
 *                 Name = "vpnSiteLink1",
 *             },
 *         },
 *         VpnSiteName = "vpnSite1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVpnSite(ctx, "vpnSite", &network.VpnSiteArgs{
 * 			AddressSpace: &network.AddressSpaceArgs{
 * 				AddressPrefixes: pulumi.StringArray{
 * 					pulumi.String("10.0.0.0/16"),
 * 				},
 * 			},
 * 			IsSecuritySite: pulumi.Bool(false),
 * 			Location:       pulumi.String("West US"),
 * 			O365Policy: network.O365PolicyPropertiesResponse{
 * 				BreakOutCategories: &network.O365BreakOutCategoryPoliciesArgs{
 * 					Allow:    pulumi.Bool(true),
 * 					Default:  pulumi.Bool(false),
 * 					Optimize: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			VirtualWan: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualWANs/wan1"),
 * 			},
 * 			VpnSiteLinks: []network.VpnSiteLinkArgs{
 * 				{
 * 					BgpProperties: {
 * 						Asn:               pulumi.Float64(1234),
 * 						BgpPeeringAddress: pulumi.String("192.168.0.0"),
 * 					},
 * 					Fqdn:      pulumi.String("link1.vpnsite1.contoso.com"),
 * 					IpAddress: pulumi.String("50.50.50.56"),
 * 					LinkProperties: {
 * 						LinkProviderName: pulumi.String("vendor1"),
 * 						LinkSpeedInMbps:  pulumi.Int(0),
 * 					},
 * 					Name: pulumi.String("vpnSiteLink1"),
 * 				},
 * 			},
 * 			VpnSiteName: pulumi.String("vpnSite1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VpnSite;
 * import com.pulumi.azurenative.network.VpnSiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpnSite = new VpnSite("vpnSite", VpnSiteArgs.builder()
 *             .addressSpace(Map.of("addressPrefixes", "10.0.0.0/16"))
 *             .isSecuritySite(false)
 *             .location("West US")
 *             .o365Policy(Map.of("breakOutCategories", Map.ofEntries(
 *                 Map.entry("allow", true),
 *                 Map.entry("default", false),
 *                 Map.entry("optimize", true)
 *             )))
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "value1"))
 *             .virtualWan(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualWANs/wan1"))
 *             .vpnSiteLinks(Map.ofEntries(
 *                 Map.entry("bgpProperties", Map.ofEntries(
 *                     Map.entry("asn", 1234),
 *                     Map.entry("bgpPeeringAddress", "192.168.0.0")
 *                 )),
 *                 Map.entry("fqdn", "link1.vpnsite1.contoso.com"),
 *                 Map.entry("ipAddress", "50.50.50.56"),
 *                 Map.entry("linkProperties", Map.ofEntries(
 *                     Map.entry("linkProviderName", "vendor1"),
 *                     Map.entry("linkSpeedInMbps", 0)
 *                 )),
 *                 Map.entry("name", "vpnSiteLink1")
 *             ))
 *             .vpnSiteName("vpnSite1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VpnSite vpnSite1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnSites/{vpnSiteName}
 * ```
 * @property addressSpace The AddressSpace that contains an array of IP address ranges.
 * @property bgpProperties The set of bgp properties.
 * @property deviceProperties The device properties.
 * @property id Resource ID.
 * @property ipAddress The ip-address for the vpn-site.
 * @property isSecuritySite IsSecuritySite flag.
 * @property location Resource location.
 * @property o365Policy Office365 Policy.
 * @property resourceGroupName The resource group name of the VpnSite.
 * @property siteKey The key for vpn-site that can be used for connections.
 * @property tags Resource tags.
 * @property virtualWan The VirtualWAN to which the vpnSite belongs.
 * @property vpnSiteLinks List of all vpn site links.
 * @property vpnSiteName The name of the VpnSite being created or updated.
 */
public data class VpnSiteArgs(
    public val addressSpace: Output<AddressSpaceArgs>? = null,
    public val bgpProperties: Output<BgpSettingsArgs>? = null,
    public val deviceProperties: Output<DevicePropertiesArgs>? = null,
    public val id: Output<String>? = null,
    public val ipAddress: Output<String>? = null,
    public val isSecuritySite: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val o365Policy: Output<O365PolicyPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val siteKey: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualWan: Output<SubResourceArgs>? = null,
    public val vpnSiteLinks: Output<List<VpnSiteLinkArgs>>? = null,
    public val vpnSiteName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.VpnSiteArgs> {
    override fun toJava(): com.pulumi.azurenative.network.VpnSiteArgs =
        com.pulumi.azurenative.network.VpnSiteArgs.builder()
            .addressSpace(addressSpace?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .bgpProperties(bgpProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deviceProperties(deviceProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .ipAddress(ipAddress?.applyValue({ args0 -> args0 }))
            .isSecuritySite(isSecuritySite?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .o365Policy(o365Policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .siteKey(siteKey?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualWan(virtualWan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vpnSiteLinks(
                vpnSiteLinks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .vpnSiteName(vpnSiteName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpnSiteArgs].
 */
@PulumiTagMarker
public class VpnSiteArgsBuilder internal constructor() {
    private var addressSpace: Output<AddressSpaceArgs>? = null

    private var bgpProperties: Output<BgpSettingsArgs>? = null

    private var deviceProperties: Output<DevicePropertiesArgs>? = null

    private var id: Output<String>? = null

    private var ipAddress: Output<String>? = null

    private var isSecuritySite: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var o365Policy: Output<O365PolicyPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var siteKey: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualWan: Output<SubResourceArgs>? = null

    private var vpnSiteLinks: Output<List<VpnSiteLinkArgs>>? = null

    private var vpnSiteName: Output<String>? = null

    /**
     * @param value The AddressSpace that contains an array of IP address ranges.
     */
    @JvmName("ppprybtthfjhouny")
    public suspend fun addressSpace(`value`: Output<AddressSpaceArgs>) {
        this.addressSpace = value
    }

    /**
     * @param value The set of bgp properties.
     */
    @JvmName("ufwsfuublfivdwpn")
    public suspend fun bgpProperties(`value`: Output<BgpSettingsArgs>) {
        this.bgpProperties = value
    }

    /**
     * @param value The device properties.
     */
    @JvmName("eavydgegtgjoifhf")
    public suspend fun deviceProperties(`value`: Output<DevicePropertiesArgs>) {
        this.deviceProperties = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("fbjnpjpqadlxdpua")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The ip-address for the vpn-site.
     */
    @JvmName("edvonetfyvamrjny")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value IsSecuritySite flag.
     */
    @JvmName("cvpuolwtrohrehnu")
    public suspend fun isSecuritySite(`value`: Output<Boolean>) {
        this.isSecuritySite = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("vlawlfhxxwlcfcke")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Office365 Policy.
     */
    @JvmName("cxyojtoxxrcairmg")
    public suspend fun o365Policy(`value`: Output<O365PolicyPropertiesArgs>) {
        this.o365Policy = value
    }

    /**
     * @param value The resource group name of the VpnSite.
     */
    @JvmName("fuxjagvvpppdijss")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The key for vpn-site that can be used for connections.
     */
    @JvmName("bqucpwhketoxadom")
    public suspend fun siteKey(`value`: Output<String>) {
        this.siteKey = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("odqhwfmxmggdemod")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The VirtualWAN to which the vpnSite belongs.
     */
    @JvmName("mogyafotkgshrxak")
    public suspend fun virtualWan(`value`: Output<SubResourceArgs>) {
        this.virtualWan = value
    }

    /**
     * @param value List of all vpn site links.
     */
    @JvmName("podhkxjyynajqpga")
    public suspend fun vpnSiteLinks(`value`: Output<List<VpnSiteLinkArgs>>) {
        this.vpnSiteLinks = value
    }

    @JvmName("ltnntbiltwboenqi")
    public suspend fun vpnSiteLinks(vararg values: Output<VpnSiteLinkArgs>) {
        this.vpnSiteLinks = Output.all(values.asList())
    }

    /**
     * @param values List of all vpn site links.
     */
    @JvmName("sucbbpnhhvwfloxd")
    public suspend fun vpnSiteLinks(values: List<Output<VpnSiteLinkArgs>>) {
        this.vpnSiteLinks = Output.all(values)
    }

    /**
     * @param value The name of the VpnSite being created or updated.
     */
    @JvmName("lloqcocosnbkfneu")
    public suspend fun vpnSiteName(`value`: Output<String>) {
        this.vpnSiteName = value
    }

    /**
     * @param value The AddressSpace that contains an array of IP address ranges.
     */
    @JvmName("gahlwaoncskaavgr")
    public suspend fun addressSpace(`value`: AddressSpaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressSpace = mapped
    }

    /**
     * @param argument The AddressSpace that contains an array of IP address ranges.
     */
    @JvmName("ckqrcaepuvianfwq")
    public suspend fun addressSpace(argument: suspend AddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = AddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.addressSpace = mapped
    }

    /**
     * @param value The set of bgp properties.
     */
    @JvmName("gvqgdrjrvrvuswmb")
    public suspend fun bgpProperties(`value`: BgpSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpProperties = mapped
    }

    /**
     * @param argument The set of bgp properties.
     */
    @JvmName("xofoihiwcdyuvtmo")
    public suspend fun bgpProperties(argument: suspend BgpSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = BgpSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bgpProperties = mapped
    }

    /**
     * @param value The device properties.
     */
    @JvmName("qskpcdvodkleaxvo")
    public suspend fun deviceProperties(`value`: DevicePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceProperties = mapped
    }

    /**
     * @param argument The device properties.
     */
    @JvmName("efqlcurqcaqmhmtk")
    public suspend fun deviceProperties(argument: suspend DevicePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DevicePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deviceProperties = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("bbslromequndolnp")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The ip-address for the vpn-site.
     */
    @JvmName("gxrmfkedvlcppsnk")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value IsSecuritySite flag.
     */
    @JvmName("yfgptiyasjmadsmi")
    public suspend fun isSecuritySite(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isSecuritySite = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("usjlkieaegauwwrh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Office365 Policy.
     */
    @JvmName("xgfmidjpxmvrdmlk")
    public suspend fun o365Policy(`value`: O365PolicyPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.o365Policy = mapped
    }

    /**
     * @param argument Office365 Policy.
     */
    @JvmName("vwlywtifuybgcreq")
    public suspend fun o365Policy(argument: suspend O365PolicyPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = O365PolicyPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.o365Policy = mapped
    }

    /**
     * @param value The resource group name of the VpnSite.
     */
    @JvmName("pmphtgtrbjpbvopr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The key for vpn-site that can be used for connections.
     */
    @JvmName("bsnwtglxukswchuh")
    public suspend fun siteKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteKey = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ekyythpojnspajmv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jahemkjwoligtvdd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The VirtualWAN to which the vpnSite belongs.
     */
    @JvmName("hvfbbnynkjpkhoda")
    public suspend fun virtualWan(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualWan = mapped
    }

    /**
     * @param argument The VirtualWAN to which the vpnSite belongs.
     */
    @JvmName("pocfwhrdwqeufjha")
    public suspend fun virtualWan(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualWan = mapped
    }

    /**
     * @param value List of all vpn site links.
     */
    @JvmName("dhyyjtlpaxxpfupc")
    public suspend fun vpnSiteLinks(`value`: List<VpnSiteLinkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnSiteLinks = mapped
    }

    /**
     * @param argument List of all vpn site links.
     */
    @JvmName("vttudkgpyyknugok")
    public suspend fun vpnSiteLinks(argument: List<suspend VpnSiteLinkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { VpnSiteLinkArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.vpnSiteLinks = mapped
    }

    /**
     * @param argument List of all vpn site links.
     */
    @JvmName("vrvlbasnkrtdfeyk")
    public suspend fun vpnSiteLinks(vararg argument: suspend VpnSiteLinkArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { VpnSiteLinkArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.vpnSiteLinks = mapped
    }

    /**
     * @param argument List of all vpn site links.
     */
    @JvmName("frjfxylqhmktrkcu")
    public suspend fun vpnSiteLinks(argument: suspend VpnSiteLinkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VpnSiteLinkArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.vpnSiteLinks = mapped
    }

    /**
     * @param values List of all vpn site links.
     */
    @JvmName("uohhipikpadvxdck")
    public suspend fun vpnSiteLinks(vararg values: VpnSiteLinkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnSiteLinks = mapped
    }

    /**
     * @param value The name of the VpnSite being created or updated.
     */
    @JvmName("yoetljrwwfryhcri")
    public suspend fun vpnSiteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnSiteName = mapped
    }

    internal fun build(): VpnSiteArgs = VpnSiteArgs(
        addressSpace = addressSpace,
        bgpProperties = bgpProperties,
        deviceProperties = deviceProperties,
        id = id,
        ipAddress = ipAddress,
        isSecuritySite = isSecuritySite,
        location = location,
        o365Policy = o365Policy,
        resourceGroupName = resourceGroupName,
        siteKey = siteKey,
        tags = tags,
        virtualWan = virtualWan,
        vpnSiteLinks = vpnSiteLinks,
        vpnSiteName = vpnSiteName,
    )
}
