@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.WebApplicationFirewallPolicyArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.ManagedRulesDefinitionArgs
import com.pulumi.azurenative.network.kotlin.inputs.ManagedRulesDefinitionArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.PolicySettingsArgs
import com.pulumi.azurenative.network.kotlin.inputs.PolicySettingsArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.WebApplicationFirewallCustomRuleArgs
import com.pulumi.azurenative.network.kotlin.inputs.WebApplicationFirewallCustomRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Defines web application firewall policy.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-07-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Creates or updates a WAF policy within a resource group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webApplicationFirewallPolicy = new AzureNative.Network.WebApplicationFirewallPolicy("webApplicationFirewallPolicy", new()
 *     {
 *         CustomRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.WebApplicationFirewallCustomRuleArgs
 *             {
 *                 Action = "Block",
 *                 MatchConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.MatchConditionArgs
 *                     {
 *                         MatchValues = new[]
 *                         {
 *                             "192.168.1.0/24",
 *                             "10.0.0.0/24",
 *                         },
 *                         MatchVariables = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.MatchVariableArgs
 *                             {
 *                                 VariableName = "RemoteAddr",
 *                             },
 *                         },
 *                         Operator = "IPMatch",
 *                     },
 *                 },
 *                 Name = "Rule1",
 *                 Priority = 1,
 *                 RuleType = "MatchRule",
 *             },
 *             new AzureNative.Network.Inputs.WebApplicationFirewallCustomRuleArgs
 *             {
 *                 Action = "Block",
 *                 MatchConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.MatchConditionArgs
 *                     {
 *                         MatchValues = new[]
 *                         {
 *                             "192.168.1.0/24",
 *                         },
 *                         MatchVariables = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.MatchVariableArgs
 *                             {
 *                                 VariableName = "RemoteAddr",
 *                             },
 *                         },
 *                         Operator = "IPMatch",
 *                     },
 *                     new AzureNative.Network.Inputs.MatchConditionArgs
 *                     {
 *                         MatchValues = new[]
 *                         {
 *                             "Windows",
 *                         },
 *                         MatchVariables = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.MatchVariableArgs
 *                             {
 *                                 Selector = "UserAgent",
 *                                 VariableName = "RequestHeaders",
 *                             },
 *                         },
 *                         Operator = "Contains",
 *                     },
 *                 },
 *                 Name = "Rule2",
 *                 Priority = 2,
 *                 RuleType = "MatchRule",
 *             },
 *             new AzureNative.Network.Inputs.WebApplicationFirewallCustomRuleArgs
 *             {
 *                 Action = "Block",
 *                 GroupByUserSession = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.GroupByUserSessionArgs
 *                     {
 *                         GroupByVariables = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.GroupByVariableArgs
 *                             {
 *                                 VariableName = "ClientAddr",
 *                             },
 *                         },
 *                     },
 *                 },
 *                 MatchConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.MatchConditionArgs
 *                     {
 *                         MatchValues = new[]
 *                         {
 *                             "192.168.1.0/24",
 *                             "10.0.0.0/24",
 *                         },
 *                         MatchVariables = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.MatchVariableArgs
 *                             {
 *                                 VariableName = "RemoteAddr",
 *                             },
 *                         },
 *                         NegationConditon = true,
 *                         Operator = "IPMatch",
 *                     },
 *                 },
 *                 Name = "RateLimitRule3",
 *                 Priority = 3,
 *                 RateLimitDuration = "OneMin",
 *                 RateLimitThreshold = 10,
 *                 RuleType = "RateLimitRule",
 *             },
 *         },
 *         Location = "WestUs",
 *         ManagedRules = new AzureNative.Network.Inputs.ManagedRulesDefinitionArgs
 *         {
 *             Exclusions = new[]
 *             {
 *                 new AzureNative.Network.Inputs.OwaspCrsExclusionEntryArgs
 *                 {
 *                     ExclusionManagedRuleSets = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.ExclusionManagedRuleSetArgs
 *                         {
 *                             RuleGroups = new[]
 *                             {
 *                                 new AzureNative.Network.Inputs.ExclusionManagedRuleGroupArgs
 *                                 {
 *                                     RuleGroupName = "REQUEST-930-APPLICATION-ATTACK-LFI",
 *                                     Rules = new[]
 *                                     {
 *                                         new AzureNative.Network.Inputs.ExclusionManagedRuleArgs
 *                                         {
 *                                             RuleId = "930120",
 *                                         },
 *                                     },
 *                                 },
 *                                 new AzureNative.Network.Inputs.ExclusionManagedRuleGroupArgs
 *                                 {
 *                                     RuleGroupName = "REQUEST-932-APPLICATION-ATTACK-RCE",
 *                                 },
 *                             },
 *                             RuleSetType = "OWASP",
 *                             RuleSetVersion = "3.2",
 *                         },
 *                     },
 *                     MatchVariable = "RequestArgNames",
 *                     Selector = "hello",
 *                     SelectorMatchOperator = "StartsWith",
 *                 },
 *                 new AzureNative.Network.Inputs.OwaspCrsExclusionEntryArgs
 *                 {
 *                     ExclusionManagedRuleSets = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.ExclusionManagedRuleSetArgs
 *                         {
 *                             RuleGroups = new[] {},
 *                             RuleSetType = "OWASP",
 *                             RuleSetVersion = "3.1",
 *                         },
 *                     },
 *                     MatchVariable = "RequestArgNames",
 *                     Selector = "hello",
 *                     SelectorMatchOperator = "EndsWith",
 *                 },
 *                 new AzureNative.Network.Inputs.OwaspCrsExclusionEntryArgs
 *                 {
 *                     MatchVariable = "RequestArgNames",
 *                     Selector = "test",
 *                     SelectorMatchOperator = "StartsWith",
 *                 },
 *                 new AzureNative.Network.Inputs.OwaspCrsExclusionEntryArgs
 *                 {
 *                     MatchVariable = "RequestArgValues",
 *                     Selector = "test",
 *                     SelectorMatchOperator = "StartsWith",
 *                 },
 *             },
 *             ManagedRuleSets = new[]
 *             {
 *                 new AzureNative.Network.Inputs.ManagedRuleSetArgs
 *                 {
 *                     RuleGroupOverrides = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.ManagedRuleGroupOverrideArgs
 *                         {
 *                             RuleGroupName = "REQUEST-931-APPLICATION-ATTACK-RFI",
 *                             Rules = new[]
 *                             {
 *                                 new AzureNative.Network.Inputs.ManagedRuleOverrideArgs
 *                                 {
 *                                     Action = "Log",
 *                                     RuleId = "931120",
 *                                     State = "Enabled",
 *                                 },
 *                                 new AzureNative.Network.Inputs.ManagedRuleOverrideArgs
 *                                 {
 *                                     Action = "AnomalyScoring",
 *                                     RuleId = "931130",
 *                                     State = "Disabled",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     RuleSetType = "OWASP",
 *                     RuleSetVersion = "3.2",
 *                 },
 *             },
 *         },
 *         PolicyName = "Policy1",
 *         PolicySettings = new AzureNative.Network.Inputs.PolicySettingsArgs
 *         {
 *             LogScrubbing = new AzureNative.Network.Inputs.PolicySettingsLogScrubbingArgs
 *             {
 *                 ScrubbingRules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.WebApplicationFirewallScrubbingRulesArgs
 *                     {
 *                         MatchVariable = "RequestArgNames",
 *                         Selector = "test",
 *                         SelectorMatchOperator = "Equals",
 *                         State = "Enabled",
 *                     },
 *                     new AzureNative.Network.Inputs.WebApplicationFirewallScrubbingRulesArgs
 *                     {
 *                         MatchVariable = "RequestIPAddress",
 *                         SelectorMatchOperator = "EqualsAny",
 *                         State = "Enabled",
 *                     },
 *                 },
 *                 State = "Enabled",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := network.NewWebApplicationFirewallPolicy(ctx, "webApplicationFirewallPolicy", &network.WebApplicationFirewallPolicyArgs{
 * CustomRules: []network.WebApplicationFirewallCustomRuleArgs{
 * {
 * Action: pulumi.String("Block"),
 * MatchConditions: network.MatchConditionArray{
 * {
 * MatchValues: pulumi.StringArray{
 * pulumi.String("192.168.1.0/24"),
 * pulumi.String("10.0.0.0/24"),
 * },
 * MatchVariables: network.MatchVariableArray{
 * {
 * VariableName: pulumi.String("RemoteAddr"),
 * },
 * },
 * Operator: pulumi.String("IPMatch"),
 * },
 * },
 * Name: pulumi.String("Rule1"),
 * Priority: pulumi.Int(1),
 * RuleType: pulumi.String("MatchRule"),
 * },
 * {
 * Action: pulumi.String("Block"),
 * MatchConditions: network.MatchConditionArray{
 * {
 * MatchValues: pulumi.StringArray{
 * pulumi.String("192.168.1.0/24"),
 * },
 * MatchVariables: network.MatchVariableArray{
 * {
 * VariableName: pulumi.String("RemoteAddr"),
 * },
 * },
 * Operator: pulumi.String("IPMatch"),
 * },
 * {
 * MatchValues: pulumi.StringArray{
 * pulumi.String("Windows"),
 * },
 * MatchVariables: network.MatchVariableArray{
 * {
 * Selector: pulumi.String("UserAgent"),
 * VariableName: pulumi.String("RequestHeaders"),
 * },
 * },
 * Operator: pulumi.String("Contains"),
 * },
 * },
 * Name: pulumi.String("Rule2"),
 * Priority: pulumi.Int(2),
 * RuleType: pulumi.String("MatchRule"),
 * },
 * {
 * Action: pulumi.String("Block"),
 * GroupByUserSession: network.GroupByUserSessionArray{
 * {
 * GroupByVariables: network.GroupByVariableArray{
 * {
 * VariableName: pulumi.String("ClientAddr"),
 * },
 * },
 * },
 * },
 * MatchConditions: network.MatchConditionArray{
 * {
 * MatchValues: pulumi.StringArray{
 * pulumi.String("192.168.1.0/24"),
 * pulumi.String("10.0.0.0/24"),
 * },
 * MatchVariables: network.MatchVariableArray{
 * {
 * VariableName: pulumi.String("RemoteAddr"),
 * },
 * },
 * NegationConditon: pulumi.Bool(true),
 * Operator: pulumi.String("IPMatch"),
 * },
 * },
 * Name: pulumi.String("RateLimitRule3"),
 * Priority: pulumi.Int(3),
 * RateLimitDuration: pulumi.String("OneMin"),
 * RateLimitThreshold: pulumi.Int(10),
 * RuleType: pulumi.String("RateLimitRule"),
 * },
 * },
 * Location: pulumi.String("WestUs"),
 * ManagedRules: network.ManagedRulesDefinitionResponse{
 * Exclusions: network.OwaspCrsExclusionEntryArray{
 * interface{}{
 * ExclusionManagedRuleSets: network.ExclusionManagedRuleSetArray{
 * interface{}{
 * RuleGroups: network.ExclusionManagedRuleGroupArray{
 * interface{}{
 * RuleGroupName: pulumi.String("REQUEST-930-APPLICATION-ATTACK-LFI"),
 * Rules: network.ExclusionManagedRuleArray{
 * &network.ExclusionManagedRuleArgs{
 * RuleId: pulumi.String("930120"),
 * },
 * },
 * },
 * &network.ExclusionManagedRuleGroupArgs{
 * RuleGroupName: pulumi.String("REQUEST-932-APPLICATION-ATTACK-RCE"),
 * },
 * },
 * RuleSetType: pulumi.String("OWASP"),
 * RuleSetVersion: pulumi.String("3.2"),
 * },
 * },
 * MatchVariable: pulumi.String("RequestArgNames"),
 * Selector: pulumi.String("hello"),
 * SelectorMatchOperator: pulumi.String("StartsWith"),
 * },
 * interface{}{
 * ExclusionManagedRuleSets: network.ExclusionManagedRuleSetArray{
 * interface{}{
 * RuleGroups: network.ExclusionManagedRuleGroupArray{
 * },
 * RuleSetType: pulumi.String("OWASP"),
 * RuleSetVersion: pulumi.String("3.1"),
 * },
 * },
 * MatchVariable: pulumi.String("RequestArgNames"),
 * Selector: pulumi.String("hello"),
 * SelectorMatchOperator: pulumi.String("EndsWith"),
 * },
 * &network.OwaspCrsExclusionEntryArgs{
 * MatchVariable: pulumi.String("RequestArgNames"),
 * Selector: pulumi.String("test"),
 * SelectorMatchOperator: pulumi.String("StartsWith"),
 * },
 * &network.OwaspCrsExclusionEntryArgs{
 * MatchVariable: pulumi.String("RequestArgValues"),
 * Selector: pulumi.String("test"),
 * SelectorMatchOperator: pulumi.String("StartsWith"),
 * },
 * },
 * ManagedRuleSets: network.ManagedRuleSetArray{
 * interface{}{
 * RuleGroupOverrides: network.ManagedRuleGroupOverrideArray{
 * interface{}{
 * RuleGroupName: pulumi.String("REQUEST-931-APPLICATION-ATTACK-RFI"),
 * Rules: network.ManagedRuleOverrideArray{
 * &network.ManagedRuleOverrideArgs{
 * Action: pulumi.String("Log"),
 * RuleId: pulumi.String("931120"),
 * State: pulumi.String("Enabled"),
 * },
 * &network.ManagedRuleOverrideArgs{
 * Action: pulumi.String("AnomalyScoring"),
 * RuleId: pulumi.String("931130"),
 * State: pulumi.String("Disabled"),
 * },
 * },
 * },
 * },
 * RuleSetType: pulumi.String("OWASP"),
 * RuleSetVersion: pulumi.String("3.2"),
 * },
 * },
 * },
 * PolicyName: pulumi.String("Policy1"),
 * PolicySettings: network.PolicySettingsResponse{
 * LogScrubbing: interface{}{
 * ScrubbingRules: network.WebApplicationFirewallScrubbingRulesArray{
 * &network.WebApplicationFirewallScrubbingRulesArgs{
 * MatchVariable: pulumi.String("RequestArgNames"),
 * Selector: pulumi.String("test"),
 * SelectorMatchOperator: pulumi.String("Equals"),
 * State: pulumi.String("Enabled"),
 * },
 * &network.WebApplicationFirewallScrubbingRulesArgs{
 * MatchVariable: pulumi.String("RequestIPAddress"),
 * SelectorMatchOperator: pulumi.String("EqualsAny"),
 * State: pulumi.String("Enabled"),
 * },
 * },
 * State: pulumi.String("Enabled"),
 * },
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.WebApplicationFirewallPolicy;
 * import com.pulumi.azurenative.network.WebApplicationFirewallPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webApplicationFirewallPolicy = new WebApplicationFirewallPolicy("webApplicationFirewallPolicy", WebApplicationFirewallPolicyArgs.builder()
 *             .customRules(
 *                 Map.ofEntries(
 *                     Map.entry("action", "Block"),
 *                     Map.entry("matchConditions", Map.ofEntries(
 *                         Map.entry("matchValues",
 *                             "192.168.1.0/24",
 *                             "10.0.0.0/24"),
 *                         Map.entry("matchVariables", Map.of("variableName", "RemoteAddr")),
 *                         Map.entry("operator", "IPMatch")
 *                     )),
 *                     Map.entry("name", "Rule1"),
 *                     Map.entry("priority", 1),
 *                     Map.entry("ruleType", "MatchRule")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("action", "Block"),
 *                     Map.entry("matchConditions",
 *                         Map.ofEntries(
 *                             Map.entry("matchValues", "192.168.1.0/24"),
 *                             Map.entry("matchVariables", Map.of("variableName", "RemoteAddr")),
 *                             Map.entry("operator", "IPMatch")
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("matchValues", "Windows"),
 *                             Map.entry("matchVariables", Map.ofEntries(
 *                                 Map.entry("selector", "UserAgent"),
 *                                 Map.entry("variableName", "RequestHeaders")
 *                             )),
 *                             Map.entry("operator", "Contains")
 *                         )),
 *                     Map.entry("name", "Rule2"),
 *                     Map.entry("priority", 2),
 *                     Map.entry("ruleType", "MatchRule")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("action", "Block"),
 *                     Map.entry("groupByUserSession", Map.of("groupByVariables", Map.of("variableName", "ClientAddr"))),
 *                     Map.entry("matchConditions", Map.ofEntries(
 *                         Map.entry("matchValues",
 *                             "192.168.1.0/24",
 *                             "10.0.0.0/24"),
 *                         Map.entry("matchVariables", Map.of("variableName", "RemoteAddr")),
 *                         Map.entry("negationConditon", true),
 *                         Map.entry("operator", "IPMatch")
 *                     )),
 *                     Map.entry("name", "RateLimitRule3"),
 *                     Map.entry("priority", 3),
 *                     Map.entry("rateLimitDuration", "OneMin"),
 *                     Map.entry("rateLimitThreshold", 10),
 *                     Map.entry("ruleType", "RateLimitRule")
 *                 ))
 *             .location("WestUs")
 *             .managedRules(Map.ofEntries(
 *                 Map.entry("exclusions",
 *                     Map.ofEntries(
 *                         Map.entry("exclusionManagedRuleSets", Map.ofEntries(
 *                             Map.entry("ruleGroups",
 *                                 Map.ofEntries(
 *                                     Map.entry("ruleGroupName", "REQUEST-930-APPLICATION-ATTACK-LFI"),
 *                                     Map.entry("rules", Map.of("ruleId", "930120"))
 *                                 ),
 *                                 Map.of("ruleGroupName", "REQUEST-932-APPLICATION-ATTACK-RCE")),
 *                             Map.entry("ruleSetType", "OWASP"),
 *                             Map.entry("ruleSetVersion", "3.2")
 *                         )),
 *                         Map.entry("matchVariable", "RequestArgNames"),
 *                         Map.entry("selector", "hello"),
 *                         Map.entry("selectorMatchOperator", "StartsWith")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("exclusionManagedRuleSets", Map.ofEntries(
 *                             Map.entry("ruleGroups", ),
 *                             Map.entry("ruleSetType", "OWASP"),
 *                             Map.entry("ruleSetVersion", "3.1")
 *                         )),
 *                         Map.entry("matchVariable", "RequestArgNames"),
 *                         Map.entry("selector", "hello"),
 *                         Map.entry("selectorMatchOperator", "EndsWith")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("matchVariable", "RequestArgNames"),
 *                         Map.entry("selector", "test"),
 *                         Map.entry("selectorMatchOperator", "StartsWith")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("matchVariable", "RequestArgValues"),
 *                         Map.entry("selector", "test"),
 *                         Map.entry("selectorMatchOperator", "StartsWith")
 *                     )),
 *                 Map.entry("managedRuleSets", Map.ofEntries(
 *                     Map.entry("ruleGroupOverrides", Map.ofEntries(
 *                         Map.entry("ruleGroupName", "REQUEST-931-APPLICATION-ATTACK-RFI"),
 *                         Map.entry("rules",
 *                             Map.ofEntries(
 *                                 Map.entry("action", "Log"),
 *                                 Map.entry("ruleId", "931120"),
 *                                 Map.entry("state", "Enabled")
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("action", "AnomalyScoring"),
 *                                 Map.entry("ruleId", "931130"),
 *                                 Map.entry("state", "Disabled")
 *                             ))
 *                     )),
 *                     Map.entry("ruleSetType", "OWASP"),
 *                     Map.entry("ruleSetVersion", "3.2")
 *                 ))
 *             ))
 *             .policyName("Policy1")
 *             .policySettings(Map.of("logScrubbing", Map.ofEntries(
 *                 Map.entry("scrubbingRules",
 *                     Map.ofEntries(
 *                         Map.entry("matchVariable", "RequestArgNames"),
 *                         Map.entry("selector", "test"),
 *                         Map.entry("selectorMatchOperator", "Equals"),
 *                         Map.entry("state", "Enabled")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("matchVariable", "RequestIPAddress"),
 *                         Map.entry("selectorMatchOperator", "EqualsAny"),
 *                         Map.entry("state", "Enabled")
 *                     )),
 *                 Map.entry("state", "Enabled")
 *             )))
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:WebApplicationFirewallPolicy Policy1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ApplicationGatewayWebApplicationFirewallPolicies/{policyName}
 * ```
 * @property customRules The custom rules inside the policy.
 * @property id Resource ID.
 * @property location Resource location.
 * @property managedRules Describes the managedRules structure.
 * @property policyName The name of the policy.
 * @property policySettings The PolicySettings for policy.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 */
public data class WebApplicationFirewallPolicyArgs(
    public val customRules: Output<List<WebApplicationFirewallCustomRuleArgs>>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managedRules: Output<ManagedRulesDefinitionArgs>? = null,
    public val policyName: Output<String>? = null,
    public val policySettings: Output<PolicySettingsArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.WebApplicationFirewallPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.network.WebApplicationFirewallPolicyArgs =
        com.pulumi.azurenative.network.WebApplicationFirewallPolicyArgs.builder()
            .customRules(
                customRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedRules(managedRules?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .policySettings(policySettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [WebApplicationFirewallPolicyArgs].
 */
@PulumiTagMarker
public class WebApplicationFirewallPolicyArgsBuilder internal constructor() {
    private var customRules: Output<List<WebApplicationFirewallCustomRuleArgs>>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var managedRules: Output<ManagedRulesDefinitionArgs>? = null

    private var policyName: Output<String>? = null

    private var policySettings: Output<PolicySettingsArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The custom rules inside the policy.
     */
    @JvmName("ccemblljoxrgcwbu")
    public suspend fun customRules(`value`: Output<List<WebApplicationFirewallCustomRuleArgs>>) {
        this.customRules = value
    }

    @JvmName("eishknfknvtjjknt")
    public suspend fun customRules(vararg values: Output<WebApplicationFirewallCustomRuleArgs>) {
        this.customRules = Output.all(values.asList())
    }

    /**
     * @param values The custom rules inside the policy.
     */
    @JvmName("nulauijbxuaubarf")
    public suspend fun customRules(values: List<Output<WebApplicationFirewallCustomRuleArgs>>) {
        this.customRules = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("hwboevjveswclmrl")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("caegwhoceknlwuaw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Describes the managedRules structure.
     */
    @JvmName("uluqodqwugksopnl")
    public suspend fun managedRules(`value`: Output<ManagedRulesDefinitionArgs>) {
        this.managedRules = value
    }

    /**
     * @param value The name of the policy.
     */
    @JvmName("mpropogwxivswxdu")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value The PolicySettings for policy.
     */
    @JvmName("qutteowtqrtctywf")
    public suspend fun policySettings(`value`: Output<PolicySettingsArgs>) {
        this.policySettings = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("spvbxejicrkllbio")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("akrbedjftryukhll")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The custom rules inside the policy.
     */
    @JvmName("ctbkpfgmpwodydjr")
    public suspend fun customRules(`value`: List<WebApplicationFirewallCustomRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRules = mapped
    }

    /**
     * @param argument The custom rules inside the policy.
     */
    @JvmName("tcfoggpnqljsifmb")
    public suspend
    fun customRules(argument: List<suspend WebApplicationFirewallCustomRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebApplicationFirewallCustomRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customRules = mapped
    }

    /**
     * @param argument The custom rules inside the policy.
     */
    @JvmName("uqofyqfomglarbyt")
    public suspend fun customRules(
        vararg
        argument: suspend WebApplicationFirewallCustomRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebApplicationFirewallCustomRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customRules = mapped
    }

    /**
     * @param argument The custom rules inside the policy.
     */
    @JvmName("htdvhiixvomrcuye")
    public suspend
    fun customRules(argument: suspend WebApplicationFirewallCustomRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebApplicationFirewallCustomRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customRules = mapped
    }

    /**
     * @param values The custom rules inside the policy.
     */
    @JvmName("qwiysjsyephoixxi")
    public suspend fun customRules(vararg values: WebApplicationFirewallCustomRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customRules = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("imoqnuqcfiyqhoyq")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("wmlniemsgxjxdmsr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Describes the managedRules structure.
     */
    @JvmName("pucrlridycanxrhs")
    public suspend fun managedRules(`value`: ManagedRulesDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedRules = mapped
    }

    /**
     * @param argument Describes the managedRules structure.
     */
    @JvmName("jtmhidthxmtfjbfk")
    public suspend fun managedRules(argument: suspend ManagedRulesDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedRulesDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managedRules = mapped
    }

    /**
     * @param value The name of the policy.
     */
    @JvmName("kldwbkfphoojyeuv")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value The PolicySettings for policy.
     */
    @JvmName("osuiklkwjmsxvpcu")
    public suspend fun policySettings(`value`: PolicySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policySettings = mapped
    }

    /**
     * @param argument The PolicySettings for policy.
     */
    @JvmName("vpthlojkrrkqcbre")
    public suspend fun policySettings(argument: suspend PolicySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = PolicySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policySettings = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("inltjagrirooksmb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jfjtdevihengwsse")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nadvvgximxpfxjyp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): WebApplicationFirewallPolicyArgs = WebApplicationFirewallPolicyArgs(
        customRules = customRules,
        id = id,
        location = location,
        managedRules = managedRules,
        policyName = policyName,
        policySettings = policySettings,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
