@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
 */
public enum class CustomRuleEnabledState(
    public val javaValue: com.pulumi.azurenative.network.enums.CustomRuleEnabledState,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.CustomRuleEnabledState> {
    Disabled(com.pulumi.azurenative.network.enums.CustomRuleEnabledState.Disabled),
    Enabled(com.pulumi.azurenative.network.enums.CustomRuleEnabledState.Enabled),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.CustomRuleEnabledState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.CustomRuleEnabledState):
            CustomRuleEnabledState = CustomRuleEnabledState.values().first { it.javaValue == javaType }
    }
}
